## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       Vivado Make rules
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## Vivado

export M_ROOT := $(M_ROOT)

M_VIVADO_PL := $(M_ROOT)/bin/xvivado.pl
M_VIVADO_TCL := $(M_VIVADO_PROJECT)_vivado.tcl

M_VIVADO_DEVICE := $(M_DEVICE)
M_VIVADO_TARGETS := $(addprefix $(M_VIVADO_PROJECT)., $(M_MODES))
M_VIVADO_TARGETS := $(addsuffix .xvivado.log, $(M_VIVADO_TARGETS))

M_VIVADO_SOURCES := $(shell perl $(M_ROOT)/bin/tcl2make.pl -deps $(M_VIVADO_TCL))
M_VIVADO_SOURCES += $(shell perl $(M_ROOT)/bin/tcl2make.pl -dep-cores $(M_VIVADO_TCL))
M_VIVADO_SOURCES += $(M_VIVADO_TCL) $(M_VIVADO_PL)

M_VIVADO_DOCS := $(filter %_regs.v, $(M_VIVADO_SOURCES))
M_VIVADO_DOCS := $(subst .v,.md, $(M_VIVADO_DOCS))

M_VIVADO_CORES := $(shell perl $(M_ROOT)/bin/tcl2make.pl -cores $(M_VIVADO_TCL))
M_CLEAN_VIVADO_CORES := $(addsuffix .clean, $(M_VIVADO_CORES))

ifeq ($(M_MODES),)
M_VIVADO_TARGETS := $(addprefix $(M_VIVADO_PROJECT), .xvivado.log)
endif

ifeq ($(M_DEVICE),)
M_VIVADO_DEVICE := generic
endif

.PHONY: defaults
defaults: lib $(M_VIVADO_DOCS) $(M_VIVADO_TARGETS)

.PHONY: lib
lib: $(M_VIVADO_CORES)

.PHONY: $(M_VIVADO_CORES)
$(M_VIVADO_CORES):
	$(MAKE) -C $@/hdl

.PHONY: clean
clean:
	perl $(M_VIVADO_PL) $@ $(M_VIVADO_DEVICE) clean

.PHONY: clean-all
clean-all: clean $(M_CLEAN_VIVADO_CORES)

ifneq ($(M_MODES),)
.SECONDEXPANSION:
.PHONY: $(M_MODES)
$(M_MODES): $(M_VIVADO_PROJECT).$$@.xvivado.log
endif

$(M_VIVADO_TARGETS): $(M_VIVADO_SOURCES)
	perl $(M_VIVADO_PL) $@ $(M_VIVADO_DEVICE) run

$(M_CLEAN_VIVADO_CORES): %.clean:
	$(MAKE) -C $*/hdl clean

%_regs.v: %_regs.pl $(M_ROOT)/bin/dooku.pl
	perl -I $(M_ROOT)/bin $< $@

%_regs.md: %_regs.pl $(M_ROOT)/bin/dooku.pl
	perl -I $(M_ROOT)/bin $< $@

## ##################################################################################
## ##################################################################################
