#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       Auto generate dependencies from TCL
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use autodie;

$m_root = $0;
$m_root =~ s/\/bin\/tcl2sdk.pl//;

if ($ARGV[0] eq "-version") {
    open(IFILE, $ARGV[1]);
    while ($fline = <IFILE>) {
        chomp($fline);
        $fline =~ s/\s+//g;
        if ($fline =~ /^setPLATFORM_VERSION/) {
            $fline =~ s/^setPLATFORM_VERSION//;
            $fword = hex($fline);
            $major = ($fword >> 16) & 0xff;
            $minor = ($fword >>  8) & 0xff;
            $patch = ($fword >>  0) & 0xff;
            last;
        }
    }
    close(IFILE);
    print "$major.$minor.$patch";
    exit;
}

$n_cores = 0;
add_core("$m_root/library/common/sw");

if (($ARGV[0] eq "-sw-dirs") || ($ARGV[0] eq "-sw-pkg") || ($ARGV[0] eq "-sw-regs")) {
    for ($a = 2; $a <= $#ARGV; $a++) {
        open(IFILE, "../../$ARGV[$a]/hdl/$ARGV[$a]_vivado.tcl");
        while ($fline = <IFILE>) {
            chomp($fline);
            $fline =~ s/\s+//g;
            if ($fline =~ /^lappendip_core_list/) {
                $fline =~ s/^lappendip_core_list//;
                add_core("$fline/sw");
            }
        }
        close(IFILE);
    }
}

if ($ARGV[0] eq "-sw-dirs") {
    if ($n_cores == 0) {exit;}
    $m_cores = $cores[0];
    for ($n = 1; $n < $n_cores; $n++) {
        $m_cores = "$m_cores $cores[$n]";
    }
    print "$m_cores";
    exit;
}

if ($ARGV[0] eq "-sw-pkg") {
    print "-C../../$ARGV[1]/sw\n";
    for ($a = 2; $a <= $#ARGV; $a++) {
        print "$ARGV[$a].h\n";
        print "$ARGV[$a].regs\n";
    }
    if ($n_cores == 0) {exit;}
    for ($n = 0; $n < $n_cores; $n++) {
        print "-C$cores[$n]\n";
        while ($f = glob("$cores[$n]/*.h")) {
            $f =~ s/.*\///;
            print "$f\n";
        }
        while ($f = glob("$cores[$n]/*.c")) {
            $f =~ s/.*\///;
            print "$f\n";
        }
    }
    exit;
}

if ($ARGV[0] eq "-sw-regs") {
    for ($a = 2; $a <= $#ARGV; $a++) {
        $n_addrs = 0;
        open(IFILE, "../../$ARGV[1]/sw/$ARGV[$a].h");
        while ($fline = <IFILE>) {
            chomp($fline);
            if ($fline =~ /^#ifdef\s+$ARGV[$a]_base/i) {
                $base = 1;
                next;
            } elsif ($fline =~ /^#endif/) {
                $base = 0;
                next;
            }
            if ($base == 1) {
                ($s1, $base_name, $base_addr) = split(/\s+/, $fline, 3);
                for ($n = 0; $n < $n_cores; $n++) {
                    $core_name = $cores[$n];
                    $core_name =~ s/\/sw$//;
                    $core_name =~ s/.*\///;
                    if ($base_name =~ /$core_name/i) {
                        while ($f = glob("$cores[$n]/*.regs")) {
                            $addrs[$n_addrs++] = "$base_addr:$base_name:$core_name:$f";
                        }
                    }
                }
            }
        }
        close(IFILE);
        open(OFILE, ">../../$ARGV[1]/sw/$ARGV[$a].regs");
        for ($n = 0; $n < $n_addrs; $n++) {
            ($ba, $bn, $cn, $cf) = split(/:/, $addrs[$n], 4);
            $ba = hex($ba);
            $bn =~ s/_ID$//;
            $cn = uc($cn);
            open(IFILE, $cf);
            while ($fline = <IFILE>) {
                chomp($fline);
                if ($fline =~ /^\/\//) {next;}
                $fline =~ s/\s+//g;
                if ($fline eq "") {next;}
                ($ca, $cr) = split(/:/, $fline, 2);
                $cr =~ s/^${cn}_//;
                $ca = hex($ca);
                $ca = $ca + $ba;
                $ca = sprintf("0x%08x", $ca);
                print OFILE "$ca:${bn}:$cr\n";
            }
            close(IFILE);
        }
        close(OFILE);
    }

    exit;
}

if (($ARGV[0] eq "-hdl-srcs") || ($ARGV[0] eq "-hdl-pkg")) {
    for ($a = 2; $a <= $#ARGV; $a++) {
        open(IFILE, "../../$ARGV[$a]/hdl/Makefile");
        $modes = 0;
        $bit_type = "bin";
        while ($fline = <IFILE>) {
            chomp($fline);
            $fline =~ s/\s+//g;
            if ($fline =~ /^M_BIT_TYPE:=/) {
                $fline =~ s/^M_BIT_TYPE:=//;
                $bit_type = $fline;
            }
            if (($fline =~ /^M_MODES:=/) || ($fline =~ /^M_MODES\+=/)) {
                $fline =~ s/^M_MODES:=//;
                $fline =~ s/^M_MODES\+=//;
                $modes = 1;
                if ($ARGV[0] eq "-hdl-pkg") {
                    print "-C../../$ARGV[$a]/hdl/$fline\n";
                    print "$ARGV[$a]_$fline.$bit_type\n";
                    print "-C..\n";
                } else {
                    print " ../../$ARGV[$a]/hdl/$fline/$ARGV[$a]_$fline.$bit_type";
                }
            }
        }
        close(IFILE);
        if ($modes == 0) {
            if ($ARGV[0] eq "-hdl-pkg") {
                print "-C../../$ARGV[$a]/hdl\n";
                print "$ARGV[$a].$bit_type\n";
            } else {
                print " ../../$ARGV[$a]/hdl/$ARGV[$a].$bit_type";
            }
        }
    }
    exit;
}

exit(-1);

## ##################################################################################
## ##################################################################################

sub add_core {

    local($c) = @_;
    local($n);

    for ($n = 0; $n < $n_cores; $n++) {
        if ($cores[$n] eq $c) {return;}
    }

    $cores[$n_cores++] = $c;
}

## ##################################################################################
## ##################################################################################

