## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       Drivers Make rules
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## Drivers

export M_ROOT := $(M_ROOT)

VERSION := $(shell $(M_ROOT)/bin/tcl2sdk.pl -version $(M_VERSION_FILE))
HDL_SRCS := $(shell $(M_ROOT)/bin/tcl2sdk.pl -hdl-srcs $(M_COMMON) $(M_PROJECTS))
SRC_DIRS := $(shell $(M_ROOT)/bin/tcl2sdk.pl -sw-dirs $(M_COMMON) $(M_PROJECTS))
SRC_DIRS += $(M_ROOT)/projects/common/sw

INCS := $(addprefix -I, $(SRC_DIRS))
SRCS := $(foreach dir, $(SRC_DIRS), $(wildcard $(dir)/*.c))
HDRS := $(foreach dir, $(SRC_DIRS), $(wildcard $(dir)/*.h))
OBJS := $(notdir $(SRCS))
OBJS := $(patsubst %.c, %.o, $(OBJS))

TARGETS := lib_$(M_TARGET).a
TARGETS += $(M_TARGET)_regs.log
TARGETS += $(M_TARGET)_hdl_$(VERSION).tar.gz
TARGETS += $(M_TARGET)_drivers_$(VERSION).tar.gz

ifeq ($(VERSION), )
    $(error no version defined, can not continue.)
endif

.PHONY: defaults
defaults: $(TARGETS)

.PHONY: hdl
hdl: $(M_TARGET)_hdl_$(VERSION).tar.gz

.PHONY: drivers
drivers: $(M_TARGET)_drivers_$(VERSION).tar.gz

lib_$(M_TARGET).a: $(SRCS) $(HDRS) $(M_ROOT)/bin/tcl2sdk.pl
	gcc -c -I. $(INCS) $(SRCS)
	ar rcs $@ $(OBJS)

$(M_TARGET)_drivers_$(VERSION).tar.gz: $(SRCS) $(HDRS) $(M_ROOT)/bin/tcl2sdk.pl
	$(M_ROOT)/bin/tcl2sdk.pl -sw-pkg $(M_COMMON) $(M_PROJECTS) > drivers.flist
	tar -czf $@ -T drivers.flist

$(M_TARGET)_hdl_$(VERSION).tar.gz: $(HDL_SRCS) $(M_ROOT)/bin/tcl2sdk.pl
	$(M_ROOT)/bin/tcl2sdk.pl -hdl-pkg $(M_COMMON) $(M_PROJECTS) > hdl.flist
	tar -czf $@ -T hdl.flist

$(M_TARGET)_regs.log: $(SRCS) $(HDRS) $(M_ROOT)/bin/tcl2sdk.pl
	$(M_ROOT)/bin/tcl2sdk.pl -sw-regs $(M_COMMON) $(M_PROJECTS) > $@

.PHONY: clean
clean:
	rm -fr *.o

.PHONY: clean-all
clean-all: clean
	rm -fr lib_$(M_TARGET).a
	rm -fr $(M_TARGET)_drivers_$(VERSION).tar.gz
	rm -fr $(M_TARGET)_hdl_$(VERSION).tar.gz

## ##################################################################################
## ##################################################################################
