## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       Drivers Make rules
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## Drivers

export M_ROOT := $(M_ROOT)

M_LIB_COMMON := $(M_ROOT)/library/common/sw
M_PRJ_COMMON := $(M_ROOT)/projects/common/sw

REG_PLS := $(wildcard ../hdl/*.pl)
REG_PLS := $(notdir $(REG_PLS))

REG_HDRS := $(patsubst %_regs.pl, %_regs.h, $(REG_PLS))
REG_HDRS += $(patsubst %_regs.pl, %.h, $(REG_PLS))
REG_SRCS := $(patsubst %_regs.pl, %.c, $(REG_PLS))

SRCS := $(M_LIB_COMMON)/axi_utils.c
SRCS += $(wildcard *.c)
SRCS += $(REG_SRCS)

HDRS := $(M_PRJ_COMMON)/axi_common.h
HDRS += $(M_LIB_COMMON)/axi_utils.h
HDRS += $(wildcard *.h)
HDRS += $(REG_HDRS)

OBJS := $(notdir $(SRCS))
OBJS := $(patsubst %.c, %.o, $(OBJS))

.PHONY: defaults
defaults: lib_$(M_IPCORE).a
   
lib_$(M_IPCORE).a: $(SRCS) $(HDRS) $(REG_HDRS)
	gcc -c -I. -I$(M_LIB_COMMON) -I$(M_PRJ_COMMON) $(SRCS)
	ar rcs $@ $(OBJS)

.PHONY: clean
clean:
	rm -fr *.o *.a

.PHONY: clean-all
clean-all: clean

%_regs.h %.h %.c: ../hdl/%_regs.pl $(M_LIB_COMMON)/dooku.pl
	perl -I $(M_LIB_COMMON) $< $@

## ##################################################################################
## ##################################################################################
