#!/usr/bin/perl
## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       The simplest form of auto generated register/documentation
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

use Cwd;

sub setdooku {

    local(@args) = @_;
    $outfile = $args[0];
    $incdir = $args[1];
    $vlog = 1;
    $mkdn = 0;
    if ($outfile =~ /\.md$/) {
        $vlog = 0;
        $mkdn = 1;
    }
}
dooku;

sub s2h_32 {

    local($s, $i) = @_;

    $s = $s.(" " x 32);
    $s = substr($s, ($i*4), 4);
    $s =~ s/(.)/sprintf("%x",ord($1))/eg;
    $s = "0x".$s;
    return($s);
}
dooku;

sub fieldtypes {

    local($type) = @_;

    if ($type eq "RO")    {return("R");}
    return("R/W");
}
dooku;

sub define {
}
dooku;

sub field {

    local($spos, $width, $type, $default, $name, $desc) = @_;

    $desc =~ tr{\n}{ };
    $desc =~ s/ +/ /g;
    $field_spos[$no_of_fields] = $spos;
    $field_width[$no_of_fields] = $width;
    $field_type[$no_of_fields] = $type;
    if ($default =~ /^0x/) {
        $default =~ s/^0x//;
        $field_default[$no_of_fields] = $default;
    } else {
        $field_default[$no_of_fields] = sprintf("%x", $default);
    }
    $field_name[$no_of_fields] = $name;
    $field_desc[$no_of_fields] = $desc;
    $field_address[$no_of_fields] = $cur_address;
    $no_of_fields = $no_of_fields + 1;
}
dooku;

sub register_loop_field {

    local($spos, $width, $type, $default, $name, $desc) = @_;
    local($fname);

    $fname = sprintf($name, $register_index);
    field($spos, $width, $type, $default, $fname, $desc);
}
dooku;

sub field_loop {

    local($name, $desc) = @_;
    local($spos, $width, $type, $default, $fname, $fdesc);

    $spos = $field_base + ($field_index * $field_offset);
    $width = $field_width;
    $type = $field_type;
    $default = $field_default;

    $fname = sprintf($name, $field_index);
    $fdesc = sprintf($desc, $field_index);

    field($spos, $width, $type, $default, $fname, $fdesc);
}
dooku;

sub register {

    local($address, $name) = @_;
    $address =~ s/^0x//;
    $cur_address = sprintf("%x", $address);
    $register_address[$no_of_registers] = $cur_address;
    $register_name[$no_of_registers] = $name;
    $no_of_registers = $no_of_registers + 1;
}
dooku;

sub register_loop {

    local($name) = @_;
    local($raddr, $rname);

    $raddr = $register_base + ($register_index * $register_offset);
    $rname = sprintf($name, $register_index);
    register($raddr, $rname);
}
dooku;

sub instance {

    local($address, $core, $mname, $ifname, $ofname) = @_;
    local($n);

    $address =~ s/^0x//;
    $instance_address[$no_of_instances] = sprintf("%x", $address);
    $instance_core[$no_of_instances] = $core;
    $instance_module[$no_of_instances] = $mname;
    $instance_ifname[$no_of_instances] = $ifname;
    $instance_ofname[$no_of_instances] = $ofname;
    $no_of_instances = $no_of_instances + 1;
}
dooku;

sub module {

    local($address, $name) = @_;
    local($w);

    $address =~ s/^0x//;
    $module_name = $name;
    $no_of_fields = 0;
    $no_of_registers = 0;
    $no_of_instances = 0;
    $cur_address = 0;
    $mod_address = sprintf("%x", $address);

    if ($sw_name eq "") {
        $sw_name = $name;
    }

    if ($vlog == 1) {
        open(ofile, ">$outfile");
        print ofile "// **********************************************************************************\n";
        print ofile "// **********************************************************************************\n";
        print ofile "// ----------------------------------------------------------------------------------\n";
        print ofile "// ################\n";
        print ofile "// ##   ###########   Analog Devices Inc.\n";
        print ofile "// ##      ########\n";
        print ofile "// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.\n";
        print ofile "// ##            ##   This file is the confidential and proprietary property of ADI.\n";
        print ofile "// ##         #####   Possession or use of this file requires a written license.\n";
        print ofile "// ##      ########   The licensing information may be found at: www.analog.com\n";
        print ofile "// ##   ###########\n";
        print ofile "// ################\n";
        print ofile "// ----------------------------------------------------------------------------------\n";
        print ofile "// Description:       Auto generated, local modifications are discouraged.\n";
        print ofile "// ----------------------------------------------------------------------------------\n";
        print ofile "// **********************************************************************************\n";
        print ofile "// **********************************************************************************\n";
        print ofile "\n";
        print ofile "`timescale 1ps/1ps\n";
        print ofile "\n";
        print ofile "module ${name}_regs";
        $w = ($addr_width - $addr_width_used) - 1;
        if ($w > 0) {
            print ofile "  #(parameter [$w:0] ID = 0)";
        }
        print ofile " (\n";
        print ofile "\n";
    }

    if ($mkdn == 1) {
        $s = uc($name);
        $s =~ s/_/\\_/g;
        open(ofile, ">$outfile");
        print ofile "### ${s} Register Map\n";
        print ofile "The addresses shown are relative to the peripheral base address.\n";
        print ofile "\n";
        print ofile "---\n";
        print ofile "| Address | Bits | Field | Type | Default | Description |\n";
        print ofile "| ------- | ---- | ----- | ---- | ------- | ----------- |\n";
    }
}
dooku;

sub endmodule {

    local($n);

    if ($vlog == 1) {
        print ofile "endmodule\n";
        print ofile "\n";
        print ofile "// **********************************************************************************\n";
        print ofile "// **********************************************************************************\n";
        close(ofile);
    }

    if ($mkdn == 1) {
        print ofile "---\n";
        close(ofile);
    }
}
dooku;

sub endregisters {

    local($n, $i);
    local($m, $l, $s, $f, $spos, $type);

    if ($vlog == 1) {
        for ($i = 0; $i < $no_of_fields; $i++) {
            $s = lc($field_name[$i]);
            $w = $field_width[$i] - 1;
            if ($w < 10) {$w = " $w";}
            if ($field_type[$i] eq "RW1HC") {
                if ($field_width[$i] == 1) {
                    print ofile "    output  reg             axilite_${s} = 'd0,\n";
                    print ofile "    input   wire            axilite_${s}_clr,\n";
                } else {
                    print ofile "    output  reg   [$w:0]    axilite_${s} = 'd0,\n";
                    print ofile "    input   wire  [$w:0]    axilite_${s}_clr,\n";
                }
            } elsif ($field_type[$i] eq "RW") {
                if ($field_width[$i] == 1) {
                    print ofile "    output  reg             axilite_${s} = 'd0,\n";
                } else {
                    print ofile "    output  reg   [$w:0]    axilite_${s} = 'd0,\n";
                }
            } elsif ($field_type[$i] eq "MW") {
                print ofile "    output  reg             axilite_${s}_wr = 'd0,\n";
                if ($field_width[$i] == 1) {
                    print ofile "    output  reg             axilite_${s}_data = 'd0,\n";
                } else {
                    print ofile "    output  reg   [$w:0]    axilite_${s}_data = 'd0,\n";
                }
            } elsif ($field_type[$i] eq "MR") {
                print ofile "    output  reg             axilite_${s}_rd = 'd0,\n";
                if ($field_width[$i] == 1) {
                    print ofile "    input   wire            axilite_${s}_data,\n";
                } else {
                    print ofile "    input   wire  [$w:0]    axilite_${s}_data,\n";
                }
            } elsif ($field_type[$i] eq "RW1C") {
                if ($field_width[$i] == 1) {
                    print ofile "    input   wire            axilite_${s},\n";
                    print ofile "    output  wire            axilite_intr_${s},\n";
                } else {
                    print ofile "    input   wire  [$w:0]    axilite_${s},\n";
                    print ofile "    output  wire  [$w:0]    axilite_intr_${s},\n";
                }
            } else {
                if ($field_width[$i] == 1) {
                    print ofile "    input   wire            axilite_${s},\n";
                } else {
                    print ofile "    input   wire  [$w:0]    axilite_${s},\n";
                }
            }
        }
        print ofile "\n";
        $w = $addr_width - 1;
        if ($w < 10) {$w = " $w";}
        print ofile "    input   wire            axilite_clk,\n";
        print ofile "    input   wire            axilite_resetn,\n";
        print ofile "    input   wire            axilite_wrreq,\n";
        print ofile "    input   wire  [$w:0]    axilite_wraddr,\n";
        print ofile "    input   wire  [31:0]    axilite_wrdata,\n";
        print ofile "    output  reg             axilite_wrack = 'd0,\n";
        print ofile "    input   wire            axilite_rdreq,\n";
        print ofile "    input   wire  [$w:0]    axilite_rdaddr,\n";
        print ofile "    output  reg   [31:0]    axilite_rddata = 'd0,\n";
        print ofile "    output  reg             axilite_rdack = 'd0);\n";
        print ofile "\n";

        for ($i = 0; $i < $no_of_fields; $i++) {
            $s = lc($field_name[$i]);
            $w = $field_width[$i] - 1;
            if ($w < 10) {$w = " $w";}
            if ($field_type[$i] eq "RW1C") {
                if ($field_width[$i] == 1) {
                    print ofile "    reg                     axilite_${s}_w1c = 'd0;\n";
                } else {
                    print ofile "    reg           [$w:0]    axilite_${s}_w1c = 'd0;\n";
                }
            }
            if ($field_type[$i] eq "RW1HC") {
                if ($field_width[$i] == 1) {
                    print ofile "    reg                     axilite_${s}_clr_d = 'd0;\n";
                } else {
                    print ofile "    reg           [$w:0]    axilite_${s}_clr_d = 'd0;\n";
                }
            }
        }
        print ofile "\n";

        $m = $addr_width - 1;
        $l = $addr_width_used;
        print ofile "    always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
        print ofile "        if (axilite_resetn == 1'b0) begin\n";
        print ofile "            axilite_wrack <= 'd0;\n";
        print ofile "            axilite_rdack <= 'd0;\n";
        print ofile "        end else begin\n";
        if ($m > $l) {
            print ofile "            if (axilite_wraddr[$m:$l] == ID) begin\n";
            print ofile "                axilite_wrack <= axilite_wrreq;\n";
            print ofile "            end else begin\n";
            print ofile "                axilite_wrack <= 1'd0;\n";
            print ofile "            end\n";
            print ofile "            if (axilite_rdaddr[$m:$l] == ID) begin\n";
            print ofile "                axilite_rdack <= axilite_rdreq;\n";
            print ofile "            end else begin\n";
            print ofile "                axilite_rdack <= 1'd0;\n";
            print ofile "            end\n";
        } else {
            print ofile "            axilite_wrack <= axilite_wrreq;\n";
            print ofile "            axilite_rdack <= axilite_rdreq;\n";
        }
        print ofile "        end\n";
        print ofile "    end\n";
        print ofile "\n";
        for ($n = 0; $n < $no_of_registers; $n++) {
            for ($i = 0; $i < $no_of_fields; $i++) {
                if (($field_address[$i] eq $register_address[$n]) && ($field_type[$i] eq "RW")) {
                    print ofile "    always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
                    print ofile "        if (axilite_resetn == 1'b0) begin\n";
                    $s = lc($field_name[$i]);
                    print ofile "            axilite_${s} <= 'h$field_default[$i];\n";
                    print ofile "        end else begin\n";
                    print ofile "            if ((axilite_wrreq == 1'b1) &&";
                    $m = $addr_width - 1;
                    $l = $addr_width_used;
                    if ($m > $l) {
                        print ofile " (axilite_wraddr[$m:$l] == ID) &&";
                    }
                    $m = $addr_width_used - 1;
                    print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
                    if ($field_width[$i] == 32) {
                        print ofile "                axilite_${s} <= axilite_wrdata;\n";
                    } elsif ($field_width[$i] == 1) {
                        print ofile "                axilite_${s} <= axilite_wrdata[$field_spos[$i]];\n";
                    } else {
                        $l = $field_spos[$i];
                        $m = ($field_spos[$i] + $field_width[$i])-1;
                        print ofile "                axilite_${s} <= axilite_wrdata[$m:$l];\n";
                    }
                    if ($s =~ /timer$/) {
                        print ofile "            end else if (axilite_${s} > 0) begin\n";
                        print ofile "                axilite_${s} <= axilite_${s} - 1'b1;\n";
                    }
                    print ofile "            end\n";
                    print ofile "        end\n";
                    print ofile "    end\n";
                    print ofile "\n";
                }
                if (($field_address[$i] eq $register_address[$n]) && ($field_type[$i] eq "RW1HC")) {
                    print ofile "    always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
                    print ofile "        if (axilite_resetn == 1'b0) begin\n";
                    $s = lc($field_name[$i]);
                    print ofile "            axilite_${s}_clr_d <= 'd0;\n";
                    print ofile "            axilite_${s} <= 'h$field_default[$i];\n";
                    print ofile "        end else begin\n";
                    print ofile "            axilite_${s}_clr_d <= axilite_${s}_clr;\n";
                    if ($field_width[$i] > 1) {
                        for ($f = 0; $f < $field_width[$i]; $f++) {
                            print ofile "            if ((axilite_${s}_clr_d[$f] == 1'b0) && (axilite_${s}_clr[$f] == 1'b1)) begin\n";
                            print ofile "                axilite_${s}[$f] <= 1'b0;\n";
                            print ofile "            end else if ((axilite_wrreq == 1'b1) &&";
                            $m = $addr_width - 1;
                            $l = $addr_width_used;
                            if ($m > $l) {
                                print ofile " (axilite_wraddr[$m:$l] == ID) &&";
                            }
                            $m = $addr_width_used - 1;
                            print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
                            $m = $field_spos[$i]+$f;
                            print ofile "                axilite_${s}[$f] <= axilite_${s}[$f] | axilite_wrdata[$m];\n";
                            print ofile "            end\n";
                        }
                    } else {
                        print ofile "            if ((axilite_${s}_clr_d == 1'b0) && (axilite_${s}_clr == 1'b1)) begin\n";
                        print ofile "                axilite_${s} <= 1'b0;\n";
                        print ofile "            end else if ((axilite_wrreq == 1'b1) &&";
                        $m = $addr_width - 1;
                        $l = $addr_width_used;
                        if ($m > $l) {
                            print ofile " (axilite_wraddr[$m:$l] == ID) &&";
                        }
                        $m = $addr_width_used - 1;
                        print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
                        $m = $field_spos[$i];
                        print ofile "                axilite_${s} <= axilite_${s} | axilite_wrdata[$m];\n";
                        print ofile "            end\n";
                    }
                    print ofile "        end\n";
                    print ofile "    end\n";
                    print ofile "\n";
                }
                if (($field_address[$i] eq $register_address[$n]) && ($field_type[$i] eq "RW1C")) {
                    $s = lc($field_name[$i]);
                    print ofile "    assign axilite_intr_${s} = axilite_${s}_w1c;\n";
                    print ofile "\n";
                    print ofile "    always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
                    print ofile "        if (axilite_resetn == 1'b0) begin\n";
                    print ofile "            axilite_${s}_w1c <= 'h$field_default[$i];\n";
                    print ofile "        end else begin\n";
                    if ($field_width[$i] > 1) {
                        for ($f = 0; $f < $field_width[$i]; $f++) {
                            print ofile "            if (axilite_${s}[$f] == 1'b1) begin\n";
                            print ofile "                axilite_${s}_w1c[$f] <= 1'b1;\n";
                            print ofile "            end else if ((axilite_wrreq == 1'b1) &&";
                            $m = $addr_width - 1;
                            $l = $addr_width_used;
                            if ($m > $l) {
                                print ofile " (axilite_wraddr[$m:$l] == ID) &&";
                            }
                            $m = $addr_width_used - 1;
                            print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
                            $m = $field_spos[$i]+$f;
                            print ofile "                axilite_${s}_w1c[$f] <= axilite_${s}_w1c[$f] & ~axilite_wrdata[$m];\n";
                            print ofile "            end\n";
                        }
                    } else {
                        print ofile "            if (axilite_${s} == 1'b1) begin\n";
                        print ofile "                axilite_${s}_w1c <= 1'b1;\n";
                        print ofile "            end else if ((axilite_wrreq == 1'b1) &&";
                        $m = $addr_width - 1;
                        $l = $addr_width_used;
                        if ($m > $l) {
                            print ofile " (axilite_wraddr[$m:$l] == ID) &&";
                        }
                        $m = $addr_width_used - 1;
                        print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
                        $m = $field_spos[$i];
                        print ofile "                axilite_${s}_w1c <= axilite_${s}_w1c & ~axilite_wrdata[$m];\n";
                        print ofile "            end\n";
                    }
                    print ofile "        end\n";
                    print ofile "    end\n";
                    print ofile "\n";
                }
                if (($field_address[$i] eq $register_address[$n]) && ($field_type[$i] eq "MW")) {
                    print ofile "    always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
                    print ofile "        if (axilite_resetn == 1'b0) begin\n";
                    $s = lc($field_name[$i]);
                    print ofile "            axilite_${s}_wr <= 'd0;\n";
                    print ofile "            axilite_${s}_data <= 'h$field_default[$i];\n";
                    print ofile "        end else begin\n";
                    print ofile "            if ((axilite_wrreq == 1'b1) &&";
                    $m = $addr_width - 1;
                    $l = $addr_width_used;
                    if ($m > $l) {
                        print ofile " (axilite_wraddr[$m:$l] == ID) &&";
                    }
                    $m = $addr_width_used - 1;
                    print ofile " (axilite_wraddr[$m:0] == 'h$field_address[$i])) begin\n";
                    print ofile "                axilite_${s}_wr <= 1'd1;\n";
                    if ($field_width[$i] == 32) {
                        print ofile "                axilite_${s}_data <= axilite_wrdata;\n";
                    } elsif ($field_width[$i] == 1) {
                        print ofile "                axilite_${s}_data <= axilite_wrdata[$field_spos[$i]];\n";
                    } else {
                        $l = $field_spos[$i];
                        $m = ($field_spos[$i] + $field_width[$i])-1;
                        print ofile "                axilite_${s}_data <= axilite_wrdata[$m:$l];\n";
                    }
                    print ofile "            end else begin\n";
                    print ofile "                axilite_${s}_wr <= 1'd0;\n";
                    print ofile "                axilite_${s}_data <= axilite_${s}_data;\n";
                    print ofile "            end\n";
                    print ofile "        end\n";
                    print ofile "    end\n";
                    print ofile "\n";
                }
                if (($field_address[$i] eq $register_address[$n]) && ($field_type[$i] eq "MR")) {
                    print ofile "    always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
                    print ofile "        if (axilite_resetn == 1'b0) begin\n";
                    $s = lc($field_name[$i]);
                    print ofile "            axilite_${s}_rd <= 'd0;\n";
                    print ofile "        end else begin\n";
                    print ofile "            if ((axilite_rdreq == 1'b1) &&";
                    $m = $addr_width - 1;
                    $l = $addr_width_used;
                    if ($m > $l) {
                        print ofile " (axilite_rdaddr[$m:$l] == ID) &&";
                    }
                    $m = $addr_width_used - 1;
                    print ofile " (axilite_rdaddr[$m:0] == 'h$field_address[$i])) begin\n";
                    print ofile "                axilite_${s}_rd <= 1'd1;\n";
                    print ofile "            end else begin\n";
                    print ofile "                axilite_${s}_rd <= 1'd0;\n";
                    print ofile "            end\n";
                    print ofile "        end\n";
                    print ofile "    end\n";
                    print ofile "\n";
                }
            }
        }
        $m = $addr_width - 1;
        $l = $addr_width_used;
        print ofile "    always @(negedge axilite_resetn or posedge axilite_clk) begin\n";
        print ofile "        if (axilite_resetn == 1'b0) begin\n";
        print ofile "            axilite_rddata <= 'd0;\n";
        print ofile "        end else begin\n";
        if ($m > $l) {
            print ofile "            if ((axilite_rdreq == 1'b1) && (axilite_rdaddr[$m:$l] == ID)) begin\n";
        } else {
            print ofile "            if (axilite_rdreq == 1'b1) begin\n";
        }
        $m = $addr_width_used-1;
        print ofile "                case (axilite_rdaddr[$m:0])\n";
        for ($n = 0; $n < $no_of_registers; $n++) {
            $spos = 0;
            print ofile "                    'h$register_address[$n]: begin\n";
            for ($i = 0; $i < $no_of_fields; $i++) {
                if ($field_address[$i] eq $register_address[$n]) {
                    $s = lc($field_name[$i]);
                    if ($field_type[$i] eq "RW1C") {$s = "${s}_w1c";}
                    if (($field_type[$i] eq "MW") || ($field_type[$i] eq "MR")) {$s = "${s}_data";}
                    if ($field_width[$i] == 32) {
                        print ofile "                        axilite_rddata <= axilite_${s};\n";
                    } else {
                        if ($spos != $field_spos[$i]) {
                            $l = $spos;
                            $m = $field_spos[$i]-1;
                            if ($m == $l) {
                                print ofile "                        axilite_rddata[$m] <= 'd0;\n";
                            } else {
                                print ofile "                        axilite_rddata[$m:$l] <= 'd0;\n";
                            }
                        }
                        if ($field_width[$i] == 1) {
                            print ofile "                        axilite_rddata[$field_spos[$i]] <= axilite_${s};\n";
                        } else {
                            $m = ($field_spos[$i]+$field_width[$i])-1;
                            $l = $field_spos[$i];
                            print ofile "                        axilite_rddata[$m:$l] <= axilite_${s};\n";
                        }
                    }
                    $spos = $field_spos[$i] + $field_width[$i];
                }
            }
            if ($spos == 31) {
                print ofile "                        axilite_rddata[$spos] <= 'd0;\n";
            } elsif ($spos < 31) {
                print ofile "                        axilite_rddata[31:$spos] <= 'd0;\n";
            }
            print ofile "                    end\n";
        }
        print ofile "                    default: begin\n";
        print ofile "                        axilite_rddata <= 32'd0;\n";
        print ofile "                    end\n";
        print ofile "                endcase\n";
        print ofile "            end else begin\n";
        print ofile "                axilite_rddata <= 32'd0;\n";
        print ofile "            end\n";
        print ofile "        end\n";
        print ofile "    end\n";
        print ofile "\n";
    }

    if ($mkdn == 1) {
        for ($n = 0; $n < $no_of_registers; $n++) {
            for ($i = 0; $i < $no_of_fields; $i++) {
                if ($field_address[$i] eq $register_address[$n]) {
                    $s = lc($field_name[$i]);
                    $s =~ s/_/\\_/g;
                    if ($field_width[$i] > 1) {
                        $l = $field_width[$i] - 1;
                        $s = "${s}[${l}:0]";
                    }
                    $l = $field_spos[$i];
                    $m = ($field_spos[$i] + $field_width[$i])-1;
                    print ofile "| 0x$field_address[$i] | [${m}:${l}] | ${s} ";
                    $s = $field_desc[$i];
                    $s =~ s/_/\\_/g;
                    print ofile "| $field_type[$i] | 0x$field_default[$i] | $s |\n";
                }
            }
            print ofile "| | | | | | |\n";
        }
    }
}
dooku;

sub generate {

}
dooku;

## ##################################################################################
## ##################################################################################
