# ADRV9001 Transceiver MATLAB

## Getting Started
### Programming the Device
1. Ensure that the ADRV9001 transceiver evaluation software (TES) has been installed
2. Configure and then program. (If user wants to upload a Tx input file or tones using MATLAB later, user should load the Tx input file or tones before generating the MATLAB code. Refer to the "System Development User Guide" for detailed information regarding the Tx input file format)
3. Click Sample Code > MATLAB.
4. In the Select Folder dialog create a new directory to save the auto-generated MATLAB code.  As of TES 0.9.0,
multiple task based files will be generated with predetermined file names.  Note: If you auto-generate code in a
directory that already has code all of the files will be overwritten and any changes you've made will be lost.
5. Select Folder. The code generated will fully specify the state of the device and can be used to restore said
state entirely from MATLAB at a later point in time.
6. Close TES or Disconnect.
7. Run `main.m` to capture and retransmit the data.

### Helpful Snippets
To assign local context variables and some useful enums from `main.m` into the workspace:
```
...
adrv9001 = board.DeviceGet('adrv9001', 0);
fpga9001 = board.DeviceGet('fpga9001', 0);

% New code here
RX = common_Port_e.RX;
TX = common_Port_e.TX;
CHANNEL_1 = common_ChannelNumber_e.CHANNEL_1;
CHANNEL_2 = common_ChannelNumber_e.CHANNEL_2;

assignin('base', 'adrv9001', adrv9001Device_0);
assignin('base', 'fpga9001', fpga9001Device_0);
assignin('base', 'RX', RX);
assignin('base', 'TX', TX);
assignin('base', 'CHANNEL_1', CHANNEL_1);
assignin('base', 'CHANNEL_2', CHANNEL_2);
% End new code

initialize(board, fpga9001);
...
```

To parse data received in `dataCapture.m`, consider this:
```
AUTOGENERATOR_ERROR_HANDLER(fpga9001.dataChain.Data_Get_16IQInterleaved(common_Port_e.RX, common_ChannelNumber_e.CHANNEL_1, iqData_1, 16384));

interleavedData_1 = double(typecast(iqData_1.uint16, 'int16'));
iData = interleavedData_1(1:2:end);
qData = interleavedData_1(2:2:end);
```

To return parsed data from `dataCapture.m`, change the function declaration to:
```
function [iData, qData] = dataCapture(fpga9001)
```

With the above suggestions you can now do something akin to this from the workspace:
```
>>> beginCapture(fgpa9001);
>>> for loop
>>>   [iData, qData] = dataCapture(fpga9001);
>>> end
>>> stopReceiving(fgpa9001);
```

To parse data transmitted in `beginTransmitting.m`, consider this:
```
iqData_0 = [typecast(int16(iData), 'uint16'); typecast(int16(qData), 'uint16')];
iqData_0 = iqData_0(:)';

AUTOGENERATOR_ERROR_HANDLER(fpga9001.dataChain.Data_Set_16IQInterleaved(common_Port_e.TX, adi_common_ChannelNumber_e.CHANNEL_1, iqData_0, 64));
```


## Troubleshooting
### Issues with weird, unintellible errors
During local testing we've found different versions of MATLAB have different behaviors with regard to ServerManager.
If you get an error message about "Connection refused" or something about 'Hermes' try commenting out
```
%serverManager = ServerManager.CreateServerManager(ipAddress, username, password, serverLocation, serverName);
%serverManager.Start();
```
You can also try adding a `pause(1);` to allow time for the TCP connection to establish.

### Issues with system
An error as follows can occur
```
Could not load file or assembly 'System.Runtime, Version=5.0.0.0, Culture=neutral,
PublicKeyToken=b03f5f7f11d50a3a' or one of its dependencies. The system cannot find the file specified.
Source: mscorlib
HelpLink: None
```
To resolve:
- Ensure you are using Matlab version R2022b or later
- Open MATLAB.
- Create an empty folder and navigate to that empty folder so that no .m files are visible in the Folder Explorer.
- Close MATLAB.
- Open MATLAB.
- In the MATLAB console, enter `ne = dotnetenv("core")`
- If no error returned, MATLAB has switched its .NET context to .NET Core.
- Navigate to the folder where the Sample Code was generated and run main.m

### Other
- This code is *experimental* and may need to be tweaked to work correctly
- If MATLAB complains that a DLL cannot be found make sure that the variable
`CLIENT_INSTALL_DIRECTORY` points to the TES installation directory.  Look
carefully for a missing, trailing "\\".
