# README.md

## ADRV9001 prototype/ Overview
This document is an overview of the prototype/ folder of this SDK.

Shortcuts - [Workflows](#workflows) | [FPGA](#fpga) | [Software Stack](#software-stack) | [Stream Processor](#stream) | [Structure](#structure)

## <a name="workflows"></a> Workflows
Contained in this folder are tools and examples that are designed to help you be successful at
prototyping with the ADRV9001.  It's one thing to see the performance in the GUI; it's another
thing altogether to cobble together a system where the product is running in something that
resembles your end product running your algorithms.  The faster you get to prototype your
system, the faster you build confidence that your production solution will work and add value
to your customers, and we don't want to be an impediment to your progress.

There are a couple of workflows that we've imagined, and we have provided transitions between
phases that will help.  Note that every one of these workflows requires that you first run the
ADRV9001 transceiver evaluation software (TES).  TES upon connection will download the resources
to the platform, without which none of the prototyping tools will work.

As of TES 0.6.1 the ADRV9001 uses its stream processors.  The stream image for every configuration
is custom generated.  It is imperative that the configuration of the device operate with the
custuom stream image.  Currently, we do not allow you to create a custom stream image (or copy
said stream image to the platform) based on your configuration outside of TES.

*Note: You must use TES to configure the part, create the stream image, and copy
it to the platform before you can use any of these prototyping scripts.  Switching
configurations at the script layer will have no guarantee of correct operation.*

### Evaluation and Algorithm Development
In this workflow you:
1. Configure and Program the device using the ADRV9001 transceiver evaluation software (TES).
2. Connect to the device through Python or MATLAB and close some transmit/receive loop with
TES out of the loop.

We've provided both Python and MATLAB helper functions that let you connect to the hardware, get
the device handles, and use high-level `PerformRx`/`PerformTx` functions for moving data around.

### Evaluate once and System Development henceforth
In this workflow you:
1. Configure and Program the device using the ADRV9001 transceiver evaluation software (TES).
2. Save the device initialization by using the TES's File > Generate Python/MATLAB code feature.
3. Close TES and reset the part.
4. Connect to the device through Python or MATLAB.
5. Initialize the device using the generated code.
6. Design your radio.

Once you've finished Step 2, TES will not be needed to initialize the device from a reset state
because the generated file will contain the exact settings used in the first TES session, and will
be able to initialize the device identically within the native language you chose.

### Evaluate and Save Device Configuration to run Natively on the Platform
In this workflow you:
1. Configure and Program the device using the ADRV9001 transceiver evaluation software (TES).
2. Save the device initialization by using the TES's File > Generate C code feature.
3. Close TES and reset the part.
4. Compile the C code against the device driver API source code on the platform.
5. PuTTY into the platform, run the platform executable, and the device will be initialized.

The generated C code contains code that initializes the internal data structures to mirror the
settings described in TES.  You can take this code to help capture device state in a memory
efficient way which you can use in your end system.  There is a helpful script called
`compile_on_platform.py` located in the production/ folder that can help with this workflow.
See the README.md in that directory for more details.


## <a name="fpga"></a> FPGA
Keeping with the theme of helping you prototype sooner we have included FPGA HDL in this SDK.
Our Synchronous Serial Interface (SSI) is a custom interface, and given its novelty will require
time for you to get it working correctly starting from zero.  Please reference the included
HDL and user constraint files to serve as a starting point for writing your own code.  This code
is given *AS IS, WITHOUT WARRANTY*.  Please don't expect support on anything in the fpga/ folder.


## <a name="software-stack"></a> Software Stack
There is a lot of software written to operate the ADRV9001 transceiver, and it's easy to get
lost in the labyrinth.  *It is not inteded that this section fully describe the software
stack and all the inter-relationships therein.*  Rather it is to serve as a map to introduce
the components and how they generally fit together.

The ADRV9001 software stack can be visualized as such:
- On Windows
    - ADRV9001 transceiver evaluation software, Python, and MATLAB
    - Client DLL layer
- On Platform (Linux)
    - Server
    - Device Driver API
- On Device
    - Firmware

The Client and Server are a Remote Procedure Call (RPC) implementation to enable you to run device
driver APIs from Windows on the platform through a TCP/IP transport.

In each layer there are any number of components.  In our development ecosystem each component
is called a resource and is uniquely versioned.

Here are the resources and a brief description:
- On Windows
    - Adi.Adrv9001.ProfileGen - Business logic that maps a few system parameters to an
entire device profile that is used to initialize the ADRV9001.
    - Adi.Tpg.EvalClient - Client layer code containing the evaluation system bulder.
    - Adi.Tpg.EvalClient.Adrv9001.Board- Client layer RPC object representing the
    evaluation board.
    - Adi.Tpg.EvalClient.Adrv9001.Device - Client layer RPC object representing the
    ADRV9001.
    - Adi.Tpg.EvalClient.Fpga9001.Device - Client layer RPC object representing the
    FPGA.
    - Adi.Tpg.EvalClient.Zc706Sd20.Platform - Client layer RPC object representing the
    platform.
    - Adi.Tpg.EvalClient.LogReaders - Client layer RPC logging used for
    code generation.
    - Adi.Tpg.EvalClient.Adrv9001.LogReaders - Client layer RPC logging used for
    code generation.
    - Castle.Core - Inversion of control framework for managing Windows Client DLLs.
    - Castle.Windsor - Inversion of control framework for managing Windows Client DLLs.
    - SSH.NET - SSH libary to allow the Client layer to communicate with the platform.
- On Platform
    - Adi.Adrv9001.FpgaBinaries - HDL code written to demonstrate and exercise proper
ADRV9001 functionalty.
    - Adi.Adrv9001.Server - RPC server code running on the platform
which contains the device driver.
- On Device
    - Adi.Adrv9001.Firmware - The proprietary code running on the ADRV9001 that handles
calibration and proper operation.
    - Adi.Adrv9001.GainTables - Correction tables downloaded to the ADRV9001 to linearize
gain performance.

You will likely only interface directly with a few of these components as you endeavor to
prototype with the ADRV9001.  Hopefully, with the code generation, examples, and utilities
we've included in prototype/ you can quickly start prototyping without needing to fully
internalize this information, but we offer it as a reference nonetheless.


## <a name="stream"></a> Stream Processor
The ADRV9001 relies on both FW and a stream processor for operation.  The stream processor is
a co-processor that allows the ADRV9001 to make real-time decisions which offloads work for the
central processor and allows the ADRV9001 to interact very quickly (and deterministically) to
external signals.  It is not indended that the user create, modify, or understand the inner
workings of the stream processor and its image binaries.  The ADRV9001 Transceiver Evaluation
Software custom assembles stream images based on how the user configures the device.


## <a name="structure"></a> Structure
The prototype/ folder is broken into the following folders:
- DLLs/ - Binaries used to configure and control the ADRV901 from the client host.
- matlab/ - M files you can use to initialize, and transmit/receive vectors within the MATLAB environment.
- python/ - Python files you can use to initialize, and transmit/receive vectors within a Python environment.
- resources/ - Digital assets required for the proper operation of the ADRV9001 including firmware, FPGA images,
gain tables, and a device driver server.
- packages.adrv9001.config - A detailed list of every resource used in the ADRV9001 software stack.
- README.md - A detailed prototype/ document covering topics like workflows and the software stack.
