import sys
import os
import paramiko
import shutil

def sendCommand(client, command):
    stdin, stdout, stderr = client.exec_command(command)
    while True:
        text = stdout.read()
        if len(text) > 0:
            print(text)
        if stdout.channel.exit_status_ready():
            break

def mkdir_p(sftp, remote_directory):
    """Change to this directory, recursively making new folders if needed.
    Returns True if any folders were created."""
    if remote_directory == '/':
        # absolute path so change directory to root
        sftp.chdir('/')
        return
    if remote_directory == '':
        # top-level relative directory must exist
        return
    try:
        sftp.chdir(remote_directory) # sub-directory exists
    except IOError:
        dirname, basename = os.path.split(remote_directory.rstrip('/'))
        mkdir_p(sftp, dirname) # make parent directories
        sftp.mkdir(basename) # sub-directory missing, so created it
        sftp.chdir(basename)
        return True

def copyFolderToPlatform(client, localFolder, extensions=[], exclusions=[]):
    #Copies folder and all contents to deployment directory with same folder name
    for (dirpath, dirnames, filenames) in os.walk(localFolder):
        for f in filenames:
            if os.path.basename(__file__) in f:
                break

            local_filepath = os.path.abspath(os.path.join(dirpath, f))

            doCopy = True
            if len(extensions) > 0:
                _, extension = os.path.splitext(local_filepath)
                doCopy = extension[1:] in extensions

            if len(exclusions) > 0:
                for exclusion in exclusions:
                    doCopy &= local_filepath.find(exclusion) == -1
                    #print(f'{local_filepath}, {exclusion}, {doCopy}')

            #print('{0}, {1}'.format(local_filepath, doCopy))
            if doCopy:
                remote_filepath = deployment_dir + local_filepath.replace(cwd,'').replace('\\', '/')
                remote_folderpath = deployment_dir + dirpath.replace(cwd,'').replace('\\', '/')
                mkdir_p(client, remote_folderpath)
                client.put(local_filepath, remote_filepath)

# Getting/preparing necessary Directories
cwd = os.getcwd()
cmake_dir = os.path.join(cwd, 'cmake_build')
cmake_build_dir = os.path.join(cwd, 'build')
remote_cmake_example_dir = os.path.join(cwd, 'cmake_test')

c_src_dir = os.path.join(cwd, 'c_src')
destination_folder = os.path.join(cwd, 'cmake_build/c_src')
shutil.copytree(c_src_dir, destination_folder)

c99_app_dir = os.path.join(cwd, 'c99_app')
destination_folder1 = os.path.join(cwd, 'cmake_build/c_app')
shutil.copytree(c99_app_dir, destination_folder1)

# CMake commands
# Generate project build files
# The -S switch specifies source directory (containing root CMakeLists.txt)
# The -B switch specifies where to store build artifacts
# The -G switch generates makefiles for use with mingw32-make under a Windows command prompt, otherwise uses MSVC generator
os.system('cmake -S. -B build -G "MinGW Makefiles"')
# Run the build proces/compile project
os.system('cmake --build build')

os.system('mkdir cmake_test')
cmake_executable_dir = os.path.join(cwd, 'cmake_test')
c_src_executable = os.path.join(cmake_build_dir, 'cmake-example')
shutil.copy(c_src_executable, cmake_executable_dir)

# Copy arm and stream binaries to cmake_executable_dir
# Loop through all files in the source directory
for filename in os.listdir(destination_folder1):
    if filename.endswith('.bin'):
        source_path = os.path.join(destination_folder1, filename)
        destination_path = os.path.join(cmake_executable_dir, filename)

        # Check if it is a file and not a directory with the extension
        if os.path.isfile(source_path):
            shutil.copy(source_path, destination_path)
            print(f"Copied: {filename}")
        else:
            print(f"Skipped (not a regular file): {filename}")
# Get connection info
host_ip = '192.168.1.10'
user = 'root'
pw = 'analog'
port = 22

# Connecting to Platform
print("Connecting to platform...")
client = paramiko.SSHClient()
client.load_system_host_keys()
client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
client.connect(host_ip, port, user, pw)
print("Done")

# Starting File Transfer Instance
ftp_client = client.open_sftp()

# Choose Remote Deployement Directory Containing Generated C File
deployment_dir = '/home/analog/'
copyFolderToPlatform(ftp_client, cmake_executable_dir)
print("Done\n")

# Make the binary executable
sendCommand(client, 'sudo chmod +x ' + '/home/analog/cmake_test/cmake-example')

# Remove all the local cmake relevant directories
shutil.rmtree(cmake_dir, ignore_errors=True)
shutil.rmtree(cmake_build_dir, ignore_errors=True)
shutil.rmtree(remote_cmake_example_dir, ignore_errors=True)

#Closing File Transfer Instance
ftp_client.close()
print('\n\n')