/**
* \file
* \brief Function to initialize the linux_uio platform
* 
* Copyright 2020 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.txt" file in this zip file.
*/

#ifndef _ADI_PLATFORM_INIT_H_
#define _ADI_PLATFORM_INIT_H_

#include <stdint.h>
#include "adi_adrv9001_types.h"
#include "adi_fpga9001_types.h"
#include "adi_adm1293_types.h"

#ifdef __cplusplus
extern "C" {
#endif

int32_t linux_uio_initialize(adi_adrv9001_Device_t *adrv9001,
                             adi_fpga9001_Device_t *fpga9001,
                             adi_adm1293_Device_t *adm1293_vdd_1p0, 
                             adi_adm1293_Device_t *adm1293_vdda_1p0,
                             adi_adm1293_Device_t *adm1293_vdd_1p8,
                             adi_adm1293_Device_t *adm1293_vdda_1p8,
                             adi_adm1293_Device_t *adm1293_vdda_1p3);
    
    
    
    
    
#ifdef __cplusplus
}
#endif

#endif
