/**
* Copyright 2020 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information.
* see the "LICENSE.txt" file in this zip file.
*/

#include "linux_uio_init.h"
#include "adi_adrv9001_hal.h"
#include "adi_adrv9001_hal_linux_uio.h"
#include "adi_adm1293_hal_linux_uio.h"
#include "adi_fpga9001_hal_linux_uio.h"

int32_t linux_uio_initialize(adi_adrv9001_Device_t *adrv9001,
                             adi_fpga9001_Device_t *fpga9001,
                             adi_adm1293_Device_t *adm1293_vdd_1p0, 
                             adi_adm1293_Device_t *adm1293_vdda_1p0,
                             adi_adm1293_Device_t *adm1293_vdd_1p8,
                             adi_adm1293_Device_t *adm1293_vdda_1p8,
                             adi_adm1293_Device_t *adm1293_vdda_1p3)
{
    int32_t retVal = 0;
    
    if (NULL != adrv9001)
    {
        adrv9001->common.devHalInfo = linux_uio_adrv9001_cfg_create();
        if (NULL == adrv9001->common.devHalInfo)
        {
            return -1;
        }
    }
    
    if (NULL != fpga9001)
    {
        fpga9001->common.devHalInfo = linux_uio_fpga9001_open();
        if (NULL != adrv9001)
        {
            ((adi_adrv9001_hal_linux_uio_Cfg_t *)adrv9001->common.devHalInfo)->fpga9001 = fpga9001;
        }
        if (NULL == fpga9001->common.devHalInfo)
        {
            return -1;
        }
    }
    
    if (NULL != adrv9001)
    {
        retVal = adi_adrv9001_hal_open(adrv9001->common.devHalInfo);
        ADI_ERROR_RETURN(retVal);
    }

    if (NULL != adm1293_vdd_1p0)
    {
        adm1293_vdd_1p0->common.devHalInfo = linux_uio_adm1293_open(0);
        if (NULL == adm1293_vdd_1p0->common.devHalInfo)
        {
            return -1;
        }
    }

    if (NULL != adm1293_vdda_1p0)
    {
        adm1293_vdda_1p0->common.devHalInfo = linux_uio_adm1293_open(1);
        if (NULL == adm1293_vdda_1p0->common.devHalInfo)
        {
            return -1;
        }
    }

    if (NULL != adm1293_vdd_1p8)
    {
        adm1293_vdd_1p8->common.devHalInfo = linux_uio_adm1293_open(2);
        if (NULL == adm1293_vdd_1p8->common.devHalInfo)
        {
            return -1;
        }
    }

    if (NULL != adm1293_vdda_1p8)
    {
        adm1293_vdda_1p8->common.devHalInfo = linux_uio_adm1293_open(3);
        if (NULL == adm1293_vdda_1p8->common.devHalInfo)
        {
            return -1;
        }
    }

    if (NULL != adm1293_vdda_1p3)
    {
        adm1293_vdda_1p3->common.devHalInfo = linux_uio_adm1293_open(4);
        if (NULL == adm1293_vdda_1p3->common.devHalInfo)
        {
            return -1;
        }
    }
    
    return retVal;
}