/**
* \file
* \brief Type definitions for the linux_uio implementation of the FPGA9001 HAL
* 
* Copyright 2020 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.txt" file in this zip file.
*/

#ifndef _ADI_FPGA9001_HAL_LINUX_UIO_TYPES_H_
#define _ADI_FPGA9001_HAL_LINUX_UIO_TYPES_H_

#include <stdint.h>

#include "adi_linux_uio_types.h"

/**
 * \brief Memory map configuration object for the linux_uio implementation of the FPGA9001 HAL
 */
typedef struct adi_fpga9001_hal_AxiCfg
{
    char const *drvName;    /*!< Full path to the UIO driver file */
    uint32_t mapSize;       /*!< Number of bytes to memory map */
    int fd;                 /*!< UIO driver file descriptor */
    void *fptr;             /*!< UIO memory space */

} adi_fpga9001_hal_AxiCfg_t;

/**
 * \brief Configuration object for the UIO drivers
 */
typedef struct adi_fpga9001_hal_BbicCfg
{
    adi_fpga9001_hal_AxiCfg_t coreRegsCfg;      /*!< Core register configuration */
    adi_fpga9001_hal_AxiCfg_t ramCfg;           /*!< Capture RAM configuration */
} adi_fpga9001_hal_BbicCfg_t;

/**
 * \brief Context object for the linux_uio implementation of the FPGA9001 HAL
 */
typedef struct adi_fpga9001_hal_linux_uio_Cfg
{
    adi_hal_LogCfg_t logCfg;            /*!< Logging configuration */
    adi_fpga9001_hal_BbicCfg_t bbicCfg; /*!< UIO driver configuration */
} adi_fpga9001_hal_linux_uio_Cfg_t;

#endif
