/**
* \file
* \brief Helper functions for the linux_uio implementation of the FPGA9001 HAL
* 
* Copyright 2020 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.txt" file in this zip file.
*/

#ifndef _ADI_FPGA9001_HAL_LINUX_UIO_H_
#define _ADI_FPGA9001_HAL_LINUX_UIO_H_

#include <stdint.h>
#include "adi_fpga9001_hal_linux_uio_types.h"
#include "adi_fpga9001_hal.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \brief Create a HAL context object and open associated files
 * 
 * \note This is NOT a required HAL function. It is only required for use with the linux_uio evaluation platform
 * 
 * \returns The context object
 */
adi_fpga9001_hal_linux_uio_Cfg_t *linux_uio_fpga9001_open();

/**
 * \brief Close files associated with the HAL context object and free memory
 * 
 * \note This is NOT a required HAL function. It is only required for use with the linux_uio evaluation platform
 * 
 * \param[in] devHalCfg     The context object to close and free
 * 
 * \returns 0 to indicate success, negative number to indicate a file failed to close
 */
int32_t linux_uio_fpga9001_close(adi_fpga9001_hal_linux_uio_Cfg_t *devHalCfg);

/**
 * \copydoc adi_fpga9001_hal_Register_Read
 */
int32_t linux_uio_adi_fpga9001_hal_register_read(void *devHalCfg, const uint32_t addr, uint32_t *data);

/**
 * \copydoc adi_fpga9001_hal_Register_Write
 */
int32_t linux_uio_adi_fpga9001_hal_register_write(void *devHalCfg, const uint32_t addr, uint32_t data);

/**
 * \copydoc adi_fpga9001_hal_Ram_Read
 */
int32_t linux_uio_adi_fpga9001_hal_ram_read(void *devHalCfg, const uint32_t ramAddress, uint32_t data[], uint32_t length);

/**
 * \copydoc adi_fpga9001_hal_Ram_Write
 */
int32_t linux_uio_adi_fpga9001_hal_ram_write(void *devHalCfg, const uint32_t ramAddress, uint32_t data[], uint32_t length);

/**
 * \copydoc adi_fpga9001_hal_SsiType_Set
 */
int32_t linux_uio_adi_fpga9001_hal_SsiType_Set(void *devHalCfg, adi_fpga9001_SsiType_e ssiType);

/**
 * \copydoc adi_fpga9001_hal_DmaRelativeAddress_Get
 */
int32_t linux_uio_adi_fpga9001_hal_DmaRelativeAddress_Get(void *devHalCfg, adi_fpga9001_hal_Dma_e dma, uint32_t *addr);

/**
 * \copydoc adi_fpga9001_hal_CurrentPlatform_Get
 */
int32_t linux_uio_adi_fpga9001_hal_CurrentPlatform_Get(void *devHalCfg, adi_fpga9001_Platform_e *platform);

#ifdef __cplusplus
}
#endif

#endif
