/**
 * \file
 * \brief Timer functions
 *
 * Copyright 2018 Analog Devices Inc.
 *
 * Support for linux layer timer functions
 */

/**
* Copyright 2015 - 2018 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information.
* see the "LICENSE.txt" file in this zip file.
*/

#include <errno.h>
#include <time.h>
#include "adi_linux_uio_types.h"
#include "adi_linux_uio_timer.h"

/**
* \brief Provides a blocking delay of the current thread
*
* \param devHalCfg Pointer to device instance specific platform settings
* \param time_us the time to delay in mico seconds
*
* \retval 0 Function completed successfully
* \retval -2 the function has been called with a null pointer
*/
int32_t linux_uio_TimerWait_us(void *devHalCfg, uint32_t time_us)
{
    int32_t halError = 0;
    
    struct timespec t0;
    struct timespec t1;
    struct timespec *temp;
    struct timespec *waitTime = &t0;
    struct timespec *remaining = &t1;
    
    waitTime->tv_sec = time_us / 1000000;
    waitTime->tv_nsec = (time_us % 1000000) * (1000);

    do {
        halError = nanosleep(waitTime, remaining);
        temp = waitTime;
        waitTime = remaining;
        remaining = temp;
    } while ((halError == -1) && (errno == EINTR));

    return halError;
}

