/**
* \file
*/

/**
* Copyright 2015 - 2018 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information.
* see the "LICENSE.txt" file in this zip file.
*/

#ifndef _LINUX_UIO_LOGGING_H_
#define _LINUX_UIO_LOGGING_H_

#ifdef __KERNEL__
#include <linux/kernel.h>
#else
#include <stdio.h>
#include <stdint.h>
#endif

#include "adi_linux_uio_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Only allow log file to have MAX_NUM_LINES to prevent it from growing too large
 * If max lines reached, start back at line 0.
 */
#define LINUX_UIO_LOG_MAX_NUM_LINES 250000

#ifndef CLIENT_IGNORE
int32_t linux_uio_LogFileOpen(adi_hal_LogCfg_t *logCfg);
int32_t linux_uio_LogFileClose(adi_hal_LogCfg_t *logCfg);
int32_t linux_uio_LogWrite(void *devHalCfg, uint32_t logLevel, const char *comment, va_list argp);
#endif /* CLIENT_IGNORE */

#ifdef __cplusplus
}
#endif

#endif /* _LINUX_UIO_LOGGING_H_ */