/**
* \file
* \brief Type definitions for the linux_uio implementation of the ADRV9001 HAL
* 
* Copyright 2020 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.txt" file in this zip file.
*/

#ifndef _ADI_ADRV9001_HAL_LINUX_UIO_TYPES_H_
#define _ADI_ADRV9001_HAL_LINUX_UIO_TYPES_H_

#include <stdint.h>

#include "adi_fpga9001_types.h"
#include "adi_linux_uio_types.h"

/**
 * \brief SPI configuration object for the linux_uio implementation of the ADRV9001 HAL
 */
typedef struct adi_adrv9001_hal_linux_uio_spiCfg
{
    uint8_t chipSelectIndex; /*!< valid 1~8 */
    uint8_t CPHA; /*!< clock phase, sets which clock edge the data updates (valid 0 or 1) */
    uint8_t CPOL; /*!< clock polarity 0 = clock starts low, 1 = clock starts high */
    uint8_t enSpiStreaming; /*!< Not implemented. SW feature to improve SPI throughput. */
    uint8_t autoIncAddrUp; /*!< Not implemented. For SPI Streaming, set address increment direction. 1= next addr = addr+1, 0:addr = addr-1 */
    uint8_t fourWireMode; /*!< 1: Use 4-wire SPI, 0: 3-wire SPI (SDIO pin is bidirectional). NOTE: ADI's FPGA platform always uses 4-wire mode. */
    uint32_t spiClkFreq_Hz; /*!< SPI Clk frequency in Hz (default 25000000), platform will use next lowest frequency that it's baud rate generator can create */
} adi_adrv9001_hal_linux_uio_spiCfg_t;

/**
 * \brief Context object for the linux_uio implementation of the ADRV9001 HAL
 */
typedef struct adi_adrv9001_hal_linux_uio_Cfg
{
    adi_hal_LogCfg_t logCfg;                /*!< Logging configuration */
    adi_adrv9001_hal_linux_uio_spiCfg_t spiCfg; /*!< SPI configuration */
    adi_fpga9001_Device_t *fpga9001;        /*!< FPGA device context variable */
} adi_adrv9001_hal_linux_uio_Cfg_t;

#endif
