/**
* \file
* \brief Helper functions for the linux_uio implementation of the ADRV9001 HAL
* 
* Copyright 2020 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.txt" file in this zip file.
*/

#ifndef _ADI_ADRV9001_HAL_LINUX_UIO_H_
#define _ADI_ADRV9001_HAL_LINUX_UIO_H_

#include <stdint.h>
#include "adi_adrv9001_hal_linux_uio_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \brief Create a HAL context object
 * 
 * \note This is NOT a required HAL function. It is only required for use with the linux_uio evaluation platform
 * 
 * \returns The context object
 */
adi_adrv9001_hal_linux_uio_Cfg_t *linux_uio_adrv9001_cfg_create();

/**
 * \copydoc adi_adrv9001_hal_open
 */
int32_t linux_uio_adi_adrv9001_hal_open(void *devHalCfg);

/**
 * \copydoc adi_adrv9001_hal_close
 */
int32_t linux_uio_adi_adrv9001_hal_close(void *devHalCfg);

/**
 * \copydoc adi_hal_SpiWrite
 */
int32_t linux_uio_adi_adrv9001_hal_spi_write(void *devHalCfg, const uint8_t txData[], uint32_t numTxBytes);

/**
 * \copydoc adi_hal_SpiRead
 */
int32_t linux_uio_adi_adrv9001_hal_spi_read(void *devHalCfg, const uint8_t txData[], uint8_t rxData[], uint32_t numTxRxBytes);

/**
 * \copydoc adi_adrv9001_hal_close
 */
int32_t linux_uio_adi_adrv9001_hal_resetbPin_set(void *devHalCfg, uint8_t pinLevel);

/**
 * \copydoc adi_hal_ArmImagePageGet
 * \copydoc adi_hal_StreamImagePageGet
 */
int32_t linux_uio_adi_adrv9001_hal_image_page_get(void *devHalCfg, const char *imagePath, uint32_t pageIndex, uint32_t pageSize, uint8_t *rdBuff);

#ifdef __cplusplus
}
#endif

#endif
