/**
* \file
* \brief Type definitions for the linux_uio_userpace implementation of the ADM1293 HAL
* 
* Copyright 2020 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.txt" file in this zip file.
*/

#ifndef _ADI_ADM1293_HAL_LINUX_UIO_TYPES_H_
#define _ADI_ADM1293_HAL_LINUX_UIO_TYPES_H_

#include <stdint.h>

#include "adi_linux_uio_types.h"

/**
 * \brief i2c configuration object for the linux_uio implementation of the ADM1293 HAL
 */
typedef struct adi_adm1293_hal_linux_uio_i2cCfg
{
    int fd;                 /*!< i2c driver file descriptor */
    char const *drvName;    /*!< Full path to the i2c driver file */
    uint8_t slaveAddress;   /*!< i2c slave address of the particulare device */
} adi_adm1293_hal_linux_uio_i2cCfg_t;

/**
 * \brief Context object for the linux_uio implementation of the ADM1293 HAL
 */
typedef struct adi_adm1293_hal_linux_uio_Cfg
{
    adi_hal_LogCfg_t logCfg;                /*!< Logging configuration */
    adi_adm1293_hal_linux_uio_i2cCfg_t i2cCfg;  /*!< i2c configuration */
} adi_adm1293_hal_linux_uio_Cfg_t;

#endif
