/**
* \file
* \brief linux_uio implementation of the ADM1293 HAL
* 
* Copyright 2020 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.txt" file in this zip file.
*/

#ifndef _ADI_ADM1293_HAL_LINUX_UIO_H_
#define _ADI_ADM1293_HAL_LINUX_UIO_H_

#include <stdint.h>
#include "adi_adm1293_hal_linux_uio_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \brief Create a HAL context object and open associated files
 * 
 * \note This is NOT a required HAL function. It is only required for use with the linux_uio evaluation platform
 * 
 * \param[in] deviceIndex The index of the device to initialize
 *
 * \returns The context object
 */
adi_adm1293_hal_linux_uio_Cfg_t *linux_uio_adm1293_open(uint8_t deviceIndex);

/**
 * \brief Close files associated with the HAL context object and free memory
 * 
 * \note This is NOT a required HAL function. It is only required for use with the linux_uio evaluation platform
 *
 * \param[in] devHalCfg     The context object to close and free
 * 
 * \returns 0 to indicate success, negative number to indicate a file failed to close
 */
int32_t linux_uio_adm1293_close(adi_adm1293_hal_linux_uio_Cfg_t *devHalCfg);

/**
 * \copydoc adi_adm1293_hal_i2c_write
 */
int32_t linux_uio_adi_adm1293_hal_i2c_write(void *devHalCfg, const uint8_t wrData[], uint32_t numWrBytes);

/**
 * \copydoc adi_adm1293_hal_i2c_read
 */
int32_t linux_uio_adi_adm1293_hal_i2c_read(void *devHalCfg,
                                           const uint8_t wrData[], 
                                           uint32_t numWrBytes, 
                                           uint8_t rdData[], 
                                           uint32_t numRdBytes);
#ifdef __cplusplus
}
#endif

#endif
