/**
* \file
* \brief Types for the ADI LINUX_UIO platform (HAL implementation)
* 
* Copyright 2020 Analog Devices Inc.
* Released under the API license, for more information
* see the "LICENSE.txt" file in this zip file.
*/

#ifndef _ADI_LINUX_UIO_TYPES_H_
#define _ADI_LINUX_UIO_TYPES_H_

#ifdef __KERNEL__
#include <linux/kernel.h>
#else
#include <stdio.h>
#include <stdint.h>
#include "adi_fpga9001_types.h"
#endif

#define ADI_HAL_MAX_LOG_LINE 1000

/**
 * \brief Data structure for Logging facility
 */
typedef struct adi_hal_LogCfg
{
    uint8_t interfaceEnabled;
    FILE *logfd;
    char const *logFileName;
    uint32_t currentLineNumber;
} adi_hal_LogCfg_t;    

typedef struct adi_hal_Cfg
{
    adi_hal_LogCfg_t logCfg;
} adi_hal_Cfg_t;

#endif