/**
 * \file
 * \brief Template customer implementation of the FPGA9001 HAL
* 
* Copyright 2020 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.txt" file in this zip file.
 */

#ifndef _ADI_FPGA9001_HAL_CUSTOMER_H_
#define _ADI_FPGA9001_HAL_CUSTOMER_H_

#include <stdint.h>
#include "adi_fpga9001_hal.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \copydoc adi_fpga9001_hal_Register_Read
 */
int32_t customer_adi_fpga9001_hal_register_read(void *devHalCfg, const uint32_t addr, uint32_t *data);

/**
 * \copydoc adi_fpga9001_hal_Register_Write
 */
int32_t customer_adi_fpga9001_hal_register_write(void *devHalCfg, uint32_t addr, uint32_t data);

/**
 * \copydoc adi_fpga9001_hal_Ram_Read
 */
int32_t customer_adi_fpga9001_hal_ram_read(void *devHalCfg, const uint32_t ramAddress, uint32_t data[], uint32_t length);

/**
 * \copydoc adi_fpga9001_hal_Ram_Write
 */
int32_t customer_adi_fpga9001_hal_ram_write(void *devHalCfg, const uint32_t ramAddress, uint32_t data[], uint32_t length);

/**
 * \copydoc adi_fpga9001_hal_SsiType_Set
 */
int32_t customer_adi_fpga9001_hal_SsiType_Set(void *devHalCfg, adi_fpga9001_SsiType_e ssiType);

/**
 * \copydoc adi_fpga9001_hal_DmaRelativeAddress_Get
 */
int32_t customer_adi_fpga9001_hal_DmaRelativeAddress_Get(void *devHalCfg, adi_fpga9001_hal_Dma_e dma, uint32_t *addr);

#ifdef __cplusplus
}
#endif

#endif
