/**
 * \file
 * \brief Template customer implementation of the common HAL
* 
* Copyright 2020 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.txt" file in this zip file.
 */

#ifndef _ADI_COMMON_HAL_CUSTOMER_H_
#define _ADI_COMMON_HAL_CUSTOMER_H_

#include <stdio.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

int32_t customer_LogWrite(void *devHalCfg, uint32_t logLevel, const char *comment, va_list argp);
int32_t customer_TimerWait_us(void *devHalCfg, uint32_t time_us);

#ifdef __cplusplus
}
#endif

#endif
