/**
* Copyright 2015 - 2018 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information.
* see the "LICENSE.txt" file in this zip file.
*/

#include <stdarg.h>
#include "adi_fpga9001_hal.h"

#ifndef CUSTOMER_PLATFORM

#include "adi_linux_uio_logging.h"
#include "adi_linux_uio_timer.h"
#include "adi_adm1293_hal_linux_uio.h"
#include "adi_adrv9001_hal_linux_uio.h"
#include "adi_fpga9001_hal_linux_uio.h"

/* Logging interface */
int32_t(*adi_common_hal_LogWrite)(void *devHalCfg, uint32_t logLevel, const char *comment, va_list args) = linux_uio_LogWrite;

/* Timer interface */
int32_t(*adi_common_hal_Wait_us)(void *devHalCfg, uint32_t time_us) = linux_uio_TimerWait_us;

/* Pointer assignments for ADM1293 HAL */
int32_t(*adi_adm1293_hal_i2c_write)(void *devHalCfg, 
                                    const uint8_t wrData[], 
                                    uint32_t numWrBytes) = linux_uio_adi_adm1293_hal_i2c_write;
int32_t(*adi_adm1293_hal_i2c_read)(void *devHalCfg, 
                                   const uint8_t wrData[], 
                                   uint32_t numWrBytes, 
                                   uint8_t rdData[], 
                                   uint32_t numRdBytes) = linux_uio_adi_adm1293_hal_i2c_read;

/* Pointer assignments for ADRV9001 HAL */
int32_t(*adi_adrv9001_hal_open)(void *devHalCfg) = linux_uio_adi_adrv9001_hal_open;
int32_t(*adi_adrv9001_hal_close)(void *devHalCfg) = linux_uio_adi_adrv9001_hal_close;

int32_t(*adi_hal_SpiWrite)(void *devHalCfg, const uint8_t txData[], uint32_t numTxBytes) = linux_uio_adi_adrv9001_hal_spi_write;
int32_t(*adi_hal_SpiRead)(void *devHalCfg, const uint8_t txData[], uint8_t rxData[], uint32_t numRxBytes) = linux_uio_adi_adrv9001_hal_spi_read;

int32_t(*adi_adrv9001_hal_resetbPin_set)(void *devHalCfg, uint8_t pinLevel) = linux_uio_adi_adrv9001_hal_resetbPin_set;

int32_t(*adi_hal_ArmImagePageGet)(void *devHalCfg, const char *armImagePath, uint32_t pageIndex, uint32_t pageSize, uint8_t *rdBuff) = linux_uio_adi_adrv9001_hal_image_page_get;
int32_t(*adi_hal_StreamImagePageGet)(void *devHalCfg, const char *streamImagePath, uint32_t pageIndex, uint32_t pageSize, uint8_t *rdBuff) = linux_uio_adi_adrv9001_hal_image_page_get;
int32_t(*adi_hal_RxGainTableEntryGet)(void *devHalCfg, const char *rxGainTablePath, uint16_t lineCount, uint8_t *gainIndex, uint8_t *rxFeGain, uint8_t *tiaControl, uint8_t *adcControl, uint8_t *extControl, uint16_t *phaseOffset, int16_t *digGain) = NULL;
int32_t(*adi_hal_TxAttenTableEntryGet)(void *devHalCfg, const char *txAttenTablePath, uint16_t lineCount, uint16_t *attenIndex, uint8_t *txAttenHp, uint16_t *txAttenMult) = NULL;

/* Pointer assignments for FPGA9001 HAL */
int32_t(*adi_fpga9001_hal_Register_Read)(void *devHalCfg, const uint32_t addr, uint32_t *data) = linux_uio_adi_fpga9001_hal_register_read;

int32_t(*adi_fpga9001_hal_Register_Write)(void *devHalCfg, uint32_t addr, uint32_t data) = linux_uio_adi_fpga9001_hal_register_write;

int32_t(*adi_fpga9001_hal_Ram_Read)(void *devHalCfg, const uint32_t ramAddress, uint32_t data[], uint32_t length) = linux_uio_adi_fpga9001_hal_ram_read;

int32_t(*adi_fpga9001_hal_Ram_Write)(void *devHalCfg, const uint32_t ramAddress, uint32_t data[], uint32_t length) = linux_uio_adi_fpga9001_hal_ram_write;

int32_t(*adi_fpga9001_hal_SsiType_Set)(void *devHalCfg, adi_fpga9001_SsiType_e ssiType) = linux_uio_adi_fpga9001_hal_SsiType_Set;

int32_t(*adi_fpga9001_hal_DmaRelativeAddress_Get)(void *devHalCfg, adi_fpga9001_hal_Dma_e dma, uint32_t *addr) = linux_uio_adi_fpga9001_hal_DmaRelativeAddress_Get;

int32_t(*adi_fpga9001_hal_CurrentPlatform_Get)(void *devHalCfg, adi_fpga9001_Platform_e *platform) = linux_uio_adi_fpga9001_hal_CurrentPlatform_Get;

#else

#include "adi_common_hal_customer.h"
#include "adi_adm1293_hal_customer.h"
#include "adi_adrv9001_hal_customer.h"
#include "adi_fpga9001_hal_customer.h"

/* Logging interface */
int32_t(*adi_common_hal_LogWrite)(void *devHalCfg, uint32_t logLevel, const char *comment, va_list args) = customer_LogWrite;

/* Timer interface */
int32_t(*adi_common_hal_Wait_us)(void *devHalCfg, uint32_t time_us) = customer_TimerWait_us;

/* Pointer assignments for ADM1293 HAL */
int32_t(*adi_adm1293_hal_i2c_write)(void *devHalCfg, 
                                    uint8_t slaveAddress, 
                                    const uint8_t wrData[], 
                                    uint32_t numWrBytes) = customer_adi_adm1293_hal_i2c_write;
int32_t(*adi_adm1293_hal_i2c_read)(void *devHalCfg, 
                                   uint8_t slaveAddress, 
                                   const uint8_t wrData[], 
                                   uint32_t numWrBytes, 
                                   uint8_t rdData[], 
                                   uint32_t numRdBytes) = customer_adi_adm1293_hal_i2c_read;

/* Pointer assignments for ADRV9001 HAL */
int32_t(*adi_adrv9001_hal_open)(void *devHalCfg) = customer_adi_adrv9001_hal_open;
int32_t(*adi_adrv9001_hal_close)(void *devHalCfg) = customer_adi_adrv9001_hal_close;

int32_t(*adi_hal_SpiWrite)(void *devHalCfg, const uint8_t txData[], uint32_t numTxBytes) = customer_adi_adrv9001_hal_spi_write;
int32_t(*adi_hal_SpiRead)(void *devHalCfg, const uint8_t txData[], uint8_t rxData[], uint32_t numRxBytes) = customer_adi_adrv9001_hal_spi_read;

int32_t(*adi_adrv9001_hal_resetbPin_set)(void *devHalCfg, uint8_t pinLevel) = customer_adi_adrv9001_hal_resetbPin_set;

int32_t(*adi_hal_ArmImagePageGet)(void *devHalCfg, const char *armImagePath, uint32_t pageIndex, uint32_t pageSize, uint8_t *rdBuff) = NULL;
int32_t(*adi_hal_StreamImagePageGet)(void *devHalCfg, const char *streamImagePath, uint32_t pageIndex, uint32_t pageSize, uint8_t *rdBuff) = NULL;
int32_t(*adi_hal_RxGainTableEntryGet)(void *devHalCfg, const char *rxGainTablePath, uint16_t lineCount, uint8_t *gainIndex, uint8_t *rxFeGain, uint8_t *tiaControl, uint8_t *adcControl, uint8_t *extControl, uint16_t *phaseOffset, int16_t *digGain) = NULL;
int32_t(*adi_hal_TxAttenTableEntryGet)(void *devHalCfg, const char *txAttenTablePath, uint16_t lineCount, uint16_t *attenIndex, uint8_t *txAttenHp, uint16_t *txAttenMult) = NULL;

/* Pointer assignments for FPGA9001 HAL */
int32_t(*adi_fpga9001_hal_Register_Read)(void *devHalCfg, const uint32_t addr, uint32_t *data) = customer_adi_fpga9001_hal_register_read;

int32_t(*adi_fpga9001_hal_Register_Write)(void *devHalCfg, uint32_t addr, uint32_t data) = customer_adi_fpga9001_hal_register_write;

int32_t(*adi_fpga9001_hal_Ram_Read)(void *devHalCfg, const uint32_t ramAddress, uint32_t data[], uint32_t length) = customer_adi_fpga9001_hal_ram_read;

int32_t(*adi_fpga9001_hal_Ram_Write)(void *devHalCfg, const uint32_t ramAddress, uint32_t data[], uint32_t length) = customer_adi_fpga9001_hal_ram_write;

int32_t(*adi_fpga9001_hal_SsiType_Set)(void *devHalCfg, adi_fpga9001_SsiType_e ssiType) = customer_adi_fpga9001_hal_SsiType_Set;

int32_t(*adi_fpga9001_hal_DmaRelativeAddress_Get)(void *devHalCfg, adi_fpga9001_hal_Dma_e dma, uint32_t *addr) = customer_adi_fpga9001_hal_DmaRelativeAddress_Get;

#endif // !CUSTOMER_PLATFORM
