/**
 * \file
 * \brief Contains functions for controlling FPGA9001 REF_CLK output
 * 
 * Copyright 2021 Analog Devices Inc.
 * Released under the FPGA9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#include "adi_fpga9001_refclk.h"
#include "fpga9001_utilities.h"

static __maybe_unused int32_t adi_fpga9001_refclk_frequency_set_Validate(adi_fpga9001_Device_t *fpga9001, uint32_t frequency_hz)
{
    ADI_RANGE_CHECK(fpga9001, frequency_hz, 4690000, 250000000);
    ADI_API_RETURN(fpga9001);
}

int32_t adi_fpga9001_refclk_frequency_set(adi_fpga9001_Device_t *fpga9001, uint32_t frequency_hz)
{
    ADI_API_RETURN(fpga9001);
}
