/**
 * \file
 * \brief Contains top level fpga9001 MMCM related functions
 *
 * FPGA9001 API Version: $ADI_FPGA9001_API_VERSION$
 */

/**
 * Copyright 2019-2025 Analog Devices Inc.
 * Released under the FPGA9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#include "adi_common_error.h"
#include "adi_common_macros.h"
#include "adi_fpga9001_clock.h"
#include "fpga9001_utilities.h"

static __maybe_unused int32_t __maybe_unused adi_fpga9001_clock_Status_Get_Validate(adi_fpga9001_Device_t *fpga9001, adi_fpga9001_ClockStatus_t *status)
{
    ADI_NULL_PTR_RETURN(fpga9001, status);
    ADI_API_RETURN(fpga9001);
}

int32_t adi_fpga9001_clock_Status_Get(adi_fpga9001_Device_t *fpga9001, adi_fpga9001_ClockStatus_t *status)
{
    uint32_t unlocked = 0;
    uint32_t value = 0;

    ADI_PERFORM_VALIDATION(adi_fpga9001_clock_Status_Get_Validate, fpga9001, status);
    
    axi_adrv9001_top_mmcm_unlocked_get(fpga9001, AXI_ADRV9001_ID, AXI_ADRV9001_TOP_OFFSET, &unlocked);
    status->locked = !(bool)(unlocked & 0x1);
 
    axi_adrv9001_top_mcs_clk_mon_count_freq_hz(fpga9001, AXI_ADRV9001_ID, AXI_ADRV9001_TOP_OFFSET, &value);
    status->mcsClock_kHz = value / 1000;
    axi_adrv9001_gpio_clk_mon_count_freq_hz(fpga9001, AXI_ADRV9001_ID, AXI_ADRV9001_GPIO_OFFSET, &value);
    status->observationGpiosClock_kHz = value / 1000;
    axi_adrv9001_tdd_clk_mon_count_freq_hz(fpga9001, AXI_ADRV9001_ID, AXI_ADRV9001_TDD_OFFSET, &value);
    status->tddClock_kHz = value / 1000;
    axi_adrv9001_top_mmcm_ref_clk_mon_count_freq_hz(fpga9001, AXI_ADRV9001_ID, AXI_ADRV9001_TOP_OFFSET, &value);
    status->refClock_kHz = value / 1000;
    
    ADI_API_RETURN(fpga9001);
}
