/**
 * \file
 * \brief Contains functions for controlling FPGA9001 REF_CLK output
 * 
 * Copyright 2021 Analog Devices Inc.
 * Released under the FPGA9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#ifndef _ADI_FPGA9001_REFCLK_H_
#define _ADI_FPGA9001_REFCLK_H_

#ifdef __KERNEL__
#include <linux/types.h>
#else
#include <stdint.h>
#endif

#include "adi_fpga9001_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \brief Set the frequency of the FPGA9001 REF_CLK output signal
 *
 * \param[in] fpga9001      Context variable - Pointer to FPGA9001 device data structure
 * \param[in] frequency_hz  The frequency to set, denoted in Hertz (Hz)
 *
 * \returns A code indicating success (ADI_COMMON_ACT_NO_ACTION) or the required action to recover
 */
int32_t adi_fpga9001_refclk_frequency_set(adi_fpga9001_Device_t *fpga9001, uint32_t frequency_hz);

#ifdef __cplusplus
}
#endif

#endif /* _ADI_FPGA9001_REFCLK_H_ */