/*!
* \file
* \brief FPGA9001 MCS types
*
* FPGA9001 API Version: $ADI_FPGA9001_API_VERSION$
*/

/**
 * Copyright 2019-2025 Analog Devices Inc.
 * Released under the FPGA9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#ifndef _ADI_FPGA9001_MCS_TYPES_H_
#define _ADI_FPGA9001_MCS_TYPES_H_

#ifdef __cplusplus
extern "C" {
#endif
   
/**
 * \brief MCS edge alignment with device clock
 */
typedef enum adi_fpga9001_McsEdge
{
    ADI_FPGA9001_MCS_EDGE_RISING = 0,   /*!< Align MCS assert/deassert to rising edge of device clock */
    ADI_FPGA9001_MCS_EDGE_FALLING       /*!< Align MCS assert/deassert to falling edge of device clock */
} adi_fpga9001_McsEdge_e;

/**
 * \brief The desired configuration to initiate a sequence of MCS pulses
 */
typedef struct adi_fpga9001_McsCfg
{
    uint8_t numberOfPulses;            /*!< Number of pulses to generate(valid values : 1 - 16) */
    uint32_t mcsPeriod;                /*!< Number of device clock cycles between consecutive MCS pulses */
    uint32_t mcsPulseWidth;            /*!< Width of the pulse, denoted in number of device clock cycles */
    adi_fpga9001_McsEdge_e edge;       /*!< The device clock edge to which to align the pulse */   
} adi_fpga9001_McsCfg_t;

/**
 * \brief MCS status, latency, strobe, and data
 */
typedef struct adi_fpga9001_McsStatus
{
    uint32_t latency[2];               /*!< mcs to strobe latency (in number of ssi clocks) */
    uint32_t strobe[2];                /*!< mcs to first strobe */
    uint32_t data[2];                  /*!< mcs to first data */
    uint32_t bstrobe[2];               /*!< mcs to byte aligned strobe */
    uint32_t bdata[2];                 /*!< mcs to byte aligned data */
    uint32_t align_sel[2];             /*!< mcs alignment select */
    uint32_t delay_sel[2];             /*!< mcs delay select */
} adi_fpga9001_McsStatus_t;

#ifdef __cplusplus
}
#endif

#endif  /* _ADI_FPGA9001_MCS_TYPES_H_ */
