/**
 * \file
 * \brief Types for FPGA9001 Synchronous Frequency Hopping (FH) configuration
 *
 * ADRV9001 API Version: $ADI_FPGA9001_API_VERSION$
 */

/**
 * Copyright 2020 Analog Devices Inc.
 * Released under the FPGA9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#ifndef _ADI_FPGA9001_FH_TYPES_H_
#define _ADI_FPGA9001_FH_TYPES_H_

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

#include "adi_adrv9001_types.h"

/**
 * \brief Enumeration of FH per dynamic load type
 */
typedef enum adi_fpga9001_FhPerDynamicLoad
{
    ADI_FPGA9001_FH_HOP_PER_DYNAMIC_LOAD_ONE = 0,    /*!< 1 HOP per frame */
    ADI_FPGA9001_FH_HOP_PER_DYNAMIC_LOAD_FOUR = 1,   /*!< 4 HOP per frame */
    ADI_FPGA9001_FH_HOP_PER_DYNAMIC_LOAD_EIGHT = 2   /*!< 8 HOP per frame */
} adi_fpga9001_FhPerDynamicLoad_e;

#ifdef __cplusplus
}
#endif

#endif // !_ADI_FPGA9001_FH_TYPES_H_