/**
 * \file
 * \brief Functions for FPGA9001 Frequency Hopping configuration
 *
 * FPGA9001 API Version: $ADI_FPGA9001_API_VERSION$
 */

/**
 * Copyright 2020 Analog Devices Inc.
 * Released under the FPGA9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#ifndef _ADI_FPGA9001_FH_H_
#define _ADI_FPGA9001_FH_H_

#include <stdint.h>
#include "adi_fpga9001_fh_types.h"
#include "adi_fpga9001_datachain.h"
#include "adi_fpga9001_types.h"
#include "adi_fpga9001_tdd_types.h"
#include "adi_adrv9001_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \brief Generate TDD config structure parameters for SPI_TRIG
 * 
 * \pre This function can be called by the user after adi_fpga9001_DataChain_HopTable_Set_8S().
 * 
 * \param[in]  fpga9001                   Context variable - Pointer to the fpga9001 device data structure
 * \param[in]  tddConfig                  The desired TDD programmed mode configuration
 * \param[in]  numberHopsPerDynamicLoad   Number of Hops to be loaded in real time
 * \param[in]  bytesPerFrame              The desired number of bytes per frame
 * \param[out] spiTriggerConfig           The SPI_TRIG configuration
 * \param[out] numberFrames               The desired number of TDD frames in sequence
 *
 * \returns A code indicating success (ADI_COMMON_ACT_NO_ACTION) or the required action to recover
 */
int32_t adi_fpga9001_fh_Generate_SpiDma_Trigger(adi_fpga9001_Device_t *fpga9001,
                                                adi_fpga9001_TddConfig_t *tddConfig,
                                                adi_fpga9001_FhPerDynamicLoad_e numberHopsPerDynamicLoad,
                                                uint32_t bytesPerFrame,
                                                adi_fpga9001_TddEnableTiming_t *spiTriggerConfig,
                                                uint32_t *numberFrames);

#ifdef __cplusplus
}
#endif

#endif // !_ADI_FPGA9001_FH_H_