/**
 * \file
 * \brief Contains top level fpga9001 MMCM related function prototypes
 *
 * Refer to https://www.xilinx.com/support/documentation/application_notes/xapp888_7Series_DynamicRecon.pdf
 * for more info on MMCM DRP registers
 *
 * FPGA9001 API Version: $ADI_FPGA9001_API_VERSION$
 */
/**
 * Copyright 2015 - 2019 Analog Devices Inc.
 * Released under the FPGA9001 API license, for more information
 * see the "LICENSE.pdf" file in this zip file.
 */

#ifndef _ADI_FPGA9001_CLOCK_H_
#define _ADI_FPGA9001_CLOCK_H_

#include "adi_fpga9001_types.h"
#include "adi_fpga9001_clock_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \brief Get the lock status and clock frequencies of the FPGA9001
 *
 * \param[in]  fpga9001     Context variable - Pointer to FPGA9001 device data structure
 * \param[out] status       The current clock status
 *
 * \returns A code indicating success (ADI_COMMON_ACT_NO_ACTION) or the required action to recover
 */
int32_t adi_fpga9001_clock_Status_Get(adi_fpga9001_Device_t *fpga9001, adi_fpga9001_ClockStatus_t *status);

#ifdef __cplusplus
}
#endif

#endif /* _ADI_FPGA9001_CLOCK_H_ */