// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI AXI_MSPI_TOP Driver
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#ifndef AXI_MSPI_TOP_REGS_H
#define AXI_MSPI_TOP_REGS_H

#define AXI_MSPI_TOP_DISABLE 0x0
#define AXI_MSPI_TOP_FIFO_ENABLE 0x1
#define AXI_MSPI_TOP_DMA_ENABLE 0x3
#define AXI_MSPI_TOP_TRIGGER_DISABLE 0x0
#define AXI_MSPI_TOP_TRIGGER_RISING_EDGE 0x1
#define AXI_MSPI_TOP_TRIGGER_FALLING_EDGE 0x2
#define AXI_MSPI_TOP_TRIGGER_EDGE 0x3
#define AXI_MSPI_TOP_XFER_EMPTY 0xa
#define AXI_MSPI_TOP_XFER_MOSI_MASK 0x3
#define AXI_MSPI_TOP_XFER_MOSI_EMPTY 0x2
#define AXI_MSPI_TOP_XFER_MOSI_FULL 0x1
#define AXI_MSPI_TOP_XFER_MISO_MASK 0xc
#define AXI_MSPI_TOP_XFER_MISO_EMPTY 0x8
#define AXI_MSPI_TOP_XFER_MISO_FULL 0x4

#define AXI_MSPI_TOP_REG_VERSION_ADDR 0x0000
#define AXI_MSPI_TOP_VERSION_ADDR 0x0000
#define AXI_MSPI_TOP_VERSION_POS 0
#define AXI_MSPI_TOP_VERSION_MASK 0xffffffff

#define AXI_MSPI_TOP_REG_INSTANCE_ID_ADDR 0x0004
#define AXI_MSPI_TOP_INSTANCE_ID_ADDR 0x0004
#define AXI_MSPI_TOP_INSTANCE_ID_POS 0
#define AXI_MSPI_TOP_INSTANCE_ID_MASK 0xffffffff

#define AXI_MSPI_TOP_REG_SCRATCH_ADDR 0x0008
#define AXI_MSPI_TOP_SCRATCH_ADDR 0x0008
#define AXI_MSPI_TOP_SCRATCH_POS 0
#define AXI_MSPI_TOP_SCRATCH_MASK 0xffffffff

#define AXI_MSPI_TOP_REG_TIMER_ADDR 0x000c
#define AXI_MSPI_TOP_TIMER_ADDR 0x000c
#define AXI_MSPI_TOP_TIMER_POS 0
#define AXI_MSPI_TOP_TIMER_MASK 0xffffffff

#define AXI_MSPI_TOP_REG_SLAVE_SELECT_N_ADDR 0x0010
#define AXI_MSPI_TOP_SLAVE_SELECT_N_ADDR 0x0010
#define AXI_MSPI_TOP_SLAVE_SELECT_N_POS 0
#define AXI_MSPI_TOP_SLAVE_SELECT_N_MASK 0x00ff

#define AXI_MSPI_TOP_REG_ENABLE_ADDR 0x0020
#define AXI_MSPI_TOP_ENABLE_ADDR 0x0020
#define AXI_MSPI_TOP_ENABLE_POS 0
#define AXI_MSPI_TOP_ENABLE_MASK 0x0001
#define AXI_MSPI_TOP_AUTO_ADDR 0x0020
#define AXI_MSPI_TOP_AUTO_POS 1
#define AXI_MSPI_TOP_AUTO_MASK 0x0001

#define AXI_MSPI_TOP_REG_BUSY_ADDR 0x0024
#define AXI_MSPI_TOP_BUSY_ADDR 0x0024
#define AXI_MSPI_TOP_BUSY_POS 0
#define AXI_MSPI_TOP_BUSY_MASK 0x0001

#define AXI_MSPI_TOP_REG_NUM_OF_BYTES_ADDR 0x0030
#define AXI_MSPI_TOP_NUM_OF_BYTES_ADDR 0x0030
#define AXI_MSPI_TOP_NUM_OF_BYTES_POS 0
#define AXI_MSPI_TOP_NUM_OF_BYTES_MASK 0xfffff

#define AXI_MSPI_TOP_REG_NUM_OF_FRAMES_ADDR 0x0034
#define AXI_MSPI_TOP_NUM_OF_FRAMES_ADDR 0x0034
#define AXI_MSPI_TOP_NUM_OF_FRAMES_POS 0
#define AXI_MSPI_TOP_NUM_OF_FRAMES_MASK 0xfffff

#define AXI_MSPI_TOP_REG_SCLK_PERIOD_ADDR 0x0040
#define AXI_MSPI_TOP_SCLK_PERIOD_ADDR 0x0040
#define AXI_MSPI_TOP_SCLK_PERIOD_POS 0
#define AXI_MSPI_TOP_SCLK_PERIOD_MASK 0xffff

#define AXI_MSPI_TOP_REG_SCLK_INIT_ADDR 0x0050
#define AXI_MSPI_TOP_SCLK_INIT_ADDR 0x0050
#define AXI_MSPI_TOP_SCLK_INIT_POS 0
#define AXI_MSPI_TOP_SCLK_INIT_MASK 0x0001

#define AXI_MSPI_TOP_REG_MOSI_BIDIR_MODE_ADDR 0x0060
#define AXI_MSPI_TOP_MOSI_BIDIR_MODE_ADDR 0x0060
#define AXI_MSPI_TOP_MOSI_BIDIR_MODE_POS 0
#define AXI_MSPI_TOP_MOSI_BIDIR_MODE_MASK 0x0001

#define AXI_MSPI_TOP_REG_MOSI_BIDIR_OFFSET_ADDR 0x0064
#define AXI_MSPI_TOP_MOSI_BIDIR_OFFSET_ADDR 0x0064
#define AXI_MSPI_TOP_MOSI_BIDIR_OFFSET_POS 0
#define AXI_MSPI_TOP_MOSI_BIDIR_OFFSET_MASK 0x000f

#define AXI_MSPI_TOP_REG_MISO_CONTROL_ADDR 0x0070
#define AXI_MSPI_TOP_MISO_FALL1_RISE0_ADDR 0x0070
#define AXI_MSPI_TOP_MISO_FALL1_RISE0_POS 0
#define AXI_MSPI_TOP_MISO_FALL1_RISE0_MASK 0x0001

#define AXI_MSPI_TOP_REG_MISO_SELECT_ADDR 0x0074
#define AXI_MSPI_TOP_MISO_SELECT_ADDR 0x0074
#define AXI_MSPI_TOP_MISO_SELECT_POS 0
#define AXI_MSPI_TOP_MISO_SELECT_MASK 0x00ff

#define AXI_MSPI_TOP_REG_MISO_ENABLE_ADDR 0x0078
#define AXI_MSPI_TOP_MISO_ENABLE_ADDR 0x0078
#define AXI_MSPI_TOP_MISO_ENABLE_POS 0
#define AXI_MSPI_TOP_MISO_ENABLE_MASK 0x0001

#define AXI_MSPI_TOP_REG_TRIGGERS_ADDR 0x0080
#define AXI_MSPI_TOP_TRIGGER_MODE_ADDR 0x0080
#define AXI_MSPI_TOP_TRIGGER_MODE_POS 0
#define AXI_MSPI_TOP_TRIGGER_MODE_MASK 0x0003
#define AXI_MSPI_TOP_TRIGGER_MODE_POS_OFFSET 2

#define AXI_MSPI_TOP_REG_DMA1_FIFO0_ADDR 0x0090
#define AXI_MSPI_TOP_DMA1_FIFO0_ADDR 0x0090
#define AXI_MSPI_TOP_DMA1_FIFO0_POS 0
#define AXI_MSPI_TOP_DMA1_FIFO0_MASK 0x0001

#define AXI_MSPI_TOP_REG_SWRESET_ADDR 0x00a0
#define AXI_MSPI_TOP_SWRESET_ADDR 0x00a0
#define AXI_MSPI_TOP_SWRESET_POS 0
#define AXI_MSPI_TOP_SWRESET_MASK 0x0001

#define AXI_MSPI_TOP_REG_MOSI_DATA_ADDR 0x0100
#define AXI_MSPI_TOP_MOSI_DATA_ADDR 0x0100
#define AXI_MSPI_TOP_MOSI_DATA_POS 0
#define AXI_MSPI_TOP_MOSI_DATA_MASK 0x00ff

#define AXI_MSPI_TOP_REG_MISO_DATA_ADDR 0x0104
#define AXI_MSPI_TOP_MISO_DATA_ADDR 0x0104
#define AXI_MSPI_TOP_MISO_DATA_POS 0
#define AXI_MSPI_TOP_MISO_DATA_MASK 0x00ff

#define AXI_MSPI_TOP_REG_STATUS_ADDR 0x0110
#define AXI_MSPI_TOP_MOSI_FULL_ADDR 0x0110
#define AXI_MSPI_TOP_MOSI_FULL_POS 0
#define AXI_MSPI_TOP_MOSI_FULL_MASK 0x0001
#define AXI_MSPI_TOP_MOSI_EMPTY_ADDR 0x0110
#define AXI_MSPI_TOP_MOSI_EMPTY_POS 1
#define AXI_MSPI_TOP_MOSI_EMPTY_MASK 0x0001
#define AXI_MSPI_TOP_MISO_FULL_ADDR 0x0110
#define AXI_MSPI_TOP_MISO_FULL_POS 2
#define AXI_MSPI_TOP_MISO_FULL_MASK 0x0001
#define AXI_MSPI_TOP_MISO_EMPTY_ADDR 0x0110
#define AXI_MSPI_TOP_MISO_EMPTY_POS 3
#define AXI_MSPI_TOP_MISO_EMPTY_MASK 0x0001

#define AXI_MSPI_TOP_REG_BYTE_COUNT_ADDR 0x0114
#define AXI_MSPI_TOP_BYTE_COUNT_ADDR 0x0114
#define AXI_MSPI_TOP_BYTE_COUNT_POS 0
#define AXI_MSPI_TOP_BYTE_COUNT_MASK 0x7fffff

#define AXI_MSPI_TOP_REG_SSN_STATE_ADDR 0x0140
#define AXI_MSPI_TOP_SSN_STATE_ADDR 0x0140
#define AXI_MSPI_TOP_SSN_STATE_POS 0
#define AXI_MSPI_TOP_SSN_STATE_MASK 0x0001

#define AXI_MSPI_TOP_REG_SSN_SCLK_COUNT_ADDR 0x0144
#define AXI_MSPI_TOP_SSN_SCLK_COUNT_ADDR 0x0144
#define AXI_MSPI_TOP_SSN_SCLK_COUNT_POS 0
#define AXI_MSPI_TOP_SSN_SCLK_COUNT_MASK 0xffffffff

#define AXI_MSPI_TOP_REG_DMA_STATUS_ADDR 0x0148
#define AXI_MSPI_TOP_DMA_STATUS_ADDR 0x0148
#define AXI_MSPI_TOP_DMA_STATUS_POS 0
#define AXI_MSPI_TOP_DMA_STATUS_MASK 0x0001

#define AXI_MSPI_TOP_REG_INTR_ENABLE_ADDR 0x0204
#define AXI_MSPI_TOP_INTR_MOSI_FULL_ENABLE_ADDR 0x0204
#define AXI_MSPI_TOP_INTR_MOSI_FULL_ENABLE_POS 0
#define AXI_MSPI_TOP_INTR_MOSI_FULL_ENABLE_MASK 0x0001
#define AXI_MSPI_TOP_INTR_MOSI_EMPTY_ENABLE_ADDR 0x0204
#define AXI_MSPI_TOP_INTR_MOSI_EMPTY_ENABLE_POS 1
#define AXI_MSPI_TOP_INTR_MOSI_EMPTY_ENABLE_MASK 0x0001
#define AXI_MSPI_TOP_INTR_MISO_FULL_ENABLE_ADDR 0x0204
#define AXI_MSPI_TOP_INTR_MISO_FULL_ENABLE_POS 2
#define AXI_MSPI_TOP_INTR_MISO_FULL_ENABLE_MASK 0x0001
#define AXI_MSPI_TOP_INTR_MISO_EMPTY_ENABLE_ADDR 0x0204
#define AXI_MSPI_TOP_INTR_MISO_EMPTY_ENABLE_POS 3
#define AXI_MSPI_TOP_INTR_MISO_EMPTY_ENABLE_MASK 0x0001
#define AXI_MSPI_TOP_INTR_DMA_DONE_ENABLE_ADDR 0x0204
#define AXI_MSPI_TOP_INTR_DMA_DONE_ENABLE_POS 4
#define AXI_MSPI_TOP_INTR_DMA_DONE_ENABLE_MASK 0x0001
#define AXI_MSPI_TOP_INTR_XFER_DONE_ENABLE_ADDR 0x0204
#define AXI_MSPI_TOP_INTR_XFER_DONE_ENABLE_POS 5
#define AXI_MSPI_TOP_INTR_XFER_DONE_ENABLE_MASK 0x0001

#define AXI_MSPI_TOP_REG_SSN_DISABLE_ADDR 0x0280
#define AXI_MSPI_TOP_SSN_DISABLE_ADDR 0x0280
#define AXI_MSPI_TOP_SSN_DISABLE_POS 0
#define AXI_MSPI_TOP_SSN_DISABLE_MASK 0x00ff

#define AXI_MSPI_TOP_REG_SCLK_DISABLE_ADDR 0x0284
#define AXI_MSPI_TOP_SCLK_DISABLE_ADDR 0x0284
#define AXI_MSPI_TOP_SCLK_DISABLE_POS 0
#define AXI_MSPI_TOP_SCLK_DISABLE_MASK 0x00ff

#define AXI_MSPI_TOP_REG_MOSI_DISABLE_ADDR 0x0288
#define AXI_MSPI_TOP_MOSI_DISABLE_ADDR 0x0288
#define AXI_MSPI_TOP_MOSI_DISABLE_POS 0
#define AXI_MSPI_TOP_MOSI_DISABLE_MASK 0x00ff


#endif

// **********************************************************************************
// **********************************************************************************

