/**
 * \file
 * \brief BitField accessors for nvs_regmap_core_3
 *
 * Autogenerated with yoda-gen 1.2.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_NVS_REGMAP_CORE_3_H__
 #define __ADRV9001_BF_NVS_REGMAP_CORE_3_H__

#include "adrv9001_bf_hal.h"



/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc0Pa1RampDelayEnMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc0Pa1RampDelayEnMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc0Pa2RampDelayEnMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc0Pa2RampDelayEnMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc1Pa1RampDelayEnMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc1Pa1RampDelayEnMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc1Pa2RampDelayEnMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc1Pa2RampDelayEnMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc2Pa1RampDelayEnMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc2Pa1RampDelayEnMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc2Pa2RampDelayEnMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc2Pa2RampDelayEnMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc3Pa1RampDelayEnMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) 0: Unmask pa1_ramp_delay_en reset to analog, 1: Mask pa1_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc3Pa1RampDelayEnMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc3Pa2RampDelayEnMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x66), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) 0: Unmask pa2_ramp_delay_en reset to analog, 1: Mask pa2_ramp_delay_en reset to analog
 */
static inline int32_t adrv9001_NvsRegmapCore3_Adc3Pa2RampDelayEnMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x66), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in AUX_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbAuxPllClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in AUX_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbAuxPllClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CLK_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbClkPllClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe3), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CLK_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbClkPllClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CLK_PLL_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbClkPllLpClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe3), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CLK_PLL_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbClkPllLpClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_1 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore1ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_1 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore1ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_2 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore2ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe1), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_2 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore2ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_3 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore3ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe1), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE_3 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCore3ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbCoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) force hready even if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHready_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xed), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) force hready even if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHready_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xed), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) generate a response error from regmap if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHresp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xed), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) generate a response error from regmap if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHresp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xed), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Bypass the hresp error generator even if AHB or REG clk are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHrespBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xed), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Bypass the hresp error generator even if AHB or REG clk are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromRegmapHrespBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xed), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) force hready on SP even if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromSpHready_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xed), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) force hready on SP even if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromSpHready_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xed), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) generate a response error from SP if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromSpHresp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xed), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) generate a response error from SP if clock are gated
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbFromSpHresp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xed), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RF1_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRf1PllClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe3), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RF1_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRf1PllClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RF2_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRf2PllClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe3), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RF2_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRf2PllClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcIClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcIClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcLpClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcLpClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcQClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AdcQClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AnaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1AnaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx1CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcIClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcIClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcLpClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcLpClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcQClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AdcQClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AnaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2AnaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRx2CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb1AnaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb1AnaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb1CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb1CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb2CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in RXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbRxb2CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1AnaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1AnaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1DacClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe4), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX1_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx1DacClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2AnaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2AnaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2DacClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe5), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TX2_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTx2DacClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe5), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTxb1CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTxb1CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTxb2CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the AHB clock in TXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_AhbTxb2CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable12796_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1c9), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1c8), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1c7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1c6), (value >> 0));

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable12796_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c8), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable159128_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1cd), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1cc), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1cb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1ca), (value >> 0));

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable159128_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1cd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1cc), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1cb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1ca), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable191160_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1d1), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1d0), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1cf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1ce), (value >> 0));

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable191160_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1d1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1d0), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1cf), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1ce), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable223192_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1d5), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1d4), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1d3), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1d2), (value >> 0));

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable223192_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1d5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1d4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1d3), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1d2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable239224_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1d7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1d6), (value >> 0));

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable239224_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1d7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1d6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable310_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1bd), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1bc), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1bb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1ba), (value >> 0));

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable310_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1bd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1bc), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1bb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1ba), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable6332_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1c1), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1c0), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1bf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1be), (value >> 0));

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable6332_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c0), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1bf), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1be), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable9564_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1c5), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1c4), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1c3), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1c2), (value >> 0));

    return status;
}

/**
 * (C0 New) Enable corresponding ARM IRQ Pulse gen : 0=bypass, 1=ARM IRQ generated to ARM is a pulse of N cycles of 184MHz clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmIrqPulseGenEnable9564_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c3), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd0_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x0), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x0), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x0), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x0), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd10_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd10_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd11_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd11_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd12_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x6), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd12_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd13_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x6), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd13_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x6), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd14_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd14_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd15_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd15_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd16_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x8), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd16_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd17_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x8), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd17_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x8), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd18_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x9), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd18_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x9), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd19_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x9), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd19_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x9), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd20_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd20_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd21_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd21_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd22_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xb), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd22_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xb), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd23_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xb), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd23_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xb), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd24_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xc), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd24_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xc), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd25_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xc), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd25_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xc), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd26_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd26_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd27_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd27_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd28_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd28_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd29_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd29_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd3_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd3_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd30_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd30_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd31_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd31_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd32_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd32_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd33_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd33_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd34_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd34_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd35_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd35_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd36_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x15f), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (C0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd36_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15f), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd37_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x15f), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (C0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd37_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15f), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd4_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x2), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd4_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x2), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd5_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x2), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd5_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x2), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd6_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd6_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd7_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd7_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd8_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd8_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd9_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramNapRetPsd9_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of NAP input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverrideNap_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x15), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of NAP input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverrideNap_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of PSD input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverridePsd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x15), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of PSD input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverridePsd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of RET input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverrideRet_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x15), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Override the control of the latch during powerdown of RET input port of the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_ArmSramPowerdownLatchOverrideRet_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0DecLinearDataCapture_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x64), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0DecLinearDataCapture_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x64), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Linearity_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x6a), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x69), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Linearity_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x6a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x69), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0MsbFlip_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0MsbFlip_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Offset_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x68), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x67), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Offset_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x68), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x67), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0ReadData_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x6c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x6b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Sel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x80), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc0Sel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x80), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1DecLinearDataCapture_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x64), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1DecLinearDataCapture_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x64), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Linearity_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x70), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x6f), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Linearity_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x70), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x6f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1MsbFlip_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1MsbFlip_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Offset_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x6e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x6d), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Offset_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x6e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x6d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1ReadData_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x72), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x71), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Sel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x81), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc1Sel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x81), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2DecLinearDataCapture_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x64), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2DecLinearDataCapture_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x64), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Linearity_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x76), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x75), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Linearity_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x76), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x75), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2MsbFlip_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2MsbFlip_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Offset_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x74), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x73), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Offset_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x74), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x73), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2ReadData_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x78), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x77), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Sel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x82), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc2Sel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x82), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3DecLinearDataCapture_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x64), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3DecLinearDataCapture_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x64), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Linearity_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7c), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x7b), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Linearity_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x7b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3MsbFlip_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x7f), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3MsbFlip_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Offset_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x7a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x79), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Offset_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x7a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x79), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3ReadData_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x7e), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x7d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Sel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x83), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) Aux ADC input select
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdc3Sel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x83), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdcDecClkInv_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x62), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdcDecClkInv_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x62), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of cycles@184MHz of the reset generated by PA_RAMP delay enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdcPaResetClkExtend_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x65), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of cycles@184MHz of the reset generated by PA_RAMP delay enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxAdcPaResetClkExtend_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x65), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxPllSynthLdoHizBRes_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18b), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxPllSynthLdoHizBRes_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxPllVcoLdoHizBRes_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18b), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxPllVcoLdoHizBRes_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0Bypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0Bypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Flip AUXADC0 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0FlipMsb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Flip AUXADC0 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0FlipMsb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC0 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0LinearCorr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd1), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd0), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC0 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0LinearCorr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC0 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0OffsetCorr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd9), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd8), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC0 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac0OffsetCorr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1Bypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1Bypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Flip AUXADC1 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1FlipMsb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcf), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Flip AUXADC1 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1FlipMsb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcf), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC1 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1LinearCorr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd3), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd2), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC1 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1LinearCorr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC1 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1OffsetCorr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xdb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xda), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC1 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac1OffsetCorr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xdb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xda), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2Bypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2Bypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Flip AUXADC2 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2FlipMsb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcf), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Flip AUXADC2 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2FlipMsb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcf), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC2 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2LinearCorr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd5), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd4), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC2 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2LinearCorr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC2 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2OffsetCorr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xdd), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xdc), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC2 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac2OffsetCorr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xdd), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xdc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3Bypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: auxdac data output from pa_ramp, 1: auxdac data output from SPI (default)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3Bypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Flip AUXADC3 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3FlipMsb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcf), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Flip AUXADC3 SPI register MSB bit
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3FlipMsb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcf), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC3 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3LinearCorr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xd7), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xd6), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC3 linear correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3LinearCorr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xd7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xd6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) U1.11 AUXADC3 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3OffsetCorr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xdf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xde), (value >> 0));

    return status;
}

/**
 * (B0 New) U1.11 AUXADC3 offset correction factor
 */
static inline int32_t adrv9001_NvsRegmapCore3_Auxdac3OffsetCorr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xdf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xde), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxgenDivRatio_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xfc), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xfb), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxgenDivRatio_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xfc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xfb), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxpllVcoLdoBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xfa), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxpllVcoLdoBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xfa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxpllVcoLdoPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xfa), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_AuxpllVcoLdoPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xfa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ClkPllLpSynthLdoHizBRes_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18b), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ClkPllLpSynthLdoHizBRes_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ClkPllLpVcoLdoHizBRes_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18b), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ClkPllLpVcoLdoHizBRes_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ClkPllSynthLdoHizBRes_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ClkPllSynthLdoHizBRes_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ClkPllVcoLdoHizBRes_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ClkPllVcoLdoHizBRes_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Code Fabric reported an error on ARM master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSignal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x127), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from ARM master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSignalClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x128), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from ARM master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSignalClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x128), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on ARM master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSlaveHaddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x131), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x130), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x12f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x12e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on ARM master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSlaveHsize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x132), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on ARM master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterArmErrorSlaveHwrite_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x132), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Code Fabric reported an error on SPI-to-AHB master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSignal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x127), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SPI master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSignalClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x128), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SPI master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSignalClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x128), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on SPI master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSlaveHaddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x12c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x12b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x12a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x129), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on SPI master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSlaveHsize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x12d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of Code fabric Error on SPI master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_CodeFabricMasterSpiErrorSlaveHwrite_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x12d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ConverterLdoGmBoost_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xef), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ConverterLdoGmBoost_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xef), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ConverterLdoResLoad_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xef), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_ConverterLdoResLoad_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xef), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x57), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Clear realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x57), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Receive status for {arm_clk, clk368, clk184, golden}Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x58), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Start realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x57), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Start realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x57), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Use realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x57), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Use realign for {arm_clk, clk368, clk184, golden} Div Counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_CoreClkUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x57), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DevClkLdoGmBoost_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf0), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DevClkLdoGmBoost_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf0), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DevClkLdoResLoad_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf0), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DevClkLdoResLoad_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf0), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoDisThermalShutdown_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf2), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoDisThermalShutdown_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoFilterBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoFilterBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoGmBoost_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf2), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoGmBoost_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf2), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoIlimitInc_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf3), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoIlimitInc_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf3), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf3), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf3), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoResLoad_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf2), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoResLoad_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf2), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf5), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoThermalShutdown0c_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf3), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoThermalShutdown0c_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoVoutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf4), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoVoutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf4), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoVoutTrim_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf4), (value >> 0), 0x38, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigLdoVoutTrim_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf4), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DigSramSupplyOk_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0DeadCycleEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x118), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0DeadCycleEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x118), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0DeadCycleValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x11a), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0DeadCycleValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x11a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0MaxNumberOfWordMsb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma0MaxNumberOfWordMsb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1DeadCycleEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x118), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1DeadCycleEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x118), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1DeadCycleValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x11b), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1DeadCycleValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x11b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1MaxNumberOfWordMsb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma1MaxNumberOfWordMsb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2DeadCycleEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x118), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2DeadCycleEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x118), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2DeadCycleValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x11c), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2DeadCycleValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x11c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2MaxNumberOfWordMsb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11e), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma2MaxNumberOfWordMsb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3DeadCycleEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x118), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3DeadCycleEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x118), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3DeadCycleValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x11d), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3DeadCycleValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x11d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3MaxNumberOfWordMsb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_Dma3MaxNumberOfWordMsb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainDeadCycleEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x118), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Allow Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainDeadCycleEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x118), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainDeadCycleValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x119), (value >> 0));

    return status;
}

/**
 * (B0 New) Number of Dead Cycles between 2 DMA AHB access
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainDeadCycleValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x119), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainMaxNumberOfWordMsb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) MSB bit of the Maximum number of word possible in 1 DMA burst
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaMainMaxNumberOfWordMsb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemAhbError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mode to always update the memory with the data in the register
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemAlwaysWriteMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (C0 New) Mode to always update the memory with the data in the register
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemAlwaysWriteMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Block base offset address for index mode operation
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemBlockBaseOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x170), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x16f), (value >> 0));

    return status;
}

/**
 * (C0 New) Block base offset address for index mode operation
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemBlockBaseOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x170), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x16f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0: Index Table Format ,1. Block type instruction
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemBlockMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) 0: Index Table Format ,1. Block type instruction
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemBlockMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Debug mode where the register data and the data in the instruction are compared
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemCompareMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Debug mode where the register data and the data in the instruction are compared
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemCompareMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Miscompare Count where the DMA reports the register data and address
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemCompareStopCount_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16b), (value >> 0), 0x7e, 0x1);

    return status;
}

/**
 * (C0 New) Miscompare Count where the DMA reports the register data and address
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemCompareStopCount_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16b), &register_value, 0x7e, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) Current index address the DMA is executing
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemCurrIndex_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x178), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x177), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x176), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x175), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0: DMA Instruction Format, 1: Packed Data Format
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemDataFormat_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (C0 New) 0: DMA Instruction Format, 1: Packed Data Format
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemDataFormat_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) The destination address where to store the instructions. (Used in update memory mode with block instructions)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemDestAddr_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x169), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x168), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x167), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x166), (value >> 0));

    return status;
}

/**
 * (C0 New) The destination address where to store the instructions. (Used in update memory mode with block instructions)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemDestAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x169), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x168), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x167), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x166), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemEndOfTransferFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x179), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemErrorFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x179), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) Field type errors for invalid type of instructions/ Instructions misplaced in the wrong table.
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemFieldTypeError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17a), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemGenbusError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) Error flag when the last instruction is a read-only register or a non-existent register
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemLastInstInvalidError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) Register address where there is a miscompare
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemMiscompareAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17e), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x17d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) Current Miscompare Count/ Total Miscompare Count
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemMiscompareCount_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17b), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) Data from the register where there is a miscompare
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemMiscompareData_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x17c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mode to pause and resume from one miscompare to the next.
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemPauseResumeMiscompareMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x173), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Mode to pause and resume from one miscompare to the next.
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemPauseResumeMiscompareMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x173), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Register map offset address used by the DMA to refer for RMW instructions.
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemRegmapOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x172), (value >> 8), 0x7f, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x171), (value >> 0));

    return status;
}

/**
 * (C0 New) Register map offset address used by the DMA to refer for RMW instructions.
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemRegmapOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x172), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x171), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Signal used to resume to the next miscompare
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemResumeMiscompare_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x173), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) Signal used to resume to the next miscompare
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemResumeMiscompare_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x173), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) This is the number of instructions to be formed.
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemSize_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x165), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x164), (value >> 0));

    return status;
}

/**
 * (C0 New) This is the number of instructions to be formed.
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemSize_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x165), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x164), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mode to skip those registers that are read-only and registers not available in the regmap
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemSkipReadOnlyMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (C0 New) Mode to skip those registers that are read-only and registers not available in the regmap
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemSkipReadOnlyMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)  The starting register bus address to read from in DMA instruction mode/ the starting memory address to read from in update memory mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemSourceAddr_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x163), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x162), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x161), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x160), (value >> 0));

    return status;
}

/**
 * (C0 New)  The starting register bus address to read from in DMA instruction mode/ the starting memory address to read from in update memory mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemSourceAddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x163), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x162), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x161), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x160), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) DMA State
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemState_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x174), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) DMA Status
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x179), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Table base offset address for index mode operation
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemTableBaseOffsetAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16e), (value >> 8), 0xf, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x16d), (value >> 0));

    return status;
}

/**
 * (C0 New) Table base offset address for index mode operation
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemTableBaseOffsetAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16e), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x16d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mode to select update memory mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemUpdateMemMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) Mode to select update memory mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemUpdateMemMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mode to use reserved bit to skip updating the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemUseRsvBitMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (C0 New) Mode to use reserved bit to skip updating the memory
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaRegToMemUseRsvBitMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Control signal to select the DMA, 0: Mem-to-Reg DMA, 1: Reg-to-Mem DMA
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Control signal to select the DMA, 0: Mem-to-Reg DMA, 1: Reg-to-Mem DMA
 */
static inline int32_t adrv9001_NvsRegmapCore3_DmaSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCalcCrc_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCalcCrc_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCalcEcc_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCalcEcc_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Select the clock of the efuse : 0=ref_clk_out, 1=ref_clk_system_tick
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseClkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Select the clock of the efuse : 0=ref_clk_out, 1=ref_clk_system_tick
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseClkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCrcChecksum_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x3b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x3a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCrcDone_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x23), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCrcError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x23), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseCrcSpareData_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x35), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x34), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x33), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccAddr0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1e), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccAddr1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1f), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccAddr2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x20), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccAddr3_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x21), &register_value, 0x7f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccComplete_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x23), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccDoubleBitErr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x22), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccParity0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccParity1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccParity2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccParity3_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseEccSingleBitErr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x22), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseExportWithoutEcc_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseExportWithoutEcc_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseExternalReadState_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x23), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemAddr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x17), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemDataIn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x18), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemDataIn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x18), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemDataOut_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x19), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemRd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemRd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemWr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseIntMemWr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseInternalReadState_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x23), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseLoadEccDataIntoIntMem_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseLoadEccDataIntoIntMem_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseMrEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x16), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseMrEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x16), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: mse/ms/wmse/wms control from EFUSE,  mse/ms/wmse/wms control from SPI bits
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x37), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) 0: mse/ms/wmse/wms control from EFUSE,  mse/ms/wmse/wms control from SPI bits
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x37), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) ms control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramMs_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x36), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) ms control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramMs_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x36), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) mse control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramMse_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x37), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) mse control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramMse_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x37), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) wms control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramWms_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x36), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) wms control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramWms_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x36), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) wmse control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramWmse_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x37), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) wmse control
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideSramWmse_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x37), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgAbs_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x38), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgAbs_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x38), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgAbsUseFuse_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x38), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgAbsUseFuse_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x38), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgTempco_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x39), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgTempco_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x39), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgTempcoUseFuse_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x39), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_EfuseOverrideTrmVbgTempcoUseFuse_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x39), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Priority defined (SPI first, ARM second), 1: Round Robin mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricArbScheme_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x126), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: Priority defined (SPI first, ARM second), 1: Round Robin mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricArbScheme_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x126), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clock gating on AHB Fabric Crossbar
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricClkEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x126), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Clock gating on AHB Fabric Crossbar
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricClkEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x126), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Crossbar disabled for AHB bus, 1: Crossbar enabled for AHB bus
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x126), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Crossbar disabled for AHB bus, 1: Crossbar enabled for AHB bus
 */
static inline int32_t adrv9001_NvsRegmapCore3_FabricEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x126), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0: 1us reference is extracted from REF_CLK, 1: 1us reference is extracted from ARM_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexSp01usArmClkCounterSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) 0: 1us reference is extracted from REF_CLK, 1: 1us reference is extracted from ARM_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexSp01usArmClkCounterSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0: 1us reference is extracted from REF_CLK, 1: 1us reference is extracted from ARM_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexSp11usArmClkCounterSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (C0 New) 0: 1us reference is extracted from REF_CLK, 1: 1us reference is extracted from ARM_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexSp11usArmClkCounterSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0: 1us reference is extracted from REF_CLK, 1: 1us reference is extracted from ARM_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexSp21usArmClkCounterSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18c), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (C0 New) 0: 1us reference is extracted from REF_CLK, 1: 1us reference is extracted from ARM_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexSp21usArmClkCounterSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0: 1us reference is extracted from REF_CLK, 1: 1us reference is extracted from ARM_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexSp31usArmClkCounterSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (C0 New) 0: 1us reference is extracted from REF_CLK, 1: 1us reference is extracted from ARM_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexSp31usArmClkCounterSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mask all the trigger for Flex Stream Proc 0: 0=Unmasked(default), 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexStream0TriggerMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x17f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) Mask all the trigger for Flex Stream Proc 0: 0=Unmasked(default), 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexStream0TriggerMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mask all the trigger for Flex Stream Proc 1: 0=Unmasked(default), 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexStream1TriggerMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x17f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (C0 New) Mask all the trigger for Flex Stream Proc 1: 0=Unmasked(default), 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexStream1TriggerMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mask all the trigger for Flex Stream Proc 2: 0=Unmasked(default), 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexStream2TriggerMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x17f), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (C0 New) Mask all the trigger for Flex Stream Proc 2: 0=Unmasked(default), 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexStream2TriggerMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mask all the trigger for Flex Stream Proc 3: 0=Unmasked(default), 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexStream3TriggerMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x17f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (C0 New) Mask all the trigger for Flex Stream Proc 3: 0=Unmasked(default), 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_FlexStream3TriggerMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma0ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xec), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma0ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xec), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma1ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xec), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma1ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xec), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 2
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma2ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xec), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 2
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma2ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xec), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 3
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma3ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xec), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA 3
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusDma3ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xec), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp0ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xeb), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp0ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xeb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp1ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xeb), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp1ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xeb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 2
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp2ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xeb), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 2
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp2ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xeb), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 3
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp3ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xeb), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for Flex Stream Processor 3
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusFlexSp3ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xeb), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA MAIN
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusMainDmaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xec), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for DMA MAIN
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusMainDmaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xec), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for MAIN Stream Processor
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusMainSpClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xeb), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the GENBUS clock arbiter for MAIN Stream Processor
 */
static inline int32_t adrv9001_NvsRegmapCore3_GenbusMainSpClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xeb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoGmBoost1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf1), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoGmBoost1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf1), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoGmBoost2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf3), (value >> 0), 0x18, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoGmBoost2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf3), &register_value, 0x18, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoResLoad1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf1), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoResLoad1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf1), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoResLoad2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf3), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_GpLdoResLoad2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf3), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapAuxPll_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapAuxPll_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapClkPll_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapClkPll_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapClkPllLp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapClkPllLp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRf1Pll_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5f), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRf1Pll_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRf2Pll_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRf2Pll_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1Adc_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1Adc_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcI_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcI_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcLp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcLp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcQ_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1AdcQ_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1Ana_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1Ana_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1bAna_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx1bAna_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2Adc_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2Adc_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcI_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcI_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcLp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcLp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcQ_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2AdcQ_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2Ana_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapRx2Ana_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx1Ana_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx1Ana_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx1Dac_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x60), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx1Dac_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x60), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx2Ana_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx2Ana_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx2Dac_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x61), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) 0: Mask data read from Analog regmap, 1: Unmask data read
 */
static inline int32_t adrv9001_NvsRegmapCore3_MaskAnaRegmapTx2Dac_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x61), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) MBIST clock division ratio. (Default is Div1)
 */
static inline int32_t adrv9001_NvsRegmapCore3_MbistClkDiv_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x104), (value >> 0));

    return status;
}

/**
 * (B0 New) MBIST clock division ratio. (Default is Div1)
 */
static inline int32_t adrv9001_NvsRegmapCore3_MbistClkDiv_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x104), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: REF_CLK, 1: HS_DIG_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_MbistClkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x105), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: REF_CLK, 1: HS_DIG_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_MbistClkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x105), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) In early Powerup mode, once ARM sent the SPI Master command to the external interface, we need to set ARM back to powerdown mode until end of Timer
 */
static inline int32_t adrv9001_NvsRegmapCore3_MonEarlySleepPowerdownEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x19c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) In early Powerup mode, once ARM sent the SPI Master command to the external interface, we need to set ARM back to powerdown mode until end of Timer
 */
static inline int32_t adrv9001_NvsRegmapCore3_MonEarlySleepPowerdownEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x19c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Status specifying if the chip is in early wakeup or not : 0=end of Sleep, 1=end of early sleep
 */
static inline int32_t adrv9001_NvsRegmapCore3_MonEarlySleepStatus_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Status specifying if the chip is in early wakeup or not : 0=end of Sleep, 1=end of early sleep
 */
static inline int32_t adrv9001_NvsRegmapCore3_MonEarlySleepStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Early Wakeup Time (referred to the sleep timer in the monitor)
 */
static inline int32_t adrv9001_NvsRegmapCore3_MonEarlySleepTime_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1a0), (value >> 24));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x19f), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x19e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x19d), (value >> 0));

    return status;
}

/**
 * (C0 New) Early Wakeup Time (referred to the sleep timer in the monitor)
 */
static inline int32_t adrv9001_NvsRegmapCore3_MonEarlySleepTime_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1a0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x19f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x19e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x19d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable Early wakeup from sleep to transmit frames from SPI master before going to sleep again until the end of the Timer
 */
static inline int32_t adrv9001_NvsRegmapCore3_MonEarlySleepTimeEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x19c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Enable Early wakeup from sleep to transmit frames from SPI master before going to sleep again until the end of the Timer
 */
static inline int32_t adrv9001_NvsRegmapCore3_MonEarlySleepTimeEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x19c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Clock selection for Temp_sense clock : 0=ref_clk_internal (default), 1=ref_clk_out
 */
static inline int32_t adrv9001_NvsRegmapCore3_MonTempSenseRefClkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Clock selection for Temp_sense clock : 0=ref_clk_internal (default), 1=ref_clk_out
 */
static inline int32_t adrv9001_NvsRegmapCore3_MonTempSenseRefClkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) 0: PA RAMP TX1 HIGH THRESHOLD interrupt flag, 1: PA RAMP TX1 MID THRESHOLD interrupt flag, 2: PA RAMP TX2 HIGH THRESHOLD interrupt flag, 3: PA RAMP TX2 MID THRESHOLD interrupt flag
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampOrStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xce), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampSramNapRetPsd1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x14), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampSramNapRetPsd1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x14), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampSramNapRetPsd2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x14), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampSramNapRetPsd2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x14), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 During the PA RAMP OFF state, this value are feed to AUXDAC
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxadcCode0_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x8b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x8a), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 During the PA RAMP OFF state, this value are feed to AUXDAC
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxadcCode0_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x8b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x8a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 The factor multiplied with the data from LUT
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxadcCode1_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x8d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x8c), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 The factor multiplied with the data from LUT
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxadcCode1_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x8d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x8c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 The initial value of AUXADC input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacInit_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa2), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa1), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 The initial value of AUXADC input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacInit_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXDAC mamimum threshold, every output should be less than this value (default value = Fs *0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacOutMax_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x9f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x9e), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXDAC mamimum threshold, every output should be less than this value (default value = Fs *0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacOutMax_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x9f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x9e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC input valid counter threshold. The AUXADC input data will be used after this register number of data, to avoid the garbage data from AUXADC.
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacValidCntTh_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa3), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) AUXADC input valid counter threshold. The AUXADC input data will be used after this register number of data, to avoid the garbage data from AUXADC.
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1AuxdacValidCntTh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) update the close loop SPI manual control register from shadow register, asycn self cleared
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopManualUpdate_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x86), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) update the close loop SPI manual control register from shadow register, asycn self cleared
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopManualUpdate_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x86), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) close loop SPI manual control register, support on-the-fly change
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopManualValue_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x89), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x88), (value >> 0));

    return status;
}

/**
 * (B0 New) close loop SPI manual control register, support on-the-fly change
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopManualValue_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x89), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x88), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Sample and Hold mode, 1: Linear predication mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x86), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Sample and Hold mode, 1: Linear predication mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1CloopMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x86), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Force close loop input to ZERO during OFF and ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1DiffZeroEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x86), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Force close loop input to ZERO during OFF and ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1DiffZeroEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x86), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: select auxadc0 output as PA ramp close loop input, 1: auxadc1, 2: auxadc2, 3: auxadc3
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1InSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa0), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * (B0 New) 0: select auxadc0 output as PA ramp close loop input, 1: auxadc1, 2: auxadc2, 3: auxadc3
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1InSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa0), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) The LUT read interval.

 * 0: Read LUT every DP_CLK cycle

 * 1: Read LUT every 2 DP_CLK cycles

 * 3: Read LUT every 4 DP_CLK cycles

 * 7: Read LUT every 8 DP_CLK cycles

 * 15: Read LUT every 16 DP_CLK cycles

 * Others are not supported
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Interval_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x87), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) The LUT read interval.

 * 0: Read LUT every DP_CLK cycle

 * 1: Read LUT every 2 DP_CLK cycles

 * 3: Read LUT every 4 DP_CLK cycles

 * 7: Read LUT every 8 DP_CLK cycles

 * 15: Read LUT every 16 DP_CLK cycles

 * Others are not supported
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Interval_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x87), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Ki0_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x91), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x90), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x8f), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Ki0_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x91), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x90), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x8f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Ki1_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x94), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x93), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x92), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Ki1_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x94), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x93), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x92), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable signal to control the switch between factor 0 and 1 during PA ramp ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1KipSwitchEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x8e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable signal to control the switch between factor 0 and 1 during PA ramp ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1KipSwitchEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x8e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Kp0_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x97), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x96), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x95), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Kp0_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x97), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x96), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x95), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Kp1_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x9a), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x99), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x98), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1Kp1_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x9a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x99), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x98), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) During ON state, lock the AUXDAC output
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OnstateLock_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) During ON state, lock the AUXDAC output
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OnstateLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Open Loop Mode similar as Navassa A0, 1: Close Loop Mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OpenLoopDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x86), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Open Loop Mode similar as Navassa A0, 1: Close Loop Mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OpenLoopDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x86), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear TX1 HIGH and MID THRESHOLD interrupt flag
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Clear TX1 HIGH and MID THRESHOLD interrupt flag
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange high threshold. When data exceeds this value, an interrupt will be generated (default value = Fs*0.9). Set this value to 16'h7FFF to disable the high threshold interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrHighTh_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa5), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa4), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange high threshold. When data exceeds this value, an interrupt will be generated (default value = Fs*0.9). Set this value to 16'h7FFF to disable the high threshold interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrHighTh_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC overrange mid counter threshold
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidCntTh_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa9), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) AUXADC overrange mid counter threshold
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidCntTh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa9), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC overrange settle counter threshold, used in mid overrange mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidStlTh_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xa9), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) AUXADC overrange settle counter threshold, used in mid overrange mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidStlTh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xa9), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange mid thredhold. An interrupt will be generated when both mid_cnt and stl_cnt reaches the threshold value (default value = Fs*0.75), Set this value to 16'h7FFF to disable the mid threshold interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidTh_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xa6), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange mid thredhold. An interrupt will be generated when both mid_cnt and stl_cnt reaches the threshold value (default value = Fs*0.75), Set this value to 16'h7FFF to disable the mid threshold interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1OrMidTh_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xa6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 Preset value of the close loop input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RampupstartPreset_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x9d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x9c), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 Preset value of the close loop input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RampupstartPreset_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x9d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x9c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Preset the close loop input at the PA ramp enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RampupstartPresetEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x9b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Preset the close loop input at the PA ramp enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RampupstartPresetEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x9b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: select data from LUT, 1: select data from SPI registers, debug purpose
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RefinSwCtrl_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x86), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: select data from LUT, 1: select data from SPI registers, debug purpose
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx1RefinSwCtrl_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x86), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 During the PA RAMP OFF state, this value are feed to AUXDAC
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxadcCode0_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xaf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xae), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 During the PA RAMP OFF state, this value are feed to AUXDAC
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxadcCode0_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xaf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xae), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 The factor multiplied with the data from LUT
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxadcCode1_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb0), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 The factor multiplied with the data from LUT
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxadcCode1_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 The initial value of AUXADC input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacInit_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc6), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc5), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 The initial value of AUXADC input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacInit_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXDAC mamimum threshold, every output should be less than this value (default value = Fs *0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacOutMax_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc3), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc2), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXDAC mamimum threshold, every output should be less than this value (default value = Fs *0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacOutMax_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC input valid counter threshold. The AUXADC input data will be used after this register number of data, to avoid the garbage data from AUXADC.
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacValidCntTh_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xc7), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) AUXADC input valid counter threshold. The AUXADC input data will be used after this register number of data, to avoid the garbage data from AUXADC.
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2AuxdacValidCntTh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xc7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) update the close loop SPI manual control register from shadow register, asycn self cleared
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopManualUpdate_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xaa), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) update the close loop SPI manual control register from shadow register, asycn self cleared
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopManualUpdate_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xaa), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) close loop SPI manual control register, support on-the-fly change
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopManualValue_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xad), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xac), (value >> 0));

    return status;
}

/**
 * (B0 New) close loop SPI manual control register, support on-the-fly change
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopManualValue_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xad), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xac), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Sample and Hold mode, 1: Linear predication mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xaa), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Sample and Hold mode, 1: Linear predication mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2CloopMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xaa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Force close loop input to ZERO during OFF and ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2DiffZeroEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xaa), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Force close loop input to ZERO during OFF and ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2DiffZeroEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xaa), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: select auxadc0 output as PA ramp close loop input, 1: auxadc1, 2: auxadc2, 3: auxadc3
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2InSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xc4), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * (B0 New) 0: select auxadc0 output as PA ramp close loop input, 1: auxadc1, 2: auxadc2, 3: auxadc3
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2InSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xc4), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) The LUT read interval.

 * 0: Read LUT every DP_CLK cycle

 * 1: Read LUT every 2 DP_CLK cycles

 * 3: Read LUT every 4 DP_CLK cycles

 * 7: Read LUT every 8 DP_CLK cycles

 * 15: Read LUT every 16 DP_CLK cycles

 * Others are not supported
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Interval_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xab), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) The LUT read interval.

 * 0: Read LUT every DP_CLK cycle

 * 1: Read LUT every 2 DP_CLK cycles

 * 3: Read LUT every 4 DP_CLK cycles

 * 7: Read LUT every 8 DP_CLK cycles

 * 15: Read LUT every 16 DP_CLK cycles

 * Others are not supported
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Interval_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xab), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Ki0_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb5), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb4), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb3), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Ki0_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Ki1_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb8), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb6), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_I factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Ki1_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable signal to control the switch between factor 0 and 1 during PA ramp ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2KipSwitchEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xb2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable signal to control the switch between factor 0 and 1 during PA ramp ON state
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2KipSwitchEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xb2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Kp0_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xbb), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xba), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xb9), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 0
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Kp0_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xbb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xba), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xb9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Kp1_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xbe), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xbd), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xbc), (value >> 0));

    return status;
}

/**
 * (B0 New) S4.20 K_P factor 1
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2Kp1_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xbe), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xbd), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xbc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) During ON state, lock the AUXDAC output
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OnstateLock_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xc4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) During ON state, lock the AUXDAC output
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OnstateLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xc4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Open Loop Mode similar as Navassa A0, 1: Close Loop Mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OpenLoopDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xaa), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: Open Loop Mode similar as Navassa A0, 1: Close Loop Mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OpenLoopDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xaa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear TX1 HIGH and MID THRESHOLD interrupt flag
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcc), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Clear TX1 HIGH and MID THRESHOLD interrupt flag
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange high threshold. When data exceeds this value, an interrupt will be generated (default value = Fs*0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrHighTh_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc9), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc8), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange high threshold. When data exceeds this value, an interrupt will be generated (default value = Fs*0.9)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrHighTh_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC overrange mid counter threshold
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidCntTh_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcd), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) AUXADC overrange mid counter threshold
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidCntTh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcd), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) AUXADC overrange settle counter threshold, used in mid overrange mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidStlTh_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xcd), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) AUXADC overrange settle counter threshold, used in mid overrange mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidStlTh_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xcd), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange mid thredhold. An interrupt will be generated when both mid_cnt and stl_cnt reaches the threshold value (default value = Fs*0.75)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidTh_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xcb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xca), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 AUXADC overrange mid thredhold. An interrupt will be generated when both mid_cnt and stl_cnt reaches the threshold value (default value = Fs*0.75)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2OrMidTh_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xcb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xca), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) S1.15 Preset value of the close loop input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RampupstartPreset_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xc0), (value >> 0));

    return status;
}

/**
 * (B0 New) S1.15 Preset value of the close loop input
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RampupstartPreset_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xc0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Preset the close loop input at the PA ramp enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RampupstartPresetEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xbf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Preset the close loop input at the PA ramp enable rising edge
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RampupstartPresetEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xbf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: select data from LUT, 1: select data from SPI registers, debug purpose
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RefinSwCtrl_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xaa), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) 0: select data from LUT, 1: select data from SPI registers, debug purpose
 */
static inline int32_t adrv9001_NvsRegmapCore3_PaRampTx2RefinSwCtrl_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xaa), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PdRefClkInt_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PdRefClkInt_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PdRefClkIntActiveShield_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PdRefClkIntActiveShield_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Select the clock for the PFIR Coeff programming (0: REF_clk, 1: 184MHz)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PfirCoeff184ClkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x15d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Select the clock for the PFIR Coeff programming (0: REF_clk, 1: 184MHz)
 */
static inline int32_t adrv9001_NvsRegmapCore3_PfirCoeff184ClkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) PFIR Address Auto increment mode : 0=standard mode, 1=auto_increment mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PfirCoeffAutoIncrAddrMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x15e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) PFIR Address Auto increment mode : 0=standard mode, 1=auto_increment mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_PfirCoeffAutoIncrAddrMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) PFIR Write Enable done. Set when coefficient wr_enable is done,
 */
static inline int32_t adrv9001_NvsRegmapCore3_PfirWrEnableDone_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) PFIR Write Enable done. Set when coefficient wr_enable is done,
 */
static inline int32_t adrv9001_NvsRegmapCore3_PfirWrEnableDone_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) New Realign Div value
 */
static inline int32_t adrv9001_NvsRegmapCore3_RealignClkDivNewValue_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x184), (value >> 24), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x183), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x182), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x181), (value >> 0));

    return status;
}

/**
 * (C0 New) New Realign Div value
 */
static inline int32_t adrv9001_NvsRegmapCore3_RealignClkDivNewValue_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x184), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x183), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x182), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x181), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0: use standard Realign counter to realign clocks, 1: Use new value to realign clocks
 */
static inline int32_t adrv9001_NvsRegmapCore3_RealignClkUseNewValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x180), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) 0: use standard Realign counter to realign clocks, 1: Use new value to realign clocks
 */
static inline int32_t adrv9001_NvsRegmapCore3_RealignClkUseNewValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x180), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntClkBufferEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntClkBufferEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntDevclkDivideRatio_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf6), (value >> 0), 0x1c, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntDevclkDivideRatio_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf6), &register_value, 0x1c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntDevclkDividerMcsResetb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf6), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntDevclkDividerMcsResetb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntMcsSampleEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefClkIntMcsSampleEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mask the GPIO that trig the Reference Timer : 0=Unmasked, 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerITGpioPinMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b4), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (C0 New) Mask the GPIO that trig the Reference Timer : 0=Unmasked, 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerITGpioPinMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Select GPIO to send the interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerITGpioPinSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b4), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (C0 New) Select GPIO to send the interrupt
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerITGpioPinSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b4), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Each bit of this field masks one of the following events to ARM interrupt: bit0: Event Val0, bit1: Event Val1, bit2: Event Val2, bit3: Event Val3, bit4: Event Max Val, bit5: Event Zero Val, bit6: Monitor Start Event, bit7: Monitor Start Event
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerArmEventMaskIT_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1b5), (value >> 0));

    return status;
}

/**
 * (C0 New) Each bit of this field masks one of the following events to ARM interrupt: bit0: Event Val0, bit1: Event Val1, bit2: Event Val2, bit3: Event Val3, bit4: Event Max Val, bit5: Event Zero Val, bit6: Monitor Start Event, bit7: Monitor Start Event
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerArmEventMaskIT_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1b5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) Ref Timer ARM Interrupt status
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerArmEventStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1b6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Clear the IRQ line to ARM
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerArmEventStatusClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) Clear the IRQ line to ARM
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerArmEventStatusClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Clears the external IT output when it is in level mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerClearLevelIT_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b3), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (C0 New) Clears the external IT output when it is in level mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerClearLevelIT_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b3), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Capture current count value using SPI
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterCapture_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) Capture current count value using SPI
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterCapture_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) Reference Timer Current counter value
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterCaptureValue_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1af), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1ae), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1ad), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0=Enable Reference Timer with SPI bit, 1=Enable Reference Timer with PIN
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterEnableUsingPin_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a9), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (C0 New) 0=Enable Reference Timer with SPI bit, 1=Enable Reference Timer with PIN
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterEnableUsingPin_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Load new counter value using SPI.
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterLoad_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (C0 New) Load new counter value using SPI.
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterLoad_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) A new counter value can be loaded at any time usning SPI or a trigger pin
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterLoadValue_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1ac), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1ab), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1aa), (value >> 0));

    return status;
}

/**
 * (C0 New) A new counter value can be loaded at any time usning SPI or a trigger pin
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterLoadValue_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1ac), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1ab), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1aa), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Reference Timer Counter incrementing or decrementing : 0=Decrement, 1=Increment
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterUpOrDown_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a8), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (C0 New) Reference Timer Counter incrementing or decrementing : 0=Decrement, 1=Increment
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerCounterUpOrDown_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) A new delta value is used to adjust the counter current value at any time
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerDeltaVal_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b0), (value >> 0), 0x3f, 0x0);

    return status;
}

/**
 * (C0 New) A new delta value is used to adjust the counter current value at any time
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerDeltaVal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b0), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Adjust enable of counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerDeltaValEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b0), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (C0 New) Adjust enable of counter
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerDeltaValEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b0), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Counter Adjust type:  0: Add,  1= Substract
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerDeltaValIncr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b0), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (C0 New) Counter Adjust type:  0: Add,  1= Substract
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerDeltaValIncr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b0), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable the Reference Timer
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Enable the Reference Timer
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Each bit of this field masks one of the following events: bit0: Event Val0, bit1: Event Val1, bit2: Event Val2, bit3: Event Val3, bit4: Event Max Val, bit5: Event Zero Val, bit6: Monitor Start Event, bit7: Monitor Start Event
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerEventMaskIT_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1b1), (value >> 0));

    return status;
}

/**
 * (C0 New) Each bit of this field masks one of the following events: bit0: Event Val0, bit1: Event Val1, bit2: Event Val2, bit3: Event Val3, bit4: Event Max Val, bit5: Event Zero Val, bit6: Monitor Start Event, bit7: Monitor Start Event
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerEventMaskIT_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1b1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) This register captures the events that happen since the last clear.

 * Only unmasked events are captured in this status register.

 * A READ to this register clears it
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerEventStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1b2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Clear the IRQ line to GPIO
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerGpioEventStatusClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Clear the IRQ line to GPIO
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerGpioEventStatusClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable Reference Timer to control Monitor Scheduler
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerMonEnableEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Enable Reference Timer to control Monitor Scheduler
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerMonEnableEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Select the source of the start of the monitor : 0=SPI or Pin (B0 compliant), 1=from reference Timer
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerMonEnablePinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (C0 New) Select the source of the start of the monitor : 0=SPI or Pin (B0 compliant), 1=from reference Timer
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerMonEnablePinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0=Detect posedge of Pin (or event) for stop, 1= Detect negedge of Pin (or event) for stop
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerMonEnableStopEdgeDetectPolarity_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b9), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (C0 New) 0=Detect posedge of Pin (or event) for stop, 1= Detect negedge of Pin (or event) for stop
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerMonEnableStopEdgeDetectPolarity_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b9), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Selects the Monitor stop event from a pin (1) or from the counter event (0).

 * 0: Monitor Stop Event from Timer value comparison with STOP time value.

 * 1: Monitor Stop Event from GPIO pin (Monitor Enable) or a SPI register bit.
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerMonEnableStopUsePin_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) Selects the Monitor stop event from a pin (1) or from the counter event (0).

 * 0: Monitor Stop Event from Timer value comparison with STOP time value.

 * 1: Monitor Stop Event from GPIO pin (Monitor Enable) or a SPI register bit.
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerMonEnableStopUsePin_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Indicates if the generated external interrupt is a pulse (0) or a level (1)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerPulseOrLevelIT_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b3), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Indicates if the generated external interrupt is a pulse (0) or a level (1)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerPulseOrLevelIT_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Indicates the duration of the external IT in terms of number of ref. clock cycles.
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerPulseWidthIT_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1b3), (value >> 0), 0x7e, 0x1);

    return status;
}

/**
 * (C0 New) Indicates the duration of the external IT in terms of number of ref. clock cycles.
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerPulseWidthIT_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1b3), &register_value, 0x7e, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Reference Timer Clock Division ratio from ref_clk (N value can be programmed from 0 to 63. Ratio=N+1)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerRefclkDiv_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a7), (value >> 0), 0x7e, 0x1);

    return status;
}

/**
 * (C0 New) Reference Timer Clock Division ratio from ref_clk (N value can be programmed from 0 to 63. Ratio=N+1)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerRefclkDiv_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a7), &register_value, 0x7e, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Reference Timer Clock Enable
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerRefclkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Reference Timer Clock Enable
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerRefclkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mask ref_timer events that goes to SPI master start trigger: 0=Unmasked, 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerSpimEventMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1b8), (value >> 0));

    return status;
}

/**
 * (C0 New) Mask ref_timer events that goes to SPI master start trigger: 0=Unmasked, 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerSpimEventMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1b8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mask the GPIO that trig the Reference Timer : 0=Unmasked, 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerTrigGpioPinMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a9), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (C0 New) Mask the GPIO that trig the Reference Timer : 0=Unmasked, 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerTrigGpioPinMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Select GPIO to Trig the Reference Timer
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerTrigGpioPinSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a9), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (C0 New) Select GPIO to Trig the Reference Timer
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerTrigGpioPinSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a9), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Selects the mode of operation of the next Pin trigger event (Pulse): 0=None, 1=load, 2=start, 3=capture
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerTriggerPinMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a9), (value >> 0), 0xc0, 0x6);

    return status;
}

/**
 * (C0 New) Selects the mode of operation of the next Pin trigger event (Pulse): 0=None, 1=load, 2=start, 3=capture
 */
static inline int32_t adrv9001_NvsRegmapCore3_RefTimerTriggerPinMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a9), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in AUX_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegAuxPllClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the REG clock in AUX_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegAuxPllClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CLK_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegClkPllClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CLK_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegClkPllClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CLK_PLL_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegClkPllLpClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe8), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CLK_PLL_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegClkPllLpClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_1 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore1ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_1 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore1ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_2 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore2ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe6), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_2 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore2ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_3 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore3ClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe6), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE_3 regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCore3ClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the REG clock in CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegCoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RF1_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRf1PllClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RF1_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRf1PllClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RF2_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRf2PllClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe8), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RF2_PLL regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRf2PllClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcIClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcIClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcLpClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcLpClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcQClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AdcQClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AnaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1AnaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx1CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcIClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_I regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcIClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcLpClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_LP regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcLpClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcQClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ADC_Q regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AdcQClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AnaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2AnaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRx2CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb1AnaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb1AnaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb1CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb1CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb2CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Gate the REG clock in RXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegRxb2CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1AnaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1AnaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1DacClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe9), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX1_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx1DacClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2AnaClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_ANA regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2AnaClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2DacClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xea), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TX2_DAC regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTx2DacClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xea), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTxb1CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TXB1_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTxb1CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate the REG clock in TXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTxb2CoreClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xe7), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Gate the REG clock in TXB2_CORE regmap for power saving
 */
static inline int32_t adrv9001_NvsRegmapCore3_RegTxb2CoreClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xe7), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrConfig0_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0xfe), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrConfig0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0xfe), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xfd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xfd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xfd), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1ExtloRccrSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xfd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoDisThermalShutdown_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x186), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoDisThermalShutdown_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x186), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoFilterBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x186), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoFilterBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x186), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoIlimitInc_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x186), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoIlimitInc_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x186), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x187), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoThermalShutdown0c_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x186), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoThermalShutdown0c_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x186), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoVoutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x185), (value >> 0), 0xe0, 0x5);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoVoutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x185), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoVoutTrim_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x185), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll1VcoLdoVoutTrim_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x185), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrConfig0_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x100), (value >> 0));

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrConfig0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x100), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xff), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xff), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xff), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2ExtloRccrSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xff), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoDisThermalShutdown_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x189), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoDisThermalShutdown_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x189), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoFilterBypass_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x189), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoFilterBypass_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x189), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoIlimitInc_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x189), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoIlimitInc_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x189), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoPd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoPd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoStatus_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18a), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoThermalShutdown0c_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x189), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoThermalShutdown0c_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x189), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoVoutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x188), (value >> 0), 0xe0, 0x5);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoVoutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x188), &register_value, 0xe0, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoVoutTrim_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x188), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * (C0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rfpll2VcoLdoVoutTrim_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x188), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1IdataCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x108), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1IdataCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x108), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1IdataCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x108), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1IdataCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x108), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1QdataCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x109), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1QdataCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x109), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1QdataCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x109), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1QdataCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x109), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ArmClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x84), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ArmClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x84), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ClkCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x106), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ClkCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x106), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ClkCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x106), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1ClkCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x106), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x53), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Clear realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x53), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Receive status for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x54), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Start realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x53), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Start realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x53), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Use realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x53), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Use realign for RX1 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1CoreClkUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x53), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1CssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1CssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1CssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1LssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1LssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1LssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x48), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx1SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x48), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2CssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2CssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2CssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2LssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2LssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2LssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x49), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx2SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x49), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3CssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3CssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3CssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3LssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3LssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3LssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1Orx3SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin0GpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x59), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin0GpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x59), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin0GpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x59), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin0GpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x59), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin1GpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin1GpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin1GpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5a), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin1GpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin2GpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5b), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin2GpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin2GpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5b), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PcaCntrlPin2GpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5b), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PFIR read data for RX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PfirCoeffData_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x120), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for RX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PfirCoeffWrEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for RX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1PfirCoeffWrEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxCssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxCssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxCssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxDpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxLssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxLssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxLssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxSsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxSsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxSsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x47), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1RxSsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x47), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1StrobeCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x107), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1StrobeCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x107), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1StrobeCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x107), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx1StrobeCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x107), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2IdataCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10c), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2IdataCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10c), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2IdataCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10c), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2IdataCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10c), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2QdataCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10d), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2QdataCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2QdataCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10d), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2QdataCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10d), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ArmClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x84), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ArmClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x84), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ClkCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10a), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ClkCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10a), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ClkCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10a), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2ClkCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10a), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x55), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Clear realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x55), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) Receive status for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x56), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Start realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x55), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Start realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x55), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Use realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x55), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Use realign for RX2 Div Counter Div2,Div3
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2CoreClkUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x55), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1CssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1CssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1CssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x51), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1LssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1LssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1LssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx1SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2CssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2CssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2CssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x51), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2LssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2LssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2LssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx2SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3CssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3CssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3CssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x51), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3LssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3LssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3LssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x50), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2Orx3SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x50), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin0GpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin0GpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin0GpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5c), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin0GpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5c), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin1GpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin1GpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin1GpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5d), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin1GpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5d), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin2GpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin2GpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin2GpioSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x5e), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PcaCntrlPin2GpioSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x5e), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PFIR read data for RX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PfirCoeffData_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x121), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for RX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PfirCoeffWrEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x11f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for RX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2PfirCoeffWrEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x11f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxCssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxCssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxCssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x51), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxDpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxLssiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxLssiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxLssiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x52), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxSsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxSsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxSsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x4d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2RxSsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x4d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2StrobeCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10b), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2StrobeCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10b), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2StrobeCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10b), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Rx2StrobeCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10b), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Gate AHB clock on rxqec_top (0:clock disabled, 1: clock enabled)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RxqecAhbClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xee), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Gate AHB clock on rxqec_top (0:clock disabled, 1: clock enabled)
 */
static inline int32_t adrv9001_NvsRegmapCore3_RxqecAhbClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xee), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Select Scan Clock before entering scan_mode : 0=PLL_clock, 1=REF_clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ScanClkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x103), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Select Scan Clock before entering scan_mode : 0=PLL_clock, 1=REF_clock
 */
static inline int32_t adrv9001_NvsRegmapCore3_ScanClkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x103), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp0SramNapRetPsd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x12), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp0SramNapRetPsd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x12), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp1SramNapRetPsd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x12), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp1SramNapRetPsd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x12), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp2SramNapRetPsd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x13), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp2SramNapRetPsd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x13), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp3SramNapRetPsd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x13), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * (B0 New) Control SRAM NAP/RET/PSD/CEN ports of the memory (bit0:PSD, bit1:RET, bit2:NAP, bit3:CEN)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Sp3SramNapRetPsd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x13), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0: 1us reference is extracted from REF_CLK, 1: 1us reference is extracted from ARM_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpMain1usArmClkCounterSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x18c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) 0: 1us reference is extracted from REF_CLK, 1: 1us reference is extracted from ARM_CLK
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpMain1usArmClkCounterSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x18c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Set the 16 MSB bits of the address of the system RAM for Stream Proc Main. Default is 0x20040000
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpMainBaseAddrOffsetMsb_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x102), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x101), (value >> 0));

    return status;
}

/**
 * (B0 New) Set the 16 MSB bits of the address of the system RAM for Stream Proc Main. Default is 0x20040000
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpMainBaseAddrOffsetMsb_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x102), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x101), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Select the analog GPIO for CS : bit0=CS0 on GPIO0,  bit1=CS1 on GPIO1, bit2=CS2 on GPIO2, bit3=CS3 on GPIO3, bit4=CS0 on GPIO4, bit5=CS1 on GPIO5, bit6=CS2 on GPIO6, bit7=CS3 on GPIO7, bit8=CS0 on GPIO8
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiMasterCsAnalogGpioSel_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a6), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1a5), (value >> 0));

    return status;
}

/**
 * (C0 New) Select the analog GPIO for CS : bit0=CS0 on GPIO0,  bit1=CS1 on GPIO1, bit2=CS2 on GPIO2, bit3=CS3 on GPIO3, bit4=CS0 on GPIO4, bit5=CS1 on GPIO5, bit6=CS2 on GPIO6, bit7=CS3 on GPIO7, bit8=CS0 on GPIO8
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiMasterCsAnalogGpioSel_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1a5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Select the digital GPIO for CS : bit0=CS0 on GPIO0,  bit1=CS1 on GPIO1, bit2=CS2 on GPIO2, bit3=CS3 on GPIO3, bit4=CS0 on GPIO4, bit5=CS1 on GPIO5, bit6=CS2 on GPIO6, bit7=CS3 on GPIO7, bit8=CS0 on GPIO8
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiMasterCsDigitalGpioSel_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a4), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x1a3), (value >> 0));

    return status;
}

/**
 * (C0 New) Select the digital GPIO for CS : bit0=CS0 on GPIO0,  bit1=CS1 on GPIO1, bit2=CS2 on GPIO2, bit3=CS3 on GPIO3, bit4=CS0 on GPIO4, bit5=CS1 on GPIO5, bit6=CS2 on GPIO6, bit7=CS3 on GPIO7, bit8=CS0 on GPIO8
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiMasterCsDigitalGpioSel_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x1a3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0= GP interrupt connected to ARM, 1= SPI Master connected to ARM
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiMasterOrGpIrqSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) 0= GP interrupt connected to ARM, 1= SPI Master connected to ARM
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiMasterOrGpIrqSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0=SPI Master IRQ connected to ARM, 1=REF_TIMER IRQ connected to ARM
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiMasterOrRefTimerIrqSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x1a2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) 0=SPI Master IRQ connected to ARM, 1=REF_TIMER IRQ connected to ARM
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiMasterOrRefTimerIrqSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x1a2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Legacy Mode (SPI read_data might have a contention when 2 masters access 2 registers of different regmap at the same time), 1: No contention possible on SPI read data
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiReadDataLegacyDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x125), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Legacy Mode (SPI read_data might have a contention when 2 masters access 2 registers of different regmap at the same time), 1: No contention possible on SPI read data
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiReadDataLegacyDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x125), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) For single instruction mode, extend the rd_blockout_windows to the Nth cycle of the SPI transaction.
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiSlaveRdBlockoutExtendValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x190), (value >> 0), 0x3e, 0x1);

    return status;
}

/**
 * (C0 New) For single instruction mode, extend the rd_blockout_windows to the Nth cycle of the SPI transaction.
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiSlaveRdBlockoutExtendValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x190), &register_value, 0x3e, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0= rd_en_pulse is generated from SPI slave (A0/B0 compatible), 1 =rd_en_toggle is generated from SPI slave
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiSlaveRdEnSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x191), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) 0= rd_en_pulse is generated from SPI slave (A0/B0 compatible), 1 =rd_en_toggle is generated from SPI slave
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiSlaveRdEnSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x191), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) For single instruction mode, Enable the extension of rd_blockout window
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiSlaveUseRdBlockoutExtend_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x190), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) For single instruction mode, Enable the extension of rd_blockout window
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpiSlaveUseRdBlockoutExtend_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x190), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Destination Address to the SPI master
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimAddr_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x193), (value >> 0), 0x1f, 0x0);

    return status;
}

/**
 * (C0 New) Destination Address to the SPI master
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x193), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) Data read from the SPI master
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimDataRd_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x197), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x196), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Data to write to the SPI master
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimDataWr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x195), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x194), (value >> 0));

    return status;
}

/**
 * (C0 New) Data to write to the SPI master
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimDataWr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x195), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x194), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Status notifying transaction is done (write 0 to clear status)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimDone_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x198), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Status notifying transaction is done (write 0 to clear status)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimDone_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x198), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) trigger the APB bridge transaction to the SPI master
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x192), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (C0 New) trigger the APB bridge transaction to the SPI master
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x192), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable Analog GPIO[11:8] for SPI_Master ports : 0=analog GPIO, 1=SPI_master ports
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimGpioAnalogPadSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x192), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (C0 New) Enable Analog GPIO[11:8] for SPI_Master ports : 0=analog GPIO, 1=SPI_master ports
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimGpioAnalogPadSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x192), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable digital GPIO[11:8] for SPI_Master ports : 0=digital GPIO, 1=SPI_master ports
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimGpioDigitalPadSelect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x192), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (C0 New) Enable digital GPIO[11:8] for SPI_Master ports : 0=digital GPIO, 1=SPI_master ports
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimGpioDigitalPadSelect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x192), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) For indirect access via the local registers, set the mode of operation of the local registers : 0=Use Data mode, 1=Use Instruction mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimInstrOrDataMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x192), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (C0 New) For indirect access via the local registers, set the mode of operation of the local registers : 0=Use Data mode, 1=Use Instruction mode
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimInstrOrDataMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x192), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Clear SPI Master Instruction error status
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimInstructionClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x198), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) Clear SPI Master Instruction error status
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimInstructionClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x198), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (C0 New) SPI Master error in instruction mode : bit0=In the instruction, trans_bytes num > num_of_bytes, bit1=current_byte_num>Total_num_of_byte
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimInstructionError_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x199), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Enable latches of the SPI master interface for Early Wakeup by ARM
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimLatchEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x192), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (C0 New) Enable latches of the SPI master interface for Early Wakeup by ARM
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimLatchEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x192), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Select the destination of the SPI master config bus : 0= to Configuration registers, 1=to Reg-to-APB bridge
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x192), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Select the destination of the SPI master config bus : 0= to Configuration registers, 1=to Reg-to-APB bridge
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x192), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Trigger the start of the transaction from Configuration registers to SPI master through APB
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimStart_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x19b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Trigger the start of the transaction from Configuration registers to SPI master through APB
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimStart_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x19b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mask the GPIO source selected: 0=Unmasked, 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimStartFromPinGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x19b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) Mask the GPIO source selected: 0=Unmasked, 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimStartFromPinGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x19b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Select the GPIO to start the SPI Master from pin
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimStartFromPinGpioSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x19b), (value >> 0), 0x3c, 0x2);

    return status;
}

/**
 * (C0 New) Select the GPIO to start the SPI Master from pin
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimStartFromPinGpioSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x19b), &register_value, 0x3c, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mask the source of the start (0:Unmasked, 1:Masked) : bit0=from SPI, bit1=from Monitor, bit2=from REF_TIMER, bit3=from GPIO
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimStartTriggerSourceSelMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x19a), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (C0 New) Mask the source of the start (0:Unmasked, 1:Masked) : bit0=from SPI, bit1=from Monitor, bit2=from REF_TIMER, bit3=from GPIO
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimStartTriggerSourceSelMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x19a), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) 0= DATA from FIFO (Multiple transactions), 1=DATA from SPI (single transactions)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimUseSpiData_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x192), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (C0 New) 0= DATA from FIFO (Multiple transactions), 1=DATA from SPI (single transactions)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimUseSpiData_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x192), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Access type to the SPI master: 0=Read, 1=Write
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimWrRdb_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x192), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (C0 New) Access type to the SPI master: 0=Read, 1=Write
 */
static inline int32_t adrv9001_NvsRegmapCore3_SpimWrRdb_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x192), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Mask all the trigger for Stream Proc Main : 0=Unmasked(default), 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_StreamMainTriggerMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x17f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (C0 New) Mask all the trigger for Stream Proc Main : 0=Unmasked(default), 1=Masked
 */
static inline int32_t adrv9001_NvsRegmapCore3_StreamMainTriggerMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x17f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (C0 New) Number of ARM clock cycle to generate 1us pulse for Internal Timer (same value for all stream proc since they share the same ARM clock)
 */
static inline int32_t adrv9001_NvsRegmapCore3_StreamProc1usArmCounterValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x1600 + 0x18d), (value >> 0));

    return status;
}

/**
 * (C0 New) Number of ARM clock cycle to generate 1us pulse for Internal Timer (same value for all stream proc since they share the same ARM clock)
 */
static inline int32_t adrv9001_NvsRegmapCore3_StreamProc1usArmCounterValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x18d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on ARM master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSignal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from ARM master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSignalClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from ARM master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSignalClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on ARM master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSlaveHaddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x15b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x15a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x159), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x158), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on ARM master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSlaveHsize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15c), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on ARM master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterArmErrorSlaveHwrite_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x15c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on DMA 0 master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSignal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA0 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSignalClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA0 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSignalClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 0 master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSlaveHaddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x147), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x146), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x145), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x144), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 0 master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSlaveHsize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x148), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 0 master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma0ErrorSlaveHwrite_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x148), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on DMA 1 master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSignal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA1 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSignalClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA1 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSignalClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 1 master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSlaveHaddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x14c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x14b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x14a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x149), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 1 master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSlaveHsize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x14d), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 1 master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma1ErrorSlaveHwrite_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x14d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on DMA 2 master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSignal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA2 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSignalClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA2 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSignalClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 2 master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSlaveHaddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x151), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x150), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x14f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x14e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 2 master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSlaveHsize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x152), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 2 master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma2ErrorSlaveHwrite_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x152), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on DMA 3 master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSignal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA3 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSignalClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA3 master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSignalClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 3 master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSlaveHaddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x156), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x155), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x154), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x153), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 3 master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSlaveHsize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x157), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA 3 master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDma3ErrorSlaveHwrite_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x157), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on DMA Main master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSignal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA_MAIN master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSignalClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from DMA_MAIN master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSignalClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA Main master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSlaveHaddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x142), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x141), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x140), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x13f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA Main master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSlaveHsize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x143), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on DMA Main master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterDmaMainErrorSlaveHwrite_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x143), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on SP Main master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSignal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SP_MAIN master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSignalClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SP_MAIN master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSignalClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SP Main master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSlaveHaddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x13d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x13c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x13b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x13a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SP Main master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSlaveHsize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x13e), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SP Main master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpMainErrorSlaveHwrite_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x13e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) System Fabric reported an error on SPI-to-AHB master transaction
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSignal_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x133), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SPI master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSignalClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x134), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Clear Error Report Info from SPI master (ASyncCleared)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSignalClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x134), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SPI master, the fabric reports the address of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSlaveHaddr_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x138), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x137), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x136), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x135), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SPI master, the fabric reports the size of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSlaveHsize_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x139), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) In case of System fabric Error on SPI master, the fabric reports the access mode (R/W) of the slave that created this error
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysFabricMasterSpiErrorSlaveHwrite_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x139), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysrefRefClkIntForcePd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0xf7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_SysrefRefClkIntForcePd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0xf7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_TestDateAndTime_Get(void *const device,
    uint64_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x29), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x28), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x27), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_TestLotDeviceSerialNum_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x26), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x25), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1IdataCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x111), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1IdataCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x111), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1IdataCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x111), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1IdataCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x111), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1QdataCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x112), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1QdataCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x112), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1QdataCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x112), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1QdataCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x112), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ArmClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x84), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ArmClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x84), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ClkCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10e), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ClkCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10e), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ClkCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10e), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1ClkCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10e), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1FromCoreClk184En_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x85), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1FromCoreClk184En_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x85), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx1SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx2SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x40), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1Otx3SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x40), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampAuxAdcClkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x62), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampAuxAdcClkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x62), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampClkReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x63), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampClkReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x63), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampClkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x62), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PaRampClkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x62), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PFIR read data for TX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PfirCoeffData_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x123), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for TX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PfirCoeffWrEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x122), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for TX1 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1PfirCoeffWrEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x122), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1RefclkCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10f), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1RefclkCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10f), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1RefclkCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x10f), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1RefclkCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x10f), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1StrobeCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x110), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1StrobeCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x110), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1StrobeCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x110), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1StrobeCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x110), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxDpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x41), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x3d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx1TxSsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x3d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2IdataCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x116), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2IdataCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x116), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2IdataCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x116), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2IdataCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x116), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2QdataCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x117), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2QdataCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x117), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2QdataCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x117), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2QdataCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x117), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ArmClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x84), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ArmClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x84), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ClkCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x113), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ClkCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x113), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ClkCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x113), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2ClkCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x113), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2FromCoreClk184En_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x85), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2FromCoreClk184En_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x85), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x43), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx1SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x43), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x44), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx2SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x44), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3DpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x45), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2Otx3SsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x45), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampAuxAdcClkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x62), (value >> 0), 0x30, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampAuxAdcClkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x62), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampClkReset_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x63), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampClkReset_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x63), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampClkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x62), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PaRampClkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x62), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PFIR read data for TX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PfirCoeffData_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x124), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for TX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PfirCoeffWrEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x122), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) Enable Write PFIR coefficient for TX2 channel
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2PfirCoeffWrEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x122), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2RefclkCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x114), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2RefclkCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x114), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2RefclkCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x114), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2RefclkCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x114), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2StrobeCmosNDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x115), (value >> 0), 0x7, 0x0);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2StrobeCmosNDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x115), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2StrobeCmosPDelay_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x115), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * (B0 New) CMOS pad delay
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2StrobeCmosPDelay_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x115), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxDpUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiClkAlignReceivedClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiClkAlignReceivedClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiCoreClkEnAlignReceived_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x46), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiStartClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiStartClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiUseClkAlign_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x1600 + 0x42), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_Tx2TxSsiUseClkAlign_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x1600 + 0x42), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_UltraflexTesterId_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x24), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_WaferLotId_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x32), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x31), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x30), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_WaferNum_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore3_WaferXyCoord_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x1600 + 0x2d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_NVS_REGMAP_CORE_3_H__