/**
 * \file
 * \brief BitField accessors for nvs_regmap_core_2
 *
 * Autogenerated with yoda-gen 1.2.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_NVS_REGMAP_CORE_2_H__
 #define __ADRV9001_BF_NVS_REGMAP_CORE_2_H__

#include "adrv9001_bf_hal.h"



static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio118Invert_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c7), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio118Invert_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio118SourceSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c6), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio118SourceSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c6), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio30Invert_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio30Invert_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio30SourceSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c4), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio30SourceSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c4), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio74Invert_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c7), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio74Invert_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio74SourceSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c5), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_AnalogGpio74SourceSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 12bit AuxDAC0 data word
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac0_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

	status = adi_bf_hal_Register_Write(device, (0x400 + 0x0), (value >> 0));
    if (0 != status) return status;

	status = adi_bf_hal_Field_Write(device, (0x400 + 0x1), (value >> 8), 0xf, 0x0);

    return status;
}

/**
 * 12bit AuxDAC0 data word
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac0_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 4bit AuxDAC0 config parameters
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac0Config_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * 4bit AuxDAC0 config parameters
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac0Config_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * AUXDAC0 power-down bit
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac0Pd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * AUXDAC0 power-down bit
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac0Pd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 12bit AuxDAC1 data word
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac1_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

	status = adi_bf_hal_Register_Write(device, (0x400 + 0x2), (value >> 0));
    if (0 != status) return status;

	status = adi_bf_hal_Field_Write(device, (0x400 + 0x3), (value >> 8), 0xf, 0x0);

    return status;
}

/**
 * 12bit AuxDAC1 data word
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac1_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x3), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 4bit AuxDAC1 config parameters
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac1Config_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x3), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * 4bit AuxDAC1 config parameters
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac1Config_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x3), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * AUXDAC0 power-down bit
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac1Pd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * AUXDAC0 power-down bit
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac1Pd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 12bit AuxDAC2 data word
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac2_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

	status = adi_bf_hal_Register_Write(device, (0x400 + 0x4), (value >> 0));
    if (0 != status) return status;

	status = adi_bf_hal_Field_Write(device, (0x400 + 0x5), (value >> 8), 0xf, 0x0);

    return status;
}

/**
 * 12bit AuxDAC2 data word
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac2_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x5), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 4bit AuxDAC2 config parameters
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac2Config_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x5), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * 4bit AuxDAC2 config parameters
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac2Config_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x5), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * AUXDAC0 power-down bit
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac2Pd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * AUXDAC0 power-down bit
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac2Pd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 12bit AuxDAC3 data word
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac3_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

	status = adi_bf_hal_Register_Write(device, (0x400 + 0x6), (value >> 0));
    if (0 != status) return status;

	status = adi_bf_hal_Field_Write(device, (0x400 + 0x7), (value >> 8), 0xf, 0x0);

    return status;
}

/**
 * 12bit AuxDAC3 data word
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac3_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 4bit AuxDAC3 config parameters
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac3Config_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x7), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * 4bit AuxDAC3 config parameters
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac3Config_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x7), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * AUXDAC0 power-down bit
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac3Pd_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * AUXDAC0 power-down bit
 */
static inline int32_t adrv9001_NvsRegmapCore2_Auxdac3Pd_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 4bits AUXDAC mux selection.

 * Bit [0]: AUXDAC 0 select:  1: xbar_dac0, 0: spi_auxdac0

 * Bit [1]: AUXDAC 1 select:  1: xbar_dac1, 0: spi_auxdac1

 * Bit [2]: AUXDAC 2 select:  1: xbar_dac2, 0: spi_auxdac2

 * Bit [3]: AUXDAC 3 select:  1: xbar_dac3, 0: spi_auxdac3
 */
static inline int32_t adrv9001_NvsRegmapCore2_AuxdacMuxsel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x11), (value >> 0), 0xf0, 0x4);

    return status;
}

/**
 * 4bits AUXDAC mux selection.

 * Bit [0]: AUXDAC 0 select:  1: xbar_dac0, 0: spi_auxdac0

 * Bit [1]: AUXDAC 1 select:  1: xbar_dac1, 0: spi_auxdac1

 * Bit [2]: AUXDAC 2 select:  1: xbar_dac2, 0: spi_auxdac2

 * Bit [3]: AUXDAC 3 select:  1: xbar_dac3, 0: spi_auxdac3
 */
static inline int32_t adrv9001_NvsRegmapCore2_AuxdacMuxsel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x11), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Control the XBAR 2in 4 out MUX. 

 * Bit[0]: xbar 0 select: 1: TX2, 0: TX1

 * Bit[1]: xbar 1 select: 1: TX2, 0: TX1

 * Bit[2]: xbar 2 select: 1: TX2, 0: TX1

 * Bit[3]: xbar 3 select: 1: TX2, 0: TX1
 */
static inline int32_t adrv9001_NvsRegmapCore2_AuxdacXconfig_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x11), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Control the XBAR 2in 4 out MUX. 

 * Bit[0]: xbar 0 select: 1: TX2, 0: TX1

 * Bit[1]: xbar 1 select: 1: TX2, 0: TX1

 * Bit[2]: xbar 2 select: 1: TX2, 0: TX1

 * Bit[3]: xbar 3 select: 1: TX2, 0: TX1
 */
static inline int32_t adrv9001_NvsRegmapCore2_AuxdacXconfig_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x11), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) BBIC_GPIO_0 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio0FallMaskSp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ec), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) BBIC_GPIO_0 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio0FallMaskSp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ec), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio0PinMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d7), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio0PinMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio0PinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d7), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio0PinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d7), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) BBIC_GPIO_0 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio0RiseMaskSp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ec), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) BBIC_GPIO_0 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio0RiseMaskSp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ec), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) BBIC_GPIO_1 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio1FallMaskSp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ec), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New) BBIC_GPIO_1 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio1FallMaskSp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ec), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio1PinMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d8), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio1PinMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio1PinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d8), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio1PinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d8), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) BBIC_GPIO_1 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio1RiseMaskSp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ec), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New) BBIC_GPIO_1 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio1RiseMaskSp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ec), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) BBIC_GPIO_2 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio2FallMaskSp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ec), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) BBIC_GPIO_2 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio2FallMaskSp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ec), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio2PinMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d9), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio2PinMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio2PinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d9), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio2PinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d9), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) BBIC_GPIO_2 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio2RiseMaskSp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ec), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) BBIC_GPIO_2 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio2RiseMaskSp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ec), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) BBIC_GPIO_3 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio3FallMaskSp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ec), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * (B0 New) BBIC_GPIO_3 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio3FallMaskSp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ec), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio3PinMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1da), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio3PinMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1da), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio3PinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1da), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio3PinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1da), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) BBIC_GPIO_3 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio3RiseMaskSp_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ec), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * (B0 New) BBIC_GPIO_3 edge detection is masked for Stream Processor Trigger (0: unmasked, 1: Masked). It still goes to ARM_IRQ
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicGpio3RiseMaskSp_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ec), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c9), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop1GpioPinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c9), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop1GpioPinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c9), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop1PinMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c9), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop1PinMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ca), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ca), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop2GpioPinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ca), (value >> 0), 0xf, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop2GpioPinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ca), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop2PinMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ca), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHop2PinMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ca), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHopEdge0Sel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1db), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHopEdge0Sel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1db), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHopEdge1Sel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1dc), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHopEdge1Sel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1dc), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHopEdge2Sel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1dd), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHopEdge2Sel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1dd), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHopEdge3Sel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1de), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHopEdge3Sel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1de), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHopMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c8), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicHopMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicMonitorEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1df), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicMonitorEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1df), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicMonitorEnablePinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1df), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicMonitorEnablePinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1df), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx1ArmOverrideCtrl_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cf), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx1ArmOverrideCtrl_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cf), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx1Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cf), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx1Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx1EnableByArm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cf), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx1EnableByArm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cf), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx1GpioPinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cf), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx1GpioPinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cf), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx1PinMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cf), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx1PinMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cf), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx2ArmOverrideCtrl_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d0), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx2ArmOverrideCtrl_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx2Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d0), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx2Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx2EnableByArm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d0), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx2EnableByArm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx2GpioPinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d0), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx2GpioPinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d0), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx2PinMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicOrx2PinMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPll1Lock_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e0), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPll1Lock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPll1LockNetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPll1LockNetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPll2Lock_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e0), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPll2Lock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPll2LockNetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e0), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPll2LockNetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPllAuxLock_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e0), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPllAuxLock_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPllAuxLockNetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e0), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicPllAuxLockNetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1ArmOverrideCtrl_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cb), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1ArmOverrideCtrl_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cb), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1DdcLoSync_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cc), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1DdcLoSync_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cc), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1DdcLoSyncNetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cc), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1DdcLoSyncNetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cc), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cb), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1EnableByArm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cb), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1EnableByArm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1ExtlpbEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cc), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1ExtlpbEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mask the Rx1HopEdgeDuringRx1High IRQ, 1: Unmasked
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1HopEdgeDuringRx1HighMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cc), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: mask the Rx1HopEdgeDuringRx1High IRQ, 1: Unmasked
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1HopEdgeDuringRx1HighMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cc), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select the hop_edge source : 0: hop2_edge, 1: hop2_fall, 2: hop2_rise, 3: hop1_edge, 4: hop1_fall, 5: hop1_rise
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1HopSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cc), (value >> 0), 0x38, 0x3);

    return status;
}

/**
 * Select the hop_edge source : 0: hop2_edge, 1: hop2_fall, 2: hop2_rise, 3: hop1_edge, 4: hop1_fall, 5: hop1_rise
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1HopSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cc), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1IntlpbEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cc), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1IntlpbEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cc), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1PinMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cb), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx1PinMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2ArmOverrideCtrl_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cd), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2ArmOverrideCtrl_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cd), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2DdcLoSync_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ce), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2DdcLoSync_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ce), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2DdcLoSyncNetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ce), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2DdcLoSyncNetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ce), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cd), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2EnableByArm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cd), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2EnableByArm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2ExtlpbEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ce), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2ExtlpbEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ce), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mask the Rx2HopEdgeDuringRx2High IRQ, 1: Unmasked
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2HopEdgeDuringRx2HighMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ce), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * 0: mask the Rx2HopEdgeDuringRx2High IRQ, 1: Unmasked
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2HopEdgeDuringRx2HighMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ce), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select the hop_edge source : 0: hop2_edge, 1: hop2_fall, 2: hop2_rise, 3: hop1_edge, 4: hop1_fall, 5: hop1_rise
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2HopSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ce), (value >> 0), 0x38, 0x3);

    return status;
}

/**
 * Select the hop_edge source : 0: hop2_edge, 1: hop2_fall, 2: hop2_rise, 3: hop1_edge, 4: hop1_fall, 5: hop1_rise
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2HopSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ce), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2IntlpbEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ce), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2IntlpbEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ce), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2PinMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1cd), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicRx2PinMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1cd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1ArmOverrideCtrl_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d1), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1ArmOverrideCtrl_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d1), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1EnableByArm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d1), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1EnableByArm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1GainChange_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d2), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1GainChange_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1GainChangeNetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d2), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1GainChangeNetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1GainRampup_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d2), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1GainRampup_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1GainRampupNetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d2), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1GainRampupNetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mask the Tx1HopEdgeDuringTx1High IRQ, 1: Unmasked
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1HopEdgeDuringTx1HighMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d1), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: mask the Tx1HopEdgeDuringTx1High IRQ, 1: Unmasked
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1HopEdgeDuringTx1HighMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select the hop_edge source : 0: hop2_edge, 1: hop2_fall, 2: hop2_rise, 3: hop1_edge, 4: hop1_fall, 5: hop1_rise
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1HopSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d1), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * Select the hop_edge source : 0: hop2_edge, 1: hop2_fall, 2: hop2_rise, 3: hop1_edge, 4: hop1_fall, 5: hop1_rise
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1HopSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d1), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync0_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync0NetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d3), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync0NetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d3), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync1NetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d3), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync1NetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d3), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d3), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync2NetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d3), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1NcoLoSync2NetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d3), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1PinMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d1), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx1PinMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2ArmOverrideCtrl_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d4), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2ArmOverrideCtrl_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2EnableByArm_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d4), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2EnableByArm_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2GainChange_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d5), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2GainChange_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2GainChangeNetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d5), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2GainChangeNetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2GainRampup_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d5), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2GainRampup_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2GainRampupNetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d5), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2GainRampupNetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: mask the Tx2HopEdgeDuringTx2High IRQ, 1: Unmasked
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2HopEdgeDuringTx2HighMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d4), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: mask the Tx2HopEdgeDuringTx2High IRQ, 1: Unmasked
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2HopEdgeDuringTx2HighMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select the hop_edge source : 0: hop2_edge, 1: hop2_fall, 2: hop2_rise, 3: hop1_edge, 4: hop1_fall, 5: hop1_rise
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2HopSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d4), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * Select the hop_edge source : 0: hop2_edge, 1: hop2_fall, 2: hop2_rise, 3: hop1_edge, 4: hop1_fall, 5: hop1_rise
 */
static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2HopSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d4), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync0_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d6), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync0NetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d6), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync0NetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d6), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync1NetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d6), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync1NetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d6), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d6), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync2NetSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d6), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2NcoLoSync2NetSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2PinMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d4), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_BbicTx2PinMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: unmasked, 1: masked
 */
static inline int32_t adrv9001_NvsRegmapCore2_Gpio4ArmIrqMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ea), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: unmasked, 1: masked
 */
static inline int32_t adrv9001_NvsRegmapCore2_Gpio4ArmIrqMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ea), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Gpio4ArmIrqPinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ea), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Gpio4ArmIrqPinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ea), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: unmasked, 1: masked
 */
static inline int32_t adrv9001_NvsRegmapCore2_Gpio5ArmIrqMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1eb), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) 0: unmasked, 1: masked
 */
static inline int32_t adrv9001_NvsRegmapCore2_Gpio5ArmIrqMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1eb), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Gpio5ArmIrqPinSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1eb), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Gpio5ArmIrqPinSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1eb), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_IntDelay0Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_IntDelay0Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_IntDelay1Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1d), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_IntDelay1Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LUT write address
 */
static inline int32_t adrv9001_NvsRegmapCore2_LutAddr_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf), (value >> 8), 0x1, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xe), (value >> 0));

    return status;
}

/**
 * LUT write address
 */
static inline int32_t adrv9001_NvsRegmapCore2_LutAddr_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xe), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LUT read enable signal
 */
static inline int32_t adrv9001_NvsRegmapCore2_LutRdEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * LUT read enable signal
 */
static inline int32_t adrv9001_NvsRegmapCore2_LutRdEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LUT write data
 */
static inline int32_t adrv9001_NvsRegmapCore2_LutWrData_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x10), (value >> 0));

    return status;
}

/**
 * LUT write data
 */
static inline int32_t adrv9001_NvsRegmapCore2_LutWrData_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x10), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * LUT write enable signal
 */
static inline int32_t adrv9001_NvsRegmapCore2_LutWrEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * LUT write enable signal
 */
static inline int32_t adrv9001_NvsRegmapCore2_LutWrEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x181), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x181), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x181), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x181), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x181), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x181), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x181), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x181), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x181), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x181), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x181), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x181), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x181), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x181), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x181), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x181), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x187), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x186), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x185), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x187), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x186), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x185), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x184), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x183), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x182), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop1EnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x184), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x183), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x182), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainHop1Toggle_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c0), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainHop1Toggle_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore2_MainHop1ToggleDelayed_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x188), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x188), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x188), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x188), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x188), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x188), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x188), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x188), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x188), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x188), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x188), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x188), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x188), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x188), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x188), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x188), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x18e), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x18d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x18c), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x18e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x18d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x18c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x18b), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x18a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x189), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainHop2EnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x18b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x18a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x189), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainHop2Toggle_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainHop2Toggle_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_NvsRegmapCore2_MainHop2ToggleDelayed_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelay1Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c0), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelay1Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelay2Enable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c0), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelay2Enable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x17a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x17a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x17a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x17a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x17a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x17a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x17a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x17a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x17a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x17a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x17a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x17a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x17a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x17a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x17a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x17a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x180), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x17f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x17e), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x180), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x17f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x17e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x17d), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x17c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x17b), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayEnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x17d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x17c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x17b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayStartEnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bf), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayStartEnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayStopEnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bf), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_MainIntDelayStopEnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bf), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: Enable ECC function  1: disable ECC function
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampEccDisable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * (B0 New) 0: Enable ECC function  1: disable ECC function
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampEccDisable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) 0: interrupt for uncorrectable error  1: interrupt for both correctable and uncorrectable error
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampEccIrqSensitivity_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e5), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * (B0 New) 0: interrupt for uncorrectable error  1: interrupt for both correctable and uncorrectable error
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampEccIrqSensitivity_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * LUT read back data
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampLutRdData_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x12), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * LUT read valid signal
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampLutRdValid_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x13), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Pa_ramp tx1 ramp up/down is asymmetric or not. 1: asymmetric, 0: symmetric, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1Asymmetric_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Pa_ramp tx1 ramp up/down is asymmetric or not. 1: asymmetric, 0: symmetric, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1Asymmetric_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Pa_ramp tx1 ramp down threshold, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1DownThreshold_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xa), (value >> 0));

    return status;
}

/**
 * Pa_ramp tx1 ramp down threshold, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1DownThreshold_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xa), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) PA ramp TX1 ECC status(error flag, error addr) clear signal, it is self-cleared
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1EccClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e5), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * (B0 New) PA ramp TX1 ECC status(error flag, error addr) clear signal, it is self-cleared
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1EccClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PA ramp TX1 error address
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1EccErrorAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x1e8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) ECC error flag signals for TX1
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1EccErrorFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TX1 LUT select signal
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1LutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x14), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * TX1 LUT select signal
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1LutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x14), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Pa_ramp tx1 ramp up threshold, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1UpThreshold_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x9), (value >> 0));

    return status;
}

/**
 * Pa_ramp tx1 ramp up threshold, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx1UpThreshold_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Pa_ramp tx2 ramp up/down is asymmetric or not. 1: asymmetric, 0: symmetric, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2Asymmetric_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Pa_ramp tx2 ramp up/down is asymmetric or not. 1: asymmetric, 0: symmetric, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2Asymmetric_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Pa_ramp tx2 ramp down threshold, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2DownThreshold_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xc), (value >> 0));

    return status;
}

/**
 * Pa_ramp tx2 ramp down threshold, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2DownThreshold_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) PA ramp TX2 ECC status(error flag, error addr) clear signal, it is self-cleared
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2EccClear_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e5), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * (B0 New) PA ramp TX2 ECC status(error flag, error addr) clear signal, it is self-cleared
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2EccClear_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e5), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) PA ramp TX2 error address
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2EccErrorAddr_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x1e9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


/**
 * (B0 New) ECC error flag signals for TX2
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2EccErrorFlag_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * TX2 LUT select signal
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2LutSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x14), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * TX2 LUT select signal
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2LutSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x14), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Pa_ramp tx2 ramp up threshold, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2UpThreshold_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xb), (value >> 0));

    return status;
}

/**
 * Pa_ramp tx2 ramp up threshold, default 0.
 */
static inline int32_t adrv9001_NvsRegmapCore2_PaRampTx2UpThreshold_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved0_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x20), (value >> 0));

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x20), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x21), (value >> 0));

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x21), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved2_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x22), (value >> 0));

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved2_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x22), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved3_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x23), (value >> 0));

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved3_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x23), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved4_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x24), (value >> 0));

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved4_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x24), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved5_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x25), (value >> 0));

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved5_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x25), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved6_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x26), (value >> 0));

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved6_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x26), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved7_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x27), (value >> 0));

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved7_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x27), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved8_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x28), (value >> 0));

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved8_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x28), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved9_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x29), (value >> 0));

    return status;
}

/**
 * (B0 New) Unused
 */
static inline int32_t adrv9001_NvsRegmapCore2_Reserved9_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x29), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x5b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x5b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x5b), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x5b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x5b), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x5b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x5b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x5b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x5b), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x5b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x5b), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x5b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x195), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x195), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x195), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x195), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x5b), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x5b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x5b), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x5b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x195), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x195), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x195), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x195), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x61), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x60), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x5f), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x61), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x60), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x5f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x5e), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x5d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x5c), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1AgcPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x5e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x5d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x5c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x69), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x69), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x69), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x69), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x69), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x69), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x69), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x69), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x69), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x69), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x69), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x69), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x197), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x197), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x197), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x197), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x69), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x69), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x69), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x69), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x197), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x197), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x197), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x197), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x6f), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x6e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x6d), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x6f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x6e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x6d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x6c), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x6b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x6a), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1BbdcPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x6c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x6b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x6a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x85), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x85), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x85), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x85), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x85), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x85), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x85), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x85), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x85), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x85), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x85), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x85), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19b), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19b), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x85), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x85), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x85), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x85), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19b), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19b), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x8b), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x8a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x89), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x8b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x8a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x89), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x88), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x87), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x86), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1DdcLoSyncPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x88), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x87), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x86), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x3f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x3f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x3f), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x3f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x3f), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x3f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x3f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x3f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x3f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x3f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x3f), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x3f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x190), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x190), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x190), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x190), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x3f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x3f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x3f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x3f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x190), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x190), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x190), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x190), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x45), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x44), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x43), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x45), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x44), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x43), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x42), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x41), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x40), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic1CaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x42), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x41), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x40), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x46), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x46), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x46), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x46), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x46), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x46), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x46), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x46), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x46), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x46), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x46), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x46), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x191), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x191), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x191), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x191), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x46), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x46), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x46), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x46), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartRx1GainChangeSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x191), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartRx1GainChangeSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x191), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartRx1OverloadSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x191), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStartRx1OverloadSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x191), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x191), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x191), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x191), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x191), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStopRx1GainChangeSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x191), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStopRx1GainChangeSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x191), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStopRx1OverloadSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x191), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedStopRx1OverloadSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x191), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x4c), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x4b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x4a), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x4c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x4b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x4a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x49), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x48), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x47), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Fic2CaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x49), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x48), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x47), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1FicPauseThld_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e2), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1FicPauseThld_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e2), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1GainTableClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e4), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1GainTableClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x38), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x38), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x38), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x38), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x38), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x38), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x38), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x38), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x38), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x38), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x38), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x38), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x18f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x18f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x18f), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x18f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x38), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x38), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x38), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x38), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x18f), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x18f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x18f), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x18f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x3e), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x3d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x3c), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x3e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x3d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x3c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x3b), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x3a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x39), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1Hd2CaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x3b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x3a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x39), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x9a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x9a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x9a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x9a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x9a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x9a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x9a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x9a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x9a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x9a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x9a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x9a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x9a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x9a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x9a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x9a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xa0), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x9f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x9e), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xa0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x9f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x9e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x9d), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x9c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x9b), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0EnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x9d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x9c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x9b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19e), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19e), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19e), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19e), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay0PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa1), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa1), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa1), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa1), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa1), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa1), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa1), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa1), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xa7), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xa6), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xa5), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xa7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xa6), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xa5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xa4), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xa3), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xa2), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1EnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xa4), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xa3), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xa2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19f), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19f), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19f), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19f), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntDelay1PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8c), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8c), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8c), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8c), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x8c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x8c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x92), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x91), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x90), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x92), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x91), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x90), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x8f), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x8e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x8d), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxEnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x8f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x8e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x8d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19c), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19c), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19c), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19c), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntOrxPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x93), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x93), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x93), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x93), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x93), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x93), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x93), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x93), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x93), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x93), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x93), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x93), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x93), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x93), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x93), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x93), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x99), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x98), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x97), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x99), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x98), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x97), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x96), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x95), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x94), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxEnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x96), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x95), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x94), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19d), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19d), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19d), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19d), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1IntRxPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1LpkPhaseAccumClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e4), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1LpkPhaseAccumClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x70), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x70), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x70), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x70), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x70), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x70), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x70), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x70), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x70), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x70), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x70), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x70), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x198), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x198), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x198), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x198), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x70), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x70), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x70), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x70), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x198), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x198), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x198), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x198), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x76), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x75), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x74), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x76), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x75), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x74), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x73), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x72), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x71), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync0PedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x73), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x72), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x71), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x77), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x77), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x77), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x77), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x77), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x77), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x77), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x77), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x77), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x77), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x77), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x77), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x199), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x199), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x199), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x199), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x77), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x77), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x77), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x77), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x199), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x199), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x199), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x199), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x7d), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x7c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x7b), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x7d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x7c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x7b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x7a), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x79), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x78), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync1PedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x7a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x79), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x78), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x7e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x7e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x7e), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x7e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x7e), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x7e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x7e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x7e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x7e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x7e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x7e), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x7e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19a), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x7e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x7e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x7e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x7e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19a), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x19a), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x19a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x84), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x83), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x82), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x84), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x83), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x82), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x81), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x80), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x7f), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1NcoLoSync2PedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x81), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x80), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x7f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiCaptPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x194), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiCaptPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x194), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiCaptPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x194), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiCaptPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x194), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiCaptPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x194), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiCaptPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x194), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiCaptPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x194), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiCaptPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x194), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x54), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x54), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x54), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x54), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x54), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x54), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x54), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x54), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x54), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x54), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x54), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x54), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x54), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x54), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x54), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x54), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x5a), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x59), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x58), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x5a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x59), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x58), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x57), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x56), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x55), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1PwrMonRssiPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x57), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x56), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x55), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x62), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x62), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x62), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x62), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x62), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x62), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x62), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x62), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x62), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x62), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x62), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x62), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x196), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x196), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x196), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x196), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x62), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x62), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x62), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x62), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x196), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x196), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x196), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x196), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x68), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x67), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x66), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x68), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x67), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x66), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x65), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x64), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x63), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RfdcPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x65), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x64), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x63), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x192), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x192), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x192), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x192), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartExtlpbkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x193), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartExtlpbkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x193), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartIntlpbkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x193), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartIntlpbkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x193), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartOrxqecSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x193), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartOrxqecSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x193), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartRxqecSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x193), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStartRxqecSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x193), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x192), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x192), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x192), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x192), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopExtlpbkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x193), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopExtlpbkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x193), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopIntlpbkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x193), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopIntlpbkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x193), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopOrxqecSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x193), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopOrxqecSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x193), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopRxqecSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x193), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCaptPedStopRxqecSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x193), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCorrRdyGenEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e1), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCorrRdyGenEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e1), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCorrRdyGenSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e1), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecCorrRdyGenSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e1), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x4d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x4d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x4d), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x4d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x4d), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x4d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x4d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x4d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x4d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x4d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x4d), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x4d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x4d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x4d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x4d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x4d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x53), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x52), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x51), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x53), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x52), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x51), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x50), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x4f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x4e), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx1RxqecPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x50), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x4f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x4e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xfc), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xfc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xfc), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xfc), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xfc), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xfc), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xfc), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xfc), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xfc), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xfc), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xfc), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xfc), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ad), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ad), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ad), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ad), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xfc), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xfc), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xfc), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xfc), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ad), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ad), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ad), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ad), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x102), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x101), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x100), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x102), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x101), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x100), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xff), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xfe), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xfd), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2AgcPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xff), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xfe), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xfd), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x10a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x10a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x10a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x10a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x10a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x10a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x10a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x10a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x10a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x10a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x10a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x10a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1af), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1af), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1af), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1af), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x10a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x10a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x10a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x10a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1af), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1af), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1af), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1af), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x110), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x10f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x10e), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x110), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x10f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x10e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x10d), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x10c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x10b), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2BbdcPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x10d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x10c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x10b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x126), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x126), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x126), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x126), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x126), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x126), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x126), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x126), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x126), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x126), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x126), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x126), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b3), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x126), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x126), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x126), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x126), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b3), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b3), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x12c), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x12b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x12a), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x12c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x12b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x12a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x129), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x128), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x127), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2DdcLoSyncPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x129), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x128), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x127), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe0), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe0), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe0), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe0), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe0), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe0), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe0), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe0), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe0), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a8), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a8), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe0), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe0), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe0), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a8), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a8), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xe6), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xe5), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xe4), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xe6), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xe5), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xe4), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xe3), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xe2), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xe1), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic1CaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xe3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xe2), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xe1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe7), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe7), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe7), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe7), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe7), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe7), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe7), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe7), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe7), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a9), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a9), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe7), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe7), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xe7), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xe7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartRx2GainChangeSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a9), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartRx2GainChangeSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartRx2OverloadSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a9), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStartRx2OverloadSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a9), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a9), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a9), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStopRx2GainChangeSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a9), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStopRx2GainChangeSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a9), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStopRx2OverloadSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a9), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedStopRx2OverloadSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xed), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xec), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xeb), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xed), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xec), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xeb), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xea), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xe9), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xe8), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Fic2CaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xea), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xe9), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xe8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2FicPauseThld_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e3), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2FicPauseThld_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e3), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2GainTableClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e4), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2GainTableClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptEnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptEnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd9), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd9), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd9), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd9), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd9), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd9), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd9), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd9), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd9), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd9), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a7), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd9), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd9), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd9), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a7), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a7), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xdf), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xde), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xdd), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xdf), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xde), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xdd), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xdc), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xdb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xda), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2Hd2CaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xdc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xdb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xda), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x13b), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x13b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x13b), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x13b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x13b), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x13b), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x13b), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x13b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x13b), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x13b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x13b), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x13b), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x13b), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x13b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x13b), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x13b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x141), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x140), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x13f), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x141), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x140), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x13f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x13e), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x13d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x13c), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0EnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x13e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x13d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x13c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b6), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b6), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b6), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b6), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay0PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x142), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x142), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x142), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x142), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x142), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x142), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x142), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x142), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x142), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x142), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x142), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x142), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x142), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x142), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x142), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x142), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x148), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x147), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x146), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x148), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x147), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x146), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x145), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x144), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x143), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1EnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x145), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x144), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x143), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b7), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b7), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b7), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntDelay1PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b7), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x12d), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x12d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x12d), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x12d), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x12d), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x12d), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x12d), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x12d), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x12d), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x12d), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x12d), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x12d), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x12d), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x12d), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x12d), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x12d), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x133), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x132), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x131), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x133), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x132), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x131), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x130), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x12f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x12e), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxEnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x130), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x12f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x12e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b4), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b4), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b4), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntOrxPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x134), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x134), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x134), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x134), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x134), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x134), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x134), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x134), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x134), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x134), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x134), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x134), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x134), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x134), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x134), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x134), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x13a), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x139), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x138), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x13a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x139), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x138), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x137), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x136), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x135), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxEnablePedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x137), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x136), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x135), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b5), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b5), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b5), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b5), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2IntRxPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2LpkPhaseAccumClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e4), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2LpkPhaseAccumClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x111), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x111), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x111), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x111), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x111), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x111), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x111), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x111), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x111), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x111), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x111), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x111), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b0), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x111), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x111), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x111), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x111), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b0), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b0), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x117), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x116), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x115), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x117), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x116), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x115), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x114), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x113), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x112), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync0PedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x114), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x113), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x112), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x118), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x118), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x118), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x118), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x118), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x118), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x118), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x118), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x118), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x118), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x118), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x118), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b1), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b1), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x118), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x118), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x118), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x118), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b1), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b1), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x11e), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x11d), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x11c), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x11e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x11d), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x11c), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x11b), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x11a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x119), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync1PedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x11b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x11a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x119), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x11f), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x11f), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x11f), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x11f), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x11f), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x11f), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x11f), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x11f), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x11f), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x11f), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x11f), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x11f), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b2), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b2), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x11f), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x11f), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x11f), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x11f), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b2), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b2), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x125), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x124), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x123), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x125), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x124), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x123), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x122), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x121), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x120), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2NcoLoSync2PedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x122), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x121), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x120), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiCaptPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ac), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiCaptPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ac), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiCaptPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ac), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiCaptPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ac), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiCaptPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ac), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiCaptPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ac), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiCaptPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ac), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiCaptPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ac), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf5), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf5), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf5), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf5), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf5), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf5), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf5), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf5), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf5), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf5), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf5), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xf5), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xf5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xfb), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xfa), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xf9), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xfb), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xfa), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xf9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xf8), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xf7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xf6), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2PwrMonRssiPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xf8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xf7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xf6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x103), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x103), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x103), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x103), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x103), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x103), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x103), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x103), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x103), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x103), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x103), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x103), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ae), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ae), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ae), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ae), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x103), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x103), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x103), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x103), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ae), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ae), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ae), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ae), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x109), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x108), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x107), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x109), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x108), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x107), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x106), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x105), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x104), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RfdcPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x106), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x105), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x104), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1aa), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1aa), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1aa), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1aa), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartExtlpbkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ab), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartExtlpbkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ab), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartIntlpbkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ab), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartIntlpbkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ab), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartOrxqecSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ab), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartOrxqecSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ab), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartRxqecSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ab), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStartRxqecSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ab), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1aa), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1aa), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1aa), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1aa), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopExtlpbkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ab), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopExtlpbkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ab), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopIntlpbkSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ab), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopIntlpbkSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ab), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopOrxqecSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ab), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopOrxqecSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ab), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopRxqecSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ab), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCaptPedStopRxqecSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ab), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCorrRdyGenEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e1), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCorrRdyGenEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e1), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCorrRdyGenSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e1), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecCorrRdyGenSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e1), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xee), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xee), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xee), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xee), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xee), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xee), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xee), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xee), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xee), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xee), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xee), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xee), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xee), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xee), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xee), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xee), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xf4), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xf3), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xf2), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xf4), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xf3), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xf2), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xf1), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xf0), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xef), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Rx2RxqecPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xf1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xf0), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xef), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_RxqecCaptPedStartRx2Sel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c3), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_RxqecCaptPedStartRx2Sel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_RxqecCaptPedStopRx2Sel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c3), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_RxqecCaptPedStopRx2Sel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_RxqecObsRdyGenSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e1), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_RxqecObsRdyGenSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e1), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_SwStatus0_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x1e), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_SwStatus0_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x1e), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_SwStatus1_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x1f), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_SwStatus1_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x1f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xb6), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xb6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xb6), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xb6), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xb6), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xb6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xb6), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xb6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xb6), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xb6), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xb6), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xb6), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xb6), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xb6), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xb6), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xb6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xbc), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xbb), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xba), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xbc), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xbb), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xba), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xb9), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xb8), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xb7), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcDataCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xb9), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xb8), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xb7), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a2), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a2), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a2), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a2), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1ClgcRssiCcPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdActiveSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c2), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdActiveSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa8), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa8), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa8), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa8), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa8), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa8), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa8), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa8), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa8), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa8), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa8), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xa8), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xa8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xae), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xad), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xac), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xae), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xad), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xac), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xab), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xaa), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xa9), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1DpdDataCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xab), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xaa), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xa9), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1GainTableClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1GainTableClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xbd), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xbd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xbd), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xbd), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xbd), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xbd), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xbd), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xbd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xbd), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xbd), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xbd), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xbd), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xbd), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xbd), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xbd), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xbd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xc3), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xc2), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xc1), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xc3), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xc2), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xc1), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xc0), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xbf), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xbe), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcDataCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xc0), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xbf), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xbe), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a3), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a3), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a3), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1GanAmpRssiCcPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a3), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xcb), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xcb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xcb), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xcb), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xcb), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xcb), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xcb), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xcb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xcb), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xcb), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xcb), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xcb), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xcb), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xcb), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xcb), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xcb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xd1), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xd0), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xcf), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xd1), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xd0), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xcf), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xce), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xcd), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xcc), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0EnableCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xce), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xcd), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xcc), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a5), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a5), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a5), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a5), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay0PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a5), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd2), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd2), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd2), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd2), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd2), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd2), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd2), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd2), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd2), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd2), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xd2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xd2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xd8), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xd7), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xd6), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xd8), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xd7), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xd6), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xd5), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xd4), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xd3), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1EnableCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xd5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xd4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xd3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a6), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a6), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a6), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a6), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntDelay1PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a6), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xc4), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xc4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xc4), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xc4), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xc4), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xc4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xc4), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xc4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xc4), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xc4), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xc4), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xc4), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xc4), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xc4), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xc4), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xc4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xca), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xc9), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xc8), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xca), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xc9), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xc8), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xc7), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xc6), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xc5), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxEnableCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xc7), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xc6), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xc5), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a4), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a4), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a4), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1IntTxPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a4), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampClkDivValue_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x17), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x16), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampClkDivValue_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x17), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x16), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampDelayedEnableStartSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampDelayedEnableStartSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampDelayedEnableStopSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampDelayedEnableStopSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampDelayedEnableTx1EnableStartSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampDelayedEnableTx1EnableStartSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampDelayedEnableTx1EnableStopSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampDelayedEnableTx1EnableStopSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampEnableGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampEnableGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampEnableGpioSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampEnableGpioSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x2a), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x2a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x2a), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x2a), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x2a), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x2a), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x2a), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x2a), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x2a), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x2a), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x2a), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x2a), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x2a), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x2a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x2a), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x2a), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x30), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x2f), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x2e), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x30), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x2f), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x2e), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x2d), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x2c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x2b), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1PaRampPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x2d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x2c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x2b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxDpdPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a0), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxDpdPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxDpdPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxDpdPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxDpdPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a0), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxDpdPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxDpdPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a0), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxDpdPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a0), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xaf), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xaf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xaf), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xaf), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xaf), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xaf), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xaf), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xaf), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xaf), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xaf), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xaf), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xaf), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xaf), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xaf), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0xaf), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0xaf), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xb5), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xb4), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xb3), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xb5), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xb4), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xb3), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xb2), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xb1), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0xb0), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolDataCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xb2), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xb1), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0xb0), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a1), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a1), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a1), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a1), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx1TxqecLolPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a1), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x157), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x157), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x157), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x157), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x157), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x157), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x157), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x157), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x157), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x157), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x157), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x157), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x157), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x157), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x157), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x157), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x15d), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x15c), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x15b), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x15d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x15c), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x15b), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x15a), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x159), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x158), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcDataCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x15a), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x159), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x158), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ba), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ba), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ba), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ba), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ba), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ba), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1ba), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2ClgcRssiCcPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1ba), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdActiveSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c2), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdActiveSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x149), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x149), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x149), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x149), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x149), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x149), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x149), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x149), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x149), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x149), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x149), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x149), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x149), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x149), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x149), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x149), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x14f), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x14e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x14d), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x14f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x14e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x14d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x14c), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x14b), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x14a), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2DpdDataCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x14c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x14b), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x14a), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2GainTableClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1e4), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2GainTableClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1e4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15e), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15e), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15e), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15e), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15e), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15e), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15e), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15e), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15e), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15e), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15e), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15e), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15e), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x15e), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x15e), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x164), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x163), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x162), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x164), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x163), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x162), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x161), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x160), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x15f), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcDataCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x161), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x160), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x15f), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bb), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bb), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bb), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bb), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bb), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2GanAmpRssiCcPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bb), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x16c), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x16c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x16c), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x16c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x16c), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x16c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x16c), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x16c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x16c), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x16c), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x16c), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x16c), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x16c), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x16c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x16c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x16c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x172), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x171), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x170), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x172), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x171), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x170), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x16f), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x16e), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x16d), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0EnableCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x16f), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x16e), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x16d), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bd), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bd), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bd), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bd), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay0PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bd), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x173), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x173), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x173), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x173), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x173), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x173), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x173), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x173), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x173), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x173), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x173), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x173), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x173), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x173), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x173), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x173), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x179), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x178), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x177), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x179), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x178), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x177), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x176), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x175), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x174), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1EnableCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x176), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x175), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x174), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1PedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1be), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1PedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1be), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1PedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1be), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1PedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1be), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1PedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1be), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1PedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1be), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1PedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1be), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntDelay1PedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1be), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x165), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x165), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x165), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x165), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x165), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x165), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x165), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x165), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x165), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x165), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x165), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x165), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x165), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x165), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x165), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x165), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x16b), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x16a), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x169), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x16b), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x16a), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x169), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x168), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x167), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x166), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxEnableCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x168), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x167), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x166), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bc), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bc), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bc), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bc), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bc), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1bc), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2IntTxPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1bc), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampClkDivValue_Set(void *const device,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1a), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x19), (value >> 0));

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampClkDivValue_Get(void *const device,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1a), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x19), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampClkEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x18), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampClkEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x18), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampDelayedEnableStartSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x18), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampDelayedEnableStartSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x18), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampDelayedEnableStopSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampDelayedEnableStopSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampDelayedEnableTx2EnableStartSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x18), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampDelayedEnableTx2EnableStartSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x18), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampDelayedEnableTx2EnableStopSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * (B0 New)
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampDelayedEnableTx2EnableStopSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x18), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x18), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampEnableGpioMask_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1c), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampEnableGpioMask_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampEnableGpioSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x18), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampEnableGpioSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x18), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x31), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x31), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x31), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x31), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x31), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x31), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x31), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x31), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x31), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x31), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x31), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x31), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x31), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x31), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x31), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x31), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x37), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x36), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x35), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x37), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x36), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x35), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x34), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x33), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x32), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2PaRampPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x34), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x33), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x32), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxDpdPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b8), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxDpdPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxDpdPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b8), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxDpdPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxDpdPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b8), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxDpdPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxDpdPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b8), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxDpdPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b8), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedEn_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x150), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * 0: Disable, 1: Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedEn_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x150), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedEndGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x150), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedEndGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x150), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedEndPosedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x150), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Edge Select for End Trigger - 0: Negedge Detect, 1: Posedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedEndPosedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x150), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedMode_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x150), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Operation Mode - 0: Independent Start and End; 1: End delay follows start delay
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedMode_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x150), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedSoftOverrideEnable_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x150), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Soft Override Enable
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedSoftOverrideEnable_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x150), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedSoftOverrideValue_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x150), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * Soft Override Value
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedSoftOverrideValue_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x150), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedStartGeneratedEdgeType_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x150), (value >> 0), 0x40, 0x6);

    return status;
}

/**
 * 0: Positive Edge, 1: Negative Edge
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedStartGeneratedEdgeType_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x150), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedStartNegedgeDetect_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x150), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Edge Select for Start Trigger - 0: Posedge Detect, 1: Nedgedge Detect
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedStartNegedgeDetect_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x150), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedTrigEndDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x156), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x155), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x154), (value >> 0));

    return status;
}

/**
 * Programmable value for End Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedTrigEndDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x156), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x155), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x154), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedTrigStartDelay_Set(void *const device,
    const uint32_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x153), (value >> 16));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x152), (value >> 8));
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (0x400 + 0x151), (value >> 0));

    return status;
}

/**
 * Programmable value for Start Delay, with reference to ARM Clock
 */
static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolDataCaptPedTrigStartDelay_Get(void *const device,
    uint32_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x153), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x152), &register_value);
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (0x400 + 0x151), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolPedStartArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b9), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolPedStartArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolPedStartArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b9), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolPedStartArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolPedStopArm0EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b9), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolPedStopArm0EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolPedStopArm1EnableSel_Set(void *const device,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (0x400 + 0x1b9), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_NvsRegmapCore2_Tx2TxqecLolPedStopArm1EnableSel_Get(void *const device,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (0x400 + 0x1b9), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_NVS_REGMAP_CORE_2_H__