/**
 * \file
 * \brief Contains internal use only FH engineering declarations
 *
 * ADRV9001 API Version: $ADI_ADRV9001_API_VERSION$
 */

 /**
 * Copyright 2020 Analog Devices Inc.
 * Released under the ADRV9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#ifndef _ADI_ADRV9001_INTERNAL_FH_H_
#define _ADI_ADRV9001_INTERNAL_FH_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "adi_adrv9001_internal_fh_types.h"
#include "adi_adrv9001_fh_types.h"
#include "adi_adrv9001.h"

#ifndef CLIENT_IGNORE
#endif

/**
 * \brief Set function for overwritting FH precalibration information
 *
 * Overwrites calibration information in ARM memory.
 *
 * \note Message type: \ref timing_direct "Direct ARM memory acccess"
 *       This function should NOT be called during initial calibrations.
 *       ARM contains a default copy however BBIC can overwrite it for internal testing
 *
 * \pre Channel state is STANDBY 
 * 
 * \param[in] adrv9001          Context variable - Pointer to the ADRV9001 device data structure.
 * \param[in] fhCalibrationCfg  The desired FH calibration configuration settings
 *
 * \returns A code indicating success (ADI_COMMON_ACT_NO_ACTION) or the required action to recover
 */
 int32_t adi_adrv9001_internal_fh_Calibration_Config(adi_adrv9001_Device_t *adrv9001, 
                                                     adi_adrv9001_FhCalibrationCfg_t *fhCalibrationCfg);

/**
 * \brief Get function for reading FH precalibration information
 *
 * Reads FH calibration information directly from ARM memory
 *
 * \note Message type: \ref timing_direct "Direct ARM memory acccess"
 * 
 * \pre Channel state is STANDBY, CALIBRATED
 *
 * \param[in]  adrv9001          Context variable - Pointer to the ADRV9001 device data structure.
 * \param[out] fhCalibrationCfg  Readback of FH calibration configuration settings
 *
 * \returns A code indicating success (ADI_COMMON_ACT_NO_ACTION) or the required action to recover
 */
 int32_t adi_adrv9001_internal_fh_Calibration_Config_Inspect(adi_adrv9001_Device_t *adrv9001, 
                                                             adi_adrv9001_FhCalibrationCfg_t *fhCalibrationCfg);                                                              

#ifdef __cplusplus
}
#endif

#endif /* _ADI_ADRV9001_INTERNAL_FH_H_ */
