/**
 * \file
 * \brief Contains ADI ADM1293 i2c functionality
 *
 * Copyright 2022 Analog Devices Inc.
 * Released under the ADRV9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */

#include "adi_adm1293_i2c.h"
#include "adi_common_error.h"

int32_t adi_adm1293_i2c_write(adi_adm1293_Device_t *adm1293, 
                              const uint8_t wrData[],
                              uint32_t numWrBytes)
{
    int32_t halError = 0;
    
    ADI_NULL_DEVICE_PTR_RETURN(adm1293);
    ADI_NULL_PTR_RETURN(adm1293, wrData);
    
    halError = adi_adm1293_hal_i2c_write(adm1293->common.devHalInfo, wrData, numWrBytes);
    ADI_ERROR_REPORT(adm1293, 2, halError, ADI_COMMON_ACT_ERR_RESET_FEATURE, NULL, "ADM1293 I2C write failed");
    
    ADI_API_RETURN(adm1293);
}

int32_t adi_adm1293_i2c_read(adi_adm1293_Device_t *adm1293,
                             const uint8_t wrData[], 
                             uint32_t numWrBytes, 
                             uint8_t rdData[], 
                             uint32_t numRdBytes)
{
    int32_t halError = 0;
    
    ADI_NULL_DEVICE_PTR_RETURN(adm1293);
    ADI_NULL_PTR_RETURN(adm1293, wrData);
    ADI_NULL_PTR_RETURN(adm1293, rdData);
    
    halError = adi_adm1293_hal_i2c_read(adm1293->common.devHalInfo, wrData, numWrBytes, rdData, numRdBytes);
    ADI_ERROR_REPORT(adm1293, 2, halError, ADI_COMMON_ACT_ERR_RESET_FEATURE, NULL, "ADM1293 I2C read failed");
    
    ADI_API_RETURN(adm1293);
}