/**
* \file
* \brief Types related to the power monitoring chips on the CE board
*
* ADRV9001 API Version: $ADI_ADRV9001_API_VERSION$
*/

/**
* Copyright 2019 Analog Devices Inc.
* Released under the ADRV9001 API license, for more information
* see the "LICENSE.txt" file in this zip file.
*/

#ifndef _ADI_ADM1293_TYPES_H_
#define _ADI_ADM1293_TYPES_H_

#include "adi_common_types.h"

/**
 * \brief Available power monitoring chips by associated I2C slave address
 */
typedef enum adi_adrv9001Ce01_PowerMonitor
{
    ADI_ADRV9001CE01_POWERMONITOR_VDD_1P0   = 0x30,     /*!< VDD 1.0V domain */
    ADI_ADRV9001CE01_POWERMONITOR_VDDA_1P0  = 0x31,     /*!< VDDA 1.0V domain */
    ADI_ADRV9001CE01_POWERMONITOR_VDD_1P8   = 0x32,     /*!< VDD 1.8V domain */
    ADI_ADRV9001CE01_POWERMONITOR_VDDA_1P8  = 0x33,     /*!< VDDA 1.8V domain */
    ADI_ADRV9001CE01_POWERMONITOR_VDDA_1P3  = 0x3B      /*!< VDDA 1.3V domain */
} adi_adrv9001Ce01_PowerMonitor_e;

/**
 * \brief Sample averaging options
 */
typedef enum adi_adm1293_average
{
    ADI_ADM1293_AVERAGE_DISABLED,       /*!< Disables samples averaging */
    ADI_ADM1293_AVERAGE_SAMPLES_2,      /*!< Sets sample averaging to 2 samples */
    ADI_ADM1293_AVERAGE_SAMPLES_4,      /*!< Sets sample averaging to 4 samples */
    ADI_ADM1293_AVERAGE_SAMPLES_8,      /*!< Sets sample averaging to 8 samples */
    ADI_ADM1293_AVERAGE_SAMPLES_16,     /*!< Sets sample averaging to 16 samples */
    ADI_ADM1293_AVERAGE_SAMPLES_32,     /*!< Sets sample averaging to 32 samples */
    ADI_ADM1293_AVERAGE_SAMPLES_64,     /*!< Sets sample averaging to 64 samples */
    ADI_ADM1293_AVERAGE_SAMPLES_128     /*!< Sets sample averaging to 128 samples */
} adi_adm1293_average_e;

/**
 * \brief Current sense range
 */
typedef enum adi_adm1293_currentRange
{
    ADI_ADM1293_CURRENTRANGE_PM25,      /*!< Sets current sense range to plus or minus 25 mV */
    ADI_ADM1293_CURRENTRANGE_PM50,      /*!< Sets current sense range to plus or minus 50 mV */
    ADI_ADM1293_CURRENTRANGE_PM100,     /*!< Sets current sense range to plus or minus 100 mV */
    ADI_ADM1293_CURRENTRANGE_PM200      /*!< Sets current sense range to plus or minus 200 mV */
} adi_adm1293_currentRange_e;

/**
 * \brief VIN Sampling mode select
 */
typedef enum adi_adm1293_vinSelect
{
    ADI_ADM1293_VINSELECT_DISABLED,     /*!< VIN sampling disabled */
    ADI_ADM1293_VINSELECT_FS_1P2,       /*!< VIN sampling as direct ADC input with full scale of 1.2 V */
    ADI_ADM1293_VINSELECT_FS_7P4,       /*!< VIN sampling with ADC full scale of 7.4 V */
    ADI_ADM1293_VINSELECT_FS_21         /*!< VIN sampling with ADC full scale of 21 V */
} adi_adm1293_vinSelect_e;

/**
 * \brief Power monitor configuration
 */
typedef struct adi_adm1293_config
{
    bool simultaneous;
    adi_adm1293_average_e power_averaging;
    adi_adm1293_average_e voltage_current_averaging;
    adi_adm1293_currentRange_e current_sense_range;
    bool continuous;
    adi_adm1293_vinSelect_e vin_select;
    bool vaux_enable;
} adi_adm1293_config_t;

#ifndef CLIENT_IGNORE
/**
 *\brief Data structure to hold ADM1293 device instance settings
 */
typedef struct adi_adm1293_Device
{
    adi_common_Device_t common; /*!< Common layer structure */
} adi_adm1293_Device_t;
#endif

#endif
