/**
 * \file
 * \brief Contains ADI ADM1293 i2c functionality
 *        Analog Devices maintains and provides updates to this code layer.
 *        The end user should not modify this file or any code in this directory.
 */

/**
 * Copyright 2022 Analog Devices Inc.
 * Released under the FPGA9001 API license, for more information
 * see the "LICENSE.txt" file in this zip file.
 */
#ifndef _ADI_ADM1293_HAL_WRAPPER_H_
#define _ADI_ADM1293_HAL_WRAPPER_H_

#include "adi_adm1293_types.h"
#include "adi_adm1293_hal.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \brief Write data to the ADM1293 via i2c
 * 
 * \param[in] adm1293 Context variable
 * \param[in] wrData            The data to be written
 * \param[in] numWrBytes        The number of bytes to write
 * 
 * \returns A code indicating success (ADI_COMMON_ACT_NO_ACTION) or the required action to recover
 */
int32_t adi_adm1293_i2c_write(adi_adm1293_Device_t *adm1293, 
                              const uint8_t wrData[],
                              uint32_t numWrBytes);

/**
 * \brief Read data from the ADM1293 via i2c
 * 
 * \param[in] adm1293 Context variable
 * \param[in]  wrData           The data to be written (command codes or register addresses to read from)
 * \param[in]  numWrBytes       The number of bytes to write
 * \param[out] rdData           The data which was read
 * \param[in]  numRdBytes       The number of bytes to read
 * 
 * \returns A code indicating success (ADI_COMMON_ACT_NO_ACTION) or the required action to recover
 */
int32_t adi_adm1293_i2c_read(adi_adm1293_Device_t *adm1293,
                             const uint8_t wrData[], 
                             uint32_t numWrBytes, 
                             uint8_t rdData[], 
                             uint32_t numRdBytes);

#ifdef __cplusplus
}
#endif

#endif /* _ADI_ADM1293_HAL_WRAPPER_H_ */
