# README.md
## ADRV9001 production/ Overview
This document is an overview of the production/ folder of this SDK.

Shortcuts - [Versioning](#versioning) | [Device Driver](#device_driver) | [HAL Overview](#hal_overview)

## <a name="versioning"></a> Versioning
This section has some helpful information related to versionining and Git.

### Semantic Versioning
The device driver source code is versioned using a variation of [semantic versioning](https://semver.org/).

The device driver has two phases of release:
- Pre-release software - 0.MAJOR.MINOR.PATCH
- Officially released software - MAJOR.MINOR.PATCH

Given the convention, we will increment the:
- MAJOR version when we make incompatible API changes (such as change the `init_t` struct),
- MINOR version when we add functionality in a backwards-compatible manner, and
- PATCH version when we make backwards-compatible bug fixes.

The same rules apply regardless of whether the "0." prefix is present or not.

### Git integration
Since the device driver code has not yet been released publically, the code is distributed under NDA.
Currently, Analog Devices does not have a prefered way to host a private Git repository.  Until this
process has been standardized, we recommend the following process to integrate this source into your
Git flow.
1. For every release of the SDK, extract the production/ folder to a consistent location on your hard drive.
2. The production/ folder has a .git/ folder which makes this a Git repo - let's call it `origin`.
3. Clone `origin` to your working project - let's call it `local` - where you will make changes to the hardware
abstraction layer and develop the base-band IC radio code.
4. When a new version of this SDK is released, extract the production/ folder to and overwrite `origin`.
5. From `local`, merge the changes from `origin` so that you get the improvements and keep your modifications.
6. If at some point in the future Analog Devices releases the production/ code on a private Git repo
you can point your `origin` to the remote repo and your Git flow should behave seamlessly.

## <a name="device_driver"></a> Device Driver
This section descibes the device driver source and describes how to build it.

### ADRV9001_API.chm
This is the doxygen help file that documents the device driver API and guides the developer through the code.

### c_src/
This folder contains the device driver API source code. It also contains a makefile that will assist in
compiling the device driver source with the generated C code from the ADRV9001 Transceiver Evaluation
Software.

### compile_on_platform.py
This script helps copy and compile the source code on the platform.  It will copy both the
operational source (say C99 example code from TES) and the device driver API source to
the platform.  The script anticipates the operational source be placed in a user-created
directory called test1/, however the directory can be named anything.

### cmake_cross-compile_on_host.py
This script helps generate CMake build files and compile the source code on the host for specified target(armhf)
in toolchain.cmake file . It will copy the generated binary file to the platform and provide executable permissions to it.

### memory_profile.py
This script runs a memory profiler against whatever executable you would like.

### refactor_large_stack_variables.py
This script has been removed for SDK 0.14

### Building the Source
How to generate C code, compile for the platform, and run remotely on the platform
Requirements: Python 3.7 (installed and on PATH), paramiko module for Python
Note: Officially python.org dropped support for 2.7 on January 1, 2020.  We will try and keep the scripts backwards
compatible, but it is *strongly recommended* that you use Python 3.
Optional: PuTTY (installed and on PATH)
1. Ensure that the ADRV9001 transceiver evaluation software (TES) has been installed
2. Create a directory at the same level as c_src/ which will contain the generate C code from TES - consider the name test1/.
3. Configure the ADRV9001 with TES
4. In the TES GUI, click Sample Code > C99, then save the generated code in the created directory
5.  At this stage, one can choose between make and cmake as per instructions below :
  - **make** - From a command prompts run "`python compile_on_platform.py`" and follow the instructions
    _Note: Code generation produces multiple source and header files logically organized into tasks.  The file
    `main.c` serves as the starting point.  All source files (whether it be many or just one) need to be copied
    to the platform to ensure successful compilation.  The `compile_on_platform.py` script will do this for you.
  - **cmake** - From a command prompts run "`python cmake_cross-compile_on_host.py`" and it generates cmake build files and compiles it to
    generate a binary. The binary is then copied to remote platform and provided executable permissions.
    The `cmake_cross-compile_on_host.py` script will do this for you.

All resources such as gain tables and FW binaries are serialized as byte arrays are are included in the
`initialize.c` file.  This obviates the need to manage resources with a file system._

### Running the memory profiler
How to profile the memory of your example program
1. Make sure you have built the executable using the above steps
2. Using PuTTY, `cd` to directory containing c_src/ (but not into the c_src/ directory)
3. Run "`python memory_profile.py`" and follow instructions
_Note: There is a known issue with a 3rd party utility that uses heap space and never frees (shameful!).
This is a platform level function and is not needed in a production system._


## <a name="hal_overview"></a> Migrating to the new HAL
The hardware abstraction layer (HAL) has been changed to reduce complexity and increase clarity.
If you previously implemented a HAL for your own platform, follow this guide to update.
- `adi_hal_PlatformSetup()` has been removed in favor of statically assigning function pointers at compile time. See adi_platform.c for an example.
- A template HAL implementation “customer” (location in the c_src/platforms directory) has been added to make it easier to implement your own new HAL. The CUSTOMER_PLATFORM preprocessor directive makes assigning function pointers easy (see adi_platform.c)
- The HAL has been split into individual, device-specific HALs for each device (ADM1293 power monitor, ADRV9001 transceiver, FPGA9001) and common functions used by each device driver.
- `adi_hal_DevHalCfgCreate()` and `adi_hal_DevHalCfgFree()` have been removed. The user is responsible for configuring the `devHalCfg` context object for each device driver HAL and ensuring that any resources are ready (opening files, for example) before calling any device API functions.
- `adi_hal_HwOpen()` and `adi_hal_HwClose()` are only necessary for the ADRV9001 HAL and have been renamed to `adi_adrv9001_hal_open()` and `adi_adrv9001_hal_close()`, respectively. These only exist because of a quirk in the evaluation platform – LVDS and CMOS SSI configurations use separate FPGA images and switching between the two requires opening and closing underlying resources. These two functions should go away in the future.
- `adi_hal_HwReset()` has been renamed to ` adi_adrv9001_hal_resetbPin_set()`
- `adi_hal_Wait_ms()` has been removed
- The logging functions:
    - `adi_hal_LogFileOpen()`
    - `adi_hal_LogFileClose()`
    - `adi_hal_LogLevelSet()`
    - `adi_hal_LogLevelGet()`

have been removed, as it is not appropriate for device driver API functions to call them. It is the user’s responsibility to set up any logging functionality (console output, file, etc.) before calling any API functions. Similarly, it is the user’s responsibility to filter log messages based on log levels as desired – the API functions simply specify the level of each message.
- The functions:
    - `adi_hal_SpiWrite()`,
    - `adi_hal_SpiRead()`,
    - `adi_hal_ArmImagePageGet()`,
    - `adi_hal_StreamImagePageGet()`,
    - `adi_hal_RxGainTableEntryGet()`,
    - `adi_hal_TxAttenTableEntryGet()`,
    - `adi_hal_Mcs_Pulse()`,
    - `adi_hal_ssi_Reset()`

are unchanged, but have moved to the ADRV9001 HAL.
- `adi_hal_BbicRegisterRead()` has been renamed to `adi_fpga9001_hal_Register_Read()`
- `adi_hal_BbicRegisterWrite()` has been renamed to `adi_fpga9001_hal_Register_Write()`
- `adi_hal_BbicRegistersRead()` has been renamed to `adi_fpga9001_hal_Ram_Read()`
- `adi_hal_BbicRegistersWrite()` has been renamed to `adi_fpga9001_hal_Ram_Write()`
- `adi_hal_I2C_Write()` has been renamed to `adi_adm1293_hal_i2c_write()`
- `adi_hal_I2C_Read()` has been renamed to `adi_adm1293_hal_i2c_read()`


### Troubleshooting
- `clr` not found
    1. Open command prompt and run `pip install pythonnet`
- `paramiko` not found
    1. Ensure Python is on the PATH
    2. Open command prompt and run `pip install paramiko`
- paramiko.ssh_exception.BadHostKeyException: Host key for server '192.168.1.10' does not match...
    1. Delete ~/.ssh/known_hosts on the platform
