# Changelog

All notable changes to this project will be documented in this file. See standard-version for commit guidelines.

### 68.20.12 (2026-01-30)

### 68.20.11 (2026-01-22)

### 68.20.10 (2026-01-16)


### Bug Fixes

* board init params must have parameterless constructor for rosetta (#956](https://jira.analog.com/browse/956)) ([639d982)

### 68.20.9 (2025-12-18)

### 68.20.8 (2025-12-12)

### 68.20.7 (2025-12-12)

### 68.20.6 (2025-12-05)

### 68.20.5 (2025-12-02)

### 68.20.4 (2025-11-27)

### 68.20.3 (2025-11-16)

### 68.20.2 (2025-09-11)

### 68.20.1 (2025-09-09)


### Bug Fixes

* Only trigger policy collateral on release_v branch with specific component version (#945](https://jira.analog.com/browse/945)) ([04578b1)

## 68.20.0 (2025-08-29)


### Features

* Activate generate and publish SBOM with actions (#944](https://jira.analog.com/browse/944)) ([2929510)

## 68.19.0 (2025-08-27)


### Features

* separate gain tables per channel, refactor board initialize params (#941](https://jira.analog.com/browse/941)) ([d858280)

### 68.18.2 (2025-08-27)

### 68.18.1 (2025-08-07)

## 68.18.0 (2025-08-06)


### Features

* first-pass split FPGA initialize from Navassa initialize (#939](https://jira.analog.com/browse/939)) ([1de8f60)

## 68.17.0 (2025-07-15)


### Features

* interfaces compatible with Rosetta 17 dynamic proxy logging Nss 00000 (#938](https://jira.analog.com/browse/938)) ([66e3ea8)

### 68.16.2 (2025-06-15)

### 68.16.1 (2025-06-11)

## 68.16.0 (2025-05-29)

### 68.15.13 (2025-05-28)

### 68.15.12 (2025-05-19)

### 68.15.11 (2025-05-16)

### 68.15.10 (2025-05-14)

### 68.15.9 (2025-05-12)

### 68.15.8 (2025-05-12)

### 68.15.7 (2025-05-07)

### 68.15.6 (2025-05-02)

### 68.15.5 (2025-04-28)

### 68.15.4 (2025-04-21)

### 68.15.3 (2025-04-10)

### 68.15.2 (2025-04-03)

### 68.15.1 (2025-04-01)

## 68.15.0 (2025-03-14)


### Features

* update FW version to 0.22.40, test:add NUnit test for SSI port power down in first PRIME state (2ea52a6)

### 68.14.14 (2025-03-05)

### 68.14.13 (2025-01-27)

### 68.14.12 (2025-01-03)

### 68.14.11 (2024-12-19)

### 68.14.10 (2024-11-26)

### 68.14.9 (2024-11-01)

### 68.14.8 (2024-10-28)

### 68.14.7 (2024-10-26)

### 68.14.6 (2024-10-24)

### 68.14.5 (2024-10-17)


### Bug Fixes

* revert to synchronous resets (d6032e9)

### 68.14.4 (2024-10-08)

### 68.14.3 (2024-10-07)

### 68.14.2 (2024-09-27)

### 68.14.1 (2024-09-11)

## 68.14.0 (2024-09-10)


### Features

* consume web-rpc 3.0 (be20ba4)

### 68.13.13 (2024-08-19)

### 68.13.12 (2024-07-25)

### 68.13.11 (2024-07-18)

### 68.13.10 (2024-07-18)

### 68.13.9 (2024-07-18)

### 68.13.8 (2024-06-10)

### 68.13.7 (2024-05-16)


### Bug Fixes

* revert system <> to local "" change to demonstrate successful build using local (d9e2da4)

### 68.13.6 (2024-05-13)

### 68.13.5 (2024-05-07)

### 68.13.4 (2024-05-03)

### 68.13.3 (2024-05-02)

### 68.13.2 (2024-05-02)

### 68.13.1 (2024-03-26)

## 68.13.0 (2024-03-18)


### Features

* add eval client standard constructor for radio control init (73b5b29)

### 68.12.2 (2024-03-01)


### Bug Fixes

* nuke remote files for clean sdcard before install, avoid multple versions causing sdcard full errors (54674c5)

### 68.12.1 (2024-02-29)

## 68.12.0 (2024-02-29)


### Features

* Support for Navassa New and Navassa Lite variants and add Nunit test cases (1c834f0)

### 68.11.2 (2024-02-21)

### 68.11.1 (2024-02-12)

## 68.11.0 (2024-02-07)


### Features

* update profilegen and profiles. add test to verify lock time (33399e9)

### 68.10.4 (2024-02-06)

### 68.10.3 (2024-01-29)

### 68.10.2 (2024-01-24)

### 68.10.1 (2023-12-05)

## 68.10.0 (2023-12-05)


### Features

* update to new ophis, morpheus, rosetta (1887952)

### 68.9.7 (2023-11-30)

### 68.9.6 (2023-11-29)

### 68.9.5 (2023-11-29)

### 68.9.4 (2023-11-28)

### 68.9.3 (2023-11-27)

### 68.9.2 (2023-11-22)

### 68.9.1 (2023-11-21)


### Bug Fixes

* update fw version to pull in fix,  added regression nUnit test to verify LO Leakage below 80 Mhz (1ba8c4b)

## 68.9.0 (2023-11-07)


### Features

* bring Rosetta up to current standards (7c277f3)


### Bug Fixes

* hard-code morpheus package name (6e2400c)
* revert all test updates (06788a6)
* revert test adapter update because somehow it broke everything (6ac58d1)

### 68.8.2 (2023-10-09)

### 68.8.1 (2023-08-21)

## 68.8.0 (2023-08-21)


### Features

* update profilegen and profiles versions and add test for r+s 9.6msps cmos 4-lane usecase (c2eebcb)

### 68.7.11 (2023-08-17)

### 68.7.10 (2023-08-11)

### 68.7.9 (2023-08-04)

### 68.7.8 (2023-08-03)

### 68.7.7 (2023-08-03)

### 68.7.6 (2023-08-03)

### 68.7.5 (2023-07-31)

### 68.7.4 (2023-07-28)

### 68.7.3 (2023-07-28)

### 68.7.2 (2023-07-25)

### 68.7.1 (2023-07-25)


### Bug Fixes

* only run all tests on pull request or when commit message calls for it. no longer run on master (094b15c)
* update clgc test to uc11 (3fc213e)
* update settings in clgc test (f043324)

## 68.7.0 (2023-07-21)


### Features

* show test output and change agent to mconnor1-d03 (fa3f43c)


### Bug Fixes

* bump version (93d41f1)
* bumpversion (6b027e0)

### 68.6.1 (2023-07-19)


### Bug Fixes

* bump version and fix all tests (3dd46f6)

### 68.5.12 (2023-06-15)


### Bug Fixes

* ARM firmware version (2eac6d0)

### 68.5.11 (2023-06-01)

### 68.5.10 (2023-06-01)


### Bug Fixes

* add back ignore for warmboot tests (601f3e3)
* further simplify define constants declaration (f7380c0)
* only declare rosetta constants in rosetta and offline (6fe33db)

### 68.5.9 (2023-05-04)

### 68.5.8 (2023-04-27)

### 68.5.7 (2023-04-26)

### 68.5.6 (2023-04-25)

### 68.5.5 (2023-04-25)

### 68.5.4 (2023-04-25)

### 68.5.3 (2023-04-25)

### 68.5.2 (2023-04-24)

### 68.5.1 (2023-04-24)

## 68.5.0 (2023-04-20)


### Features

* add test to detect gpio pin settings are correct for unused channels (55593c4)
* expand gpio testing (fffdb5c)

## 68.4.0 (2023-04-19)


### Features

* configure Python and MATLAB Meta Rosetta (3669844)
* Rosetta for NUnit including C and MATLAB (a374028)
* tweak and revamp Navassa Grafoi (48ccbfd)


### Bug Fixes

* client connection code in rosetta (8c66394)

### 68.3.2 (2023-04-18)


### Bug Fixes

* update to webrpcgen 1.0.1 (877dbcf)

### 68.3.1 (2023-04-11)

## 68.3.0 (2023-04-11)


### Features

* update rx sync detect default thresholds for updated algorithm (21e23fe)

### 68.2.1 (2023-04-07)


### Bug Fixes

* fix tx atten gpio ctrl tests passes in second rf_enabled. (9402f04)

## 68.2.0 (2023-04-05)


### Features

* nss-2552 FH channel filter load and switch (347dc19)

### 68.1.2 (2023-04-03)

### 68.1.1 (2023-03-30)

## 68.1.0 (2023-02-03)


### Features

* add example gui python script (12ecceb)

### 68.0.8 (2023-01-06)


### Bug Fixes

* allow board to be JSON-serialized by removing last not implemented (79bf179)

### 68.0.7 (2023-01-05)

### 68.0.6 (2022-12-21)


### Bug Fixes

* correct number of arguments to initialize (b219f0c)
* one more ADM1293 instance (e41e4ac)
* remove hard-coded autogenerator error handler (66db9bc)

### 68.0.5 (2022-12-21)

### 68.0.4 (2022-12-14)

### 68.0.3 (2022-12-12)

### 68.0.2 (2022-12-08)

### 68.0.1 (2022-12-07)

## 68.0.0 (2022-11-29)


### ⚠ BREAKING CHANGES

* split adm1293 into separate device instances and add some configurability

### Features

* split adm1293 into separate device instances and add some configurability (7632ed0)
* update for web-rpc (0f96606)

### 67.3.2 (2022-11-16)

### 67.3.1 (2022-10-25)

## 67.3.0 (2022-10-06)


### Features

* add broadcast mode capability for initialization sequence to calibrated state (24617c1)

## 67.2.0 (2022-10-04)


### Features

* remove TBD fields from agc struct (5a128f2)


### Bug Fixes

* correctly access pfir buffer array (6f30f88)
* don't use 'char' unless it's a string (7f1fc7e)
* include linux/types if compiling for kernel; add fpga define to separate from adrv9001 types (0e9da9e)
* properly free or don't allocate memory to prevent leaks (2fa34f1)
* use #define for max count instead of enum (bfb5fed)

### 67.1.3 (2022-09-15)

### 67.1.2 (2022-08-09)


### Bug Fixes

* memcpy usage in warmboot functions had destination and source swapped (7aadc04)

### 67.1.1 (2022-05-31)


### Bug Fixes

* revert use of mosi_spi_xfer to regular _xfer, disable tests (5d76f30)
* revert use of mosi_spi_xfer to regular _xfer, disable tests, revert to jsimonse-d01 agent for now (6e34fd9)

## 67.1.0 (2022-05-25)


### Features

* updated Jenkinsfile to target limk-srp-d02 agent, update nrm version, updated build_client_vs2019.bat, move git push of tag from publish.bat and use new ssh credentials (3ed18c6)


### Bug Fixes

* update credentials (f23ee8e)
* update credentials (01f5380)

### 64.0.2 (2022-05-24)


### Bug Fixes

* only use prbs15 for txssical when samplingrate and interfacerate allow. add asr initcal and ssical tests (48eff9a)

### 64.0.1 (2022-05-18)

## 64.0.0 (2022-05-18)


### ⚠ BREAKING CHANGES

* rx_interface_gain_seed_save array added to adi_adrv9001_GpioCtrlInitCfg_t

### Features

* add rxinterfacegainseed feature and tests (bae4e49)

### 63.0.3 (2022-05-16)

### 63.0.2 (2022-05-16)

### 63.0.1 (2022-05-16)

## 63.0.0 (2022-05-16)


### ⚠ BREAKING CHANGES

* not breaking, version clean up
* not breaking, using to bump major to resolve version issue

* disable uc13 mcs test for now (dae8487)
* disable warmboot tests, disable all tests for now to publish (3a3d684)

### 62.0.1 (2022-05-13)

## 62.0.0 (2022-05-03)


### ⚠ BREAKING CHANGES

* fix version

### Bug Fixes

* fix version (8be8ebf)

## 58.0.0 (2022-05-03)


### ⚠ BREAKING CHANGES

* fix version

### Bug Fixes

* fix version (6bf3b56)

## 56.0.0 (2022-05-03)


### ⚠ BREAKING CHANGES

* fix version
* fix version
* fix version
* change version
* function of adi_adrv9001_cals_InitCals_WarmBoot_Coefficients_Get/Set to adi_adrv9001_cals_InitCals_WarmBoot_Coefficients_MaxArray_Get/Set

### Bug Fixes

* change version (ea507ac)
* fix version (2f6ec30)
* fix version (742f34e)
* fix version (8dae396)
* remove cleanup (e195bda)
* target mconnor1 jenkins credentials, skip tests (2bca786)
* update warmboot #defines (156 unique cals) (e7bc983)

## 50.0.0 (2022-04-15)


### ⚠ BREAKING CHANGES

* gainControlAutomaticThreshold_dBFS, signalPAR and enableFastAttack added to adi_adrv9001_RxInterfaceGainCtrl_t

### Features

* update adi_adrv9001_RxInterfaceGainCtrl_t with new parameters and updated limits (5571a95)

### 49.0.2 (2022-04-12)

### 49.0.1 (2022-03-23)


### Bug Fixes

* correct dynamic fh table load tdd settings so spi trig coincides with first hop for load4 and load8 (740e364)

## 49.0.0 (2022-03-18)


### ⚠ BREAKING CHANGES

* captureDelay_us added to adi_adrv9001_DpdCfg_t, enableAGCGainIndexSeeding added to adi_adrv9001_FhCfg_t
* captureDelay_us added to adi_adrv9001_DpdCfg_t, enableAGCGainIndexSeeding added to adi_adrv9001_FhCfg_t

### Features

* captureDelay_us added to adi_adrv9001_DpdCfg_t, enableAGCGainIndexSeeding added to adi_adrv9001_FhCfg_t, add test for fhagcseed, update fw, add reporting of profilegen version (5759a7e)
* captureDelay_us added to adi_adrv9001_DpdCfg_t, enableAGCGainIndexSeeding added to adi_adrv9001_FhCfg_t, add test for fhagcseed, update fw, add reporting of profilegen version (742c961)

### 48.50.1 (2022-03-03)


### Bug Fixes

* clean up changelog (3fc0272)

## 48.50.0 (2022-03-03)


### Features

* configure spi trig for dynamictableload corectly, send only 8 bits data for tx attenuation, add helper function for configuring fh, add dynamictableload tests including customer usecase (3188bf5)

### 48.49.3 (2022-02-21)


### Bug Fixes

* linux wframe-larger-than warnings (85b6347)

### 48.49.2 (2022-02-05)


### Bug Fixes

* correct typos in warmboot mask generation, add coverage for server warmboot calls (4503144)

### 48.49.1 (2022-02-04)


### Bug Fixes

* if no FMC data found, use outermost boundaries for carrier and LO (89ff29f)
* restore tests (e9599b8)

## 48.49.0 (2022-02-03)


### Features

* add back a byte array method to set get warmboot coefficients (f9b13cd)


### Bug Fixes

* restore tests (902d4b3)

## 48.48.0 (2022-02-03)


### Features

* use list of tuples on client side instead of 2-d byte array for warmboot coeffs, avoids large memory footprint for coeffs in tes (b743648)

### 48.47.1 (2022-02-02)


### Bug Fixes

* add back tests (d49decd)

## 48.47.0 (2022-02-01)


### Features

* update board layer warmboot functions to take coeff array as an argument (c0aa1f9)


### Bug Fixes

* add back tests (af9054c)
* really turn off all tests (945377d)
* turn off tests to publish (d10527c)

## 48.46.0 (2022-01-28)


### Bug Fixes

* skip tests and publish (786cfc0)
* turn off tests (c0d206d)

## 48.45.0 (2022-01-25)


### Features

* add ability to update fh nco within frame by memory write and gpio pulse. update pg, verify gaintabletype correct when extlnafeat is enabled (c0f6c57)

## 48.44.0 (2022-01-20)


### Features

* update loid interface to hardcode interval and use a single threshold (c0f6129)


### Bug Fixes

* disable custom with oversample test (ddaa453)

## 48.43.0 (2022-01-19)


### Features

* update clgc validation, update frameinfoinspect test, adding rxcapture (4109059)

### 48.42.5 (2022-01-17)


### Bug Fixes

* updated warmboot testing for new flexible cal table read and write (a448ae5)

### 48.42.4 (2022-01-12)

### 48.42.3 (2022-01-11)

### 48.42.2 (2021-12-22)

### 48.42.1 (2021-12-20)

## 48.42.0 (2021-12-14)


### Features

* add new fh memory write functions (cbf38eb)
* add timin alaysis for static fh table configure (e6199a6)
* use new fh functions to write table (9ca205f)


### Bug Fixes

* bring more writes into the cache (f7779eb)
* correct array init (c55c5bc)
* correct indexing, update test to compare configure and inspect, frameinfo returning like auto loop (cc2aa09)
* directly access hal function (d65df18)
* get hoptableaddresses at configure time not at table load time (f328915)
* move sw interrupt inside table write function (a070abc)
* remove time of function check from fh static table configure (ed33df5)
* resolve issues with table write, update test that crashed server now validation is removed from tablewrite, resolve all failing tests (1b39936)
* send fh table in cached arrays of size 256 (d6d0b3e)
* update fh table address (5bdc9f2)
* update fw, pg and stream (a676e6a)

### 48.41.5 (2021-12-09)

### 48.41.4 (2021-12-08)


### Bug Fixes

* update board layer gpio fh function validation to only assess initialized channels (2d64080)

### 48.41.3 (2021-12-07)


### Bug Fixes

* update resources, add smarter validation for fh gpio ctrl (acf1481)

### 48.41.2 (2021-12-03)


### Bug Fixes

* add channel2 control at board level of gain/atten pins in fpga (c9c4f0b)

### 48.41.1 (2021-12-01)

## 48.41.0 (2021-11-22)


### Features

* update mmrssi test (6008caf)
* update state validation for MonitorMode_Rssi_Configure, change dpd define from binary to decimal (81d9938)


### Bug Fixes

* clean up header descriptions for dynamic fh table load (a6026d6)

## 48.40.0 (2021-11-19)


### Features

* expand fh table for independent txatten and rxgain control on channel1 and channel2 (1581330)

## 48.39.0 (2021-11-18)


### Features

* improve ssicaltx  with earlier restore and more error clearing, add ssiloopback and ssitx tests to smoke, loosen qec limit to 35 for now, run ssical always in helper.calibrate, enable trackingcals in helper.calibrate, have jenkins publish test results even if batch script returns error (59ba49f)

### 48.38.1 (2021-11-18)

## 48.38.0 (2021-11-09)


### Features

* support manual rx port switching in non fh mode (98ed1a2)


### Bug Fixes

* temporarily remove rxportswitch tests (nss-3212) and disable arm boot error test (9eed16c)
* update fw version to resolve conflict with master (37bd634)

## 48.37.0 (2021-11-03)


### Features

* warmboot: add warmbootenable flag in profile, add get and set of warmboot cal values for warmboot (40f1e91)

### 48.36.1 (2021-10-26)

## 48.36.0 (2021-10-26)


### Features

* update dpd enum to dpd_clgc (1387762)

### 48.35.2 (2021-10-20)


### Bug Fixes

* handle frequency split inside driver function (24cb2c6)

### 48.35.1 (2021-10-19)


### Bug Fixes

* add more test cases (87e8ec6)
* clean up tests (cc4fea6)

## 48.35.0 (2021-10-18)


### Features

* optimize fh frame table size (11e786c)

### 48.34.5 (2021-10-14)

### 48.34.4 (2021-10-07)

### 48.34.3 (2021-10-06)


### Bug Fixes

* word alignment of fh hop frame struct and increase of buffer size (80d44a2)

### 48.34.2 (2021-09-27)


### Bug Fixes

* pfir checksum calculation (2642c00)

### 48.34.1 (2021-09-24)


### Bug Fixes

* add test for gpio io between adrv9001 and fpga9001, testing 15 through 12 (b57b9b7)

## 48.34.0 (2021-09-22)


### Features

* add external lo test for uc5 (e79126e)

### 48.33.2 (2021-09-20)


### Bug Fixes

* disable external path delay cal (0f442cb)
* write dpdinitconfig when either dpd or clgc is enabled, update dpd test to ensure gain read is non zero when appropriate (e9da0e7)

### 48.33.1 (2021-09-10)


### Bug Fixes

* reverse order of multi register bitfield set for auxdac_0_1_2_3 so msb is set last and clocks in the value (7a64074)

## 48.33.0 (2021-09-10)


### Features

* add support for firmware tests (437538f)

## 48.32.0 (2021-09-09)


### Features

* add bbicwakeuplevlel enable to monitor mode mailbox. update and add tests (6d9826b)

## 48.31.0 (2021-09-09)


### Features

* API - Add interface for Tx PA CLGC (8a68072)
* API - Add interface for Tx PA CLGC (49e4819)

## 48.30.0 (2021-09-09)


### Features

* add rssi duration control to interface configure and inspect (d23a02f)

### 48.29.1 (2021-09-08)

## 48.29.0 (2021-09-07)


### Features

* update pg, pt, profiles for ncoenable variable (48eb057)

## 48.28.0 (2021-08-25)


### Features

* API - Remove unused adi_adrv9001_GpioSignal_e types (fe666e2)


### Bug Fixes

* preserve fh hop  2 table select value for compatability with fw (a5d1fcf)
* update examples repo submodule (ca40991)

## 48.27.0 (2021-08-18)


### Features

* API - Refactor adi_adm1293_Read into voltage/current/power read functions (628bb51)
* API - Refactor adi_adm1293_Read into voltage/current/power read functions (e4c693b)
* API - Refactor adi_adm1293_Read into voltage/current/power read functions (f3123ef)
* API - Refactor adi_adm1293_Read into voltage/current/power read functions (5c9c5a4)
* API - Refactor adi_adm1293_Read into voltage/current/power read functions (d222c50)


### Bug Fixes

* add 3sec timeout and 100ms checkinterval for radio state (99a0359)
* add assert to ensure rx data is not all zero (030f0ea)
* add known good zcu102 delays, change tests to not run ssicalibrate, add repeat const (549213c)
* add string error messages, expand threshold to 10 degrees (d5e6067)
* add wait before reading mcs state (4e756cb)
* clean up phasediff logic, disable ssi cal (26c99d5)
* correct phase eval (970c75f)
* correct platform logic, repeat tests 100 times (e0c72ed)
* update mcs tests and move to latest FW (6a86e26)
* use only rxramptest (888098c)

### 48.26.4 (2021-08-09)


### Bug Fixes

* add delay between load_set and load_clear for lssi (0482c85)
* apply 1ms delay between debug_load_set and debug_load_clear. update test (5bf1e02)
* correct sample rate for custom rx ssi test. update ssical test (55f2680)
* update custom rx interface rate test. update pg. use 0x8 pattern for rxssicalibrate (3ed8c8d)
* update rxssicalibrate to always use pattern, not using aaaaaaaa (126aa91)
* use fixed pattern for rx lvds ssicalibrate to avoid issues when samplerate greater than interfacerate (2beac9f)

### 48.26.3 (2021-08-08)


### Bug Fixes

* add console print of sample and interface rates (d83b5ff)
* add test for usecase16 in custom and standard interfacerate. add step to skip ssicalibrate and force known good delays. (926bf92)
* clean up (385365b)
* set tx_ssi_ratio correctly, always leave orx and rx ssi_ratio equal to zero (51ee4ec)

### 48.26.2 (2021-08-05)


### Bug Fixes

* add new flavor of dps test to switch to all profiles at run time. add helper prim function. disable interface gain set in helper for now (3ef70df)
* bug in tx ss ratio bitfield (8de8734)
* bug tx ss mode bitfield (84f3392)
* test passing now, extend to all indices and add back capture and transmit. ignore on jenkins for now (eb3c774)

### 48.26.1 (2021-08-03)


### Bug Fixes

* calculate fpga ssi ratio correctly (5d6dc70)
* call portswitch config api before any carrierfreq configure api (2bb611b)
* disable failing nunit tests temporarily (25c7946)
* leave rx and orx ssiratio at 0 always (60a25a2)
* move min carrier freq test out of smoke tests (59e8689)
* remove console writes from helper.cs (7698293)
* remove dependency on log (6838435)
* update fw, add printfs to fpga ssi settings, add console writes to performbasictransmit, refacttor dps test (ee85afd)

## 48.26.0 (2021-08-02)


### Features

* update arm boot state in api to match fw state (548d011)
* update default monitor mode sync thresholds (0808051)


### Bug Fixes

* extend arm buffer size to cover 64 x tableentrysize24, add test to verify 64 entries can be written to each of tablea and tableb (91dbcac)
* syntax error in api (280a4cf)
* update fw, add test for max fh table size (812d369)

## 48.25.0 (2021-07-30)


### Features

* API - Add NUnit test for non-zero-RxIF in Wideband (401f89c)


### Bug Fixes

* add new cs nunit test file (385863e)
* fix the rx basic capture to set fund and image freq correctly. move nonzerorxif tests to own fle (f2ccfc5)
* updated packages, leave dps test ot index 5 for now (8f083af)

## 48.24.0 (2021-07-27)


### Features

* API - Reduce MinCarrierFreq to 25 MHz (4237f6f)
* API - Reduce MinCarrierFreq to 25 MHz (15f8b51)


### Bug Fixes

* add back commented out code for local testing (8d0ec04)
* add helper code to allow siggen with no reference selection be used. add ignore so jenkins does not use minfreq as tpi does not support < 35 mhz. limit test to uc1 as wideband not supported at 27 mhz (192139c)
* bypass ssical for uc13 mcssync, revert fpga version, disable rx gain delay cal in dps (b5bc934)
* disable uc13 mmsync tx loopback test, failing. only run ssicalibrate if platform is not zc706, use zc706 defaults otherwise. print fpga platform type. revert fpga to 8.2.18 (8fb6671)
* ignore failing rosetta test for now (b7dd376)
* rc check limit from 30 to 25 (35537fd)
* update dynamic profile test to report rx and orx capture for profile index 5 (3e38080)
* update packages to latest (7e37a7c)

## 48.23.0 (2021-07-22)


### Features

* create new functions to allow for an unblocked data capture (49a5c65)


### Bug Fixes

* add concole writes of blueprint field before and after feature enable (50eacc9)
* add gaincontrolconfigure to extlna test (2af5b57)
* allow all crumbs be unassigned in gain index gpio (c3fb38d)
* enable pg feature in mmsync test (48f67aa)

## 48.22.0 (2021-07-21)


### Features

* add api to read tx1 and tx2 clock polarity for ssi calibration (3ad2589)


### Bug Fixes

* configure ss ratio only when the channel is enabled (b105fa8)
* range of valid delays must be greater than or equal to 3 for a successful tx calibration (82de6fb)
* run ssi calibrate after initcals for smoketests (eeb938d)

## 48.21.0 (2021-07-20)


### Features

* add api to read tx1 and tx2 clock polarity for ssi calibration (3ad2589)


### Bug Fixes

* range of valid delays must be greater than or equal to 3 for a successful tx calibration (82de6fb)

## 48.20.0 (2021-07-19)


### Features

* add nunit coverage for fh retune (7713bba)
* two triggers before reading rf pll 1 and 2 phase difference (f3fa059)

## 48.19.0 (2021-07-14)


### Features

* API - MMSync - WakeUp (a7b9dc9)
* API - MMSync - WakeUp (16800b3)
* API - MMSync - WakeUp (37c59fe)


### Bug Fixes

* check if arm is accessible before power management confgure (cf1c256)

## 48.18.0 (2021-07-13)


### Features

* add board layer function for dynamic profile switching (66e1503)

### 48.17.1 (2021-07-02)


### Bug Fixes

* force data path clock in gain table read  (98be08b)

## 48.17.0 (2021-07-01)


### Features

* ddapi support for dynamic profile switching (66e6efa)

### 48.16.1 (2021-07-01)


### Bug Fixes

* always set ext_lna_digial_gain_delay, not just for compensated table (1819ac3)
* apply fix to set function also (bb7f44f)

## 48.16.0 (2021-07-01)


### Features

* add min gain index to generate gain table with external lna (bf4c0e6)
* create function to route rx1 and rx2 gain index to gpio outputs (4d20401)
* Create function to route the Rx1 and Rx2 GainChange signals to GPIO outputs (891d745)
* Update MON_WAKEUP GpioSignal_e (b998f3a)
* Update MON_WAKEUP GpioSignal_e (5bfb7b6)


### Bug Fixes

* bug in ddapi (1947dc0)

## 48.15.0 (2021-06-22)


### Features

* api to provide dma length (080c567)

## 48.14.0 (2021-06-21)


### Features

* support external lna gain table (76f8528)

## 48.13.0 (2021-06-16)


### Features

* delete channel argument in monitor mode vector configure function (9ef6a4e)

## 48.12.0 (2021-06-16)


### Features

* update ssi configuration parameters (f9a55a2)


### Bug Fixes

* add an additional condition to enable orx channels (77a6e45)

## 48.11.0 (2021-06-15)


### Features

* add fpga refclk interface (005577d)
* update fw version to fix failing mcs tests (e4c2578)

## 48.10.0 (2021-06-09)


### Features

* increase power threshold range to 32 bit in dmr search cfg (91f3585)

## 48.9.0 (2021-06-03)


### Features

* add new dpd lut switching parameter (e3299ab)

### 48.8.7 (2021-05-21)


### Bug Fixes

* update pa ramp validation to allow unassigned gpio when trigger is not gpio (d9b9cbd)

### 48.8.6 (2021-05-21)

### 48.8.5 (2021-05-20)


### Bug Fixes

* **client:** power monitoring default to assuming pcb is rev 02B (5a4896c)
* DataGet_15 bit mode treat as 16-bit resolution, rather than requiring shifting (f409618)

### 48.8.4 (2021-05-20)


### Bug Fixes 

* commit all (8bf9895)
* replace channel_power_down with channel and system_power_down with system to reduce enum character length and prevent matlab issue (09043f8)

### 48.8.3 (2021-05-19)

### 48.8.2 (2021-05-18)

### 48.8.1 (2021-05-18)


### Bug Fixes

* bug in ssi calibrate for 32 bit rx ssi (8c34d9b)

## 48.8.0 (2021-05-17)


### Features

* add data_get functions that converts from two's comp to signed (93057d5)

## 48.7.0 (2021-05-12)


### Features

* enable monitor mode sync (0915ab0)

## 48.6.0 (2021-05-10)


### Features

* allow user to configure rx ports for zero offset frequency (a4dd054)

### 48.5.1 (2021-05-07)

## 48.5.0 (2021-05-07)


### Features

* update pa ramp to work for c0 silicon (9ac0b90)

### 48.4.2 (2021-05-06)

### 48.4.1 (2021-05-04)

## 48.4.0 (2021-05-04)


### Features

* convert captured dpd samples to signed value (50bd26b)

## 48.3.0 (2021-05-03)


### Features

* support for port based dual hop rather channel based (027a438)


### Bug Fixes

* remove state validation, update header (a2fc1b2)
* remove unused variable (0b02131)

## 48.2.0 (2021-05-03)


### Features

* expose both types of C grafoi to customers (b085290)

## 48.1.0 (2021-04-29)


### Features

* 32 bit rx ssi calibration (3dc7d2a)


### Bug Fixes

* update fixed pattern in fpga to support 32 bit rx ssi calibration (f54a2eb)

### 48.0.1 (2021-04-28)

## 48.0.0 (2021-04-26)


### ⚠ BREAKING CHANGES

* **stream:** Renamed:
- `adi_adrv9001_Stream_C0_Gpio_Debug_Set` -> `adi_adrv9001_Stream_Gpio_Debug_Set`
- `adi_adrv9001_Stream_C0_Gpio_Debug_Get` -> `adi_adrv9001_Stream_Gpio_Debug_Get`
* **rx_portswitch:** Renamed:
- `adi_adrv9001_Rx_C0_PortSwitch_Configure` -> `adi_adrv9001_Rx_PortSwitch_Configure`
- `adi_adrv9001_Rx_C0_PortSwitch_Inspect` -> `adi_adrv9001_Rx_PortSwitch_Inspect`
* **dpd:** - Renamed `adi_adrv9001_dpd_c0_fh_regions_Configure` -> `adi_adrv9001_dpd_fh_regions_Configure`
- Renamed `adi_adrv9001_dpd_c0_fh_regions_Inspect` -> `adi_adrv9001_dpd_fh_regions_Inspect`
* **dpd:** Removed `adi_adrv9001_DpdCfg_t` -> `outlierRemovalEnable` and `outlierRemovalThreshold` fields as they were only for B0 silicon and will not be supported

### Features

* **dpd:** remove B0 DPD config fields (59ce74c)
* **dpd:** remove c0 distinction from function names (ed9a151)
* **fh:** remove `adi_adrv9001_FhCfg_t.hopSignalChannelMask` (b084ed4)
* **rx_portswitch:** removed c0 distinction from function names (eafd7d9)
* **stream:** removed c0 distinction from function names (579a705)

### 47.0.1 (2021-04-26)


### Bug Fixes

* **fpga:** report errors from the axi driver layer (8fe5dae)

## 47.0.0 (2021-04-22)


### ⚠ BREAKING CHANGES

* remove adi_adrv9001_RxRssiStatus_t in favor of passing uint32_t * directly

### Features

* remove adi_adrv9001_RxRssiStatus_t (ee48338)
* **mcs:** report phase difference of rf PLLs (d710f85)

### 46.7.1 (2021-04-21)

## 46.7.0 (2021-04-20)


### Features

* api support for rx to tx datapath loopback (a017333)


### Bug Fixes

* extend max fh frequency from 3p2ghz to 6ghz (62750d4)

### 46.6.1 (2021-04-14)


### Bug Fixes

* change interval times, updated signal test to change carrier freq and clean up (a651971)
* mcs need either edge (641ec1d)
* unused variable error (1bac44f)
* update to fpga hdl 8.2.16 (ba75b9e)

## 46.6.0 (2021-04-14)


### Features

* api to read dpd captured data samples (3282b53)

## 46.5.0 (2021-04-12)


### Features

* **client:** add pll loop filter settings to adrv9001_RadioCtrlInit_t (b562563)

### 46.4.1 (2021-04-08)

## 46.4.0 (2021-04-07)


### Features

* api support to get dpd sample rate (1bfe224)

## 46.3.0 (2021-04-05)


### Features

* add interface for gain select bits control in 32 bit rx ssi (c19a49c)
* support reading RSSI below -65.554 dB (32cc0d3)

## 46.2.0 (2021-04-01)


### Features

* support for running the Monitor Mode DMR Path Delay initcal. (9648869)


### Bug Fixes

* configure power management settings before arm starts to run (e2b97c0)

### 46.1.1 (2021-03-31)


### Bug Fixes

* ensure ahb spi bridge enable always set high by sps configure (5e46395)

## 46.1.0 (2021-03-29)


### Features

* clean up dma config for dma rx and tx data transfer (9dd0bf2)
* update fw version to support minor version more than 15 (d795576)

## 46.0.0 (2021-03-24)


### ⚠ BREAKING CHANGES

* common_ApiVersion_t is now in AnalogDevices.EvalClient.CommonApi namespace

* consume CommonApi via nrm/nuget package (b76a17e)

## 45.1.0 (2021-03-23)


### Features

* Navassa MATLAB Grafeas containing code shortcuts (49c45dc)

### 45.0.5 (2021-03-16)


### Bug Fixes

* restore erroneously commented out enabling of dma sync (c9b6dcf)

### 45.0.4 (2021-03-12)


### Bug Fixes

* **client:** expose adi_fpga9001_refclk_frequency_set (e43d6e9)

### 45.0.3 (2021-03-10)

### 45.0.2 (2021-03-09)


### Bug Fixes

* **client:** Adrv9001DeviceC0 has no server-side equivalent - just use the Adrv9001Device type (f2fd361)

### 45.0.1 (2021-03-08)


### Bug Fixes

* 22 bit i and q swapped (d95646e)
* DisableRF_Wait now has configurable polling (66d31ce)
* revert max fh frequency to 3.2 ghz. further development work required in fw to get to 6 ghz, not in day 15 (6828392)

## 45.0.0 (2021-03-05)


### ⚠ BREAKING CHANGES

* **client:** SsiCalibrate now takes Adrv9001Blueprint to accommodate different dataFormats per channel

### Features

* add txClkInverted field to adi_fpga9001_SsiCalibrationCfg_t (c42b7c9)


### Bug Fixes

* enable DMAs within SsiCalibrate (702c589)


* **client:** SsiCalibrate now takes Adrv9001Blueprint (87400b4)

### 44.2.3 (2021-03-04)


### Bug Fixes

* 22 bit i and q data extraction (5832407)
* avoid copying preloaded entry of fh table twice (9d69010)

### 44.2.2 (2021-03-03)


### Bug Fixes

* **server:** treat unknown platform as zc706 (b7696e2)

### 44.2.1 (2021-03-02)


### Bug Fixes

* dynamic table load updating wrong address for dual hop (69be409)
* select the correct sw interrupt bit for hop table loading (92ebdd7)

## 44.2.0 (2021-03-02)


### Features

* add new data get methods (3c3a0a0)
* modify mcs sample delay set function and add get function (a3ba645)

## 44.1.0 (2021-03-01)


### Features

* expose function to read fpga platform type (709513a)
* fh api to allow single table switch pin in dual hop mode (7ed440c)


### Bug Fixes

* add delay for loopback test and remove assertion on auxadc voltage for now (6a44822)
* bump to fpga 8.2.11 and modify fpga driver code (08b1d2e)
* handle array size inside hopindex_gainindex_select function (f186343)
* review comments (7ed2d72)
* run ssicalibrate for mcs tests (55adea6)

## 44.0.0 (2021-02-25)


### ⚠ BREAKING CHANGES

* adi_adrv9001_DpdCfg_t now applies to both B0 and C0
* - adi_adrv9001_FhCfg_t now applies to both B0 and C0
- (client) adrv9001_RadioCtrlInit_t no longer contains fhConfig; user must call the appropriate b0/c0 fh configure function after Initialize, but before InitCals_Run

### Features

* read the carrier frequencies used in previous successful init cal (1033e4f)


### Bug Fixes

* adi_adrv9001_Stream_Gpio_Debug_Set/Get are C0 only (7d28cbf)
* initCals->force is C0-only (b28bb33)
* **client:** GpioSignal_e contains FH_HOP_2_TABLE_SELECT (d3a2a09)
* **client:** support b0/c0 variants of ee board (17e356b)


* combine B0/C0 DPD (533da0f)
* combine B0/C0 FH (e352c64)

### 43.1.4 (2021-02-24)


### Bug Fixes

* limit device clock out to not exceed 80 mhz (4865233)

### 43.1.3 (2021-02-23)


### Bug Fixes

* separate fh feature for b0 and c0 and device specific api support (74d70af)

### 43.1.2 (2021-02-19)

### 43.1.1 (2021-02-12)


### Bug Fixes

* ensure power monitor coefficients are set no matter what (72ce618)

## 43.1.0 (2021-02-10)


### Features

* add api support for dpd interface for fh (6f42c8f)

## 43.0.0 (2021-02-10)


### ⚠ BREAKING CHANGES

* Customer is now responsible for partitioning memory for separate channels (Rx1/2, Tx1/2, etc.) through the use of adi_fpga9001_hal_DmaRelativeAddress_Get
* - adi_fpga9001_SwitchBin() removed, use adi_fpga9001_hal_wrapper_SsiType_Set() instead
- added adi_fpga9001_hal_SsiType_Set() to abstract away platform-specific file I/O

### Bug Fixes

* **fpga:** correct mcsPulseWidth limit (5c825e1)


* move memory partitioning to hal (f2ccccb)
* move platform specific file I/O to HAL (5f2691a)

## 42.2.0 (2021-02-09)


### Features

* add support for init cal rerun (215c847)

## 42.1.0 (2021-02-08)


### Features

* **c0-only:** added support for rx port switching (df54e00)

## 42.0.0 (2021-02-05)


### ⚠ BREAKING CHANGES

* 1. DynamicHopTable_Laod() --> SingleHop_DynamicTable_Load()
    - FH mode of type 'adrv9001_FhMode_e' has been passed as an additional parameter to the API to identify single or dual hop

### Features

* add dynamic dual hop table load feature (7a0a15e)


### Bug Fixes

* adi_adrv9001_Ssi_Tx_TestMode_Status_Inspect waits for Cssi capture to complete (89e1a52)
* poll Lssi capture complete too (285da84)

## 41.2.0 (2021-02-05)


### Features

* add dual hop support (3f5fe99)
* **dpd:** add peak and power threshold controls (bcddbbb)
* **dpd:** adi_adrv9001_dpd_coefficients_Get now reads back specified region instead of most recent (7709fea)
* **dpd:** adi_adrv9001_DpdInitCfg_t->preLutScale is now U2.2 (1f04f38)

### 41.1.1 (2021-02-04)


### Bug Fixes

* adi_adrv9001_Utilities_ArmImage_Load supports 288kB binary size for C0 (d109864)
* make Zc706Sd20Platform EEPROM related properties lazy (c1f11dd)
* **server:** check version argument and print before doing anything else (f084c82)

## 41.1.0 (2021-01-27)


### Features

* functions to allow channel1 dma_enable and or dma_trigger be master for channel2 (e2de6b0)

### 41.0.1 (2021-01-22)

## 41.0.0 (2021-01-21)


### ⚠ BREAKING CHANGES

* requires new sd card boot files

### Features

* support zcu102 (69172f1)

## 40.2.0 (2021-01-20)


### Features

* add support for stream to gpio debug feature (3f1247c)
* show arm error code when arm boot failed (3e92e1d)
* table switch by gpio feature in table index selection by gpio (ab79406)

### 40.1.1 (2021-01-18)

## 40.1.0 (2021-01-15)


### Features

* remove ssi mode calculation in fpga, use ssi config struct instead (d0cc49c)
* **gpio:** simplify GpIntMask_Set/Get signatures (596f017)
* remove adi_adrv9001_gpio_GpIntHandler (bed872c)

## 40.0.0 (2021-01-13)


### ⚠ BREAKING CHANGES

* API name change
adi_fpga9001_ssi_TxClockPolarity --> adi_fpga9001_ssi_TxClockPolarity_Set

### Features

* add sample code test (14fe853)
* increase maximum carrier frequency to 6ghz (9d4d592)
* support for fh table index and gain index selection by gpio (0c43acb)


### Bug Fixes

* rebase related error (e8bedc9)
* remove client directory from autogenerated C#; update dependencies (ab3dce7)
* target framework 4.5.2 (ffa68a7)

## 39.2.0 (2021-01-13)


### Features

* **fpga:** add capability to set REF_CLK output frequency (ba868a2)


### Bug Fixes

* modify count passed to mcs_sync_enable and update adi_fpga9001_DmaTrigger_e value (89d9f27)
* update use of _mcs with _sync, update number of pulses to 7 in nunit tests (765467c)
* **HAL:** compare result of mmap() to MAP_FAILED instead of NULL (c5ee6bf)

## 39.1.0 (2021-01-08)


### Features

* support fpga 8.2.0 version (d4b466d)

### 39.0.8 (2021-01-06)


### Bug Fixes

* **client:** error handling (f069b3f)

### 39.0.7 (2020-12-18)


### Bug Fixes

* build error (a6ad914)
* new function for ssi clock inversion (d252022)

### 39.0.6 (2020-12-17)


### Bug Fixes

* changed compiler directive in makefile (9ffa32b)

### 39.0.5 (2020-12-17)


### Bug Fixes

* update spi trigger tdd configuration (4d7cdbf)

### 39.0.4 (2020-12-17)

### 39.0.3 (2020-12-17)


### Bug Fixes

* rx ssi not configured correctly for tx only profile with orx enabled (1b4c057)

### 39.0.2 (2020-12-16)

### 39.0.1 (2020-12-15)

## 39.0.0 (2020-12-15)


### ⚠ BREAKING CHANGES

* attempting to force a BREAKING CHANGE 

### Features

* duplicate HopTable_BytesPerTable_Get in board layer (07039ec)


### Bug Fixes

* add mcs rx synch capture test, update loopback test (1ccdb81)
* add mcs sync test, add vgdb to test settings, update pg (462b01e)
* add more variables to test and read the ssidelays (f87bb5e)
* added usecase version of rxsynchcapture test (c7f791a)
* clean up UseCaseMcsSynchronousLoopbackCapture test (e419c22)
* failing test (c1039b8)
* increase tdd status check timeout duration before stopping tdd (f764424)
* revert back to skipped tests (a0cbaaa)
* update ssi calibration function and always invert the clock (fd28b71)


* attempting to force a BREAKING CHANGE  (adb7b18)

### 38.3.1 (2020-12-11)


### Bug Fixes

* load rx stream when rx is disabled and orx is enabled (895f406)

## 38.3.0 (2020-12-10)


### Features

* **client:** add optional emulatedPartNumber arg to Initialize (a9031cb)
* **internal:** Added a function to get ADRV9002 emulated part number. (fbcf289)

### 38.2.1 (2020-12-08)


### Bug Fixes

* resolve spi dma buffer issue (7b507fb)

## 38.2.0 (2020-12-07)


### Features

* Added reading ADRV9001 variant part number and setting emulated part number via Efuse. (e1b7a9e)

## 38.1.0 (2020-12-05)


### Features

* updated txPreProcMode enum (db766bd)

### 38.0.4 (2020-12-01)

### 38.0.3 (2020-11-30)


### Bug Fixes

* update fw, pg and pt. ignor fifofull and fifoempty in tx ssi delay cal. reuse objects in grafeas for better diffing (00ed223)

### 38.0.2 (2020-11-25)


### Bug Fixes

* SsiCalibrate supports UC 19 (8c91205)
* **client:** use error handling facilities for board functions (b3baa20)

### 38.0.1 (2020-11-24)


### Bug Fixes

* select rx ssi clk when tx ref clock pin is disabled (af9b9ea)

## 38.0.0 (2020-11-24)


### ⚠ BREAKING CHANGES

* adi_fpga9001_DataChain_HopTable_Transfer() API is split into adi_fpga9001_DataChain_HopTable_Transfer_Start() and adi_fpga9001_DataChain_HopTable_Transfer_Stop()

### Bug Fixes

* stop dma before stopping tdd and remove excessive test cases (bda07cd)

### 37.0.2 (2020-11-24)

### 37.0.1 (2020-11-23)


### Bug Fixes

* change datatype and update header comment for rxssitestmode datapattern (5635d3e)
* clean up code (cf40891)
* clean up code (64f7662)
* clean up pattern use in nunit (8fe2a2f)
* expose dma config and status (89d0370)
* fix comment in header from nss-2068 (d4dbe03)
* fix the inspect function to prevent test failure (418e0bb)
* sort out the gpio gain control inspect (17f4cd1)
* update (9faf501)
* update header and remove unused variable (71136a2)

## 37.0.0 (2020-11-20)


### ⚠ BREAKING CHANGES

* pass fpga ssi delays to adi_fpga9001_Initialize instead of hard-coding. Added adrv9001_RadioCtrlInit_t.fpga9001SsiConfig to facilitate this.

### Features

* pass fpga ssi delays to adi_fpga9001_Initialize instead of hard-coding (182fa79)


### Bug Fixes

* set rx data back to normal after ssi calibrate is complete (2068f5d)

## 36.0.0 (2020-11-19)


### ⚠ BREAKING CHANGES

* update Peitho and Eval Client

* update Peitho and Eval Client (5ac522e)

## 35.4.0 (2020-11-19)


### Features

* add fh gain control by pin feature (5d61824)
* add fh gain control by pin feature (2fc1099)


### Bug Fixes

* frequencyHoppingConfigureRC should skip radio control init (f210d4b)
* remove duplicated and incorrect test (524ead0)

### 35.3.2 (2020-11-18)


### Bug Fixes

* wait for tdd start signal to go low in tdd stop function (6fe2a7b)

### 35.3.1 (2020-11-17)


### Bug Fixes

* disable any previously enabled spi triggers in fifo configure (605c970)

## 35.3.0 (2020-11-17)


### Features

* upgrade ssitypes to add txrefclkpin and rxMaskStrobeEn (d016e64)

## 35.2.0 (2020-11-12)


### Features

* add nunit test to orx capture in frequency hopping (1a004b3)

## 35.1.0 (2020-11-12)


### Features

* **fpga:** support syncing of DMA to TDDSELECT_DMA_Enable (5647edd)
* **fpga:** support syncing of tdd enables to datapath clocks (7f0dff6)


### Bug Fixes

* add back ignore for signal tests (321732b)
* correct incorrect address order for multi register bitfields, verify gpint returns correctly (7fa828a)

## 35.0.0 (2020-11-09)


### ⚠ BREAKING CHANGES

* adi_adrv9001_fh_HopTable_Configure() API interface changed

### Features

* add support for dynamic fh table loading (caa3973)
* board layer function to wrap all dynamic fh load related functions (33c39f8)
* update fh tdd json files (ef84dbb)


### Bug Fixes

* review comments (01fd959)
* review comments and failing tests (3f18e96)
* review comments round 2 (30feff5)
* update tdd json file for fh (79cbcae)

## 34.3.0 (2020-11-05)


### Features

* changed fh table load command from high priority mailbox to spi interrupts (712a68d)


### Bug Fixes

* power monitoring correction coefficients apply to current not power (a04a23e)

## 34.2.0 (2020-11-03)


### Features

* add adi_adrv9001_profile_parse again (bc463b0)
* direct fm-fsk loopback validation (6a07187)
* direct fm-fsk loopback validation (d061bc9)
* update loopback validation (b0f16bc)
* update loopback validation (8e96e92)


### Bug Fixes

* add null check to hal init code (57fcd3e)
* build error on jenkins (c47131f)
* build error on jenkins (3c561c2)

## 34.1.0 (2020-10-30)


### Features

* modify fpga register bitfield to set ssi tx clk delay (35867ba)


### Bug Fixes

* comment direct fpga register access to avoid server crash (34be402)

## 34.0.0 (2020-10-29)


### ⚠ BREAKING CHANGES

* Requires image 8.1.0

### Bug Fixes

* stop and start pushbutton monitoring before & after switching binaries (68a4310)

### 33.0.2 (2020-10-27)


### Bug Fixes

* **fpga:** switchBin use full file name when selecting fpga image (5f083b5)

### 33.0.1 (2020-10-26)


### Bug Fixes

* update switchbin to look in old folder, searching for latest version (fe0d3c8)

## 33.0.0 (2020-10-23)


### ⚠ BREAKING CHANGES

* 1. FPGA 8.0 migration requires re-imaging the SD card
2. Xilinx SPI driver will not be supported FPGA 8.0 on wards

### Features

* modify api to support fpga 8.0 (136e943)


### Bug Fixes

* make sure signals keep their level long enough for slower clocks (4c7f82a)
* update axi drivers to 8p0p4 (8c17445)
* use ramp pattern for cmos ssi calibration test (af92bb7)

### 32.1.1 (2020-10-16)


### Bug Fixes

* bitfield get for rx2 was being assigned to rx1 variable (022bfbe)

## 32.1.0 (2020-10-14)


### Features

* add functions to set and get BBDC loop gain (2761c42)

## 32.0.0 (2020-10-14)


### ⚠ BREAKING CHANGES

* update Eval Client and Rosetta to 2.0

* update Eval Client and Rosetta to 2.0 (18d2b4c)

### 31.2.4 (2020-10-12)

### 31.2.3 (2020-10-08)


### Bug Fixes

* **fpga9001:** PerformSynchronousCapture handles trigger correctly (913e3c0)

### 31.2.2 (2020-10-08)


### Bug Fixes

* c0 fix to keep gain table clocks enabled after loading the tables (328f46f)

### 31.2.1 (2020-10-07)

## 31.2.0 (2020-10-06)


### Features

* remove adi_hal_Mcs_Pulse (3c84691)
* remove adi_hal_ssi_Reset (9e53f9c)
* **fpga9001:** use calloc only if ADI_FPGA9001_USE_DYNAMIC_MEMORY is defined (27337d5)


### Bug Fixes

* add case for pin_mode to adi_adrv9001_rx_gaincontrol_configure when setting agc_use_counters_for_mgc bitfield (af96ee3)

## 31.1.0 (2020-10-05)


### Features

* remove adi_adrv9001_RadioCtrlInit_t from C (ef29e4b)


### Bug Fixes

* adi_adrv9001_Rx_InterfaceGain_Set also allowed in PRIMED state (08e78bf)
* update intermediateFrequency range to be +/- 20MHz (7dc4287)

## 31.0.0 (2020-10-01)


### ⚠ BREAKING CHANGES

* Preparation for MCS pulses is now handled by ADRV9001 firmware. The procedure is now
1. Initialize and calibrate
2. `adi_adrv9001_Radio_ToMcsReady()`
3. Send MCS pulses

Removed
- `adi_adrv9001_Mcs_Prepare`
- `adi_adrv9001_Mcs_Digital_Reset`
- `adi_adrv9001_Mcs_Internal_Select`
- `adi_adrv9001_Mcs_Capture_Enable`
- `adi_adrv9001_Mcs_Internal_Sync`
- `adi_adrv9001_Mcs_DigitalInt_Set`
- `adi_adrv9001_Mcs_Execute`

Renamed
- `adi_adrv9001_Mcs_PrepareArm` -> `adi_adrv9001_Radio_ToMcsReady`

Combined
- `adi_adrv9001_Mcs_AnalogStatus_Get` + `adi_adrv9001_Mcs_DigitalStatus_Get` = `adi_adrv9001_Mcs_Status_Get`

Added
- `adi_fpga9001_DataChain_PerformSynchronousTransfer` for two channel simultaneous transmit/receive
- `adi_adrv9001_Mcs_SwStatus_Get`
- `adi_adrv9001_Mcs_TxMcsToStrobeSampleLatency_Get`
- `adi_adrv9001_Mcs_TxMcsSampleDelay_Set`
- `adi_fpga9001_Mcs_RxMcsToStrobeSampleLatency_Get`
- `adi_fpga9001_Mcs_Done_Get`

### Features

* MCS is now handled by ADRV9001 firmware (075fc2c)


### Bug Fixes

* in Utilities_RxGainTable_Load only check ascending order after first row (81950fa)

## 30.0.0 (2020-09-29)


### ⚠ BREAKING CHANGES

* The following APIs ahve been modified to enable user to choose desired SPI mode
1. adi_adrv9001_arm_Image_Write()
2. adi_adrv9001_arm_Memory_Write()
3. adi_adrv9001_Stream_Image_Write()
4. adi_adrv9001_Utilities_ArmImage_Load()
5. adi_adrv9001_Utilities_StreamImage_Load()
chore: Address code review comments


chore: fix typo


feat: add support for navassa streaming mode


chore: fix review comments


chore: cache spi registers and restore back after dma write is done


chore: remove unnecessary caching

### Features

* add support to choose SPI write mode by the user (581e1ae)

## 29.5.0 (2020-09-29)


### Features

* **c0 bitfields:** use new yoda-gen for const correctness (c4c68b9)
* add c0 bitfields and build configurations (031186d)


### Bug Fixes

* change missed fpga register write from absolute to relative (9eb993e)
* **c0 bitfields:** write auxdac_n bitfields LSB first (d478561)

### 29.4.1 (2020-09-28)

## 29.4.0 (2020-09-25)


### Features

* relative addressing of fpga registers (d74f8cf)

## 29.3.0 (2020-09-23)


### Features

* increase allowed firmware image size to 288kB (a220645)

## 29.2.0 (2020-09-18)


### Features

* **client:** add ContextVariableName/Type properties to BaseDevice subclasses (07e8507)


### Bug Fixes

* read dpd coefficient region value from arm and fix failing test (be48b39)

### 29.1.2 (2020-09-16)


### Bug Fixes

* modify dma length restriction from 64 bytes to 8 bytes (b2bcf61)

### 29.1.1 (2020-09-16)

## 29.1.0 (2020-09-15)


### Features

* move all HAL pointer assignments to adi_platform.c and add customer template (aaaa397)

### 29.0.3 (2020-09-15)

### 29.0.2 (2020-09-09)

### 29.0.1 (2020-09-02)


### Bug Fixes

* correct cast in adi_adrv9001_Ssi_PowerDown_Get (b18d437)
* wrap adrv9001_bf_hal.h function declarations in extern "C" { } for C++ (a135c9d)
* **client:** remove '_' from powermanagement member - violates rosetta convention (56a8442)

## 29.0.0 (2020-09-02)


### ⚠ BREAKING CHANGES

* rename adi_fpga9001_GpioHWSourceModes_e values to follow convention/be less confusing

### Bug Fixes

* rename gpio hw source mode values to follow naming convention (9b916a7)

## 28.1.0 (2020-08-28)


### Features

* **adrv9001:** ORx_Gain_Set sets both A and B register (19b73d4)

## 28.0.0 (2020-08-27)


### ⚠ BREAKING CHANGES

* **fpga9001:** rename adi_fpga9001_TddSelect_e values to follow convention/be less confusing
* **fpga9001:** adi_fpga9001_Mmcm_inspect-> adi_fpga9001_clock_Status_Get

### Features

* **fpga9001:** rename adi_fpga9001_TddSelect_e values to follow convention/be less confusing (8e38abe)
* **fpga9001:** replace mmcm_inspect with clock_Status_Get (b3311e2)

### 27.1.1 (2020-08-26)

## 27.1.0 (2020-08-26)


### Features

* add function to stop TDD state machine and separate start from configure (396b13e)

## 27.0.0 (2020-08-25)


### ⚠ BREAKING CHANGES

* remove adi_fpga9001_HwOpen/Close
* separate device specific HAL functions into device specific HAL layers
* remove fpga hal field read/write functions
* move adi_adrv9001Ee01_Ssi_Calibrate to client
* move powermonitor to separate device
* remove adi_hal_Wait_ms
* simplify hal by removing adi_hal_PlatformSetup
* remove unused HAL log functions
* remove `adi_adrv9001_Utilities_InitRadio_Load`
* remove `adi_adrv9001_Utilities_ArmMemory_Dump`
* remove file I/O based utility functions

### Features

* ability to compile out log calls based on log level (6d8aa98)
* move adi_adrv9001Ee01_Ssi_Calibrate to client (505d221)
* move powermonitor to separate device (983f00d)
* remove `adi_adrv9001_Utilities_ArmMemory_Dump` (9cd3b6a)
* remove `adi_adrv9001_Utilities_InitRadio_Load` (0fe95d7)
* remove adi_fpga9001_HwOpen/Close (c54da97)
* remove adi_hal_Wait_ms (aa5a13a)
* remove file I/O based utility functions (d6687c3)
* remove fpga hal field read/write functions (3fdfe53)
* remove old HwReset hal functions (92b9557)
* remove unused HAL log functions (de2634c)
* separate device specific HAL functions into device specific HAL layers (2961523)
* simplify hal by removing adi_hal_PlatformSetup (c451595)


### Bug Fixes

* **linux:** wrap includes of stdint.h in #ifdef __KERNEL__ (0aa98e5)

### 26.0.2 (2020-08-20)


### Bug Fixes

* range check bug in fpga gpio pin source mode configure validation (8cd438c)

### 26.0.1 (2020-08-19)


### Bug Fixes

* range check bug in gpio pin config function (8700fd4)

## 26.0.0 (2020-08-17)


### ⚠ BREAKING CHANGES

* consume Rosetta 1.0

### Features

* consume Rosetta 1.0 (ac3fc3e)

### 25.0.1 (2020-08-13)

## 25.0.0 (2020-08-12)


### ⚠ BREAKING CHANGES

* renamed `adi_adrv9001_PeakDetector_t` and `adi_adrv9001_PowerDetector_t` feedback signals

### Features

* add new fields to fh configuration (62e133d)
* add new fields to fh configuration (166e5fc)
* modified customer accessed agc signals (2c9c089)


### Bug Fixes

* validation in fh configure (7c5569a)
* validation in fh configure (41bd0bb)

## 24.0.0 (2020-08-12)


### ⚠ BREAKING CHANGES

* remove unused utility functions

### Features

* remove unused utility functions and types (60a6b0a)
* support internal tone generation (58e8324)
* **client:** add phased Initialize supporting JTAG to client (806f932)

## 23.3.0 (2020-08-11)


### Features

* **client:** expose client-only gain/atten table write methods (39f14eb)

## 23.2.0 (2020-08-11)


### Features

* 16 bit ramp support for cmos and rx to tx ssi interface loopback (742b418)

## 23.1.0 (2020-08-07)


### Features

* **client:** mark InitCalibrations_e and TrackingCalibrations_e as maskable (df60f0d)

## 23.0.0 (2020-08-07)


### ⚠ BREAKING CHANGES

* **dpd:** removed extra underscores from DPD enum values

### Features

* **dpd:** add functions to set and get DPD coefficients (113368a)


* **dpd:** make enums follow style rules (60a7cfd)

## 22.1.0 (2020-08-07)


### Features

* interpret mailbox error code and provide more descriptive error message (11fbe67)

### 22.0.1 (2020-08-06)


### Bug Fixes

* disable tdd for channels with tdd set to false (26bc7a6)

## 22.0.0 (2020-08-06)


### ⚠ BREAKING CHANGES

* 1. APIs permanently deleted:
adi_fpga9001_DataChain_Tollgate_Configure()
adi_fpga9001_DataChain_Tollgate_Inspect()
adi_fpga9001_DataChain_TollgateReset_Set()
adi_fpga9001_DataChain_TollgateReset_Get()
adi_fpga9001_DataChain_TollgateTrigger_Set()
adi_fpga9001_DataChain_TollgateTrigger_Get()
adi_fpga9001_DataChain_Dma_Configure()
adi_fpga9001_DataChain_DmaReset_Set()
adi_fpga9001_DataChain_DmaRun_Set()
adi_fpga9001_DataChain_DmaLength_Set()
adi_fpga9001_DataChain_Configure()
adi_fpga9001_DataChain_Reset()
adi_fpga9001_DataChain_TxData_Stop()
adi_fpga9001_DataChain_Capture_Wait()
adi_fpga9001_DataChain_RxClkRate_Set()
adi_fpga9001_DataChain_RxClkRate_Get()
adi_fpga9001_internal_GainIndex_Capture()
adi_fpga9001_Tdd_ProgrammedEnable_Set()
adi_fpga9001_Tdd_ProgrammedEnable_Get()

2. APIs replaced by new APIs
adi_fpga9001_DataChain_PerformCapture() and adi_fpga9001_DataChain_Tx() --> adi_fpga9001_DataChain_PerformTransfer(), combined to be one single API
adi_fpga9001_gpio_Mode_Set() --> adi_fpga9001_gpio_OperationMode_Set()
adi_fpga9001_gpio_Mode_Get() --> adi_fpga9001_gpio_OperationMode_Get()
adi_fpga9001_internal_ObservationGpio_Configure() --> adi_fpga9001_gpio_GainIndex_Configure()
adi_fpga9001_internal_ObservationGpio_Get() --> adi_fpga9001_gpio_GainIndex_Get()
adi_fpga9001_Mcs_Start() --> Split into adi_fpga9001_Mcs_Configure() and adi_fpga9001_Mcs_Start()
adi_fpga9001_ssi_Mode_Set() --> adi_fpga9001_ssi_Configure()
adi_fpga9001_ssi_Mode_Get() --> adi_fpga9001_ssi_Inspect()
adi_fpga9001_Tdd_ManualEnable_Set() --> adi_fpga9001_Tdd_Enable_Set()
adi_fpga9001_Tdd_ManualEnable_Get() --> adi_fpga9001_Tdd_Enable_Get()

3. APIs newly added
adi_fpga9001_DataChain_DmaStatus_Get()
adi_fpga9001_DataChain_GainIndex_Get_8S()
adi_fpga9001_gpio_TriggerSource_Configure()

4. APIs whose interface changed
adi_fpga9001_DataChain_Dma_Inspect()
adi_fpga9001_gpio_Read()
adi_fpga9001_gpio_pin_Configure()
adi_fpga9001_gpio_pin_Inspect()
adi_fpga9001_gpio_pin_SourceMode_Configure()
adi_fpga9001_gpio_pin_SourceMode_Inspect()
adi_fpga9001_Tdd_Configure()
adi_fpga9001_Tdd_Inspect()

### Features

* fpga api modifications for axi driver (130901e)


### Bug Fixes

* add helper function to get ssi bytes per sample (8c609e9)
* code review comments  first round (4f3bffa)
* dma timeout error (75d40b6)
* failing tests (0132674)
* merge related build errors (2fc4c4b)
* more tests (6f1ff55)
* rebase related build error (506b44e)
* review comments (b187fc3)
* review comments second round (7b0ea32)
* set to cyclic for tx (e65b310)
* timer issue in axi driver (82b65e9)

### 21.0.1 (2020-08-03)

## 21.0.0 (2020-07-29)


### ⚠ BREAKING CHANGES

* removed adi_adrv9001Ee01_Initialize[FromProfile] in favor of individual function calls generated from the client and TES

### Features

* remove adi_adrv9001Ee01_InitializeFromProfile] ([cda0d08)

## 20.11.0 (2020-07-24)


### Features

* add frequency hopping table ping-pong mode (5dd7e55)

### 20.10.1 (2020-07-23)


### Bug Fixes

* **navassa rosetta:** add explicit false parameter for c99Compliant (ff3c741)

## 20.10.0 (2020-07-23)


### Features

* function to optimize fpga ssi delays for customer profile (ad36b45)
* minimum Rx gain index is now 195 (0aeb964)


### Bug Fixes

* validate rx gain set based on initializedChannels instead of profilesValid (6add6d3)

### 20.9.3 (2020-07-22)


### Bug Fixes

* **client:** expose DEVICECLOCKDIVISOR_DISABLED value to client (75d0670)

### 20.9.2 (2020-07-16)


### Bug Fixes

* roundoff error in hsDigClk_Hz (b77bdb5)

### 20.9.1 (2020-07-15)


### Bug Fixes

* **client:** only write Tx attenuation table if Tx channels are initialized (950a918)
* **sps:** Rx1 does not need to be enabled for system power saving, but does for monitor mode (1bed9c5)
* read/write fpga sysid gpios (pushbuttons and LEDs) (452bf7c)

## 20.9.0 (2020-07-14)


### Features

* clkPllVcoFreq_kHz to clkPllVcoFreq_daHz (20c3cb3)


### Bug Fixes

* updated smoke test (f99b58f)

### 20.8.3 (2020-07-13)


### Bug Fixes

* correct casting to uint for current measurement (2ca2c11)

### 20.8.2 (2020-07-13)


### Bug Fixes

* do not assume PCB revs begin with '0' (09d9853)

### 20.8.1 (2020-07-13)


### Bug Fixes

* do not attempt to access customer board if no connection exists (19bcec1)

## 20.8.0 (2020-07-13)


### Features

* adjusted power monitoring for customer board; EVB Rf info (b9b3055)

### 20.7.2 (2020-07-10)


### Bug Fixes

* explicitly initialize Adrv9001Ee01 board pointer (a34f503)

### 20.7.1 (2020-07-10)

## 20.7.0 (2020-07-10)


### Features

* **client:** call board create from client Initialize (895d670)

### 20.6.1 (2020-07-09)


### Bug Fixes

* **client:** close and reopen file descriptors in client switch bin (596e7fe)

## 20.6.0 (2020-07-08)


### Features

* remove reference to board functions in client Initialize (db41fbd)

### 20.5.2 (2020-07-08)

### 20.5.1 (2020-07-07)

## 20.5.0 (2020-07-07)


### Features

* expand RF signal bandwidth support to 41 MHz (baf5f2b)

### 20.4.1 (2020-06-25)

## 20.4.0 (2020-06-24)


### Features

* implement ssi power down modes (3638b99)


### Bug Fixes

* fix bug where incorrect source was being assigned to analog gpios. add debug nunit test (f31711d)

## 20.3.0 (2020-06-22)


### Features

* update carrier_configure to support intermediate frequency (0267a56)


### Bug Fixes

* **powermonitor:** use correct scaled equation to calculate voltage and current (cd969b9)
* error should be reported if ARM fails to boot (e4816b6)

### 20.2.1 (2020-06-19)


### Bug Fixes

* AuxDac_Configure initialize gpio struct match designator order to declaration order (24a71a9)
* define ADI_RANGE_CHECK_X when ADI_COMMON_VERBOSE is not defined (59abb8d)

## 20.2.0 (2020-06-16)


### Features

* fpga driver support for zc706 reference clock selection (b0c7e5b)

## 20.1.0 (2020-06-16)


### Features

* consume Rosetta 14.0 and erpcgen 5.2.1 (3926c82)

### 20.0.2 (2020-06-15)

### 20.0.1 (2020-06-12)


### Bug Fixes

* make generated code namespaces consistent with device module namespaces (5e052e4)

## 20.0.0 (2020-06-12)


### ⚠ BREAKING CHANGES

* rename DLLs and namespaces - replace "Adi.Tpg" with "AnalogDevices"
* remove "erpc" namespace and remove "[Aa]di_" prefixes

### Features

* remove "erpc" namespace and remove "Aa]di_" prefixes ([f109acc)
* rename DLLs and namespaces - replace "Adi.Tpg" with "AnalogDevices" (3a399ac)

## 19.1.0 (2020-06-11)


### Features

* support external LO divisor of 1 (f1fd2bc)

## 19.0.0 (2020-06-11)


### ⚠ BREAKING CHANGES

* requires FW 0.11.1.0+

### Features

* breaking change update to FW (ef34f5f)


### Bug Fixes

* add table load to hop table set unit test (660df34)

### 18.9.5 (2020-06-10)

### 18.9.4 (2020-06-08)


### Bug Fixes

* remove float usage (9813b5b)

### 18.9.3 (2020-06-08)

### 18.9.2 (2020-06-05)


### Bug Fixes

* undo conditional based fpga binary switch changes (d4b7755)

### 18.9.1 (2020-06-04)


### Bug Fixes

* dpd configure off by 1byte (resetLuts) (0be7813)

## 18.9.0 (2020-06-02)


### Features

* add Frequency Hopping (a4e4ee1)

### 18.8.13 (2020-06-01)


### Bug Fixes

* get current gpio config for adc switch inspect function (682274b)

### 18.8.12 (2020-06-01)


### Bug Fixes

* included adi_adrv9001_defines.h to adi_adrv9001_cal_types.h (96d300c)

### 18.8.11 (2020-05-28)


### Bug Fixes

* perform fpga binary load only when the ssi type is changed (6b430c9)

### 18.8.10 (2020-05-27)


### Bug Fixes

* add dpd nunit debug test, add lte10m waveform (d4e3fa6)
* bugfix fpga mc function, 0 means 1 in fpga bitfield (9c0c8c5)
* clean up ahead of pull request (5f56071)
* clean up elb test (dfd62b8)
* update resources, improve elb, cps and cps and mm nunit debug tests (576f893)

### 18.8.9 (2020-05-27)


### Bug Fixes

* **make:** makefile updated to build on platform (74c0708)

### 18.8.8 (2020-05-21)


### Bug Fixes

* remove 1s delay before and after arm system config mailbox command (199706d)

### 18.8.7 (2020-05-18)


### Bug Fixes

* bugfix for powermonitor read, improve power monitor reads on sps and mm nunit debug tests (37943b1)
* disable auto increment for external path delay get function (a35e348)

### 18.8.6 (2020-05-18)

### 18.8.5 (2020-05-15)


### Bug Fixes

* bugfix for fpga driver range check corrupting device struct, orx and monitormode nunit tests updated (d6501e0)
* comment out ignore of signaltests (d357f5d)
* modify validation changes to just orx, add ignore for debug tests (a648e94)
* update orx test (dbed11f)

### 18.8.4 (2020-05-14)


### Bug Fixes

* add 1 sec delay after powersavingpin toggles (ff478fa)
* add ability to run all usecases in debug tests (8ac7686)
* add adcswitch test (7516cd3)
* add extra enum to monitormode state for testing, clean up systempowersaving, add systempowersaving gpio config to init (0e6f139)
* add fpga register reads and placeholder for disabling rx2 dma_mode to loopback debug nunit test (23bbc28)
* add nunit initcalstatus read test (1c9aa9f)
* add radioctrlinit gpio set (7b9775e)
* add rx gain control spi and pin nunit test (edb808f)
* add txattenpincontrol nunit test (0c520e7)
* add txssi to rxssi loopback nunit debug test (32170b8)
* add use case inittransmitrx tests to debug nunit (babbb4a)
* clean up ahead of pull request (0e2757b)
* clean up ahead of pull request (1b62367)
* clean up ahead of pull request (d0a54ba)
* clean up ahead of pull request (eddcc43)
* clean up ahead of pull request (024ff98)
* clean up ahead of pull request (b2eecdc)
* clean up ahead of pull request (546102a)
* correction to adcswitch nunit test and addmode set to txatten (df849e3)
* enable txoutputpowerboost and adcswitch, remove reliance on data_get_16i16q for rx capture (0d6debd)
* fix bug in order of write to tx atten register lsb last, improve txatten nunit test (4a428c6)
* improve txssi to rxssi nunit debug loopback test (9472205)
* move initcal status read to calibrated state (94de1d3)
* test fix for autotdd to keep pins low until programmedenable true. add debug reads to autotdd nunit test (1f8c1b1)
* update fw, remove merge comments, set powersaving nunit test delay to 50 ms (fdd5bf2)
* update profiles, add usecase22 as option (9630737)
* update resources, add monitor mode test, add power monitor output to inittxrx test (1ec9cb5)
* update resources, improve rx gain test, change mm radioctrlinit values (ea7004f)
* updated resources, update debug tests (e78e124)

### 18.8.3 (2020-05-13)


### Bug Fixes

* apply fpga delays at init time and special delay value for SSI DDR (318659c)

### 18.8.2 (2020-05-13)


### Bug Fixes

* review comments and add more validation (4adac01)
* update tx attenuation state transition diagram (a4a5b57)

### 18.8.1 (2020-05-11)


### Bug Fixes

* write auxdac_n bitfields LSB first (ecea0c4)

## 18.8.0 (2020-05-07)


### Features

* clean up PLL enums (d94869b)
* remove adi_fpga9001_Mmcm_Configure and _Lock_Get (defadc1)

### 18.7.1 (2020-05-06)


### Bug Fixes

* quietly modify device clock within 250mhz (391683c)

## 18.7.0 (2020-05-06)


### Features

* add a new function to allow rssi be configured at initialization (bd24334)

### 18.6.4 (2020-05-05)


### Bug Fixes

* **power saving:** ChannelPowerSaving_Inspect - only check channel state if channel is initialized (76e9c5c)
* **tdd:** in manual mode, enable tdd dma (ed0eab4)
* aux adc number scheme fix to be consistent with aux dac (671dfc4)

### 18.6.3 (2020-05-05)


### Bug Fixes

* use port 0 for all aux adc (d7ff755)
* write all bitfields MSB first (8563f26)

### 18.6.2 (2020-05-01)

### 18.6.1 (2020-05-01)


### Bug Fixes

* remove tdd_start from frame_set. update auto tdd nunit test (4798e7d)

## 18.6.0 (2020-04-30)


### Features

* add capability to configure on-board LDOs for additional power saving (40a8671)


### Bug Fixes

* disable auto increment for temperature get function (db30be5)
* disable auto increment to avoid out of bounds access in various functions (376108b)
* return error if byte count is not multiple of 4 (90699a9)
* txoutputpowerboost pass as value instead of reference (5632d1a)

## 18.5.0 (2020-04-30)


### Features

* add ADI_ADRV9001_ARM_MONITORMODE_UNDEFINED  (86bfff7)

## 18.4.0 (2020-04-29)


### Features

* **tdd:** add SMA output controls (19aec26)


### Bug Fixes

* add fpga tdd status read, add manual set of enables to low (29068f4)
* add ignore for debug tests (06bc074)
* add radiostate get and reads from fpga registers to auto tdd (d41bce9)
* driver to use tdd enables. nunit update tdd jsons (00eb842)
* fix conflicts with master merge. handle enable_set and enable_get. update tdd json files with sma info (859bd47)
* modify tdd jsons. add use cases for auto tdd (dfe2133)
* update profile and fw version, update testsettings accordingly (1c9c4cb)
* update profiles and add nunit tdd manual and auto tests (c2e605a)
* update to fpga 0.6.5. edit tdd json file (07cfae5)

## 18.3.0 (2020-04-22)


### Features

* program dpfifo and correlator patterns (982025d)

### 18.2.4 (2020-04-21)


### Bug Fixes

* correctly set mmcm ssi clock frequency (22d8c8d)

### 18.2.3 (2020-04-21)

### 18.2.2 (2020-04-18)


### Bug Fixes

* added axi ref clock gen drivers (fc38cb0)
* axi adrv9001 tdd typo fix (2a1a26a)
* enable tdd auto and start during frame config (f708327)

### 18.2.1 (2020-04-16)


### Bug Fixes

* array length issue in internal path delay get function (cf97563)

## 18.2.0 (2020-04-16)


### Features

* upgrade init struct for power savings (aef5753)

### 18.1.1 (2020-04-13)

## 18.1.0 (2020-04-10)


### Features

* **auxdac:** inform firmware of gpio usage (f3c52a6)
* **cals:** rename `adi_adrv9001_InitCalMode_e` values to be more descriptive (a68df52)
* **fpga:** update to fpga 0.6.4 (c92d9fd)
* **tx:** configure just tx output power boost instead of attenuation in Initialize (afe1c86)

## 18.0.0 (2020-04-08)


### ⚠ BREAKING CHANGES

* **auxadc:** removed "adi_adrv9001_AuxAdc_Range_e"
* renamed `adi_adrv9001_Radio_CarrierFrequency_Set` -> `adi_adrv9001_Radio_Carrier_Configure` and added config struct for BPN/BPS

### Features

* add function to expose rx gain index on dgpio to customer (9a9804e)
* add function to read path delay for the given port and channel (4c2c7ae)
* **auxadc:** modify code to remove voltage range enum (6d74798)
* **power saving:** add LDO power down mode (23a314b)
* support carrier configuration of BPN vs BPS (f1081c0)


### Bug Fixes

* **gain control:** inspect returns gpio assignments (bf67933)

## 17.1.0 (2020-04-06)


### Features

* **tx freqcorrection:** tx frequency correction functionality (47ba0d4)

### 17.0.1 (2020-04-06)


### Bug Fixes

* **fpga:** gpio and tdd changes to update to FPGA 0.6.3 (49186e7)

## 17.0.0 (2020-03-30)


### ⚠ BREAKING CHANGES

* **fpga:** requires update to FPGA v0.6.2
* **auxdac:** rename `adi_adrv9001_AuxDacs_e` -> `adi_adrv9001_AuxDac_e`

### Features

* **auxadc:** add AuxAdc functionality (83234a3)
* **auxdac:** rename `adi_adrv9001_AuxDacs_e` -> `adi_adrv9001_AuxDac_e` (f6154cf)
* **fpga:** axi driver support (968e148)

### 16.0.1 (2020-03-27)

## 16.0.0 (2020-03-27)


### ⚠ BREAKING CHANGES

* **version:** remove `adi_common_ApiVersion_t.build`
* **fpga:** remove `adi_fpga9001_FpgaBinDirectorySet`

### Features

* **fpga:** remove FpgaBinDirectorySet (ac51b91)
* **version:** remove `adi_common_ApiVersion_t.build` (58de708)

### 15.0.2 (2020-03-25)

### 15.0.1 (2020-03-24)


### Bug Fixes

* **agc:** limit range of resetOnRxonGainIndex (5cfcd19)

## 15.0.0 (2020-03-20)


### ⚠ BREAKING CHANGES

* rename dacFullScaleBoostEnable -> txOutputPowerBoostEnable

### Features

* rename dacFullScaleBoostEnable -> txOutputPowerBoostEnable (93b14fb)

### 14.3.9 (2020-03-19)


### Bug Fixes

* **makefile:** incorrect syntax (2bd796f)

### 14.3.8 (2020-03-19)


### Bug Fixes

* **makefile:** tabbing incorrect (c71cfb9)

### 14.3.7 (2020-03-18)


### Bug Fixes

* **make:** c code builds on platform (b1ffe23)

### 14.3.6 (2020-03-17)


### Bug Fixes

* **examples:** use default install directory for example code (d758fa3)
* workaround for dma read with auto increment (e2c8cbf)

### 14.3.5 (2020-03-16)


### Bug Fixes

* remove need for calling FpgaBinDirectorySet (0d3e2e7)
* **rosetta:** ensure device contexts are calloc'ed in multiple log case (ddfdfc8)
* ensure standard bool is correctly included (b0f1408)

### 14.3.4 (2020-03-12)


### Bug Fixes

* offset armPowerSavingClkDiv by 1 so customer sees literal divisor (66c2b39)
* rearrange tx ssi configuration for fixed pattern check (1b8e9eb)

### 14.3.3 (2020-03-11)


### Bug Fixes

* support single channel configuration w/PG actually setting ssiType (c9af1d0)

### 14.3.2 (2020-03-09)


### Bug Fixes

* **agc:** update agc secondary threshold calculation (105ed99)

### 14.3.1 (2020-03-06)


### Bug Fixes

* **powermonitor:** use the correct current scale factor for VDD_1P0 (5d6d514)
* allow only fixed pattern test for non 16 bit ssi data format (057aa8a)
* support all ssi data formats in inspect function (5564636)

## 14.3.0 (2020-02-28)


### Features

* **fpga:** support ssi delay configuration for fpga (970839f)


### Bug Fixes

* **fpga ssi:** add delay and clear Rx test mode error bits (b6c8a77)
* **ssi:** read correct bitfield for test mode status (b756c5b)
* enforce state constraints for setting attenuation mode (591112b)
* force lvds to use ddr (d0ce706)

## 14.2.0 (2020-02-21)


### Features

* **fpga:** support CMOS DDR modes (d265d4b)


### Bug Fixes

* **power saving:** only check channel state if channel is initialized (be8699f)
* profile verification failed with ilb2 enabled and elb2 disabled (1a8f372)
* return error instead of warning if disabling rf fails (a8f7cca)
* validate that channel enable mode is SPI for enableRf (0df62a1)
* **ssi:** can now repeatedly write ssi delays (c91469e)
* tx2 ref clk cmos delay was written to wrong address  (34e1928)

## 14.1.0 (2020-02-18)


### Features

* add capability to dynamically switch adc (fd57e08)
* **agc:** update threshold calculation for b0 (2332dff)


### Bug Fixes

* **agc:** use larger integer type so entire bitfield is written (2960032)
* **gpio:** unassigned enum value was handled incorrectly (0112edb)

## 14.0.0 (2020-02-07)


### ⚠ BREAKING CHANGES

* **gpio:** adi_adrv9001_gpio_Configure now takes a signal argument
* **mcs:** a0 no longer supported

### Features

* add system power saving mode functions (e4d2346)
* **dpd:** allow compander size 512 (3bc9480)
* support reset of DPD (14f58f1)
* **mcs:** clean up mcs interface, drop support for a0, no polling (515d9dd)
* add hal functions for ssi reset and mcs pulse (1f2be65)


### Bug Fixes

* bbdc enable set function was returning an error for orx (f4cd157)
* include lvdsTxClkDelay values in default radioCtrlInit_t (a2f9db6)
* only configure power saving gpio if pin is assigned (eaaf24c)
* support full range of external path delay and enforce maximum (936e02a)


* **gpio:** configure function takes a signal to clean up interface (d2d5e24)

## 13.0.0 (2020-01-31)


### ⚠ BREAKING CHANGES

* removed adi_adrv9001_RadioCtrlInit_t.adrv9001ReferenceClockDivisor and renamed .adrv9001DeviceClockDivisor to .adrv9001DeviceClockOutputDivisor
* radioCtrlInit dpd field is now an array
* AnalogDevices.Adrv9001.ProfileTypes.dll is now required

### Features

* functions to measure, read and set the elb path delay (09130e9)
* functions to measure, read and set the elb path delay (4cb74e2)
* functions to measure, read and set the elb path delay (256916d)
* functions to measure, read and set the elb path delay (5806463)


### Bug Fixes

* **rosetta:** matlab grafeas points to b0 (3e745ec)
* add mailbox command set elb path delay during initialization (a6dc115)
* code changes based on review comments (84d2cd9)
* convert elb path delay in picosecond based on review comments (2df23ef)
* correctly set max gain index for no fs gain table load (d5b3600)
* don't clobber current log level when disabling spi logging (95b00ed)
* enable gain/atten table clock in write and read functions (7da0f54)
* fix issues due to rebase (da37e92)
* missing last index write for tx attenuation table (4e58470)
* modify comments and variable names (aa996b1)
* profile parse function should be conditionally compiled (9dc7689)
* protect against divide by 0 (e50dcc3)
* rebase related errors (8296f50)
* rephrase doxygen comments to be more helpful to understand (2f29221)
* revert wrong evalclient submodule (5832124)
* revert wrong evalclient submodule (e136c64)
* revert wrong evalclient submodule (a2ef7b7)
* revert wrong evalclient submodule (aa663d5)
* review comments (4aae10a)
* unwanted changes due to rebase (fa094a6)


* consume profile types via nuget package (fa37d45)
* radioCtrlInit dpd field is now an array to be consistent (fdbef4c)
* remove ref clock divisor and modify device clock out logic (190ccbd)

## 12.0.0 (2020-01-24)


### ⚠ BREAKING CHANGES

* Removed ssiConfigSettings parameter from adrv9001Ee01_internal_InitializeFromProfile

### Features

* add ssi calibration feature for cmos and lvds interfaces (671ee25)
* allow larger atten table and update for b0 (ac6ff91)
* allow monitor mode in any of the channel states (f7b6255)
* api to support tx attenuation control through gpio pin (1706173)
* support dynamic update of tdd timing parameters (eef38aa)


### Bug Fixes

* allow new fpga versions (5891326)
* code change based on review comments (454bf45)
* code changes based on review comments (7838114)
* disallow bbdc rejection enable set in standby state (0339e55)
* rephrase the comment to be more precise (5549a67)

## 11.1.0 (2020-01-10)


### Features

* add getter method for individual channel state (db640be)

### 11.0.3 (2019-12-20)


### Bug Fixes

* **make:** runs without segfault on platform (7841acb)

### 11.0.2 (2019-12-19)


### Bug Fixes

* cgrafeas should default to ee board (2ba0009)
* **rosetta:** string discrimination provider in python/matlab grafoi (6e1a8a3)
* pass path arguments when filesystem not available (e70f10c)
* **rosetta:** correct pointer initialization (083702a)
* change lb profile min allowed rx bandwidth from 12khz to 6.25khz (774af5a)
* change tx profile min allowed rx bandwidth from 12khz to 6.25khz (f195df4)
* differentiate between manual spi and pin gain control modes (7d4d3a9)
* disable auto increment for all arm memory read to avoid read error (e887ea3)
* extend arm data memory region as two more banks are added in b0 (b6d66d4)
* fix build error due to wrong context variable name in header file (2318f5c)
* remove unknown characters (1bfa0fd)
* update error message to make more sense (a81d9f6)

### 11.0.1 (2019-12-16)


### Bug Fixes

* can configure gain control pin mode for channel 2 (a238aa0)

## 11.0.0 (2019-12-13)


### ⚠ BREAKING CHANGES

* removed old fpga gpio functions

### Features

* add ability to pass stream binary as byte array (854ed84)
* add power saving monitor mode configuration functions (bfc3fef)
* add support for offline code generation (f01d339)


### Bug Fixes

* can now set fpga pins high and low (fd4977e)
* change min allowed rx bandwidth from 12khz to 6.25khz (63ecabe)
* remove mcs callback as no longer needed in b0 and fix bug in init (adc546d)
* update grafois so connection is made correctly (7cb1827)
* remove redundant fpga gpio functions (4b8560e)

## 10.0.0 (2019-12-06)


### ⚠ BREAKING CHANGES

* renamed gain control mode functions

### Features

* add functions for configuring pin control of rx gain (0996f77)
* **b0:** added device initialization sequence for b0 silicon (b728e4a)
* **b0:** added device initialization sequence for b0 silicon (2ec1da9)
* modify internal utilities debug mailbox cmd to enable rx ssi (f23b12c)


### Bug Fixes

* **fpga:** could not toggle pin repeatedly high and low (6b44351)
* **gpio:** input level get did not return enum value (447d328)
* add doxygen option to generate erpc for b0 (2015c45)
* build errors in a0 due to changes in b0 (7627354)
* remove old parameters in struct added during merge (e64c2bf)
* rename and move gain control mode set get functions (a197627)

## 9.0.0 (2019-11-26)


### ⚠ BREAKING CHANGES

* renamed various rx and rx gain control types
* renamed functions and types related to gain control


### Bug Fixes

* change references of agc to gain control (8e947e6)
* rename rx and gain control types (10d5870)

## 8.4.0 (2019-11-25)


### Bug Fixes

* **error:** non-verbose error handling (1ce5d4d)

## 8.3.0 (2019-11-22)


### Bug Fixes

* fix failing mmcm gtest (5b31075)
* fix gtest failure (d18e77f)
* fix lcmInterfaceSampleRate calculation for mmcm calculation (06d8e02)
* load rx/orx tables also for the selected tx channel (5438046)
* mmcm to use lcm of interface rate, extend tdd_clk range to 200mhz (8b7d98c)
* modify parameter name in mmcm configure func to more relevant name (bf3cf24)
* **error:** adi error report macro when verbose off (c89c34d)
* update profilegen to 0.9.12 (d5f5aa7)

## 8.2.0 (2019-11-15)


### Bug Fixes

* nss-794, tx1 only failed (3bc9bc9)

## 8.1.0 (2019-11-14)


### Features

* **gainindex capture:**  add test to capture gain index over gpio (df723b7)
* **nunit framework:** add tetra profiles to profileNameGet (13dad61)
* **orx/elb/ilb:** add nunit test to configure and (90bb7c6)
* **orx/elb/ilb:** remove on/off_lo information from tests (c2cd60f)
* dpd configuration  (8864667)


### Bug Fixes

* increase wait time for disabling rf (c7a016e)
* **agc config:** update agc config values to latest from gui (81a0daf)
* **nunit framework:** add description to rxgainindexget nunit test (f07541b)
* **nunit framework:** update pac to fw 0.7.1.1 and profiles 7.0.0.6 (840d2c5)
* added conditional platform timeout (46d9a2e)
* added conditional platform timeout (925e965)
* nss-730 resolved (90edbb4)
* nss-730 resolved (0e365f4)
* protect against divide by zero - occurred in single channel profile (2118c4c)
* rxclkrate set to 0 for day 7 (b41ea17)
* rxclkrate set to 0 for day 7 (c1d826a)
* shift bitfield back down so an actual GpioPinLevel_e is returned (ce192fe)
* swap order of gpio crumbs for gain control feedback signals (5ec9704)

## [8.0.0] - 2019-11-01

### Added

- Added driver to support manual and automated ORX Capture

    - Added `adi_adrv9001_radio_GpioConfig_Set` to inform the ADRV9001 which GPIO pins are used (For example: the ORX1 and ORX2 enable signals)

	- Added `adi_fpga9001_gpio_pin_SourceMode_Configure` to inform the FPGA which GPIO pins to route the ORX Enable signals to



### Changed

- Modified 'adi_adrv9001_Init_t' struct to include additional values needed for B0

- ORx maximum gain index is now 14 rather than 10

- Modified the following functions to support ORx

    - `adi_fpga9001_DataChain_Configure`

	- `adi_fpga9001_DataChain_RxCapture_Wait`

- Modified FPGA RAM offsets in adi_fpga9001_datachain.h to accommodate ORX data be captured in RAM

- Modified `adi_adrv9001_Rx_InterfaceGain_Inspect` and `adi_adrv9001_Rx_InterfaceGain_Get` to not allow in STANDBY state



### Fixed

- Profile validation no longer couples ORx and Loopback channels

- 'rxClkRate_Hz' calculation to fix Rx data capture issue

- Fixed mask bits to get SSI mode in `adi_fpga9001_ssi_Mode_Get`

- `adi_adrv9001_Tx_Attenuation_Configure` and `adi_adrv9001_Tx_Attenuation_Set` weren't getting called during initialization



## [7.0.0] - 2019-10-16

### Added

- Added `interFrameControlSignal1/2` to `adi_fpga9001_TddConfig_t`

- Added `adi_adrv9001_ORx_Gain_Set` and `adi_adrv9001_ORx_Gain_Get` functions to set/get gain index for ORx channels

- Added `adi_adrv9001_TrackingCals_Set` and `adi_adrv9001_TrackingCals_Get` functions to set/get tracking calibrations



#### INTERNAL ONLY

- Add ability to configure the observationGpio data path control, control the tollgate trigger and capture gainIndex data to RAM



### Changed

- Updated NUnit tests to use the new profile filenames

- Updated 'adrv9001_FeatureID_e' enum to support the following features:

    - ORX_ENABLE

	- RX_EXT_FRONTEND_CONTROL

	- TX_EXT_FRONTEND_CONTROL

	- TX_PA_RAMP_CTRL

- Renamed `adrv9001_RxInterfaceGain_e` -> `adi_adrv9001_RxInterfaceGain_e` and added values down to -36 dB

- Renamed `adrv9001_RxInterfaceGainCtrlType_e` -> `adi_adrv9001_RxInterfaceGainCtrlMode_e`

- Renamed `adrv9001_RxInterfaceGainCtrl_t` -> `adi_adrv9001_RxInterfaceGainCtrl_t`

- Changed `adi_adrv9001_RxInterfaceGainCtrl_t`:

    - `updateInstance` -> `bool updateImmediate`

    - `gainControlMode` -> `controlMode`

- Modified `adi_fpga9001_TddFraming_t` to support FPGA 0.4.14:

    - `frameSwitchTime` is now `uint32_t` instead of `uint8_t`

    - Added `frameSwitchTimeChannel`

- Increased streamImageFile array length to 256 characters

- Modified `adi_adrv9001_Rx_InterfaceGain_Configure/Inspect` and `adi_adrv9001_Rx_InterfaceGain_Set/Get` APIs as per updated interface

    - Removed 'sigPar_dB' from adi_adrv9001_RxInterfaceGainCtrl_t

	- Added a new enum type 'adi_adrv9001_RxGainTableType_e' to determine the type of gain table loaded during ADRV9001 initialization

	- Added a detailed range check for 'gain'



### Fixed

- Bitfield value for FPGA internal tone selection fixed

- Fixed the upper threshold limits for the following AGC configuration bit fields

    - 'underRangeLowPowerThreshold' -> From 31 to 15

	- 'overRangeHighPowerThreshold' -> From 127 to 15

	- 'overRangeLowPowerThreshold'  -> From 15 to 127

- Fixed a bug in 'SWTxPaRampConfigureInspect' gtest

- Fixed the byte order of "signalPar_dB" and "gain" in 'adi_adrv9001_Rx_InterfaceGain_Configure' and 'adi_adrv9001_Rx_InterfaceGain_Inspect' functions

- When not `ADI_COMMON_VERBOSE`, `ADI_ERROR_REPORT` macro now saves values to the common error struct so functions still return error values correctly using the `ADI_API_RETURN` macro

- Fixed broken GTests `SWPllLoopFilterSetGetTest` and `SWSrlCfgSetGetTest` by disabling auto increment in adi_adrv9001_arm_Memory_Read()

- Fixed 'adi_adrv9001_cals_Tracking_Set/Get' bug by starting ERPC service for 'cals' interface ('adrv9001_cals_svc')



#### INTERNAL ONLY

    - Import 'adrv9001ee01_internal_types.erpc' in adrv9001.erpc to access 'adi_adrv9001_Day1ExecPhase_e' in client



## [0.6.0] - 2019-08-19

### Added

- `adi_fpga9001_McsEdge_e` to select MCS pulse device clock edge alignment

- Functions to convert `adi_common_Port_e` and `adi_common_ChannelNumber_e` to/from numeric indexes:

    - `adi_common_port_to_index` and `adi_common_index_to_port`

    - `adi_common_channel_to_index` and `adi_common_index_to_channel`

    - NOTE: Not currently available in client due to limitations in eRPC

- Function to convert from a set of `adi_common_Port_e`/`adi_common_ChannelNumber_e` combinations to a FW compatible bitmask: `adi_adrv9001_Radio_MailboxChannelMask_Get`

- Functions to PRIME or ENABLE RF for multiple channels in a single call:

    - `adi_adrv9001_Radio_Channels_Prime`

    - `adi_adrv9001_Radio_Channels_EnableRf`

- Functions to power down/up channels:

    - `adi_adrv9001_Radio_Channel_PowerDown` and `adi_adrv9001_Radio_Channels_PowerDown`

    - `adi_adrv9001_Radio_Channel_PowerUp` and `adi_adrv9001_Radio_Channels_PowerUp`



#### INTERNAL ONLY

- Function to read initial/tracking calibration status

    - `adi_adrv9001_internal_utilities_Cal_Status_Get`

- Function to program the device using a profile file to configure the ARM

	- `adrv9001Ee01_internal_InitializeFromProfile`



### Changed

- Renamed `adi_fpga9001_DataChain_DmaRunStop_Set` -> `adi_fpga9001_DataChain_DmaRun_Set`

- Renamed `adi_adrv9001_InitCalibrations_e` values:

    - `ADI_ADRV9001_TX_QEC` -> `ADI_ADRV9001_INIT_CAL_TX_QEC`

    - `ADI_ADRV9001_TX_LOL` -> `ADI_ADRV9001_INIT_CAL_TX_LO_LEAKAGE`

    - `ADI_ADRV9001_TX_LBPD` -> `ADI_ADRV9001_INIT_CAL_TX_LB_PD`

    - `ADI_ADRV9001_TX_DCC` -> `ADI_ADRV9001_INIT_CAL_TX_DCC`

    - `ADI_ADRV9001_TX_BBAF` -> `ADI_ADRV9001_INIT_CAL_TX_BBAF`

    - `ADI_ADRV9001_TX_BBAF_GD` -> `ADI_ADRV9001_INIT_CAL_TX_BBAF_GD`

    - `ADI_ADRV9001_TX_ATTD` -> `ADI_ADRV9001_INIT_CAL_TX_ATTEN_DELAY`

    - `ADI_ADRV9001_TX_DAC` -> `ADI_ADRV9001_INIT_CAL_TX_DAC`

    - `ADI_ADRV9001_TX_PD` -> `ADI_ADRV9001_INIT_CAL_TX_PATH_DELAY`

    - `ADI_ADRV9001_RX_HPADC_RC` -> `ADI_ADRV9001_INIT_CAL_RX_HPADC_RC`

    - `ADI_ADRV9001_RX_HPADC_FLASH` -> `ADI_ADRV9001_INIT_CAL_RX_HPADC_FLASH`

    - `ADI_ADRV9001_RX_HPADC_DAC` -> `ADI_ADRV9001_INIT_CAL_RX_HPADC_DAC`

    - `ADI_ADRV9001_RX_DCC` -> `ADI_ADRV9001_INIT_CAL_RX_DCC`

    - `ADI_ADRV9001_RX_LPADC` -> `ADI_ADRV9001_INIT_CAL_RX_LPADC`

    - `ADI_ADRV9001_RX_TIA_CUTOFF` -> `ADI_ADRV9001_INIT_CAL_RX_TIA_CUTOFF`

    - `ADI_ADRV9001_RX_TIA_FINE` -> `ADI_ADRV9001_INIT_CAL_RX_GROUP_DELAY`

    - `ADI_ADRV9001_RX_TCAL` -> `ADI_ADRV9001_INIT_CAL_RX_QEC_TCAL`

    - `ADI_ADRV9001_RX_FIIC` -> `ADI_ADRV9001_INIT_CAL_RX_QEC_FIC`

    - `ADI_ADRV9001_RX_ILB_LOD` -> `ADI_ADRV9001_INIT_CAL_RX_QEC_ILB_LO_DELAY`

    - `ADI_ADRV9001_RX_RFDC_OFFSET` -> `ADI_ADRV9001_INIT_CAL_RX_RF_DC_OFFSET`

    - `ADI_ADRV9001_RX_GPD` -> `ADI_ADRV9001_INIT_CAL_RX_GAIN_PATH_DELAY`

    - `ADI_ADRV9001_PLL` -> `ADI_ADRV9001_INIT_CAL_PLL`

    - `ADI_ADRV9001_AUXPLL` -> `ADI_ADRV9001_INIT_CAL_AUX_PLL`

    - `ADI_ADRV9001_TX_ALL` -> `ADI_ADRV9001_INIT_CAL_TX_ALL`

    - `ADI_ADRV9001_RX_ALL` -> `ADI_ADRV9001_INIT_CAL_RX_ALL`

    - `ADI_ADRV9001_RX_TX_ALL` -> `ADI_ADRV9001_INIT_CAL_RX_TX_ALL`

    - `ADI_ADRV9001_SYSTEM_ALL` -> `ADI_ADRV9001_INIT_CAL_SYSTEM_ALL`

- `adi_fpga9001_Mcs_Start` now takes pulse width and edge selection parameters

- `adi_adrv9001_Radio_Channel_Prime` and `adi_adrv9001_Radio_Channel_EnableRf` now take a boolean parameter instead of having a separate function for the inverse state transition

- `adi_adrv9001_RadioState_t.channelStates` is now a 2x2 instead of 2x3 matrix; the port-index and channel-index conversion functions should now be used for accessing the individual channel states

- Channel bitmasks are now interpreted consistently with both the profile generator and the firmware (ELB2|ELB1|ILB2|ILB1|ORX1|ORX2|TX2|TX1|RX2|RX1). This requires Adi.Adrv9001.Profiles version 0.5.1.3+

- Review and implement customer enablement team recommendations

- Renamed `adi_adrv9001_InitCalMode_e` values:

    - `ADI_ADRV9001_INITCAL_RUN_ALL_ALGO_MODE` -> `ADI_ADRV9001_INIT_CAL_MODE_ALL`

    - `ADI_ADRV9001_INITCAL_RUN_RX_ALGO_MODE` -> `ADI_ADRV9001_INIT_CAL_MODE_RX`

    - `ADI_ADRV9001_INITCAL_RUN_LB_ALGO_MODE` -> `ADI_ADRV9001_INIT_CAL_MODE_TX`

- Change "TDD_CLK_MAX = 245760;" to "TDD_CLK_MAX = 200000;" in adi_fpga9001_mmcm.c so that it does not exceed the FPGA timing constraint limit of 200 MHz

- Modify `adi_adrv9001_Rx_Rssi_Read` to avoid floating point usage



#### INTERNAL ONLY

- Modify `adrv9001Ee01_internal_Initialize` to program the device using an init struct to configure the ARM



### Removed

- Removed radio functions in favor of combined versions - `adi_adrv9001_Radio_Channel_UnPrime` and `adi_adrv9001_Radio_Channel_DisableRf`

- Removed `adi_adrv9001_RxChannels_e` because it duplicated the same concept as other enums

- Removed previously deprecated function `adi_adrv9001_MailboxChannelMask`

- Remove floating point usage in DDAPI

- Use special divide primitives for compatibility across various 32/64 bit platforms

- Protect against `libc` includes

- Use strict function prototypes to avoid compiler warnings



### Fixed

- Fixed bug that resulted in corrupted FPGA data if RAM was modified between PerformTx calls

- Fixed `SWTxAttenSetGet` GTest





## [0.5.4] - 2019-08-01

### Added

- Added `adi_adrv9001_Rx_Agc_Feedback_Configure` API to route AGC signals to digital GPIO

- `adi_adrv9001_PlatformFiles_t.orxGainTableFile` for specifying ORx gain table

- `adi_adrv9001Ee01_InitCals_Run` so client can call without passing function pointer

#### INTERNAL ONLY

- Functions to provide the internal ADI user access to firmware debug functions:

    - `adi_adrv9001_internal_utilities_Firmware_Debug_Rx_Ssi_Enable`

	- `adi_adrv9001_internal_utilities_Firmware_Debug_Rx_Datapath_Configure`

	- `adi_adrv9001_internal_utilities_Firmware_Debug_Ilb_Calibration_Tone_Configure`

	- `adi_adrv9001_internal_utilities_Firmware_Debug_Generic_Configure`



### Changed

- Tailor the voltage and current ranges of each supply domain to more precisely monitor power

- Renamed `adi_adrv9001Ce01_PowerMonitor_e` enums to reflect power domains:

    - `ADI_ADRV9001CE01_POWERMONITOR_0` -> `ADI_ADRV9001CE01_POWERMONITOR_VDD_1P0`,

    - `ADI_ADRV9001CE01_POWERMONITOR_1` -> `ADI_ADRV9001CE01_POWERMONITOR_VDDA_1P0`,

    - `ADI_ADRV9001CE01_POWERMONITOR_2` -> `ADI_ADRV9001CE01_POWERMONITOR_VDD_1P8`,

    - `ADI_ADRV9001CE01_POWERMONITOR_3` -> `ADI_ADRV9001CE01_POWERMONITOR_VDDA_1P8`,

    - `ADI_ADRV9001CE01_POWERMONITOR_4` -> `ADI_ADRV9001CE01_POWERMONITOR_VDDA_1P3`

- Modified 'peakThreshGainControlMode' to 'agcControlMode' and the type from 'bool' to 'adi_adrv9001_rxGainControlType_e' in adi_adrv9001_AgcCfg_t

- Modified `adi_adrv9001_Utilities_InitRadio_Load` to always write ORx gain table

- Modified `adi_adrv9001_Rx_GainCtrlMode_Set` to set gc_use_counters_for_mgc bit to '1' in MGC mode to reset gain peak and power signal counters exceeded counters

- Renamed `adi_adrv9001_InitCalsRun` -> `adi_adrv9001_InitCals_Run`

- All forms of Initialize no longer call `adi_adrv9001_InitCals_Run`

- All instances of `adi_adrv9001_RadioConfig_t` have been replaced with `adi_adrv9001_RadioCtrlInit_t` to reduce nesting

- Modified 'decimated_data_overload_secondary_upper_threshold' ( SPI registers: 0x105A for RX1 and 0x145A for RX2)

- Renamed `adi_adrv9001_InitCalibrations_e` values:

    - `ADI_ADRV9001_TX_LOD` -> `ADI_ADRV9001_TX_DCC`

    - `ADI_ADRV9001_RX_HPADC_STABILITY` -> `ADI_ADRV9001_RX_DCC`



### Removed

- `adi_adrv9001_RadioConfig_t` because it only contained `adi_adrv9001_RadioCtrlInit_t` and `adi_adrv9001_InitCals_t`

- `adi_adrv9001_Day1ExecPhase_e`: `ADI_ADRV9001_DAY1_EXEC_PHASE_INIT_CALIBRATIONS` and `ADI_ADRV9001_DAY1_EXEC_PHASE_INIT_RX_GAIN_PARAMETERS`

- `adi_adrv9001_RadioCtrlInit_t.gainIndexes` as it is not required



### Fixed

- `zc706sd20_eeprom_FmcFru_Read` now handles EEPROM not being present

- Fixed the values of 'peak_detect' and 'peak_and_power_detect' modes in `adi_adrv9001_RxAgcDetectMode_e`





## [0.5.3] - 2019-07-22

### Changed

- Renamed various functions to follow naming conventions:

    - `adi_channel_to_index` -> `adi_common_channel_to_index`

    - `adi_adrv9001_ApiVersionGet` -> `adi_adrv9001_ApiVersion_Get`

    - `adi_adrv9001_DeviceRevGet` -> `adi_adrv9001_DeviceRev_Get`

    - `adi_adrv9001_ProductIdGet` -> `adi_adrv9001_ProductId_Get`

    - Moved `adi_adrv9001_Temperature_Get` to from adi_adrv9001_gpio interface adi_adrv9001 interface

    - `adi_adrv9001_GpIntHandler` -> `adi_adrv9001_gpio_GpIntHandler`

    - `adi_adrv9001_GpIntMask[Set/Get]` -> `adi_adrv9001_gpio_GpIntMask_[Set/Get]`

    - `adi_adrv9001_GpIntStatusGet` -> `adi_adrv9001_gpio_GpIntStatus_Get`

    - `adi_adrv9001_GpioOutEnGet` -> `adi_adrv9001_gpio_Outputs_Get`

    - `adi_adrv9001_GpioInputDirSet` -> `adi_adrv9001_gpio_Inputs_Set`

    - `adi_adrv9001_GpioOutputDirSet` -> `adi_adrv9001_gpio_Outputs_Set`

    - `adi_adrv9001_GpioAnalog[Input/Output]DirSet` -> `adi_adrv9001_gpio_Analog[Inputs/Outputs]_Set`

    - `adi_adrv9001_GpioOutSourceCtrl[Set/Get]` -> `adi_adrv9001_gpio_OutputSourceCtrl_[Set/Get]`

    - `adi_adrv9001_GpioOutPinLevel[Set/Get]` -> `adi_adrv9001_gpio_OutputPinLevel_[Set/Get]`

    - `adi_adrv9001_GpioInputPinLevelGet` -> `adi_adrv9001_gpio_InputPinLevel_Get`

    - `adi_adrv9001_GpioMonitorOutputSource[Set/Get]` -> `adi_adrv9001_gpio_MonitorOutputSource_[Set/Get]`

    - `adi_adrv9001_InitDigitalLoad` -> `adi_adrv9001_Utilities_InitDigital_Load`

    - `adi_adrv9001_InitRadioLoad` -> `adi_adrv9001_Utilities_InitRadio_Load`

    - `FpgaBinDirectorySet` -> `adi_fpga9001_FpgaBinDirectorySet`

    - `adi_fpga9001_AxiAdvSpiCfgSet` -> `adi_fpga9001_AxiAdvSpi_Configure`

    - `adi_fpga9001_AxiAdvSpiChipSelectAll` -> `adi_fpga9001_AxiAdvSpi_SelectAllChips`

    - `adi_fpga9001_GpioMode[Set/Get]` -> `adi_fpga9001_gpio_Mode_[Set/Get]`

    - `adi_fpga9001_GpioDir[Set/Get]` -> `adi_fpga9001_gpio_Direction_[Set/Get]`

    - `adi_fpga9001_Gpio[Write/Read]` -> `adi_fpga9001_gpio_[Write/Read]`

    - `adi_fpga9001_Register[Read/Write]` -> `adi_fpga9001_hal_Register_[Read/Write]`

    - `adi_fpga9001_RegisterField[Read/Write]` -> `adi_fpga9001_hal_Field_[Read/Write]`

    - `adi_fpga9001_Ram[Read/Write]` -> `adi_fpga9001_hal_Ram_[Read/Write]`

- Renamed `adi_fpga9001_CmosSsiLaneSel_e` -> `adi_fpga9001_SsiLaneSel_e`

#### INTERNAL ONLY

- Renamed the following functions to follow naming conventions:

    - `adi_adrv9001_Rx_BbDcTestDisable_[Set/Get]` -> `adi_adrv9001_internal_rx_BbDcTestDisable_[Set/Get]`

    - `adi_adrv9001_RamDriveCapture_Configure` -> `adi_adrv9001_internal_utilities_RamDriveCapture_Configure`

    - `adi_adrv9001_RamDriveCapture_Start` -> `adi_adrv9001_internal_utilities_RamDriveCapture_Start`

    - `adi_adrv9001_DeviceMem[Read/Write]` -> `adi_adrv9001_internal_utilities_DeviceMemory_[Read/Write]`

- Added adi_adrv9001_Day1ExecPhase_e.ADI_ADRV9001_DAY1_EXEC_PHASE_INIT_RX_GAIN_PARAMETERS

  to allow running init cals in two phases using `adrv9001Ee01_internal_Initialize`





## [0.5.2] - 2019-07-17

### Added

- Enabled loading of stream binary

- `adi_adrv9001_Stream_Version` to get stream binary version information

- ADRV9001CE board-specific functions to interact with onboard power monitoring chips:

    - `adi_adrv9001Ce01_PowerMonitor_Configure`

    - `adi_adrv9001Ce01_PowerMonitor_Read`

- Create separate ORX interface

- `adi_adrv9001_ORx_BbdcRejectionEnable_Set/Get` to allow user to disable BBDC on the ORX channel if needed

- `adi_adrv9001_Rx_FrequencyCorrection_Set` to set NCO frequency to correct for small deviations in Rx LO frequency

- `adi_adrv9001_ControlOutMux_Configure` to allow the user to configure a number of GPIO pins as observation ports for the Internal Navassa Control Out signals

#### INTERNAL ONLY

- `adi_fpga9001_internal_ObservationGpio_Configure/Get` to configure FPGA to assign GPIO pins as observation GPIO and read observation GPIO data from FPGA capture memory



### Changed

- Modify MMCM Calculation logic to ensure TDD clock is an integer multiple of Navassa Rx interface Sample rate

- MCS:

    - Hack for ARM requesting specific type of MCS removed

    - FPGA SSI reset after issuing MCS

    - Check for GPINT sticky flag

- Renamed `adi_fpga9001_SsiChannelReset` -> `adi_fpga9001_ssi_Reset`



### Removed

- Temporary i2c functions:

    - ```zc706sd20_i2c[Open/Close]```

    - ```zc706sd20_i2c[Write/Read]```



### Fixed

- Bug fix in error reporting in 'ADI_EXPECT' macro





## [0.5.1] - 2019-06-18

### Fixed

- Fixed a bug to check the maximum allowed size of stream binary image



## [0.5.0] - 2019-06-10

### Added

- `zc706sd20_eeprom_FmcFru_Read` function to read EEPROM based on the FMC FRU specification

- `adi_adrv9001_arm_SystemError_Get()` to read the system error from firmware

- Functions to support MCS requests from ARM:

    - `adi_adrv9001_Mcs_PrepareArm` to instruct ARM to prepare for MCS

    - `adi_adrv9001_Mcs_ActionRequested_Get` to determine the MCS type the ARM requested

    - `adi_adrv9001Ee01_Mcs_Execute` to perform different types of MCS

    - `adi_adrv9001Ee01_Mcs_IrqHandler` to MCS on IRQ from ADRV9001



### Changed

- Modified adi_adrv9001_StreamImageWrite() to support image loading of main and flex stream processors

- Renamed SPI functions:

    - `adi_adrv9001_SpiCfg[Set/Get]` -> `adi_adrv9001_spi_[Configure/Inspect]`

    - `adi_adrv9001_SpiDataPack` -> `adi_adrv9001_spi_Data_Pack`

    - `adi_adrv9001_SpiByte(s)[Write/Read]` -> `adi_adrv9001_spi_Byte(s)_[Write/Read]`

    - `adi_adrv9001_SpiField[Write/Read]` -> `adi_adrv9001_spi_Field_[Write/Read]`

    - `adi_adrv9001_SpiCache[Write/Read]` -> `adi_adrv9001_spi_Cache_[Write/Read]`

- C# Adrv9001Device.hal -> Adrv9001Device.spi

- Renamed `adi_adrv9001_StreamImageWrite` to `adi_adrv9001_Stream_Image_Write`

- Renamed utility functions:

    - `adi_adrv9001_DeviceProfileLoad` -> `adi_adrv9001_Utilities_DeviceProfile_Load`

    - `adi_adrv9001_ArmImageLoad` -> `adi_adrv9001_Utilities_ArmImage_Load`

    - `adi_adrv9001_StreamImageLoad` -> `adi_adrv9001_Utilities_StreamImage_Load`

    - `adi_adrv9001_ResourcesLoad` -> `adi_adrv9001_Utilities_Resources_Load`

    - `adi_adrv9001_RxGainTableLoad` -> `adi_adrv9001_Utilities_RxGainTable_Load`

    - `adi_adrv9001_TxAttenTableLoad` -> `adi_adrv9001_Utilities_TxAttenTable_Load`

    - `adi_adrv9001_ArmMemDump` -> `adi_adrv9001_Utilities_ArmMemory_Dump`

    - `adi_adrv9001_SsiDelayConfigSet` -> `adi_adrv9001_Utilities_SsiDelay_Configure`

    - `adi_adrv9001_SsiDelayConfigGet` -> `adi_adrv9001_Utilities_SsiDelay_Inspect`

- Rename FPGA data chain functions and refactor to port/channel idiom:

    - `adi_fpga9001_Tollgate[Set/Get]` -> `adi_fpga9001_DataChain_Tollgate_[Configure/Inspect]`

    - `adi_fpga9001_TollgateReset[Set/Get]` -> `adi_fpga9001_DataChain_TollgateReset_[Set/Get]`

    - `adi_fpga9001_TollgateTrigger[Set/Get]` -> `adi_fpga9001_DataChain_TollgateTrigger_[Set/Get]`

    - `adi_fpga9001_Dma[Set/Get]` -> `adi_fpga9001_DataChain_Dma_[Configure/Inspect]`

    - `adi_fpga9001_DmaResetSet` -> `adi_fpga9001_DataChain_DmaReset_Set`

    - `adi_fpga9001_DmaRunStopSet` -> `adi_fpga9001_DataChain_DmaRunStop_Set`

    - `adi_fpga9001_DmaLengthSet` -> `adi_fpga9001_DataChain_DmaLength_Set`

    - `adi_fpga9001_DataChainConfigure` -> `adi_fpga9001_DataChain_Configure`

    - `adi_fpga9001_DataChainReset` -> `adi_fpga9001_DataChain_Reset`

    - `adi_fpga9001_TxDataStop` -> `adi_fpga9001_DataChain_TxData_Stop`

    - `adi_fpga9001_RxCaptureWait` -> `adi_fpga9001_DataChain_RxCapture_Wait`

    - `adi_fpga9001_Perform[Rx/Tx]` -> `adi_fpga9001_DataChain_Perform[Rx/Tx]`

    - `adi_fpga9001_Data[Set/Get][Format]` -> `adi_fpga9001_DataChain_Data_[Set/Get]_[Format]`

- Rename FPGA SSI functions and refactor to port/channel idiom:

    - `adi_fpga9001_CmosSsiIDelayTapValue[Set/Get]` -> `adi_fpga9001_ssi_IDelayTapValue_[Set/Get]`

    - `adi_fpga9001_SsiMode[Set/Get]` -> `adi_fpga9001_ssi_Mode_[Set/Get]`

    - `adi_fpga9001_BytesPerSampleGet` -> `adi_fpga9001_ssi_BytesPerSample_Get`

- Moved/renamed ADRV9001 MCS functions from device.core to separate MCS interface:

    - `adi_adrv9001_McsAnalogExtSet` -> `adi_adrv9001_Mcs_Pll_Prepare` and added pllType argument

    - `adi_adrv9001_McsAnalogStatusGet` -> `adi_adrv9001_Mcs_AnalogStatus_Get` and added pllType argument

    - `adi_adrv9001_McsDigitalIntSet` -> `adi_adrv9001_Mcs_DigitalInt_Set`

    - `adi_adrv9001_McsDigitalStatusGet` -> `adi_adrv9001_Mcs_DigitalStatus_Get`

- Renamed board functions:

    - `adi_board_adrv9001Ee01_ProgramFromInit` -> `adi_adrv9001Ee01_Initialize`

    - `adi_board_adrv9001Ee01_ProgramFromProfile` -> `adi_adrv9001Ee01_InitializeFromProfile`

    - Combined `adi_board_adrv9001Ee01_[Create/Init]` -> `adi_adrv9001Ee01_Create`

    - Combined `adi_board_adrv9001Ee01_[Clear/Destroy]` -> `adi_adrv9001Ee01_Destroy`

- Renamed `adi_board_adrv9001Ee01_t` -> `adi_adrv9001Ee01_Board_t` to be consistent with the device type

#### INTERNAL ONLY

- Moved/renamed ADRV9001 MCS functions from device.core to separate MCS interface:

    - `adi_adrv9001_McsDigitalExtSet` -> `adi_adrv9001_Mcs_Internal_Select`

- Renamed board functions:

    - `adi_board_adrv9001Ee01_ProgramDay1` -> `adrv9001Ee01_internal_Initialize` and moved to Adrv9001BoardEe.internal_core



### Removed

- Unnecessary EEPROM functions:

    - zc706sd20_FmcEepromInfoGet

    - zc706sd20_FmcEepromDescriptionGet

    - zc706sd20_FmcEepromPartNumGet

    - zc706sd20_FmcEepromSerialNumGet

    - zc706sd20_FmcEepromNameGet

- `adi_fpga9001_DmaInit`

- `adi_fpga9001_DataChainSel_e` and `adi_fpga9001_RxTxSel_e`

- `adi_fpga9001_CmosSsiIDelayTapValueMultiSet`

- `adi_fpga9001_SsiSel_e`

- Various functions from client as they now require a function pointer:

    - `adrv9001Device.arm.CmdStatus_Wait`

    - `adrv9001Device.arm.System_Program`

    - `adrv9001Device.cals.InitCalsRun`

    - `adrv9001Device.cals.InitCalsWait`

    - `adrv9001Device.utilities.InitRadioLoad`

- `adi_adrv9001_McsIntfExtSet`

- Useless or unused functions:

    - `adi_adrv9001_FullMcsDigitalExt`

    - `adi_adrv9001_InitCalibrations`



### Fixed

- `adi_fpga9001_BytesPerSampleGet` now returns a value for LVDS instead of error





## [0.4.3] - 2019-05-21

### Added

- Functions for PA Ramp control and AUX DAC/ADC configuration

    - adi_adrv9001_Tx_PaRampCtrl_[Configure/Inspect]

	- adi_adrv9001_AuxDac_[Configure/Inspect]

	- adi_adrv9001_AuxDacValue_[Set/Get]

- Allow the user of the client to supply their own error handler; to use default, do "ErrorHandler.Singleton = new ErrorHandler();"



### Changed

- Modified adrv9001_RxInterfaceGainCtrl_t struct to include additional parameter "signalPAR_dB" to pass to ARM firmware

- Program functions no longer call `adi_adrv9001_Radio_Channel_Prime`. Therefore, users must prime the channel

  themselves after calling Program

- Created separate interface for AUX DAC instead of using GPIO interface

- Renamed `adi_adrv9001_RxPinSel_e` to `adi_adrv9001_RxRfInputSel_e`

- Renamed `adi_adrv9001_ClockSettings_t` members:

    - `rx1PinSel` to `rx1RfInputSel`

    - `rx2PinSel` to `rx2RfInputSel`

    - `rfPll1LoDivider` to `extLo1Divider`

    - `rfPll2LoDivider` to `extLo2Divider`

- Renamed `adi_adrv9001_RadioCtrlInit_t`: `adrv9001DeviceClockOutDivisor` to `adrv9001DeviceClockDivisor`; values changed accordingly



### Removed

- `adi_adrv9001_Day1ExecPhase_e.ADI_ADRV9001_DAY1_EXEC_PHASE_RADIO_READY`



### Fixed

- Fixed a bug in MMCM default settings for 'mcsClock_kHz'

- `adi_adrv9001_Radio_CarrierFrequency_Set` now enforces limits of 30MHz to 6GHz





## [0.4.2] - 2019-05-06

### Added

- Created a new ERPC interface for FPGA clock and corresponding ERPC files



- Added new APIs in ai_fpga9001_tdd.c

    - adi_fpga9001_Mmcm_Configure

	- adi_fpga9001_Mmcm_Inspect

	- adi_fpga9001_MmcmLock_Get



- Added new structure adi_fpga9001_MmcmCfg_t in adi_fpga9001_tdd_types.h



- Optional client-layer logging of all device driver calls:

	1. Initialize via "Logger.Singleton = new Logger();" to turn on logging.

	2. Access via "Logger.Singleton.Log" to get log at any time.



- Tools to read client-layer logs into files:

	1. HumanReadableLogReader to read log into a visual-friendly text file.

	2. CLogReader to read log into a proper C file.

- NUnit test examples of using I2C to read:

	1. Power Monitoring

	2. EEPROM Data



### Changed

- Flattened adi_fpga9001_TddChannel_t somewhat by getting rid of TddSchedule_t

- `adi_fpga9001_PerformTx()` and `adi_fpga9001_PerformRx()` now take a tollgate `trigger` argument

- Renamed `adi_fpga9001_TollgateTrigSources_e` -> `adi_fpga9001_TollgateTriggerSources_e`

    - `ADI_FPGA9001_IMM_TRIG` -> `ADI_FPGA9001_TRIGGER_IMMEDIATE`

    - `ADI_FPGA9001_EXT_TRIG` -> `ADI_FPGA9001_TRIGGER_EXTERNAL`

    - `ADI_FPGA9001_TDD_SM` -> `ADI_FPGA9001_TRIGGER_TDD_DP`

    - `ADI_FPGA9001_ARM_ACK` -> `ADI_FPGA9001_TRIGGER_TDD_PROG`

- Move InterfaceGain functions (Set/Get and Configure/Inspect) from agc interface to rx interface in client

- Methods in `adi_board_adrv9001Ee01` C# class no longer have "adrv9001Ee01_" prefix in method names

- Methods in `adi_adrv9001_Tx` C# class no longer have "Tx_" in method names

- Methods in `adi_adrv9001_arm.h` have all been renamed to use the `adi_adrv9001_arm` prefix

- Methods in `adi_adrv9001_tdd.h` have all been renamed to use the `adi_adrv9001_Tdd` prefix

- Move `adi_adrv9001_ArmSystemProgram` as the last API called in `adi_adrv9001_InitRadioLoad`

- All Agc files have been renamed to Rx_Agc files, and the associated methods and interfaces renamed as well

- All RadioCtrl files have been renamed to Radio files, and the associated methods and interfaces renamed as well

- Added code in zc706sd20_DevHalCfgCreate to configure the halCfg->i2cCfg struct

- Modified adi_adrv9001_InitAnalog() to support all input device clock frequencies to ADRV9001 device (previous only 38.4MHz was supported).

- Reversed order of `adi_adrv9001_ClkPllMode_e` values to match FW





### Removed

- `adi_fpga9001_TddConfig_t.observationGpios`

- `adi_fpga9001_TollgateTrigSources_e`: `ADI_FPGA9001_TX1_SOF` and `ADI_FPGA9001_TX2_SOF`

- `adi_adrv9001_TxAttenuationConfig_t.outputSignaling`

- `adi_adrv9001_clkGenPllSel_e` and `adi_adrv9001_ClockSettings_t.clkGenSel`



### Fixed

- Fixed bug in passing wrong parameter order of 'channel' and 'port' info to

    - adi_adrv9001_Channel_Prime() from adi_board_adrv9001Ee01_ProgramFromInit() and adi_board_adrv9001Ee01_ProgramDay1()

	- adi_adrv9001_CarrierFrequency_Set() from adrv9001_RadioCtrlInit()

- Fixed couple of bugs in radioCtrl related API Gtests

- Disabled ARM auto increment in adi_adrv9001_Rx_GainTable_Read() to fix the failing Gtests

- Fixed a bug to get error code from ARM firmware

- Fixed zc706sd20_i2cRead by having it use I2C_RDWR



## [0.4.1] - 2019-04-17

### Added

- Functions for state-machine-based TDD:

    - adi_fpga9001_Tdd_[Configure/Inspect]

    - adi_fpga9001_TddProgrammedEnable_[Set/Get]





## [0.4.0] - 2019-04-15

### Added

- Added new structures in adi_adrv9001_PfirBuffer_t and modified adrv9001_PfirProfilesWrite() API according to FW code changes for PFIR

	1. adi_adrv9001_PfirWbNbBuffer_t

	2. adi_adrv9001_PfirPulseBuffer_t

	3. adi_adrv9001_PfirMag21Buffer_t

	4. adi_adrv9001_PfirMag13Buffer_t



### Changed

- Modified the following structures in adi_adrv9001_Init_t and modified adrv9001_ArmProfileWrite() API according to FW code changes

	1. adi_adrv9001_ClockSettings_t

	2. adi_adrv9001_RxSettings_t

	3. adi_adrv9001_TxSettings_t

	4. adi_adrv9001_DeviceSysConfig_t

- Corrected parameter order of various Rx functions to follow the convention "port, channel, values...":

    - adi_adrv9001_Rx_GainCtrlMode_Set/Get

    - adi_adrv9001_Rx_Gain_Set/Get

    - adi_adrv9001_Rx_MgcGain_Get

- Corrected parameter order of various radioctrl functions to follow the convention "port, channel, values...":

    - adi_adrv9001_CarrierFrequency_Set/Get

    - adi_adrv9001_ChannelEnableMode_Set/Get

    - adi_adrv9001_Channel_Prime/Unprime

    - adi_adrv9001_Channel_EnableRf/DisableRf

    - adi_adrv9001_Channel_ToStandby

    - adi_adrv9001_Channel_ToCalibrated

    - adi_adrv9001_Channel_ToPrimed

    - adi_adrv9001_Channel_ToRfEnabled

    - adi_adrv9001_Channel_ToState

- Renamed and changed signature of various AGC functions:

    - adi_adrv9001_AgcCfgSet -> adi_adrv9001_Rx_Agc_Configure

    - adi_adrv9001_AgcCfgGet -> adi_adrv9001_Rx_Agc_Inspect

    - adi_adrv9001_AgcGainIndexRangeSet -> adi_adrv9001_Rx_AgcMinMaxGainIndex_Set

    - adi_adrv9001_AgcGainIndexRangeGet -> adi_adrv9001_Rx_AgcMinMaxGainIndex_Get

    - adi_adrv9001_AgcReset -> adi_adrv9001_Rx_Agc_Reset

- Renamed AgcCfg_t fields to remove the redundant "agc"

- Use `bool` where appropriate in AGC structs:

    - adi_adrv9001_AgcPeak_t.enableHbOverload

    - adi_adrv9001_AgcPower.powerEnableMeasurement

    - adi_adrv9001_AgcCfg_t.lowThreshPreventGainInc

    - adi_adrv9001_AgcCfg_t.peakThreshGainControlMode

    - adi_adrv9001_AgcCfg_t.resetOnRxOn

    - adi_adrv9001_AgcCfg_t.enableSyncPulseForGainCounter

    - adi_adrv9001_AgcCfg_t.enableFastRecoveryLoop

- Renamed some macros to remove unnecessary "API" to reduce character count

    - ADI_API_EXPECT -> ADI_EXPECT

    - ADI_API_MSG_EXPECT -> ADI_MSG_EXPECT

    - ADI_API_RANGE_CHECK -> ADI_RANGE_CHECK



### Removed

- Removed confusing and/or unused members from adi_adrv9001_RadioCtrlInit_t:

    - pllLoopFilterConfig

    - pllNameSel

    - pllCalMode

- AGC validate functions are no longer public

- adi_adrv9001_AgcCfgMultiSet

- adi_adrv9001_AgcGainIndexRangeMultiSet

- adi_adrv9001_Info_t.rxAgcPeakModeMask

- Redundant ADI_X boolean macros:

    - ADI_TRUE/ADI_FALSE

    - ADI_ENABLE/ADI_DISABLE

    - ADI_ON/ADI_OFF

    - ADI_SUCCESS/ADI_FAILURE

- GET_VARIABLE_NAME and ADI_COMMON_VARIABLE_USAGE macros





## [0.3.7] - 2019-04-10

### Fixed

- adi_fpga9001_SsiModeGet now returns the value set by adi_fpga9001_SsiModeSet correctly for FPGA version >0.3.0





## [0.3.6] - 2019-04-02

### Fixed

- Revert the DMA reset workaround to go with FPGA version 0.3.8





## [0.3.5] - 2019-03-29

### Fixed

- Reset the Rx DMA so consecutive captures have different data





## [0.3.4] - 2019-03-29

### Changed

- adi_adrv9001_PlatformFiles_t now contains 1 Rx gain table file member and 1 Tx atten table file member



### Removed

- adi_adrv9001_RxGainTableFile_t and adi_adrv9001_TxAttenTableFile_t





## [0.3.3] - 2019-03-26

### Fixed

- Fix bug in setting overRangeHighPowerThresh, overRangeLowPowerThresh, underRangeHighPowerThresh and underRangeLowPowerThresh to wrong SPI registers

  in AgcConfigSet() and AgcConfigGet() APIs

- Fixed JTAG issue by setting GPIO direction to output



### Changed

- SSI delay settings adjusted to work with FPGA 0.3.7

- Removed TddManualEnable calls from PerformRx



## [0.3.2] - 2019-03-22

### Changed

- ProgramFrom[Profile/Init]() no longer take ssiConfigSettings as an argument. The values are hard-coded as they are specific to our platform.



### Fixed

- Fix SSI reset bug in adi_board_adrv9001Ee01_ProgramDay1()

- Server -x feature working - no longer inadvertently resets the ADRV9001

- Fix adrv9001_RxInterfaceGain_e enum order



## [0.3.1] - 2019-03-14

### Added

- New APIs adi_adrv9001_DeviceMemRead() and adi_adrv9001_DeviceMemWrite() to read/write memory region outside of ARM Program and Data memory

- adi_adrv9001_RadioConfig_t.radioCtrlInit now has a txAttenConfig field



### Changed

#### INTERNAL ONLY

- Created 'internal' folder in \c_src\devices\adrv9001\ and moved the following ADI specific (i.e. APIs only used by ADI) APIs to adi_adrv9001_internal_utilities.c file

    - adi_adrv9001_RamDriveCapture_Configure

	- adi_adrv9001_RamDriveCapture_Start

	- adi_adrv9001_DeviceMemRead

	- adi_adrv9001_DeviceMemWrite



### Fixed

- Modified code for Low Power CLK PLL related fixes





## [0.3.0] - 2019-03-11

### Added

- adi_common_ChannelNumber_e and adi_common_Port_e enumerations to migrate to new channel/port idiom

- Temporary functions for evaluating i2c power-monitoring chips added under Zc706Sd20Platform.i2c:

    - ```zc706sd20_i2cOpen```

    - ```zc706sd20_i2cWrite```

    - ```zc706sd20_i2cRead```

- New server command line argument "-x" to open hardware without resetting it

- APIs to manually assert the FPGA TDD enable pins

    - adi_fpga9001_TddManualEnable_Set

	- adi_fpga9001_TddManualEnable_Get

- adi_adrv9001_Temperature_Get to get the temperature in Celsius

- Various radioctrl functions to clarify state machine operations

    - adi_adrv9001_Channel_EnableRF and adi_adrv9001_Channel_DisableRF

    - adi_adrv9001_Channel_ToStandby

    - adi_adrv9001_Channel_ToCalibrated

    - adi_adrv9001_Channel_ToPrimed

    - adi_adrv9001_Channel_ToRFEnabled

    - adi_adrv9001_Channel_ToState

- New APIs to set and get Rx Interface gain control configurations and Gtest

    - adi_adrv9001_Rx_InterfaceGain_Configure()

    - adi_adrv9001_Rx_InterfaceGain_Inspect()

    - adi_adrv9001_Rx_InterfaceGain_Set()

    - adi_adrv9001_Rx_InterfaceGain_Get()



### Changed

- Renamed and changed signature of various Rx functions:

    - adi_adrv9001_RxGainCtrlModeSet -> adi_adrv9001_Rx_GainCtrlMode_Set

    - adi_adrv9001_RxGainCtrlModesSet -> adi_adrv9001_Rx_GainCtrlMode_MultiSet

    - adi_adrv9001_RxGainCtrlModeGet -> adi_adrv9001_Rx_GainCtrlMode_Get

    - adi_adrv9001_RxGainTableWrite -> adi_adrv9001_Rx_GainTable_Write

        - There is no concept of an ORx gain table, so this no longer accepts ORx channels as arguments

    - adi_adrv9001_RxGainTableRead -> adi_adrv9001_Rx_GainTable_Read

        - There is no concept of an ORx gain table, so this no longer accepts ORx channels as arguments

    - adi_adrv9001_RxMinMaxGainIndexSet -> adi_adrv9001_Rx_MinMaxGainIndex_Set

    - adi_adrv9001_RxGainSet -> adi_adrv9001_Rx_Gain_Set

    - adi_adrv9001_RxGainGet -> adi_adrv9001_Rx_Gain_Get

    - adi_adrv9001_RxMgcGainGet -> adi_adrv9001_Rx_MgcGain_Get

    - adi_adrv9001_RxRssiRead -> adi_adrv9001_Rx_Rssi_Read

    - adi_adrv9001_RxDecPowerGet -> adi_adrv9001_Rx_DecimatedPower_Get

- Renamed and changed signature of various Tx functions:

    - adi_adrv9001_TxAttenCfgSet -> adi_adrv9001_Tx_Attenuation_Configure

    - adi_adrv9001_TxAttenCfgGet -> adi_adrv9001_Tx_Attenuation_Inspect

    - adi_adrv9001_TxAttenModeSet -> adi_adrv9001_Tx_AttenuationMode_Set

    - adi_adrv9001_TxAttenModeGet -> adi_adrv9001_Tx_AttenuationMode_Get

    - adi_adrv9001_TxAttenSet -> adi_adrv9001_Tx_Attenuation_Set

    - adi_adrv9001_TxAttenGet -> adi_adrv9001_Tx_Attenuation_Get

    - adi_adrv9001_DacFullScaleSet -> adi_adrv9001_Tx_DacFullScaleBoost_Set

    - adi_adrv9001_DacFullScaleGet -> adi_adrv9001_Tx_DacFullScaleBoost_Get

    - adi_adrv9001_TxAttenTableWrite -> adi_adrv9001_Tx_AttenuationTable_Write

    - adi_adrv9001_TxAttenTableRead -> adi_adrv9001_Tx_AttenuationTable_Read

    - adi_adrv9001_TxPaProtectionCfgSet -> adi_adrv9001_Tx_PaProtection_Configure

    - adi_adrv9001_TxPaProtectionCfgGet -> adi_adrv9001_Tx_PaProtection_Inspect

    - adi_adrv9001_TxTestToneSet -> adi_adrv9001_Tx_NcoFrequency_Set

    - adi_adrv9001_TxTestToneGet -> adi_adrv9001_Tx_NcoFrequency_Get

    - adi_adrv9001_SrlCfgSet -> adi_adrv9001_Tx_SlewRateLimiter_Configure

    - adi_adrv9001_SrlCfgGet -> adi_adrv9001_Tx_SlewRateLimiter_Inspect

- Renamed and changed signature of various radioctrl functions:

    - adi_adrv9001_CarrierFrequencySet -> adi_adrv9001_CarrierFrequency_Set

    - adi_adrv9001_CarrierFrequencyGet -> adi_adrv9001_CarrierFrequency_Get

    - adi_adrv9001_PllStatusGet -> adi_adrv9001_PllStatus_Get

    - adi_adrv9001_ChannelEnableModeSet -> adi_adrv9001_ChannelEnableMode_Set

    - adi_adrv9001_ChannelEnableModeGet -> adi_adrv9001_ChannelEnableMode_Get

    - adi_adrv9001_RadioStateGet -> adi_adrv9001_RadioState_Get

    - adi_adrv9001_RadioOn -> adi_adrv9001_Channel_Prime

    - adi_adrv9001_RadioOff -> adi_adrv9001_Channel_Unprime

    - adi_adrv9001_PllLoopFilterSet -> adi_adrv9001_PllLoopFilter_Set

    - adi_adrv9001_PllLoopFilterGet -> adi_adrv9001_PllLoopFilter_Get

    - adi_adrv9001_FrontEndGpioConfigSet -> adi_adrv9001_FrontEndGpioConfig_Set

    - adi_adrv9001_RadioState_t now contains an array of channelStates instead of 1 member for each channel

- Changed code to read current Rx gain value from address offset 0x102C instead of reading from 0x104C, which reads the value set by the user.

    - In AGC mode, the Rx gain value changes and is different from the value set initially

- Enabled ARM memory write auto increment feature (ADI_ADRV9001_ARM_MEM_AUTO_INCR is set to '1')

- Increased timeout duration from 1 second to 10 seconds for ARM system configuration mailbox command response.

    - When debug mode is enabled in FW, it takes a long time to respond back to ARM system configuration mailbox command.

- Removed unnecessary debug prints from the code to spead up "program" time.

- Renamed some utility functions

    - adi_adrv9001_RamDriveCaptureConfigSet -> adi_adrv9001_RamDriveCapture_Configure

    - adi_adrv9001_RamDriveCaptureStartSet  -> adi_adrv9001_RamDriveCapture_Start



### Removed

- Rx and radioctrl validate functions are no longer public

- adi_adrv9001_ChannelEnableModeMultiSet

- adi_adrv9001_Channel[s]Enable[Set/Get]

- adi_fpga9001_DataStart

- adi_adrv9001_TxPaProtectionCfgMultiSet

- adi_adrv9001_TxChannels_e

- adi_adrv9001_DacFullScale_e

- adi_adrv9001_TxDataIfUnlock_e

- adi_adrv9001_TxAttenControl_t

- adi_adrv9001_TxChannelCfg_t



### Fixed

- Server will not exit on SendFailed

- Modified SPI write buffer size to 256; A bigger value results in write failure when auto increment and caching are enabled

- Fixed a bug in ARM memory read/write if target byte is not at full word boundary. The data address increments only if a dummy write is performed at offset 0xFB.





## [0.2.9] - 2019-02-20

### Fixed

- Set external LO divisor in firmware correctly, without dividing by 2





## [0.2.8] - 2019-02-13

### Fixed

- Server calls FpgaSwitchBin on startup by default so version info is up to date

- Removed JTAG support from adi_board_adrv9001Ee01_ProgramFromInit() API





## [0.2.7] - 2019-02-05

### Changed

- Modified code to call fpga9001_AxiAdrv9001TestOutputBfSet() instead of fpga9001_AxiAdrv9001GpioEnArmJtagBfSet() from adi_fpga9001_GpioModeSet()

  to set 1'b2 at address 0x43041010 to enable JTAG mode from API





## [0.2.6] - 2019-01-31

### Changed

- Renamed ```Zc706Sd20Platform.DLLVersion``` to ```Zc706Sd20Platform.VersionOfDLL``` because LabVIEW can't handle case-sensitive function names

- ```adi_fpga9001_GpioRead``` no longer clears bits corresponding to GPIOs configured as outputs



### Removed

- Previously deprecated functions ```adi_fpga9001_rx``` and ```adi_fpga9001_tx``` have been removed



### Fixed

- Mailbox command now also sends ORX1/2 channel mask information

- ```adi_fpga9001_GpioPin_e``` now only has values for 12 pins, consistent with how many GPIO pins there are

- ```adi_fpga9001_TxDataStop``` now clears the runStop bit for both Tx DMAs

- Fixed a bug, in which wrong address was used to reset MCS, in adi_adrv9001_McsDigitalIntReset() API

- ```adi_adrv9001_McsDigitalIntSet``` now does read-modify-write to preserve previous values of unrelated bitfields





## [0.2.5] - 2019-01-25

### Changed

- Moved adi_adrv9001_SsiDelayConfigSet() and adi_adrv9001_SsiDelayConfigGet() APIs inside adi_adrv9001_InitRadioLoad() function and called after loading TX attenuation and Rx gain tables to issue MCS

- Changed the Reference clock divide ratio from 16 to 2



### Fixed

- Added a condition to call adi_fpga9001_LvdsChannelReset() only if ssiMode is LVDS

- ```adi_fpga9001_GpioWrite``` now accepts writing all pins to 0

- ```adi_fpga9001_GpioRead``` clears bits corresponding to GPIOs configured as outputs





## [0.2.4] - 2019-01-23

### Added

- A static function adi_fpga9001_LvdsChannelReset() in adi_board_adrv9001Ee01_ProgramFromInit() and adi_board_adrv9001Ee01_ProgramDay1() before

  adi_adrv9001_InitCalibrations() to reset FPGA LVDS channel



### Changed

- Modified code to configure SysConfig based on channelMask information passed as a function parameter instead of configuring all channels

- Disabled ARM memory read auto increment in adi_adrv9001_CarrierFrequencyGet() API as it the read values are duplicated at times



### Removed

- Removed "build" field from FPGA version, so it is now major.minor.patch



## [0.2.3] - 2019-01-16

### Added

- New API to set and get the LVDS delay configurations in ADRV9001 device

- Added  gtest_adrv9001_ssi.cpp file to test the LVDS delay configuration APIs



### Changed

- Removed support for older FPGA binaries

- Removed patch version check for FPGA binary. API checks only major and minor hereafter

- Set PLL loop filter for all PLLs irrespective of the PLL selected

- Partially replaced all enums, structs and APIs with name "CmosSsi" with a generic name "Ssi" to support CMOS and LVDS

- The default FPGA binary directory is now /home/analog/adrv9001_server/resources/Adi.Adrv9001.FpgaBinaries



### Fixed

- adi_fpga9001_SwitchBin now calls switch_bin.sh without the file extensions (correctly)



### Removed

- Removed adi_fpga9001_CmosSsiCfgSet() and adi_fpga9001_CmosSsiCfgGet() and related APIs, structs and enums as they are applicable for old FPGA binaries only



## [0.2.2] - 2019-01-10

### Fixed

- sysConfig.powerdownMode in profiles is now serialized correctly





## [0.2.1] - 2019-01-09

### Changed

- Removed external MCS related code after adi_adrv9001_InitCalsWait() in adi_adrv9001_InitCalibrations() API. In future, internal MCS code will be added when tracking Cal feature is available





## [0.2.0] - 2019-01-08

### Changed

- Support for FPGA version for both CMOS and LVDS

- FPGA Initialize and Mode Set Changes to support LVDS with existing functions

- Modifications to script file name access based on new SD card directory structure

- Repurpose ArmEnable() and ArmDisable() as higher level APIs to run before and after MCS; Change ArmStart and ArmStop APIs to private APIs

- adi_adrv9001_Day1ExecPhase_e moved to Adrv9001Ee01Board_types.h

- Renamed adi_adrv9001_PllFrequencySet() and adi_adrv9001_PllFrequencyGet() APIs to adi_adrv9001_CarrierFrequencySet() and adi_adrv9001_CarrierFrequencyGet() and modified the functionality

	-> Mailbox Object ID has been modified to refer to channel carrier frequency rather than specific PLL frequency

	-> The mailbox command name changed from ADRV9001_ARM_OBJECTID_RFPLL_LO_FREQUENCY to ADRV9001_ARM_OBJECTID_CHANNEL_CARRIER_FREQUENCY



### Added

- Added two enum to handle PLL mode and support adi_adrv9001_CarrierFrequencySet() when the channel is in primed state

- New APIs to support ADRV9001_ARM_OBJECTID_RAM_DRIVE_AND_CAPTURE_CONFIG and ADRV9001_ARM_OBJECTID_RAM_DRIVE_AND_CAPTURE_START mailbox SET commands



### Fixed

- Fix register values and add new SPIWRITE to fix CLK PLL lock instability



### Removed

- day1ProfileId argument removed from adi_board_adrv9001Ee01_ProgramDay1()





## [0.1.10] - 2018-12-18

### Added

- isExecutable flag to ```FileManager.CopyFileToRemote()```



### Fixed

- Error in Program saying "Failed to set SPI config" was fixed. Had to call HwClose() and HwOpen() after

  switching FPGA binaries to reset the SPI driver



## [0.1.9] - 2018-12-14

### Added

- semaphore counter to allow features to share GPIO resources.

- FileManager class to handle copying latest resource files to the platform

- ServerManager class to start/stop the server, detect if it is running, and get the version

- adi_adrv9001_RxDecPowerGet() API to read decimated power for the given channel

- Server command line option to skip ```HwOpen()``` call on start: "--no-hardware-open" or "-n"

- adi_fpga9001_Binary_e.ADI_FPGA9001_LVDS option to support switching to LVDS FPGA binary

- Temporary ```FpgaBinDirectorySet``` function to change the directory where FPGA binaries are stored



### Removed

- Remove apdLowGainModeHigh/LowThresh from adi_adrv9001_AgcCfg_t struct

- Removed adi_fpga9001_Binary_e.ADI_FPGA9001_BASE_PLUS_SPI option - no longer used



### Changed

- Write apdHighThresh to 7 registers: 0x2e70 - 0x2e76 for channel 1 and 0x3270 - 0x3276 for channel 2 and

        apdLowThresh to 7 registers: 0x2e69 – 0x2e6F for channel  1 and 0x3269 - 0x326F for channel 2

- adi_board_adrv9001Ee01_ProgramFromInit calls adi_adrv9001_RadioOn to put initialized channels in the PRIMED state

- All Program functions now set the Rx gain control mode and gain index

- Remove call to adi_adrv9001_FullMcsDigitalExt from adi_adrv9001_InitCalibrations for now

- Renamed ```adi_fpga9001_Binary_e.ADI_FPGA9001_DUAL_CMOS``` to ```adi_fpga9001_Binary_e.ADI_FPGA9001_CMOS```

- ```adi_fpga9001_SwitchBin()``` is called in Program instead of on server start

- A single "switch_bin.sh" script replaces multiple "switch_bin_to_..." scripts



### Fixed

- Channel Mask passed to FW through mailbox is in this bit format --> b0-Rx1, b1-Rx2, b2-Tx1, b3-Tx2.

  The channelMask is adjusted for this expected format

- Changing data capture length resulted in a skipped sample or spur. This was fixed by clearing the DMA control

  register before resetting the DMA

- AdiEvaluationSystem now implements IDisposable so the socket can be released properly. AdiEvaluationSystemBuilder

  now effectively returns a singleton instance so the user doesn't accidentally create multiple instances without

  calling Dispose()





## [0.1.8] - 2018-11-29

### Changed

- Modified adi_adrv9001_InitCals_t struct and the implementation of adi_adrv9001_InitCalsRun() API according to the FW specification



### Fixed

- PerformTx now sets DMA up in continuous mode

- ProgramDay1 now sets up FPGA SSI based on profile





## [0.1.7] - 2018-11-28

### Added

- Simplified data transmit. Split into several functions to write RAM in the correct

  format and 1 function to transmit.

    - adi_fpga9001_PerformTx: Configure the data chain and begin continuous transmit

    - adi_fpga9001_DataSet_16I16Q: Write RAM from 2 16-bit arrays of I and Q data

    - adi_fpga9001_DataSet_16IQInterleaved: Write RAM from a single 16-bit array of interleaved IQ data

    - adi_fpga9001_DataSet_16I: Write RAM from a 16-bit array of I only data

    - adi_fpga9001_DataSet_8S: Write RAM from an array of 8-bit symbols

    - adi_fpga9001_DataSet_2S: Write RAM from an array of 2-bit symbols

- Functions to read EEPROM added to client in Zc706Sd20Platform.eeprom

    - FmcEepromInfoGet

    - FmcEepromDescriptionGet

    - FmcEepromPartNumGet

    - FmcEepromSerialNumGet

    - FmcEepromNameGet

### Added

- adi_board_adrv9001Ee01_ProgramProfile (replaces adi_board_adrv9001Ee01_Program)



### Fixed

- adi_adrv9001_DeviceProfileLoad returns timely and relevant error messages when profile file does not exist



### Changed

- Set "ADRV9001_INIT_DMA_MEM_READ_CHECK" to '0' to disable memory read back verification when memory write happens

- Disable debug print messages by commenting "ADRV9001_INIT_DEBUG, ADRV9001_INIT_DMAINFO_DEBUG, ADRV9001_INIT_SPI_DEBUG"

- adi_board_adrv9001Ee01_Program takes pointer to init struct as argument





## [0.1.6] - 2018-11-26

### Added

- Simplified data capture. Split into 1 function to fill RAM and several functions to read

  RAM in a certain format.

    - adi_fpga9001_CmosSsiModeGet: returns the current FPGA SSI mode

    - adi_fpga9001_BytesPerSampleGet: returns the number of bytes per sample for the current SSI mode

    - adi_fpga9001_PerformRx: Configure the data chain and block until a capture is complete

    - adi_fpga9001_DataGet_16I16Q: Read RAM into 2 16-bit arrays of I and Q data

    - adi_fpga9001_DataGet_16IQInterleaved: Read RAM into a single 16-bit array of interleaved IQ data

    - adi_fpga9001_DataGet_16I: Read RAM into a 16-bit array of I only data

    - adi_fpga9001_DataGet_8S: Read RAM into an array of 8-bit symbols

    - adi_fpga9001_DataGet_2S: Read RAM into an array of 2-bit symbols

- adi_fpga9001_VersionGet(): return the version of the current FPGA image



### Changed

- adi_board_adrv9001Ee01_Program now calls adi_fpga9001_Initialize() to configure

  the CMOS SSI based on the profile SSI configuration. It is no longer necessary

  to call CmosSsiModeSet() or CmosSsiCfgSet()

- Modify TxAttenSet() API to handle Direct Modulation mode

- Modify adi_adrv9001_ArmVersionGet() API to support 4 digit version



### Deprecated

- adi_fpga9001_CmosSsiCfgSet

- adi_fpga9001_CmosSsiCfgMultiSet

- adi_fpga9001_CmosSsiCfgGet

- adi_fpga9001_rx



### Fixed

- Correct ARM version memory location

- Fix bug in DmaMemRead() API

- HwReset() added to Program() sequence





## [0.1.5] - 2018-11-20

### Fixed

- Fix LO mapping in Device Profile based on changes made by Jim Bush



### Changed

- Switch binaries on server start



## [0.1.4] - 2018-11-15

### Added

- AgcCfgSet/Get, AgcCfgMultiSet, AgcCfgValidate, AgcGainIndexRangeSet/Get and AgcReset

- CmosSsiModeSet





## [0.1.3] - 2018-11-15

### Added

- InitCalsRun and InitCalsWait are now in the client/server

- Added RadioOn() API as part of Day1 code flow and added execution phase flag for it

- ProgramDay1 gets a profile filename parameter

- Added ADI_ADRV9001_DAY1_PROFILE_USE_FILENAME enum to adi_adrv9001_Day1ProfileId_e

- Temporary rx and tx functions in fpga9001.data_chain based on Perl scripts

- Include TxAttenCfgSet, TxAttenSet APIs in Day1 code flow

- Added and initialized with valid values for TxAtten related parameters in adi_adrv9001_day1.c; This is temporary solution and will be removed once JSON parser is included



### Changed

- Commented mailbox response for mailbox commands

- Commented the 'for' loop which sends channel mask one by one. Instead, sending all channelMask once for RadioOn mailbox command

- Cleaned up the code according to API coding guideline

- Updated gtest to load Tx/Rx gain and attenuation tables for all channels

- Updated Program based on ProgramDay1

- Increase the timout and interval to check ARM bootup status

- Disabled "adi_adrv9001_ArmCheckSumTableGet" as checksum calculation is disabled in FW codefor now



### Removed

- Removed ARM_STATUS_CHECK execution flag from Day1 flow as it is unused



### Fixed

- Fix LO frequency changes in Device profile made by Jim Bush in 'develop' branch for all 5 Device profiles

- In profile ID 4, switched input/output signaling from FM_IQ to FM_DM

- C# client no longer requires manually initializing arrays of objects of fixed size

- Fixed the TxAttenSet BF API call; Should be written in TxAtten 'A' register, but API was wrongly writing to 'B' register (which is used for FH)





## [0.1.2] - 2018-11-6

### Changed

- DLLs are no longer versioned using the AssemblyVersion attribute because LabView

  complained about DLL name changes. Instead, there is a new DllVersion() method

  in the platform class.

- All auto-generated code is once again in the "erpc" namespace

- Set ADI_ADRV9001_MAILBOX_RESPONSE to true

- Set channel mask to 0xFF to enable all channels for ARM system configuration mailbox command



### Added

- SPI write to set bit0 at SW_INTERRUPT_4 register (Address: 0x1A1) to issue "wakeup ARM" interrupt to ARM FW

- Included InitCalibrations() API in Day1 code flow and a flag "ADI_ADRV9001_DAY1_EXEC_PHASE_INIT_CALIBRATIONS"

  enable/disable InitCalibrations()



## [0.1.1] - 2018-11-5

### Added

- Five Day1 profiles to resources directory



### Changed

- The Adi.Tpg.EvalClient.Adrv9001.Board DLL no longer contains an erpc namespace.

  Instead it references the Adrv9001.Device DLL to avoid having the same types

  defined in multiple DLLs/namespaces.



### Fixed

- Changed DEVICE_NOT_CONNECTED to false

- Updated InitRadio to help with table loading





## 0.1.0 - 2018-10-29

### Added

- This change log file to document all future changes

- A non-zero version number in both the C API and the C# client DLLs



### Changed

- The C# client will throw an exception if the API version does not match the DLL version

- C# namespaces for auto-generated code will be of the form "erpc_{program}" where

  program indicates the specific device/board/platform the code is associated with.

  This is to avoid having the same types defined in the same namespace in different DLLs.





[Unreleased]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv8.0.0&sourceBranch=refs%2Fheads%2Fdevelop&targetRepoId=93

[0.1.1]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.0&sourceBranch=refs%2Ftags%2Fv0.1.1

[0.1.2]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.1&sourceBranch=refs%2Ftags%2Fv0.1.2

[0.1.3]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.2&sourceBranch=refs%2Ftags%2Fv0.1.3

[0.1.4]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.3&sourceBranch=refs%2Ftags%2Fv0.1.4

[0.1.5]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.4&sourceBranch=refs%2Ftags%2Fv0.1.5

[0.1.6]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.5&sourceBranch=refs%2Ftags%2Fv0.1.6

[0.1.7]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.6&sourceBranch=refs%2Ftags%2Fv0.1.7

[0.1.8]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.7&sourceBranch=refs%2Ftags%2Fv0.1.8

[0.1.9]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.8&sourceBranch=refs%2Ftags%2Fv0.1.9

[0.1.10]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.9&sourceBranch=refs%2Ftags%2Fv0.1.10

[0.2.0]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.1.10&sourceBranch=refs%2Ftags%2Fv0.2.0

[0.2.1]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.2.0&sourceBranch=refs%2Ftags%2Fv0.2.1

[0.2.2]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.2.1&sourceBranch=refs%2Ftags%2Fv0.2.2

[0.2.3]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.2.2&sourceBranch=refs%2Ftags%2Fv0.2.3

[0.2.4]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.2.3&sourceBranch=refs%2Ftags%2Fv0.2.4

[0.2.5]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.2.4&sourceBranch=refs%2Ftags%2Fv0.2.5

[0.2.6]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.2.5&sourceBranch=refs%2Ftags%2Fv0.2.6

[0.2.7]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.2.6&sourceBranch=refs%2Ftags%2Fv0.2.7

[0.2.8]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.2.7&sourceBranch=refs%2Ftags%2Fv0.2.8

[0.2.9]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.2.8&sourceBranch=refs%2Ftags%2Fv0.2.9

[0.3.0]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.2.9&sourceBranch=refs%2Ftags%2Fv0.3.0

[0.3.1]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.3.0&sourceBranch=refs%2Ftags%2Fv0.3.1

[0.3.2]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.3.1&sourceBranch=refs%2Ftags%2Fv0.3.2

[0.3.3]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.3.2&sourceBranch=refs%2Ftags%2Fv0.3.3

[0.3.4]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.3.3&sourceBranch=refs%2Ftags%2Fv0.3.4

[0.3.5]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.3.4&sourceBranch=refs%2Ftags%2Fv0.3.5

[0.3.6]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.3.5&sourceBranch=refs%2Ftags%2Fv0.3.6

[0.3.7]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.3.6&sourceBranch=refs%2Ftags%2Fv0.3.7

[0.4.0]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.3.7&sourceBranch=refs%2Ftags%2Fv0.4.0

[0.4.1]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.4.0&sourceBranch=refs%2Ftags%2Fv0.4.1

[0.4.2]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.4.1&sourceBranch=refs%2Ftags%2Fv0.4.2

[0.4.3]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.4.2&sourceBranch=refs%2Ftags%2Fv0.4.3

[0.5.0]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.4.3&sourceBranch=refs%2Ftags%2Fv0.5.0

[0.5.1]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.5.0&sourceBranch=refs%2Ftags%2Fv0.5.1

[0.5.2]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.5.1&sourceBranch=refs%2Ftags%2Fv0.5.2

[0.5.3]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.5.2&sourceBranch=refs%2Ftags%2Fv0.5.3

[0.5.4]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.5.3&sourceBranch=refs%2Ftags%2Fv0.5.4

[0.6.0]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.5.4&sourceBranch=refs%2Ftags%2Fv0.6.0

[7.0.0]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv0.6.0&sourceBranch=refs%2Ftags%2Fv7.0.0

[8.0.0]: https://bitbucket.analog.com/projects/NSS/repos/api-dll/compare/commits?targetBranch=refs%2Ftags%2Fv7.0.0&sourceBranch=refs%2Ftags%2Fv8.0.0
