# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

Each version will have its own section containing a possible subset of the following subsections:
- Added: for new features.
- Changed: for changes in existing functionality.
- Deprecated: for soon-to-be removed features.
- Removed: for now removed features.
- Fixed: for any bug fixes.
- Security: in case of vulnerabilities.
- Errata: for known issues.

## 0.29.0
### Added
- TES: Separate LNA and gain table controls for each Rx channel
- TES: Generated Code: Option to exclude FPGA references for improved portability
- TES: Generated Code: Enhanced structure organization with specific naming and separate file placement
- TES: Frequency Hopping: PLL loop filter coefficient processing modes
    - Calculation mode (default): Highest accuracy
    - LUT mode: Reduced processing time
- SSI Mix Mode: Support for mixed LVDS and CMOS configurations per channel

### Changed
- TES: IronPython: GUI pop-up linking to Python wrappers documentation
- Temperature Read: Single SPI transaction in direct register mode for improved efficiency
- Frequency Hopping: Reduced Rx transition time for Dual Hop LO Retune scenarios

### Deprecated

### Removed
- IronPython: Full removal in favor of Python wrappers

### Fixed
- TES: Peak Power: Extended range from -23dBm to 7dBm
- GPIO 12-15: Enabled Input/Output/Signal configuration
- Frequency Hopping: Reset to start of selected hop table
- Frequency Hopping: 22-bit gain index value, SSI readback after manual hop to Tx frame and back to Rx frame
- Calibration: Failures at certain sample rates
- MCS: PLL fails to lock for one of the frequencies in the FH table

### Security

### Errata
- RF PLL phase synchronization in MCS + FH mode is supported only with zero frequency offset.
  Intermittent phase‑sync glitches may occur with offset frequencies.

### TES components
    - FPGA image 8.3.31
    - Device Driver API 68.20.12
    - Device Driver Client 68.20.12
    - Firmware 0.22.64
    - Profile Generator 53.13.0
    - Stream Generator 0.7.18
    - Transceiver Evaluation Software 0.29.0
    - ADRV9001 Plugin 0.29.0

## 0.28.0
### Added
- TES: Rx 12-bit I/Q data option
- TES: Option to save all GUI configuration files
- Active RxPortSwitching: Allow switching between Rx ports during operation without changing the carrier

### Changed
- TES: SSI Power Down: Enable High power down mode
- TES: FDD: Allow FDD 1T2R configuration
- TES: CMOS-SDR,LVDS-DDR: Allow maximum SSI rate in Rx 22-bit I/Q data option
- SSI Power Down: SSI Data Port power down to take effect on channel's first CALIBRATED to PRIMED transition
- SSI Power Down: Enable automatic SSI Data Port power down in all System Power Saving modes
- Manual RxPortSwitching: Allow port frequency range overlapping

### Deprecated

### Removed

### Fixed
- TES: AGC Freeze: Rx2 AGC Freeze Pin HIGH option
- RxGainControl: Resolved issue with restoring configurations after recalibration
- PFIR: Resolved issue with restoring PFIR configuration after recalibration
- AuxDAC/AuxADC: All configurations restored correctly after wakeup from ARM Power Down

### Security

### Errata
- SSI Power Down: Intermittent bit misalignment on RX SSI after waking from sleep. Only present on ZC706 FPGA.

### TES components
    - FPGA image 8.3.23
    - Device Driver API 68.16.2
    - Device Driver Client 68.16.2
    - Firmware 0.22.49
    - Profile Generator 53.11.0
    - Stream Generator 0.7.15
    - Transceiver Evaluation Software 0.28.0
    - ADRV9001 Plugin 0.28.0

## 0.27.1
### Added

### Changed
- TES: IronPython Editor: No longer supported in TES. Choose the optional Python SDK in the installer wizard.Simple Python scripts using Python wrappers are available in TES InstallationDirectory/Examples/Python

### Deprecated

### Removed

### Fixed
- MCSRx1Rx21SampleOffset: Resolved MCS 1 sample offset issue between Rx1 and Rx2

### Security

### Eratta

### TES components
    - FPGA image 8.3.14
    - Device Driver API 68.14.13
    - Device Driver Client 68.14.13
    - Firmware 0.22.39
    - Profile Generator 53.11.0
    - Stream Generator 0.7.15
    - Transceiver Evaluation Software 0.27.1
    - ADRV9001 Plugin 0.27.1

## 0.27.0
### Added
- TES: ExpandSDCardPartition: Added control in TES to have TES expand the SDCard Partition size

### Changed
- TEMPERATURE_READ: Provision for direct register temperature read

### Deprecated

### Removed

### Fixed
- TES: FrequencyHopping: Correct LO assignment in frequency hopping LO retune mode with non-zero Rx offset frequency
- RxTxTrackingCalRaceConditionArmLock: Pause opposite channel marked 'not runnable' cal before ARM lock
- MCSPhaseSyncError: Resolved issue with phase sync error in short frame durations
- FrequencyHopping: Reduction in RealTimeProcessing transition time
- TES: ExternalLnaTaxidiSettings: all settings now saved to/loaded from taxidi file

### Security

### Eratta

### TES components
    - FPGA image 8.3.7
    - Device Driver API 68.14.10
    - Device Driver Client 68.14.10
    - Firmware 0.22.39
    - Profile Generator 53.11.0
    - Stream Generator 0.7.15
    - Transceiver Evaluation Software 0.27.0
    - ADRV9001 Plugin 0.27.0

## 0.26.1
### Added
POWERSAVING_IN_FREQUENCYHOPPING: TES and FW allow user to enable and disable Power Saving even when Frequency Hopping is enabled
AGC_SWFREEZE: Added SW_FREEZE option to Rx Automatic Gain Control. SW_FREEZE capable of overcoming HW_FREEZE limitations
ORX_PORT_IMPEDANCE_CONTROL: Force fast impedance change of observation port on power up/down

### Changed

### Deprecated

### Removed

### Fixed
STREAM_UPDATE: Update stream to optimize TxEnableFall. Resolves Tracking and RxAGC issues in short frame transitions
STDARG_HAL_CUSTOMER: Roll back addition of stadarg header to adi_common_hal_customer.h 
STDARG_COMMON_HAL: Add stadarg header to adi_common_hal.h 
TES: Rssi_Read error dialog in TDD

### Security

### Eratta

### TES components
    - FPGA image remains at 8.3.7
    - Device Driver API from 68.13.7 to 68.13.11
    - Device Driver Client from 68.13.7 to 68.13.11
    - Firmware from 0.22.30 to 0.22.33
    - Profile Generator from 53.6.0 to 53.7.0
    - Stream Generator remains from 0.7.11 to 0.7.12
    - Transceiver Evaluation Software from 0.26.0 to 0.26.1
    - ADRV9001 Plugin from 0.26.0 to 0.26.1
    
## 0.26.0
### Added
- FPGA: files required for rebuilding FPGA bootloader placed in SDK pkg/prototype/platform/boot directory.
- VARIANTS: Add support for ADRV9005 and ADRV9006

### Changed
- STREAM: Updated enable sequence for Rx LVDS SSI Config
- RSSI_READ: Validation to ensure state is RF_ENABLED
- RFPLL: Use Equation for Normal Calibration Mode
- FREQUENCYHOPPING: Allow user configure RF PLL Calibration Mode to Normal

### Deprecated

### Removed

### Fixed
- Profile: Support 2nd Order filter in 9.6MSPS CMOS Profile, ADC Rate High 
- DPD_FH_NB: Resolved issue with DPD operation in Frequency Hopping for Narrowband profiles
- MANUAL_RSSI: resolved bug preventing unused Rx2 channel
- TES: fixed C99 code generation using FH with GPIO Table Index Control

### Security

### Eratta

### TES components
    - FPGA image from 8.2.27 to 8.3.7
    - Device Driver API from 68.10.1 to 68.13.7
    - Device Driver Client from 68.10.1 to 68.13.7
    - Firmware from 0.22.27.0 to 0.22.22.30
    - Profile Generator from 53.2.0 to 53.6.0
    - Stream Generator remains from 0.7.10 to 0.7.11
    - Transceiver Evaluation Software from 0.25.0 to 0.26.0
    - ADRV9001 Plugin from 0.25.0 to 0.26.0

## 0.25.0
### Added
- GainIndexOnGPIO: Allow user select 2/4/6 or 8 pins for Rx_GainIndex_Gpio_Configure (previous option was 8)
- CLGC: enableRepeatedEstimationInTDD allows periodic update in FH instead of just at start of frame
- Warmboot: added new chunk functions


### Changed
- Stream: Updated enable sequence for LVDS SSI Config
- TES: Generated Python: generated code is no longer supported directly in TES. Choose the optional Python SDK in the installer wizard. This is selected by default.
- TES: Generated MATLAB: generated code is no longer supported directly in TES. Choose the optional MATLAB SDK in the installer wizard. This is selected by default.
- TES: Clarity surrounding GPIO pins in Automated TDD tab

### Fixed
- TxLolFhBug: resolved when run Below 80 MHz in Frequency Hopping Mode
- Warmboot: fixed missing channel2 mask
- RxTrackingCalArmLock: 1 second wait between overload interrupts from FIC TrackingCal to ARM to prevent lockup
- TES: Only allow assignment of Peak/PeakAndPower or GainChange/GainIndex observation on GPIOs
- TES: 2nd order LPF option now available when a FH profile has been selected
- TES: Correct call to adi_adrv9001_Tx_AttenuationMode_Set only when a Tx Channel is being PRIMED

### Removed

### TES components
    - FPGA image remains at 8.2.27
    - Device Driver API from 68.8.1 to 68.10.1
    - Device Driver Client from 68.8.1 to 68.10.1
    - Firmware from 0.22.22.0 to 0.22.27.0
    - Profile Generator from 53.1.0 to 53.2.0
    - Stream Generator from 0.7.9 to 0.7.10
    - Transceiver Evaluation Software from 0.24.0 to 0.25.0
    - ADRV9001 Plugin from 0.24.0 to 0.25.0

### Eratta

## 0.24.1
### Added
- TES: DPD - Periodic Monitor and display of status

### Changed


### Fixed

### Removed

### TES components
    - FPGA image remains at 8.2.27
    - Device Driver API remains from 68.7.9 to 68.8.1
    - Device Driver Client remains from 68.7.9 to 68.8.1
    - Firmware remains from 0.22.22.0 to 0.22.24.0
    - Profile Generator remains at  53.1.0
    - Stream Generator remains at 0.7.9
    - Transceiver Evaluation Software from 0.24.0 to 0.24.1
    - ADRV9001 Plugin from 0.24.0 to 0.24.1

### Eratta

## 0.24.0
### Added
- TES: SPI Main Feature restored.
- TES: Code Generation updgrade
- External LNA: Modify config to allow multiple LNAs
- RSSI: SPI based method to read and calculate
- DPD Monitor: adi_adrv9001_dpd_channel_Status_Get to read DPD status
- Tx LOL: adi_adrv9001_Tx_LolActuatorFilterDcOffset_Status_Get to read the I and Q DC Offset actuators

### Changed
- FW Binary size: Increased from 288 KB to 303 KB

### Fixed
- adi_adrv9001_Radio_PllLoopFilter_Get: Doxygen documentation
- adi_adrv9001_arm_Version: reads correct version

### Removed

### TES components
    - FPGA image remains at 8.2.27
    - Device Driver API from 68.5.0 to 68.7.9
    - Device Driver Client from 68.5.0 to 68.7.9
    - Firmware from 0.22.13.0 to 0.22.22.0
    - Profile Generator from 52.1.0 to 53.1.0
    - Stream Generator remains at 0.7.9
    - Transceiver Evaluation Software from 0.23.1 to 0.24.0
    - ADRV9001 Plugin from 0.23.1 to 0.24.0

### Eratta

## 0.23.1
### Added

### Changed

### Fixed
- FHPfirSwitch: Tx QEC issue resolved

### Removed

### TES components
    - FPGA image remains at 8.2.27
    - Device Driver API remains at 68.5.0
    - Device Driver Client remains at 68.5.0
    - Firmware from 0.21.0.9 to 0.22.13.0
    - Profile Generator remains at 52.1.0
    - Stream Generator remains at 0.7.9
    - Transceiver Evaluation Software from 0.23.0 to 0.23.1
    - ADRV9001 Plugin from 0.23.0 to 0.23.1

### Eratta
- ARMVersion - adi_adrv9001_arm_Version function returns incorrect 0.22.0, should be 0.22.13

## 0.23.0
### Added
- TES: External LO Swap
- Profile: Support 9.6MSPS CMOS
- FHPfirSwitch: New FH mode, LO_RETUNE_REALTIME_PROCESS_PFIR_SWITCH, allows direct load of PFIRS and switching between frames

### Changed
- TES: Expand FDD Channel select options
- FHTableMemoryOptimize: Allow user provide FREQ_HOPPING_MAX_NUM_BYTES to optimize FH Table memory allocation

### Fixed
- TxQECBug: resolved when DPD enabled in 9.6MSPS Profile
- TxAttenPinCtrl: updated diagram and GUI API calls to ensure PinCtrl persists during state transitions
- MonitorSyncDetect: Algorithm update
- UnusedSSIPinsAsGPI: resolved bug preventing unused Tx2 Tx SSI RefClk pins being used as GPI when not used for SSI

### Removed
- TES: SPI Main Feature disabled
- FH: AGC Seeding disabled in ADRV9001_FHMODE_LO_MUX_PREPROCESS

### TES components
    - FPGA image remains at 8.2.27
    - Device Driver API from 68.0.6 to 68.5.0
    - Device Driver Client from 68.0.6 to 68.5.0
    - Firmware from 0.21.0.9 to 0.22.11.0
    - Profile Generator from 50.11.0 to 52.1.0
    - Stream Generator remains at 0.7.9
    - Transceiver Evaluation Software from 0.22.0 to 0.23.0
    - ADRV9001 Plugin from 0.22.0 to 0.23.0

### Eratta
- FHPfirSwith: Rx Ok. Tx has QEC issue, large image.


## 0.22.0
### Added
- BroadCastMode: Ability to initialize ADRV9001 using SPI_WRITE only, no SPI_READ
- TES: DynamicProfileSwitching: Allow with any Dataport Sample Rate between 32 MSPS and 61.44 MSPS

### Changed
- web-rpc replaces erpc in client-server interaction
- Split adm1293 into separate device instances and add some configurability
- TES: In dual-channel Frequency Hopping with Gain / Atten by GPIO control, either one or two sequences of table indices may be uploaded
- TES: Gain Control Detection Configuration, Peak Overload Threshold may be as much as -3 dB (Previously -6 dB)
- TES: FrequencyHopping: Safeguards to confirm that Hop Table Index by Pin and Hop Table Select by Pin use sequences of the same length

### Fixed
- Warmboot: fixed destination and source swap in memcpy
- MCS: Fixed bug in adi_adrv9001_Mcs_Status_Get that was putting channels out of sync
- TES: FrequencyHopping: Correct Carrier Frequencies in Hopping Diagram
- TES: RxData: Formatting of Rx save data when I and Q are separate columns
- TES: FDD: In FDD use cases, allow starting Transmit after starting Receive
- TES: ORx: BBDC Enable / Disable / Paused working correctly

### Removed
-

### TES components
    - FPGA image from 8.2.21 to 8.2.27
    - Device Driver API from 67.1.1 to 68.0.6
    - Device Driver Client from 67.1.1 to 68.0.6
    - Firmware from 21.0.8 to 21.0.9
    - Profile Generator from 0.50.5 to 50.11.0
    - Stream Generator remains at 0.7.9
    - Transceiver Evaluation Software from 0.20.0 to 0.21.0
    - ADRV9001 Plugin from 0.20.0 to 0.21.0

### Eratta
- SPIMAIN: AGPIO CSB Activity on AGPIO8 when user selects AGPIO0 or AGPIO4 or AGPIO8


## 0.21.0
### Added
- DPD/CLGC: Added Capture Delay
- RxGainControl: Reset Gain Index in Automatic Rx Gain Control in FrequencyHoppping(FH) and nonFH modes
- RxInterfaceGain: Expanded InterfaceGain configuration
- RxInterfaceGainSeed/Save: Seed / Save Rx Interface Gain in automatic (interface) gain control mode
- Warmboot: Added functions to allow coefficients be saved/retrieved from allocated memory

### Changed
- SSICalibrate: Use PRBS15 for calibration when ssiType = LVDS and samplingRate is appropriate

### Fixed
- TES: InterfaceGain: Read back both positive and negative values for Interface Gain in 22-bit IQ data capture
- DynamicFrequencyHopping(DFH): fixes to allow DFH work for all supported platform useCases

### Removed
- TES: LVDS-SDR: removed Single-Data-Rate (SDR) for LVDS, not supported by design

### TES components
    - FPGA image from 8.2.21 to 8.2.27
    - Device Driver API from 48.49.2 to 67.1.1
    - Device Driver Client from 48.49.2 to 67.1.1
    - Firmware from 0.20.0.10 to 21.0.8
    - Profile Generator from 0.50.5 to 50.11.0
    - Stream Generator remains at 0.7.9
    - Transceiver Evaluation Software from 0.20.0 to 0.21.0
    - ADRV9001 Plugin from 0.20.0 to 0.21.0

### Eratta
- SPIMAIN: AGPIO CSB Activity on AGPIO8 when user selects AGPIO0 or AGPIO4 or AGPIO8

## 0.20.0
### Added
- WarmBoot: Allow InitialCalibration coefficients be saved. Coefficients may then be loaded in Warmboot and InitialCalibration time eliminated. TES, API-Board and API-Device support.
- FilterResponse: Composite filter responses for Rx and Tx filters in TES
- RxQECOverloadFreeze: Control of RxQECFreeze in TES (Default: enabled, preserves existing behavior)
- GainControlDetectors: Enable/Disable HalfBand Detector with checkbox in TES
- RxAGCFreezeByGpio - Freeze adaptation of gainControl using GPIO
- AuxDAC: Ideal DAC Output Voltage added in TES
- LOIDCAL: customizable amplitude threshold
- NCOAsyncChangeByGpio: TES allows assignment of pins. Function requires updated offsetFrequencies be sent during Frequency Hopping frame

### Changed
- SPIMAIN: Updated Transfer Mode. Accurate baudRate indicator in TES
- RxPortSwitching: Bound carrier selection in TES correctly
- RxGainTableType: Allow COMPENSATION and CORRECTION table from Board Configuration in TES
- GainControlThresholds: Update TES equations for converting dBFS controls to API values
- GainControlDetectionCrumbs: More accurate labels in TES

### Fixed

### Removed
- RSSIPower: No longer reported in TES during frequencyHopping to prevent contention

### TES components
    - FPGA image remains at 8.2.21  
    - Device Driver API from 48.42.0 to 48.49.2
    - Device Driver Client from 48.42.0 to 48.49.2
    - Firmware from 0.19.4.5 to 0.20.0.10
    - Profile Generator from 0.49.1 to 0.50.5
    - Stream Generator remains at 0.7.9
    - Transceiver Evaluation Software from 0.19.0 to 0.20.0
    - ADRV9001 Plugin from 0.19.0 to 0.20.0

### Eratta
- SPIMAIN - AGPIO CSB Activity on AGPIO8 when user selects AGPIO0 or AGPIO4 or AGPIO8

## 0.19.0
### Added
- LOIDCal: Smart disabling of RFDC Tracking under blocker
- SPIMain: Control a SPI Subordinate using ADRV9001 GPIOs
- ManualRxPortSwitch: Allow overlapping A and B bands when manually switching ports in non-FH
- FrequencyHopping: Independent control of RxGain and TxAtten on channels 1 and 2
- TESFrequencyHoppingWizard: Step by step wizard for FH configuration

### Changed
- CLGC: merged DPD and CLGC tracking enums
- TES:!Important: Power Monitoring will run a second command server with a different TCP port, user-specified port plus one
- TES: Refresh rate and behavior of Power Monitoring modified, linear interpolation used in plot, over-all performance improved
- TES: Analog GPIO nibble selectable for External LNA

### Fixed
- SSICalibrate: fixed error clearing to pass calibration in all useCases
- Duplex=FDD:Setup=Configuration#2: Transmit issue fixed
- TES: Initial calibrations and Tracking calibrations now saved in Taxidi files
- TES: Tracking calibrations in Sample Code take account of Automated TDD assert durations

### Removed
- TES: SNR metric in Receive and Observe

### TES components
    - FPGA image remains at 8.2.21
    - Device Driver API from 48.34.4 to 48.42.0
    - Device Driver Client from 48.34.4 to 48.42.0
    - Firmware from 0.18.1.4 to 0.19.4.5
    - Profile Generator from 0.47.0 to 0.49.1
    - Stream Generator from 0.7.8 to 0.7.9
    - Transceiver Evaluation Software from 0.18.1 to 0.19.0
    - ADRV9001 Plugin from 0.18.1 to 0.19.0

### Eratta
- Rx frequency offset correction only works in IMMEDIATE mode.
- SPIMain: assertionMode will change to transferMode in SDK20. Enum will change to transferNumBytes or transferTransactionBytes
- SPIMain- TES SPI_CLK calculation is incorrect, will be updated in SDK20

## 0.18.1
### Added

### Changed

### Fixed
- Enabling MCS no longer crashes TES during programming

### TES components
    - FPGA image remains at 8.2.21
    - Device Driver API remains at  48.34.4
    - Device Driver Client remains at  48.34.4
    - Firmware remains at  0.18.1.4
    - Profile Generator remains at  0.47.0
    - Stream Generator remains at  0.7.8
    - Transceiver Evaluation Software from 0.18.0 to 0.18.1
    - ADRV9001 Plugin from 0.18.0 to 0.18.1

### Eratta
- Rx frequency offset correction only works in IMMEDIATE mode.
- TES Device Configuration:Duplex=FDD:Setup=Configuration#2 no transmit output when ssiCalibration is not run and fixed ssiDelays are applied

## 0.18.0
### Added
- TxCLGC:               Tx Closed-Loop Gain Control, located under Digital Pre-Distortion settings in TES
- Docking:              TES supports Docking and Undocking modular views
- RxDataTabFormat:      TES support for TSV and interleaved or separate when saving Rx data
- NCOEnable:            User specifies if NCO is in Data Path, allows use of 0Hz NCO
- Monitor Mode:         BBIC Wakeup Level feature added, Wakeup may now be pulse or level
- RSSISettings:         Allow user specify RSSI Measurement Duration and RSSI Moving Average Duration in InterfaceGain control
- TempSensorRead:       TES now supports Temperature Sensor read and plotting in Power / Temp Monitor

### Changed
- Monitor Mode:         Now possible to enable without assigning Monitor Mode Wakeup pin (Wakeu signal always present on GP_INT)
- ORxAutoTdd:           Observation Receive now permitted in Automated TDD and Frequency Hopping use cases
- RxLpfMin:             Analog low-pass filter -1 dB cutoff frequency allows slightly lower values, depends on filter order
- TxLoopbackPathDelay:  Tx LO Leakage and Tx QEC initial calibrations require Tx Loopback Path Delay calibration to run
- TESUserSettings:      User settings file moved from AppData/Local/Temp/Argo to AppData/Roaming/Analog Devices/Argo
- TESLogs:              Logs moved from AppData/Local/Temp/Argo/Logs to AppData/Local/Temp/Analog Devices/Argo/Logs
- FDDSingleChannel:     TES offers more flexibile channel selection in FDD Single Channel

### Fixed
- RxPlotLockUp:         Asynchronous Rx plot updating fixes intermittent plot lock-up
- TDDGpioAssignment:    Revert accidental regression of "Allow assigning TDD General Purpose signals to ADRV GPIO features"
- OrxPinAssignment:     ORx Enable pins in Automated TDD grid view are correctly bound to ORx Enable pins in GPIO tab
- CustomRatesPrecision: Sample Rates and Bandwidths entered in Custom profiles won't cause crash if too many decimal places
- PFIRPowerSaving:      Dynamic enablement of PFIRs for extra power saving.

### TES components
    - FPGA image remains at 8.2.21
    - Device Driver API from 48.26.4 to 48.34.4
    - Device Driver Client from 48.26.4 to 48.34.4
    - Firmware from 0.17.4.22 to 0.18.1.4
    - Profile Generator from 0.46.3 to 0.47.0
    - Stream Generator from 0.7.7 to 0.7.8
    - Transceiver Evaluation Software from 0.17.1 to 0.18.0
    - ADRV9001 Plugin from 0.17.1 to 0.18.0

### Eratta
- Rx frequency offset correction only works in IMMEDIATE mode.
- TES Device Configuration:Duplex=FDD:Setup=Configuration#2 no transmit output when ssiCalibration is not run and fixed ssiDelays are applied
- Enabling MCS crashes TES during programming
## 0.17.1
### Added

### Changed

### Fixed
- Included FPGA platform files omitted in Release 0.17.0
- Fixed issue with intermittent zeroing of RxData in MCS

### TES components
    - Firmware from 0.17.4.20 to 0.17.4.22
    - Transceiver Evaluation Software from 0.17.0 to 0.17.1
    - ADRV9001 Plugin from 0.17.0 to 0.17.1

### Eratta
- For Tx LO Leakage and Tx QEC init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
- Rx frequency offset correction only works in IMMEDIATE mode.
- In FH mode the tables cannot have both zero and non-zero entries for Rx offset frequency in the same hop (LO). This is currently handled by shifting any zero entries to the default IF of 490kHz
- By default, ADI_FPGA9001_MAX_CAPTURE_BYTES is set to the absolute maximum supported by the FPGA. This may cause a segmentation fault due to large memory allocations on the stack. This can be resolved by either:
    * Modify the makefile CFLAGS to include -DADI_FPGA9001_USE_DYNAMIC_MEMORY.
    * Modify the value of ADI_FPGA9001_MAX_CAPTURE_BYTES to be smaller, only as large as the largest required data capture/transmit
- Tetra, TDM_FDD, CMOS 1T1R: ARM Mailbox error when Tx1 DCC InitCal is enabled after Tx1 brought to RF_ENABLED. Workaround: Disable Tx1 DCC InitCal
- Frequent tab-switching in TES during dataTransfer can cause program to freeze. Issue will be improved further in Day18
- IronPython example file PLL_BW_and LO_Frequency_Set.py is out of date. Remove pllCalibration and pllPower, add intermediateFrequency_Hz
- TES Device Configuration:Duplex=FDD:Setup=Configuration#2 no transmit output

## 0.17.0
### Added
- Programmable External LNA support with extended gain table
- Control Rx External LNA via Analog GPIO
- Dynamic profile switching
- Displaying Rx gain table
- Monitor Mode Sync Fast Buffer Read
- Customizable Interface Rate
- Traces and flags on plots
  - Choice of Single Tone, Two Tone, or None analysis
  - In Offline mode, Rx capture now supplies "demo data"
- Tx data vectors may be tab-separated as well as comma-separated
- Compute the enable count based on the user configured desired frame length in right-most columns of Automated TDD configuration data grid.
- LVDS Single-Data-Rate profiles (LTE and Custom)
- DPD configuration Time Filter Coefficient parameter for fine-tuning DPD
- API Functions:
  - Added new DPD LUT switching parameter
  - Increased power threshold range to 32 bit in DMR search configuration
  - Added functions to route Rx1 and Rx2 gain index and gain change signals to gpio outputs
  - Added api to read Tx1 and Tx2 clock polarity for ssi calibration

### Changed
- Rx Port Switching is configured once for the whole device, not separately for Rx1 and Rx2
- Frequency Hopping in LO Retuning modes: Hop and setup pin configure the immediate frame, not the subsequent frame
- Rx Intermediate Frequency is configurable in all profiles
- Fundamental Frequency removed in favor of reporting Image Rejection
- Move control of Monitor Mode RSSI back to Advanced page, configure at Initialization time

### Fixed
- Sample Code will no longer generate Transmit / Receive tasks if Tx / Rx not enabled
- Can successfully load session with only one of two FH tables specified
- Save and load ORx Enable GPIO pins
- Attempt to gracefully load resources mentioned by file path in session (Taxidi) files
- Do not allow uploading PA Fall Ramp if Rise Ramp is over 128 elements long
- API functions:
  - replaced channel_power_down with channel and system_power_down with system to reduce enum character length and prevent MATLAB issue
  - Added an additional condition to enable ORX channels

### TES components
    - FPGA image from 8.2.17 to 8.2.21
    - Device Driver API from 48.26.4
    - Device Driver Client from 48.26.4
    - Firmware from 0.16.3.8 to 0.17.4.20
    - Profile Generator from 0.42.1 to 0.46.3
    - Stream Generator from 0.7.3 to 0.7.7
    - Transceiver Evaluation Software from 0.16.0 to 0.17.0
    - ADRV9001 Plugin from 0.16.0 to 0.17.0

### Eratta
- For Tx LO Leakage and Tx QEC init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
- Rx frequency offset correction only works in IMMEDIATE mode.
- In FH mode the tables cannot have both zero and non-zero entries for Rx offset frequency in the same hop (LO). This is currently handled by shifting any zero entries to the default IF of 490kHz
- By default, ADI_FPGA9001_MAX_CAPTURE_BYTES is set to the absolute maximum supported by the FPGA. This may cause a segmentation fault due to large memory allocations on the stack. This can be resolved by either:
    * Modify the makefile CFLAGS to include -DADI_FPGA9001_USE_DYNAMIC_MEMORY.
    * Modify the value of ADI_FPGA9001_MAX_CAPTURE_BYTES to be smaller, only as large as the largest required data capture/transmit
- Tetra, TDM_FDD, CMOS 1T1R: ARM Mailbox error when Tx1 DCC InitCal is enabled after Tx1 brought to RF_ENABLED. Workaround: Disable Tx1 DCC InitCal
- Frequent tab-switching in TES during dataTransfer can cause program to freeze. Issue will be improved further in Day18
- IronPython example file PLL_BW_and LO_Frequency_Set.py is out of date. Remove pllCalibration and pllPower, add intermediateFrequency_Hz
- Issue with intermittent zeroing of RxData in MCS
- TES Device Configuration:Duplex=FDD:Setup=Configuration#2 no transmit output


## 0.16.0
### Added
- Automated TDD Pin Timing and Hopping diagrams
- Control of Tx DMA Continuous Transfer
- Tx Front-End GPIO control
- Tx Front-End PA Ramp
- Rx RSSI Power read-back
- Monitor mode sync detection, DMR Path Delay calibration
- Rx 15-bit I/Q data option with gain change bit
- Rx 22-bit I/Q data option with gain change bit and gain value bits
- Tx SSI to Rx SSI loopback and Rx Datapath to Tx Datapath loopback in Advanced Features
- PLL Loop Bandwidth
- Enable Rx Zero IF in Frequency Hopping
- Assign custom LO and Hop pin mapping in Dual Hop mode
- Advanced Sample Code generation options
- Demo mode button for no-hardware operation
- Open Taxidi files directly
- Help menu with support links
- Allow user to configure rx ports for zero offset frequency
- PA ramp to work for C0 silicon
- Support for port based dual hop rather than channel based
- 32 bit Rx ssi calibration
- Api support for Rx to Tx datapath loopback
- Api to read dpd captured data samples and sample rate
- Support reading RSSI below -65.554 dB

### Changed
- Separate Rx1 and Rx2 Offset Frequencies in Frequency Hopping tables
- Data Capture in signed integers, separate I and Q arrays
- Allow assigning TDD General Purpose signals to ADRV GPIO features
- Monitor Mode RSSI configuration moved from Advanced Features to Power Savings and Monitor Mode
- Checkbox to enable Rx Zero IF in Frequency Hopping
- Extended max fh frequency from 3.2Ghz to 6Ghz
- Renamed APIs to remove C0 from naming conventions as only C0 is supported

### Fixed
- Rx / Tx Overview tabs correctly updating SSI Data Format in Custom setup
- Allow simultaneous Dual Hop and Dynamic Table Load Frequency Hopping
- Do not write SSI delays to user settings file if delay values are no good
- Fixed pattern in fpga to support 32 bit rx ssi calibration
- Fpga: update to fpga hdl 8.2.16
- Fpga: report errors from the axi driver layer
- Configure power management settings before arm starts to run

### Removed
- All support for B0 silicon; software now requires C0
- Frequency Hopping: MUX Preprocess mode no longer available in dual-channel profiles

### TES components
    - FPGA image from 8.2.14 to 8.2.17
    - Device Driver API from 45.0.5 to 48.8.7
    - Device Driver Client from 45.0.5 to 48.8.7
    - Firmware from 0.15.3.8 to 0.16.3.8
    - Profile Generator from 0.40.12 to 0.42.1
    - Stream Generator from 0.7.1 to 0.7.3
    - Transceiver Evaluation Software from 0.15.0 to 0.16.0
    - ADRV9001 Plugin from 0.15.0 to 0.16.0

### Eratta
- For Tx LO Leakage and Tx QEC init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
- Rx frequency offset correction only works in IMMEDIATE mode.
- Monitor mode Wakeup pin is routed to GP_INT, but not the GPIO assigned.
- Monitor Mode Sync detection algorithm will be further optimized for improved sensitivity in Day 17 release. Its use is limited to High Performance ADC and Interface Gain 0dB in Day 16
- In FH mode the tables cannot have Rx zero entries. This is currently handled by shifting any zero entries to the default IF of 450kHz
- For Tx-only use cases, the TES sample code will include an empty dataCapture() function, resulting in an IndentationError in Python. To resolve this, comment out “import dataCapture” and the call to the dataCapture() function in main.py
- By default, ADI_FPGA9001_MAX_CAPTURE_BYTES is set to the absolute maximum supported by the FPGA. This may cause a segmentation fault due to large memory allocations on the stack. This can be resolved by either:
    Modify the makefile CFLAGS to include -DADI_FPGA9001_USE_DYNAMIC_MEMORY. This makes the ADI_FPGA9001_MAX_CAPTURE_BYTES value irrelevant, instead allocating memory on the heap.
    Modify the value of ADI_FPGA9001_MAX_CAPTURE_BYTES to be smaller - ideally only as large as the largest required data capture/transmit



## 0.15.0
### Added
-   Observation Receive (ORx) for manual TDD:
        1. Connect Tx1/Tx2 to ORx1/ORx2 via external loopback
        2. Enable ORx1/ORx2 on Device Configuration tab
        3. Start Transmitting from Transmit tab
        4. Start Observing from Observe tab
-    DPD features:
        - Over / Under threshold and counts for activating DPD
        - Define DPD regions when Frequency Hopping
-   Rx A/B Port Switching (C0 silicon only)
-   GPIO control of Frequency Hopping hop and gain/attenuation
-   Dual Hop Frequency Hopping
-   Expanded Device Clock Input range up to 1 GHz
-   Output Stream status over GPIOs (Advanced Features tab)
-   Control of Analog Low-Pass Filter -1 dB Frequency (Radio Tab)
-   SSI Strobe Type (Long vs. Short)
-   'Custom Extended' Setup for System Clock as low as 150 MHz
-   Control of MCS Sample Delay and Read Delay
-   Descriptors for TDD signal types in Automated TDD tab

### Changed
-   File Upload controls such as Channel Filter, Hop Table save as relative paths
-   Permitted to use Multi-Chip Sync and Frequency Hopping together
-   Tx Filter Interpolation options are { 1, 2 }, no longer including 3
-   User control of Tx SSI Clock Polarity removed -- calibration routines will determine optimal polarity automatically

### Fixed
-   Load/Save session for most settings, including GPIO and Auxiliary settings
-   Default Rise-to-Analog-On delays no longer contingent on GPIO Power Saving Mode
-   Tx Interpolation had inverse of correct effect in Tx Channel Filter graph

### TES components
    - FPGA image from 8.0.5 to 8.2.14
    - Device Driver API from 38.2.1 to 45.0.5
    - Device Driver Client from 38.2.1 to 45.0.5
    - Firmware from 0.13.6.2 to 0.13.7.3 (B0) and to 0.15.3.8 (C0)
    - Profile Generator from 0.34.3 to 0.40.12
    - Stream Generator from 0.5.11 to 0.7.1
    - Transceiver Evaluation Software from 0.14.0 to 0.15.0
    - ADRV9001 Plugin from 0.14.0 to 0.15.0

### Errata
1. For Tx LO Leakage and Tx QEC init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2. For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
3. Rx frequency offset correction only works in IMMEDIATE mode.
4. Limitation with external delay measurement utilized by DPD.
    a. Measurement with LTE10 profiles is recommended to obtain the highest possible measurement accuracy
    b. Customer should only make the measurement upon Navassa entering CALIBRATED state for the first time
5. Monitor mode Wakeup pin is routed to GP_INT, but not the GPIO assigned.
6. If running Rx1 and Rx2 with automated TDD, user must disable Tx QEC and Tx LO Leakage tracking calibrations.
7. For very short (less than 100uS) transitions between Tx_ENABLE fall and Rx_ENABLE rise the Tx LOL tracking calibration will fail. In such scenario, in SDK15 the Tx LOL tracking calibration needs to be disabled.
8. Code generation for MCS doesn't work correctly.  TES performs polling to check the MCS status, but the code generated does contain the polling procedure.


## 0.14.0
### Added
-   Supports product variants (ADRV9002, ADRV9003, ADRV9004)
-   Multi-Chip Sync (MCS) with optional Synchronous Transfer
-   Dynamic Table Load in Frequency Hopping mode (restriction on FH transition time >=6.7us)
-   Rx Carrier Frequency can be modified after initializing when using Intermediate Frequency
-   Power Monitoring plot of Total Power Consumption vs. Time
-   Liberate additional GPIO pins by disabling Tx SSI Ref Clock (Board Configuration pane, when SSI type is LVDS)
-   Control of Analog Low-Pass Filter Order
-   Choice of RxA or RxB RF input during initialization
-   Control of BBDC Loop Gain
-   Enabled ORx during Tx frequency hopping
-   DMA sync and sync to sample in Automated TDD
-   Silent SSI delay calibration
-   Option for fast PLL calibration
-   Tx Channel Filter with optional interpolation
-   Option to save Stream Image to file

### Changed
-   FPGA 8.0 migration requires re-imaging the SD card
-   UI Changes
    - Filters tab renamed to Rx Filters
    - New Tx Filters tab
    - Minimum Rx gain index changed from 195 to 187
-   Rx gain control signal detector information through GPIO updated
-   Initial Calibrations panes LO and Carrier configuration improved
-   Intermediate Frequency can now be negative
-   GPIO-related features automatically assign pins if and when required
-   Channel Filter plots between -180 and +20 dB
-   Pin control mode of Rx Gain index must begin at 255
-   adi_fpga9001_DataChain_HopTable_Transfer() API is split into adi_fpga9001_DataChain_HopTable_Transfer_Start() and adi_fpga9001_DataChain_HopTable_Transfer_Stop()

### Fixed
-   6 dB "notch" in center bin of Channel Filter plots
-   Profile Types import in IronPython template file

### TES components
    - FPGA image from 0.7.9 to 8.1.0
    - Device Driver API from 29.0.2 to 39.0.7
    - Device Driver Client from 29.0.2 to 39.0.7
    - Firmware from 0.12.2.5 to 0.13.6.7 (B0) and 0.14.5.5 (C0)
    - Profile Generator from 0.28.1 to 0.34.8
    - Stream Generator from 0.5.6 to 0.5.17
    - Transceiver Evaluation Software from 0.12.0 to 0.14.0
    - ADRV9001 Plugin from 0.11.0 to 0.14.0

### Errata
1. For Tx LO Leakage and Tx QEC init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2. For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
3. Rx frequency offset correction only works in IMMEDIATE mode.
4. Limitation with external delay measurement utilized by DPD.
    a. Measurement with LTE10 profiles is recommended to obtain the highest possible measurement accuracy
    b. Customer should only make the measurement upon Navassa entering CALIBRATED state for the first time
5. Monitor mode Wakeup pin is routed to GP_INT, but not the GPIO assigned.
6. If running Rx1 and Rx2 with automated TDD, user must disable Tx QEC and Tx LO Leakage tracking calibrations.


## 0.13.0
### Skipped


## 0.12.0
### Added
- Fast Frequency Hopping feature located under Carriers tab
    - New Fast Frequency Hopping amodal dialog for manual control
- Internal Tone Generation located under Radio tab
- Save and restore DPD coefficients
- Option to disable Device Clock Output entirely
- CMOS SSI type in Custom Setup
- LO divisor of 1 when LO frequencies are between 500 MHz and 1 GHz
- SPI control of channel enablement (previously removed in 0.10)
- Rx Channel Filter can be entirely disabled to save power
- SSI Power Down option when SSI Type is LVDS
- Control of component Power Consumption:
    - RF PLL 1 and 2 (when using internal LO)
    - Rx and Tx Low-Pass Filters
    - Clock PLL

### Changed
- Automated TDD interface overhauled to new data grid view including GPIOs and control of FPGA DMAs
- UI Changes
    - Initialization pane split into Clocks, Carriers, Radio, Advanced Features
    - Initial Calibrations panes LO and Carrier configuration improved
- Init Calibrations and Tracking Calibrations are configured separately for Channel 1 and Channel 2
- Optimizations in the receive data path to reduce power in certain narrow-band applications

- TES components
    - FPGA image from 0.6.7 to 7.0.10
    - Device Driver API from 20.9.2 to 29.2.0
    - Device Driver Client from 20.9.2 to 29.2.0
    - Firmware from 0.11.3.2 to 0.12.2.13
    - Profile Generator from 0.22.17 to 0.28.1
    - Stream Generator from 0.4.4.0 to 0.5.6
    - Transceiver Evaluation Software from 0.11.0 to 0.12.0
    - ADRV9001 Plugin from 0.11.0 to 0.12.0

### Errata
1. For Tx LO Leakage and Tx QEC init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2. For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
3. Rx frequency offset correction only works in IMMEDIATE mode.
4. Limitation with external delay measurement utilized by DPD.
    a. Measurement with LTE10 profiles is recommended to obtain the highest possible measurement accuracy
    b. Customer should only make the measurement upon Navassa entering CALIBRATED state for the first time
5. Monitor mode Wakeup pin is routed to GP_INT, but not the GPIO assigned.


## 0.11.0
### Added
- View Menu -> Driver Debugger
    - Added live view of API commands that being executed while using TES.
- View Menu -> Power Monitoring
    - Improve accuracy of current and power readbacks.
- Configure tab -> Device Configuration
    - Add Setup ->  Custom mode. When this mode is selected, allow user to enter
        - Data Sample Rate
        - RF Channel Bnadwidth
        - For Channel SSI:
            - SSI Type
            - Number of lanes
            - Data Rate
    - “Traffic lights” indicator informing user if selected configuration is valid

### Changed
- Minimum gain index raised from 187 to 195
- In TDD tab, enter TDD timing parameters in # of Samples
- Sample Code initialize code
    - Serializes data objects instead of using paths
    - Invokes initialization sequence explicitly (whereas previous versions called `adi_adrv9001Ee01_Initialize`)
- TES components
    - FPGA image from 0.6.7 to 0.6.7
    - Device Driver API from 18.8.10 to 20.9.2
    - Device Driver Client from 18.8.10 to 20.9.2
    - Firmware from 0.10.1.22 to 0.11.3.2
    - Profile Generator from 0.19.5.0 to 0.22.17
    - Stream Generator from 0.3.8.0 to 0.4.4.0
    - Transceiver Evaluation Software from 0.10.0 to 0.11.0
    - ADRV9001 Plugin from 0.10.0 to 0.11.0

### Errata
1. For Tx LO Leakage init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2. For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
3. Frame Boundary mode is not supported in Rx frequency offset correction.
4. Tx Baseband Analog Filter-Group Delay initialization calibration is not enabled by default.
5. Limitation with external delay measurement utilized by DPD.
    a. Measurement with LTE10 profiles is recommended to obtain the highest possible measurement accuracy
    b. Customer should only make the measurement upon Navassa entering CALIBRATED state for the first time
6. SPI control mode disabled; only Pin mode available
7. Power consumption level observed when in Calibrated State is not preserved when moving to Primed state and then back to Calibrated state. Issue is due to states of internal blocks that needs to be restored to exact settings. Issue will be addressed in following releases.
8. The Device Driver source contains APIs for frequency hopping; however, the firmware included does not enable this feature


## 0.10.0
### Added
- In File Menu
    - Button to over-write resources directory (File --> Force Update Platform) on SD card installed on ZYNQ FPGA platform
- View Menu -> Monitor Mode
    - Added Monitor Mode View
- Configure tab -> Device Configuration
    - Independent port operation in wide-band modes
    - Custom configuration #3
        - 42.666 MSPS, RF Bandwidth: 20 MHz
    - LTE profiles
        - 30.72 MSPS RF Bandwidth: 20 MHz
        - 7.68 MSPS RF Bandwidth: 5 MHz
        - 3.84 MSPS RF Bandwidth: 3 MHz
        - 1.92 MSPS RF Bandwidth: 1.4 MHz
- Configure tab -> Initialization
    - Add ability to provide arbitrary DEV_CLK (range from 10MHz to 300MHz).
        - Feature tested with frequencies available in 0.9.1 TES release. Other frequencies untested and should be treated as experimental.
    - Control of Processor Clock Divisor for Power Saving (no tracking cals with lower processor clock)
    - Explicit formula for computing Device Clock Output Frequency
    - Choice of Diversity (checked) or Independent (unchecked) LO configuration in Dual-Channel modes
    - Choice between Best Phase Noise or Best Power Consumption optimization for internal LO sources
    - Ability to disable/enable Rx Frequency Offset Correction
    - Ability to disable/enable Tx Frequency Offset Correction
    - Ability to enable optional 3 dB DAC full-scale power boost on Tx outputs
    - Initial settings for Monitor Mode
- Configure tab -> Filters
    - Capacity to upload custom channel filter coefficients
    - Scale factor is 2^23
- Transmit tab
    - Ability to control Tx Frequency Offset Correction
- Receive tab
    - Ability to control Baseband DC correction calibration
- GPIO tab
    - Rx Gain Index readout via GPIO pins
    - Add option for GPIO to control ARM power down mode
- Gain control tab
    - Re-enable Peak-and-Power detection mode for Gain Control
- System Power Savings and Monitor Mode tab
    - Add option for GPIO to control ARM power down mode (deep sleep)
    - Add interface to configure Monitor Mode operation
    - Add Monitor Mode Wakeup Pin
        - Assigned this Pin, will work in Monitor Mode ( periodical detection and sleep)
        - Unassigned this Pin, will work in System Power Saving mode (sleep only)
    - Add "Primed" state controls on System Power Savings and Monitor Mode tab
- TDD Enablement delays
    - Add measurement of internal path delay
- TDD tab
    - Add ability to load TDD configurations from drop-down selector
    - User can save and reload custom TDD timings
- Tracking Cals tab
    - Add FDD tracking calibrations (Rx/ORx QEC and Rx HD2)
- Auxiliary tab
    - Add interface to control Auxiliary ADCs / Auxiliary DACs


### Changed
- FPGA architecture implementation
- Custom1, Custom2 setups renamed to Configuration #1, Configuration #2
- Configuration #2 switched from SDR to DDR
- GPIO configurations moved to top bar
    - Can assign and reassign GPIO pins after programming
    - Can change Rx gain index control mode, Tx attenuation control mode, System Power Savings and Channel Power Savings configurations after programming
- Dual-channel profiles can now
    - Toggle all four channels' states independently (e.g. Rx1 in Calibrated, Rx2 in Primed, etc.)
    - Set all four channels' carrier frequencies independently except with FDD duplex
- DPD can now be enabled in LTE configurations (up to LTE20)
    - External loopback path delay information needs to be provided in the Board Configuration tab.
    - API ExternalPathDelay_Calibrate, and ExternalPathDelay_Get need to be called to get the external loopback path delay number in ns.
    - This is not required for Tetra DPD, but required for LTE DPD.
- Update display of Analog Power-Up and PLL Power-Up delays scaled with System Clock Frequency
- Enable Low Power Clock PLL to support most of available profiles (with exception of LTE40, 61.44MSPS).
- Fix issue with saving Rx files in Configuration #2 profile.
- TES components
    - FPGA image from 0.5.29 to 0.6.7
    - Device Driver API from 14.3.9 to 18.8.10
    - Device Driver Client from 14.3.9 to 18.8.10
    - Firmware from 0.9.2.16 to 0.10.1.22
    - Profile Generator from 0.18.4.0 to 0.19.5.0
    - Stream Generator from 0.3.6.0 to 0.3.8.0
    - Transceiver Evaluation Software from 0.9.1 to 0.10.0
    - ADRV9001 Plugin from 0.9.1 to 0.9.1


### Errata
1. For Tx LO Leakage init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2. For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
3. Frame Boundary mode is not supported in Rx frequency offset correction.
4. Tx Baseband Analog Filter-Group Delay initialization calibration is not enabled by default.
5. The Tx attenuation delay calibration is not yet supported
6. Limitation with external delay measurement utilized by DPD.
    - Measurement with LTE10 profiles is recommended to obtain the highest possible measurement accuracy
    - Customer should only make the measurement upon Navassa entering CALIBRATED state for the first time
7. Power savings mode transitions
8. Auto-generated MATLAB and Python code needs to be modified to work correctly.  See READMEs.
9. SPI control mode disabled; only Pin mode available

## 0.9.1
### Fixed
- TES MATLAB sample code correctly passes a .NET array to `fpga9001.dataChain.Data_Get`
- TES dependency management

### Changed:
- TES components:
    - Transceiver Evaluation Software from 0.9.0 to 0.9.1
    - ADRV9001 Plugin from 0.9.0 to 0.9.1


## 0.9.0
### Added
- In Board Configuration section of Configure tab, add External Path Delay option
- In Initialization section of Configure tab, change Compandor Size information to LUT Size and Pre-LUT Scale input parameters in Digital Pre-Distortion section.
- In GPIO Configuration section of Configure tab add
    - System Power Savings
    - Tx Attenuation Control
    - Channel Power Savings Control
- In Transmit and Receive tables add option to control DGPIO pin that can power down selected channel.
- New “Hibernated” state in the “View” -> “Radio State” window when operating in Single Channel mode.
- New tab called Attenuation Control enabling access to set and control Tx attenuations for each Tx channel
- New tab called TDD Enablement Delays to allow user interact with proposed power saving features per channel.
- Enable tone init calibration in wideband mode

### Changed
- Support only second revision of ADRV9002 silicon. SDK release SDK Release 0.8.1 is the last one that supports first ADRV9002 silicon revision.
- For Custom2 profile enable:
    - supports 40MHz DEV_CLK
    - support of CMOS 4-Lane SDR data port SSI mode
- In drop down menu code generation relocate from “File” menu to dedicated “Sample Code” menu.
- Update defaults for gain control minima and maxima values for Overload and Underload Thresholds.
- Update minimum gain index value from 183 to 187.  Default value from 255 to 247.
- TES components:
    - FPGA image from 0.4.15 to 0.4.29
    - Device Driver API from 11.0.2 to 14.3.7
    - Device Driver Client from 11.0.2 to 14.3.7
    - Firmware from 0.8.0.12 to 0.9.2.15
    - Profile Generator from 0.10.4.0 to 0.18.4.0
    - Stream Generator from 0.2.11.0 to 0.3.6.0
    - Transceiver Evaluation Software from 0.8.1 to 0.9.0
    - ADRV9001 Plugin from 0.8.4 to 0.9.0

### Errata
1.  For Tx LO Leakage init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2.  For TDD LTE and Custom1 profiles all Rx and Tx channels are enabled by default.
3.  When Automated TDD State Machine is chosen in the TDD tab, user can only choose either “TDD Enabled for Rx1” or “TDD Enabled for Tx1” as the predefined TDD structure. TX-Only or RX-Only framing is supported for DMR standard.
4.  For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
5.  Frame Boundary mode is not supported in Rx frequency offset correction.
6.  The Tx attenuation delay calibration is not yet supported
7.  The Peak-and-Power detection mode is not yet supported


## 0.8.0
### Added
- Radio State bidirectional user control under View menu
- 300Mhz Reference clock for DMR/Analog FM/Tetra profiles (only with High Performance Clock PLL)
- FDD support for
    - LTE Profile
    - Custom2 Profile
        - Rx I/Q, sample rate 936kSPS, bandwidth 7.813/31.25/62.5/156.25/312.5kHz
        - Tx I/Q, sample rate 936kSPS, bandwidth 7.813/31.25/62.5/156.25/312.5kHz
- Single Channel / Dual Channel user control (toggleable in FDD duplex LTE and Custom2 setups)
- Manual Control of Rx gain via selectable GPIO Pin
- Stream Generator version number displayed in dependency list

### Changed
- GPIO configuration tab
- Rename Custom setup to Custom1
- Setup control relocated from channel group to new Device group on Device Configuration pane
- AnalogFM setup in FDD duplex now has diagonal channels enabled (Rx2 and Tx1)
- IronPython editor and Power Monitoring view relocated to View menu
- Narrow-band setups default Clock PLL to Low Power and ADC Rate to Low; wide-band setups default to High for both Clock PLL and ADC Rate.
- Rx Capture Number of Samples now editable even while Transmit/Receiving
- Tx Attenuation does not change during Transmit until pressing Enter or losing focus on the input field
- Tracking calibration names improved for accuracy
- TES components:
    - FPGA image from 0.4.15 to 0.4.15
    - Device Driver API from 9.0.0 to 11.0.2
    - Device Driver Client from 9.0.0 to 11.0.2
    - Firmware from 0.7.1.9 to 0.8.0.11
    - Profile Generator from 0.9.14.0 to 0.10.4.0
    - Stream Generator from 0.2.8 to 0.2.11.0
    - Transceiver Evaluation Software from 0.7.0 to 0.8.1
    - ADRV9001 Plugin from 0.7.0 to 0.8.3

### Errata
1.  For Tx LO Leakage init cal to converge, user has to enable and execute Tx Loopback Path Delay init cal.
2.  For TDD LTE and Custom1 profiles all Rx and Tx channels are enabled by default.
3.  When Automated TDD State Machine is chosen in the TDD tab, user can only choose either “TDD Enabled for Rx1” or “TDD Enabled for Tx1” as the predefined TDD structure. TX-Only or RX-Only framing is supported for DMR standard.
4.  For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
5.  Frame Boundary mode is not supported in Rx frequency offset correction.


## 0.7.0
### Added
-   Digital Pre-Distortion
    - Dedicated page with DPD configuration details,
    - Board Configuration page with External Loopback configuration options
    - DPD polynomial terms selection in Initialization page
-   Tracking Calibrations page including:
    - Rx:
        - AGC,
        - Baseband DC offset,
        - 2nd Harmonic Distortion,
        - QEC Narrow Band
        - QEC Wideband
    - Tx:
        - DPD
        - LO Leakage
        - QEC
-   For DMR and Analog FM setups enable reception of Frequency Deviation signal type for Rx.
-   For DMR, TETRA  and Analog FM setups allow Single-channel operation (Rx-only or Tx-only).
-   Interface Gain:
    - Automatic Gain Control for Interface Gain
    - Expand Update modes to Now vs. Update Next Frame
    - Depending on profiles, allow Rx Gain + Interface Gain values from -36 dB to +18 dB
-   Include new sample data files for transmit in \Example folder
-   GPIO Configuration page with ability to map Gain Control Feedback signals to DGPIO pins
-   Allow MED and LOW ADC Rate for Rx Low Power ADCs
-   Ability to dynamically switch pFIR filter coefficients.

### Changed
-   Signal type for Tx1 and Tx2 (I/Q, I/Q FM/FSK, and Direct FM/FSK) relocated on Device Configuration pane
-   Programmable Intermediate Frequency (IF) now set for correct profiles
-   In Rx Gain Control pane change threshold levels to correct values.
-   Update internal configuring to correctly handle external LO at frequencies in range between 400MHz to 420MHz.
-   Modify stream binary generation and delivery when autogenerating C, MATLAB, or Python initialization codes.
-   Improve power consumption numbers for Rx and Tx active states.
-   Enhancements on Tx and Rx data path enable stages to avoid glitches and attenuated data section on Tx and Rx outputs.
-   In TDD pane change parameters values from clock cycles to micro/mili seconds
-   TES components:
    - FPGA image from 0.4.12 to 0.4.15
    - Device Driver API from 0.6.3 to 9.0.0
    - Device Driver Client from 0.6.3 to 9.0.0
    - Firmware from 0.6.1.3 to 0.7.1.9
    - Profile Generator from 0.7.8 to 0.9.14.0
    - Stream Generator from 0.2.3 to 0.2.8
    - Transceiver Evaluation Software from 0.6.1 to 0.7.0
    - ADRV9001 Plugin from 0.6.1 to 0.7.0

### Known issues and limitations with 0.7.0 TES release
1.  For Tx LO Leakage init cal to converge, user have to enable and execute Tx Loopback Path Delay init cal.
2.  For LTE and Custom profiles all Rx and Tx channels are enabled by default.
3.  When Automated TDD State Machine is chosen in the TDD tab, user can only choose either “TDD Enabled for Rx1” or “TDD Enabled for Tx1” as the predefined TDD structure. TX-Only or RX-Only framing is supported for DMR standard.
4.  For very low sampling frequencies (24kHz) and especially under Automated TDD control where RX_EN is toggling high and low, the real time taken for multiple millions of samples to come out of the ADRV9001 may exceed the timeout values generating TES exception.
5.  Frame Boundary mode is not supported in Rx frequency offset correction.
6.  "Manual SPI Control " Mode is not supported in this GUI release


## 0.6.1
### Added
-   Enable TDD interface
    - Provide pre-set configurations and control over frame duration.
    - Display information about frame, pin and data timing.
-   User-defined Intermediate Frequency for Rx in TETRA, DMR and AnalogFM systems.
    - Recommend range from 490K to 20M
-   Enable Clock PLL selection:
    - High performance
    - Low power (does not support LTE 61.44MSPS).
-   Duty Cycle Correction calibration (external LO only)
-   Enable selection of Rx ADC characteristics (rate and optimization mode)
    - Low power mode is only supported on ADC HIGH sample rate.
-   Peak and Power AGC mode.
-   Selection between Gain Compensation or Gain Correction mode.
-   Enable PLL re-tuning control
    - Provide capability to run Rx init cals, retune LO, then run Tx init cals

### Changed
-   Expand Rx Gain Control tab with diagrams and extra controls.
-   Enhancements to various init calibrations.
-   Increase capture duration limit on Rx to allow for collecting more samples in narrow-band profiles
-   Fix bug that would cause crash on PCs that never installed Microsoft's English language pack
-   Improve accuracy of power supply monitoring readouts.
-   TES components:
    - FPGA image from 0.4.6 to 0.4.12
    - Device Driver API from 0.5.3 to 0.6.5
    - Device Driver Client from 0.5.3 to 0.6.5
    - Firmware from 0.5.1.5 to 0.6.1.3
    - Profile Generator 0.7.8
    - Stream Generator 0.2.4
    - Transceiver Evaluation Software from 0.5.2 to 0.6.1
    - ADRV9001 Plugin from 0.5.2 to 0.6.2

### Errata
1.  For Tx LO Leakage init cal to converge, user have to enable and execute Tx Loopback Path Delay init cal.
2.  For LTE and Custom profiles all Rx and Tx channels are enabled.
3.  In DMR and analogFM profiles, when the Rx sample rate is set as 48kSPS, 25kHz bandwidth is not supported.
4.  Frame Boundary mode is not supported in Rx frequency offset correction.
5.  DMR TDD framing supports only TX or RX but not both, user should not play RX while TX is enabled or vice versa
6.  TDD long capture length may cause GUI exception
7.  Code generation for MATLAB to initilize the part from a reset state doesn't work.  It can with a few modifications.


## 0.5.2
### Added
- Enable TDD interface
    - Provide pre-set configurations and control over frame duration.
    - Display information about frame, pin and data timing.
- User-defined Intermediate Frequency for Rx in TETRA, DMR and AnalogFM systems.
    - Recommend range from 490K to 20M
- Enable Clock PLL selection:
    - High performance
    - Low power (does not support LTE 61.44MSPS).
- Duty Cycle Correction calibration (external LO only)
- Enable selection of Rx ADC characteristics (rate and optimization mode)
    - Low power mode is only supported on ADC HIGH sample rate.
- Peak and Power AGC mode.
- Selection between Gain Compensation or Gain Correction mode.
- Enable PLL re-tuning control
    - Provide capability to run Rx init cals, retune LO, then run Tx init cals

### Changed
- Expand Rx Gain Control tab with diagrams and extra controls.
- Enhancements to various init calibrations.
- Increase capture duration limit on Rx to allow for collecting more samples in narrow-band profiles
- Fix bug that would cause crash on PCs that never installed Microsoft's English language pack
- Improve accuracy of power supply monitoring readouts.
- TES components:
    - FPGA image from 0.4.6 to 0.4.12
    - Device Driver API from 0.5.3 to 0.6.3
    - Device Driver Client from 0.5.3 to 0.6.3
    - Firmware from 0.5.1.5 to 0.6.1.3
    - Profile Generator 0.7.8
    - Stream Generator 0.2.3
    - Transceiver Evaluation Software from 0.5.2 to 0.6.1
    - ADRV9001 Plugin from 0.5.2 to 0.6.2

### Errata
1.  For Tx LO Leakage init cal to converge, user have to enable and execute Tx Loopback Path Delay init cal.
2.  For LTE and Custom profiles all Rx and Tx channels are enabled.
3.  In DMR and analogFM profiles, when the Rx sample rate is set as 48kSPS, 25kHz bandwidth is not supported.
4.  Frame Boundary mode is not supported in Rx frequency offset correction.
5.  DMR TDD framing supports only TX or RX but not both, user should not play RX while TX is enabled or vice versa
6.  TDD long capture length may cause GUI exception


## 0.5.2
### Added
- FDD system setup
    - AnalogFM profile with configurable frequency deviation
    - Rx I/Q
        - 24kSPS, 12.5kHz RF BW
        - 48kSPS, 12.5kHz RF BW
    - Tx DM FM/FSK
        - 96kSPS, 12.5kHz RF BW
- TDM-FDD system setup with Tetra device setup
    - Rx I/Q
        - 144kSPS, 25kHz or 50kHz RF BW
    - Tx I/Q
        - 144kSPS, 25kHz or 50kHz RF BW
- Capability of tone generation in Transmit tab
    - Support both single tone and dual tone generation
    - Configurable tone amplitude, tone frequency and sample length
- Capability of transmitting all zeros in Transmit tab
- Live swap of Tx data while transmitting
- Rx frequency offset correction
    - Configurable correction mode (only immediate mode is supported in this release)
    - Configurable correction value (Hz)
- Power Monitoring table view in Transmit and Receive tabs

### Changed
- Minimal external LO divider is changed to 2x (instead 4x in the release V0.4.3)
- Removed the limitation of disabling Tx QEC initial calibration when LO<350MHz
- Continuous capture mode allows persistence of zoom
- Scroll bars are enabled in configuration panes even after part has been programmed
- Roll-your-own up-down arrows on Rx gain index in Receive pane
- TES components:
    - Device Driver API from 0.5.1 to 0.5.3
    - Device Driver Client from 0.5.1 to 0.5.3
    - Firmware from 0.4.4.4 to 0.5.1.5
    - Transceiver Evaluation Software from 0.4.3 to 0.5.2
    - ADRV9001 Plugin from 0.4.3 to 0.5.2

### Errata
- For Tx LO Leakage init cal to converge, user have to enable and execute Tx Loopback Path Delay init cal.
- For LTE and Custom profiles all Rx and Tx channels are enabled.
- In DMR and analogFM profiles, when the Rx sample rate is set as 48kSPS, 25kHz bandwidth is not supported.
- Frame Boundary mode is not supported in Rx frequency offset correction.


## 0.4.1
### Added
- Analog FM profile:
    - Rx I/Q,
        - 24kSPS, 12.5kHz RF BW
        - 48kSPS, 12.5kHz or 25kHz RF BW
    - Tx I/Q FM/FSK or Direct FM/FSK
        - 96kSPS, 12.5kHz RF BW
    - Custom frequency deviation
- DMR profile:
    - Rx I/Q,
        - 48kSPS, 12.5kHz or 25kHz RF BW
    - Tx I/Q,
        - 48kSPS, 12.5kHz RF BW
    - Frequency deviation display for Tx I/Q FM/FSK and Tx Direct FM/FSK
    - Enable Tx External LO in DMR I/Q and DMR I/Q FM/FSK profiles.
- Custom profile:
    - Rx I/Q,
        - 20MSPS, 5.4 or 7.3 or 9.2MHz RF BW
    - Tx I/Q,
        - 40MSPS, 9.2MHz RF BW
- Device clock frequency:
    - 40MHz,
    - 49.152MHz
- Rx ADC configurability
    - Enable selection of High Performance or Low Power ADC used by Rx data path.
- Tx QEC init calibration
- Gain Compensation selection
    - Select between gain correction or gain compensation options
- Rx overview tab
    - Display main information related to selected profile
- Tx overview tab
    - Display main information related to selected profile
- Tx QEC init calibration
- Read back and display information on configuration of connected EVB hardware
    - Add warning messages when user attempts to operate hardware outside its bounds
- Generation of
    - JSON profile file
    - Initialization sequence in ANSI C that brings part into programmed state (experimental)
    - Initialization sequence in Python that brings part into programmed state (experimental)
    - Initialization sequence in MATLAB that brings part into programmed state (experimental)

### Changed
- General:
    - Introduce first take on power consumption optimization (disable unused blocks in analog section of ADRV9002). More power saving optimization is planned for future software releases.
    - Fix bug related to PC geographical settings (comma vs dot)
- In Receive tab,
    - Rearrange displayed information
- In Transmit tab,
    - Rearrange displayed information
- Enhance logging capabilities.
- TES components:
    - FPGA image from 0.3.8 to 0.4.6
    - Device Driver API from 0.3.7 to 0.5.1
    - Device Driver Client from 0.3.7 to 0.5.1
    - Firmware from 0.3.0.6 to 0.4.4.4
    - Transceiver Evaluation Software from 0.3.16 to 0.4.3
    - ADRV9001 Plugin from 0.3.20 to 0.4.3


### Errata
- The Tx QEC init calibration is automatically disabled when LO<350MHz.
- Minimal external LO divider set to 4x (instead 2x).
- For Tx LO Leakage init cal to converge, user have to enable and execute Tx Loopback Path Delay init cal.
- For LTE and Custom profiles all Rx and Tx channels are enabled.
