# ADRV9001 Transceiver Python

## Getting Started
### Programming the Device
1. Ensure that the ADRV9001 transceiver evaluation software (TES) has been installed
2. Run TES and Configure.
3. Click Sample Code > Python.
4. In the Select Folder dialog create a new directory to save the auto-generated Python code.  As of TES 0.9.0,
multiple task based files will be generated with predetermined file names.  Note: If you auto-generate code in a
directory that already has code all of the files will be overwritten and any changes you've made will be lost.
5. Select Folder. The code generated will fully specify the state of the device and can be used to restore said
state entirely from Python at a later point in time.
6. Close TES or Disconnect.
7. Run `main.py` to capture and retransmit the data.

### Stream Image
The ADRV9001 requires a stream image binary to be downloaded to the device which has been custom asembled based on
the device configuration.  TES automatically creates this stream image and passes it to the function that
initializes the part.  The stream image is a byte array and it will be part of the auto-generated code so there
is no need to manage it as a separate resource (as was done with previous versions of TES).

## Troubleshooting
- This code is *experimental* and may need to be tweaked to work correctly
- If Python complains that a DLL cannot be found make sure that the variable
`CLIENT_INSTALL_DIRECTORY` points to the TES installation directory.  Look
carefully for a missing, trailing "\\".
