// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       ADRV9001 Platform
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#include "common.h"

#ifdef cmos
#define CMOS1_LVDS0 1
#endif

#ifdef lvds
#define CMOS1_LVDS0 0
#endif

int main(int argc, char **argv) {

  if (axi_platform_open(0) != 0) {
    return(-1);
  }

  if (axi_platform_power_setup() != 0) {
    return(-1);
  }
 
  if (axi_platform_clock_setup() != 0) {
    return(-1);
  }
 
  axi_platform_setup();
  axi_mspi_setup();
  adrv9001_setup(CMOS1_LVDS0);
  axi_adrv9001_setup(CMOS1_LVDS0);
  if (axi_platform_ssi_calibrate() != 0) {
    return(-1);
  }

  axi_txdma_setup();
  axi_rxdma_setup();
  printf("INFO: Done.\n");
  axi_platform_close(0);
  return(0);
}

// **********************************************************************************
// **********************************************************************************
