// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       ADRV9001 Platform
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#ifndef COMMON_H
#define COMMON_H

#include "axi_common.h"
#include "axi_sysid.h"
#include "axi_mspi.h"
#include "axi_dma.h"
#include "axi_adrv9001.h"
#include "axi_clkgen.h"
#include "adrv9001.h"

uint32_t axi_dma_data(uint32_t data);
void axi_rxdma_setup(void);
void axi_txdma_setup(void);
void axi_adrv9001_clk_setup(void);
void axi_adrv9001_ssi_setup(uint32_t cmos1_lvds0);
void axi_adrv9001_setup(uint32_t cmos1_lvds0);
int32_t axi_platform_ssi_calibrate(void);
void axi_mspi_setup(void);
void axi_platform_setup(void);
int32_t axi_platform_clock_setup(void);
int32_t axi_platform_power_setup(void);

#endif

// **********************************************************************************
// **********************************************************************************
