// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Remi Malaquin/Rejeesh Kutty
// Description:       Simple Setup: 61.44MHz LSSI & 24kHz CSSI
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#include "adrv9001.h"

void adrv9001_setup (uint32_t cmos1_lvds0) {

  axi_adrv9001_reset_set(0, AXI_ADRV9001_ID, 0x0);
  axi_adrv9001_delay_us(0, AXI_ADRV9001_ID, 1000);
  axi_adrv9001_reset_set(0, AXI_ADRV9001_ID, 0x1);
  axi_adrv9001_delay_us(0, AXI_ADRV9001_ID, 1000);

  /* spi settings */

  adrv9001_reg_write(0x1, 0x80);
  adrv9001_reg_write(0x0, 0x18);
  adrv9001_delay_ms(1);

  adrv9001_reg_write(0x0628, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x0a28, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x0196, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x01b8, ((cmos1_lvds0 == 1) ? 0x84 : 0x84));
  adrv9001_reg_write(0x01b8, ((cmos1_lvds0 == 1) ? 0x04 : 0x04));
  adrv9001_reg_write(0x0196, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x01b8, ((cmos1_lvds0 == 1) ? 0x04 : 0x04));
  adrv9001_reg_write(0x01b8, ((cmos1_lvds0 == 1) ? 0x04 : 0x04));
  adrv9001_reg_write(0x018d, ((cmos1_lvds0 == 1) ? 0x33 : 0x33));

  /* device & vendor info */

  axi_platform_log(0, AXI_PLATFORM_INFO, "device[%2d]\n", adrv9001_reg_read(0x3)),
  axi_platform_log(0, AXI_PLATFORM_INFO, "vendor[%2d]\n", adrv9001_reg_read(0xb));

  /* clock pll */

  adrv9001_reg_write(0x01aa, ((cmos1_lvds0 == 1) ? 0x04 : 0x04));
  adrv9001_reg_write(0x01b3, ((cmos1_lvds0 == 1) ? 0x23 : 0x23));
  adrv9001_reg_write(0x01ab, ((cmos1_lvds0 == 1) ? 0x03 : 0x03));
  adrv9001_delay_ms(1);

  adrv9001_reg_write(0x1a00, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x1a01, ((cmos1_lvds0 == 1) ? 0x03 : 0x03));
  adrv9001_reg_field_write(0x01ca,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1ad2,  0, 0x7f, ((cmos1_lvds0 == 1) ? 0x08 : 0x08));
  adrv9001_reg_field_write(0x1ad1,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01e0,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01e0,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01e2,  0, 0x07, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x1a02, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1a03,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x1a04, ((cmos1_lvds0 == 1) ? 0x08 : 0x08));
  adrv9001_reg_write(0x1a05, ((cmos1_lvds0 == 1) ? 0x30 : 0x30));
  adrv9001_reg_write(0x1a36, ((cmos1_lvds0 == 1) ? 0x03 : 0x03));
  adrv9001_reg_write(0x1a24, ((cmos1_lvds0 == 1) ? 0x08 : 0x08));
  adrv9001_reg_write(0x1a2d, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_write(0x1a2e, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x1a2f, ((cmos1_lvds0 == 1) ? 0x3e : 0x3e));
  adrv9001_reg_write(0x1a30, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_write(0x1a31, ((cmos1_lvds0 == 1) ? 0x3e : 0x3e));
  adrv9001_reg_write(0x1a38, ((cmos1_lvds0 == 1) ? 0x65 : 0x65));
  adrv9001_reg_write(0x1a43, ((cmos1_lvds0 == 1) ? 0x80 : 0x80));
  adrv9001_reg_write(0x1a26, ((cmos1_lvds0 == 1) ? 0x03 : 0x03));
  adrv9001_reg_write(0x1a27, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x1a35, ((cmos1_lvds0 == 1) ? 0x03 : 0x03));
  adrv9001_reg_write(0x1ad5, ((cmos1_lvds0 == 1) ? 0x03 : 0x03));
  adrv9001_reg_write(0x1ad4, ((cmos1_lvds0 == 1) ? 0x0d : 0x0d));
  adrv9001_reg_write(0x1ad3, ((cmos1_lvds0 == 1) ? 0x3f : 0x3f));
  adrv9001_reg_write(0x1a74, ((cmos1_lvds0 == 1) ? 0x7f : 0x7f));
  adrv9001_reg_write(0x1a73, ((cmos1_lvds0 == 1) ? 0xff : 0xff));
  adrv9001_reg_write(0x1a72, ((cmos1_lvds0 == 1) ? 0xf1 : 0xf1));
  adrv9001_reg_write(0x1a77, ((cmos1_lvds0 == 1) ? 0x7f : 0x7f));
  adrv9001_reg_write(0x1a76, ((cmos1_lvds0 == 1) ? 0xff : 0xff));
  adrv9001_reg_write(0x1a75, ((cmos1_lvds0 == 1) ? 0xf1 : 0xf1));
  adrv9001_reg_write(0x1a7a, ((cmos1_lvds0 == 1) ? 0x7f : 0x7f));
  adrv9001_reg_write(0x1a79, ((cmos1_lvds0 == 1) ? 0xff : 0xff));
  adrv9001_reg_write(0x1a78, ((cmos1_lvds0 == 1) ? 0xf1 : 0xf1));
  adrv9001_reg_write(0x1a00, ((cmos1_lvds0 == 1) ? 0xff : 0xff));
  adrv9001_reg_write(0x1a01, ((cmos1_lvds0 == 1) ? 0x04 : 0x04));
  adrv9001_reg_write(0x1a23, ((cmos1_lvds0 == 1) ? 0x33 : 0x33));
  adrv9001_reg_write(0x1a22, ((cmos1_lvds0 == 1) ? 0x33 : 0x33));
  adrv9001_reg_write(0x1a21, ((cmos1_lvds0 == 1) ? 0x2d : 0x2d));
  adrv9001_reg_field_write(0x1a1f,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xe6 : 0xe6));
  adrv9001_reg_field_write(0x1a20,  0, 0x07, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x1a8b, ((cmos1_lvds0 == 1) ? 0xc5 : 0xc5));
  adrv9001_reg_write(0x1a8c, ((cmos1_lvds0 == 1) ? 0x08 : 0x08));
  adrv9001_reg_write(0x1a8a, ((cmos1_lvds0 == 1) ? 0x02 : 0x02));
  adrv9001_reg_field_write(0x1a33,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x1a33,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_write(0x1a0a, ((cmos1_lvds0 == 1) ? 0x07 : 0x07));
  adrv9001_reg_write(0x1a0a, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x01b8, ((cmos1_lvds0 == 1) ? 0x02 : 0x02));
  adrv9001_reg_field_write(0x01e4,  0, 0x03, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_write(0x0197, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x0392, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));

  /* clock-gen config */

  adrv9001_reg_write(0x1a0a, ((cmos1_lvds0 == 1) ? 0x07 : 0x07));
  adrv9001_reg_write(0x1a0a, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01b8,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x01b9,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x01ba,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x01bb,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x01bc,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x01e4,  0, 0x03, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x039d,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x0f : 0x0f));
  adrv9001_reg_write(0x00b5, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_write(0x00a0, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_write(0x00b3, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_write(0x061e, ((cmos1_lvds0 == 1) ? 0x02 : 0x02));
  adrv9001_reg_write(0x0a1e, ((cmos1_lvds0 == 1) ? 0x02 : 0x02));
  adrv9001_reg_field_write(0x01b8,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x02 : 0x02));
  adrv9001_reg_field_write(0x01b9,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x04 : 0x04));
  adrv9001_reg_field_write(0x01ba,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x04 : 0x04));
  adrv9001_reg_field_write(0x01bb,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x04 : 0x04));
  adrv9001_reg_field_write(0x01bc,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x04 : 0x04));

  /* receive-1 data path clocks */

  adrv9001_reg_field_write(0x0e4f,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e4f,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e4f,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0e1a,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e4f,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0e1a,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e1a,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0e4f,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e4f,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e4f,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e4f,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e1b,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e31,  0, 0x0f, ((cmos1_lvds0 == 1) ? 0x09 : 0x00));
  adrv9001_reg_field_write(0x0e1b,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e1b,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e1b,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e1b,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e1b,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e1b,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e1b,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e1c,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e1c,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e1c,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e1c,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e1c,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0ec6,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x67 : 0x08));
  adrv9001_reg_field_write(0x0ec7,  0, 0x7f, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x10aa,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e3a,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0e32,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x2c : 0x00));
  adrv9001_reg_field_write(0x0e33,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xff : 0x00));

  /* obs-receive-1 data path clocks */

  adrv9001_reg_field_write(0x0f80,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f80,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f80,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0f7d,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f80,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0f7d,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f7d,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0f80,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f80,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f80,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f80,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f7e,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f81,  0, 0x0f, ((cmos1_lvds0 == 1) ? 0x09 : 0x00));
  adrv9001_reg_field_write(0x0f7e,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f7e,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f7e,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f7e,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f7e,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f7e,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f7e,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f7f,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f7f,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f7f,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f7f,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f7f,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0ec8,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x67 : 0x08));
  adrv9001_reg_field_write(0x0ec9,  0, 0x7f, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f96,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e3a,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0e34,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x2c : 0x00));
  adrv9001_reg_field_write(0x0e35,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xff : 0x00));

  /* obs-receive-2 data path clocks */

  adrv9001_reg_field_write(0x0f9a,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f9a,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f9a,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0f97,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f9a,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0f97,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f97,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0f9a,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f9a,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f9a,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f9a,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f98,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f9b,  0, 0x0f, ((cmos1_lvds0 == 1) ? 0x09 : 0x00));
  adrv9001_reg_field_write(0x0f98,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f98,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f98,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f98,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f98,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f98,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f98,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f99,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f99,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f99,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f99,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0f99,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0eca,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x67 : 0x08));
  adrv9001_reg_field_write(0x0ecb,  0, 0x7f, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb0,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e3a,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0e36,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x2c : 0x00));
  adrv9001_reg_field_write(0x0e37,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xff : 0x00));

  /* obs-receive-3 data path clocks */

  adrv9001_reg_field_write(0x0fb4,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0fb4,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0fb4,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0fb1,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb4,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0fb1,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0fb1,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0fb4,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb4,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0fb4,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb4,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0fb2,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb5,  0, 0x0f, ((cmos1_lvds0 == 1) ? 0x09 : 0x00));
  adrv9001_reg_field_write(0x0fb2,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0fb2,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0fb2,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0fb2,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0fb2,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0fb2,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb2,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb3,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb3,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb3,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb3,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fb3,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0ecc,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x67 : 0x08));
  adrv9001_reg_field_write(0x0ecd,  0, 0x7f, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0fca,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e3a,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0e38,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x2c : 0x00));
  adrv9001_reg_field_write(0x0e39,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xff : 0x00));

  /* receive-1 ssi clocks */

  adrv9001_reg_field_write(0x0e05,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xe0 : 0x01));
  adrv9001_reg_field_write(0x0e06,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* obs-receive-1 ssi clocks */

  adrv9001_reg_field_write(0x0e07,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xe0 : 0x01));
  adrv9001_reg_field_write(0x0e08,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* obs-receive-2 ssi clocks */

  adrv9001_reg_field_write(0x0e09,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xe0 : 0x01));
  adrv9001_reg_field_write(0x0e0a,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* obs-receive-3 ssi clocks */

  adrv9001_reg_field_write(0x0e0b,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xe0 : 0x01));
  adrv9001_reg_field_write(0x0e0c,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* receive-1 profile */

  adrv9001_reg_field_write(0x0e00,  1, 0x03, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0e00,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e04,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0e04,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e04,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0e0e,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e0e,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e11,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0e12,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e10,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0e10,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0e18,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01b9,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x09 : 0x09));
  adrv9001_reg_field_write(0x018e,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0f70,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));

  /* receive-2 data path clocks */

  adrv9001_reg_field_write(0x124f,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x124f,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x124f,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x121a,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x124f,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x121a,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x121a,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x124f,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x124f,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x124f,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x124f,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x121b,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1231,  0, 0x0f, ((cmos1_lvds0 == 1) ? 0x09 : 0x00));
  adrv9001_reg_field_write(0x121b,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x121b,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x121b,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x121b,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x121b,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x121b,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x121b,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x121c,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x121c,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x121c,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x121c,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x121c,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x12c6,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x67 : 0x08));
  adrv9001_reg_field_write(0x12c7,  0, 0x7f, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x14aa,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x123a,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x1232,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x2c : 0x00));
  adrv9001_reg_field_write(0x1233,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xff : 0x00));

  /* obs-receive-1 data path clocks */

  adrv9001_reg_field_write(0x1380,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1380,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1380,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x137d,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1380,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x137d,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x137d,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x1380,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1380,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1380,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1380,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x137e,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1381,  0, 0x0f, ((cmos1_lvds0 == 1) ? 0x09 : 0x00));
  adrv9001_reg_field_write(0x137e,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x137e,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x137e,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x137e,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x137e,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x137e,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x137e,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x137f,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x137f,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x137f,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x137f,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x137f,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x12c8,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x67 : 0x08));
  adrv9001_reg_field_write(0x12c9,  0, 0x7f, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1396,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x123a,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x1234,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x2c : 0x00));
  adrv9001_reg_field_write(0x1235,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xff : 0x00));

  /* obs-receive-2 data path clocks */

  adrv9001_reg_field_write(0x139a,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x139a,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x139a,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x1397,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x139a,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x1397,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1397,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x139a,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x139a,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x139a,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x139a,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1398,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x139b,  0, 0x0f, ((cmos1_lvds0 == 1) ? 0x09 : 0x00));
  adrv9001_reg_field_write(0x1398,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1398,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1398,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1398,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1398,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1398,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1398,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1399,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1399,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1399,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1399,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1399,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x12ca,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x67 : 0x08));
  adrv9001_reg_field_write(0x12cb,  0, 0x7f, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b0,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x123a,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x1236,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x2c : 0x00));
  adrv9001_reg_field_write(0x1237,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xff : 0x00));

  /* obs-receive-3 data path clocks */

  adrv9001_reg_field_write(0x13b4,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x13b4,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x13b4,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x13b1,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b4,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x13b1,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x13b1,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x13b4,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b4,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x13b4,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b4,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x13b2,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b5,  0, 0x0f, ((cmos1_lvds0 == 1) ? 0x09 : 0x00));
  adrv9001_reg_field_write(0x13b2,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x13b2,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x13b2,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x13b2,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x13b2,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x13b2,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b2,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b3,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b3,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b3,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b3,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13b3,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x12cc,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x67 : 0x08));
  adrv9001_reg_field_write(0x12cd,  0, 0x7f, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x13ca,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x123a,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x1238,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x2c : 0x00));
  adrv9001_reg_field_write(0x1239,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xff : 0x00));

  /* receive-1 ssi clocks */

  adrv9001_reg_field_write(0x1205,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xe0 : 0x01));
  adrv9001_reg_field_write(0x1206,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* obs-receive-1 ssi clocks */

  adrv9001_reg_field_write(0x1207,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xe0 : 0x01));
  adrv9001_reg_field_write(0x1208,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* obs-receive-2 ssi clocks */

  adrv9001_reg_field_write(0x1209,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xe0 : 0x01));
  adrv9001_reg_field_write(0x120a,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* obs-receive-3 ssi clocks */

  adrv9001_reg_field_write(0x120b,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xe0 : 0x01));
  adrv9001_reg_field_write(0x120c,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* receive-2 profile */

  adrv9001_reg_field_write(0x1200,  1, 0x03, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x1200,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1204,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x1204,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1204,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x120e,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x120e,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1211,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x1212,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1210,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x1210,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1218,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01ba,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x09 : 0x09));
  adrv9001_reg_field_write(0x018f,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x1370,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));

  /* transmit-1 data path clocks */

  adrv9001_reg_field_write(0x062b,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062b,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062b,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062b,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062b,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062b,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062c,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062c,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x062c,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x062c,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x062c,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x062c,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x062c,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062d,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062d,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062d,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x062d,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x062d,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x062f,  0, 0x0f, ((cmos1_lvds0 == 1) ? 0x09 : 0x00));
  adrv9001_reg_field_write(0x062e,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x062e,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x062f,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0630,  0, 0x07, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0631,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0632,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0633,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x064f,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x062f,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0637,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0635,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x2c : 0x00));
  adrv9001_reg_field_write(0x0636,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xff : 0x00));
  adrv9001_reg_field_write(0x0190,  4, 0x03, ((cmos1_lvds0 == 1) ? 0x03 : 0x00));

  /* transmit-1 ssi clocks */

  adrv9001_reg_field_write(0x0618,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x062d,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0612,  1, 0x03, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0612,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0619,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xf0 : 0x01));
  adrv9001_reg_field_write(0x061a,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0618,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0618,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0628,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x062d,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x061c,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x061c,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x061e,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x061f,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0628,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x061d,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x061d,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));

  /* transmit-1 profile */

  adrv9001_reg_field_write(0x01bb,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x09 : 0x09));
  adrv9001_reg_field_write(0x06c4,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));

  /* transmit-2 data path clocks */

  adrv9001_reg_field_write(0x0a2b,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2b,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2b,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2b,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2b,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2b,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2c,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2c,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a2c,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a2c,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a2c,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a2c,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a2c,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2d,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2d,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2d,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0a2d,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a2d,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0a2f,  0, 0x0f, ((cmos1_lvds0 == 1) ? 0x09 : 0x00));
  adrv9001_reg_field_write(0x0a2e,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0a2e,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a2f,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a30,  0, 0x07, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a31,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a32,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0a33,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a4f,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a2f,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a37,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0a35,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x2c : 0x00));
  adrv9001_reg_field_write(0x0a36,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xff : 0x00));
  adrv9001_reg_field_write(0x0191,  4, 0x03, ((cmos1_lvds0 == 1) ? 0x03 : 0x00));

  /* transmit-2 ssi clocks */

  adrv9001_reg_field_write(0x0a18,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a2d,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a12,  1, 0x03, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0a12,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a19,  0, 0xff, ((cmos1_lvds0 == 1) ? 0xf0 : 0x01));
  adrv9001_reg_field_write(0x0a1a,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a18,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0a18,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a28,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0a2d,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0a1c,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a1c,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a1e,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a1f,  0, 0xff, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0a28,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a1d,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0a1d,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));

  /* transmit-2 profile */

  adrv9001_reg_field_write(0x01bc,  0, 0x1f, ((cmos1_lvds0 == 1) ? 0x09 : 0x09));
  adrv9001_reg_field_write(0x0ac4,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));

  /* digital clocks */

  adrv9001_reg_field_write(0x0195,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0192,  0, 0x03, ((cmos1_lvds0 == 1) ? 0x02 : 0x02));
  adrv9001_reg_field_write(0x0193,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_write(0x0395, ((cmos1_lvds0 == 1) ? 0x11 : 0x11));

  adrv9001_reg_field_write(0x03f2,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0193,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));

  /* mcs clear */

  adrv9001_reg_field_write(0x01ec,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01ec,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01ec,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01ec,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01ec,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x01ec,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x01ec,  4, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x01ec,  5, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_read(0x01e9);

  adrv9001_reg_field_write(0x01e8,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));

  /* mcs internal set */

  adrv9001_reg_field_write(0x01e7,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01e8,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));

  /* mcs internal toggle */

  adrv9001_reg_field_write(0x01e8,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01e8,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));

  adrv9001_reg_field_write(0x03f2,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00d2,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));

  /* receive-1 ssi cmos io-config */

  adrv9001_reg_field_write(0x0077,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0077,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0077,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0077,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x007a,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x007a,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x007a,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x007a,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x007d,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x007d,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x007d,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x007d,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0080,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0080,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0080,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0080,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));

  /* receive-2 ssi cmos io-config */

  adrv9001_reg_field_write(0x0083,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0083,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0083,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0083,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0086,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0086,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0086,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0086,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0089,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0089,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0089,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0089,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x008c,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x008c,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x008c,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x008c,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));

  /* transmit-1 ssi cmos io-config */

  adrv9001_reg_field_write(0x0090,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0090,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0090,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0090,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0094,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0094,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0094,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0094,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0098,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0098,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x0098,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0098,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x009c,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x009c,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x009c,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x009c,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x009f,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x009f,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x009f,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x009f,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* transmit-1 ssi cmos io-config */

  adrv9001_reg_field_write(0x00a3,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x00a3,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00a3,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00a3,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00a7,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x00a7,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00a7,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00a7,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x00ab,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00ab,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00ab,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x00ab,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00af,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00af,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00af,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00af,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00b2,  3, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00b2,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x00b2,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));
  adrv9001_reg_field_write(0x00b2,  6, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  adrv9001_reg_field_write(0x00b5,  0, 0x03, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));

  /* receive-1 ssi lvds io-config */

  adrv9001_reg_field_write(0x0078,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x007e,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0081,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x007b,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));

  /* receive-2 ssi lvds io-config */

  adrv9001_reg_field_write(0x0084,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x008a,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x008d,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0087,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));

  /* transmit-1 ssi lvds io-config */

  adrv9001_reg_field_write(0x0091,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0099,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x009d,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0095,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x00a0,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x008f,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0093,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0097,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x009b,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));

  /* transmit-2 ssi lvds io-config */

  adrv9001_reg_field_write(0x00a4,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x00ac,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x00b0,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x00a8,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x00b3,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x00a2,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x00a6,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x00aa,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x00ae,  7, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));

  adrv9001_reg_write(0x0091, ((cmos1_lvds0 == 1) ? 0x07 : 0x07));
  adrv9001_reg_write(0x00a4, ((cmos1_lvds0 == 1) ? 0x07 : 0x07));

  /* receive-1 ssi enable */

  adrv9001_reg_field_write(0x0e10,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0e10,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0e10,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0e01,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* receive-2 ssi enable */

  adrv9001_reg_field_write(0x1210,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x1210,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x1210,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x1201,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* transmit-1 ssi enable */

  adrv9001_reg_field_write(0x061d,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x061d,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x061d,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0613,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0613,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0613,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* transmit-2 ssi enable */

  adrv9001_reg_field_write(0x0a1d,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0a1d,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0a1d,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x01));
  adrv9001_reg_field_write(0x0a13,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a13,  2, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));
  adrv9001_reg_field_write(0x0a13,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x00));

  /* mcs internal toggle */

  adrv9001_reg_field_write(0x01e8,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x01e8,  1, 0x01, ((cmos1_lvds0 == 1) ? 0x00 : 0x00));

  adrv9001_reg_field_write(0x0e3c,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x123c,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0651,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));
  adrv9001_reg_field_write(0x0a51,  0, 0x01, ((cmos1_lvds0 == 1) ? 0x01 : 0x01));

  /* receive ssi ramp */

  adrv9001_reg_field_write(0x0e13,  0, 0x01, 0x01);
  adrv9001_reg_field_write(0x0e15,  0, 0xff, 0x00);
  adrv9001_reg_field_write(0x0e16,  0, 0xff, 0x00);
  adrv9001_reg_field_write(0x0e14,  0, 0x01, 0x01);
  adrv9001_reg_field_write(0x0e14,  0, 0x01, 0x00);
  adrv9001_reg_field_write(0x0e13,  1, 0x01, 0x01);
  adrv9001_reg_field_write(0x1213,  0, 0x01, 0x01);
  adrv9001_reg_field_write(0x1215,  0, 0xff, 0x00);
  adrv9001_reg_field_write(0x1216,  0, 0xff, 0x00);
  adrv9001_reg_field_write(0x1214,  0, 0x01, 0x01);
  adrv9001_reg_field_write(0x1214,  0, 0x01, 0x00);
  adrv9001_reg_field_write(0x1213,  1, 0x01, 0x01);

  /* receive cmos ramp */

  adrv9001_reg_field_write(0x0e02,  0, 0x01, 0x01);
  adrv9001_reg_field_write(0x0e03,  1, 0x01, 0x00);
  adrv9001_reg_field_write(0x0e03,  4, 0x0f, 0x00);
  adrv9001_reg_field_write(0x0e03,  0, 0x01, 0x01);
  adrv9001_reg_field_write(0x0e03,  0, 0x01, 0x00);
  adrv9001_reg_field_write(0x0e02,  1, 0x01, 0x01);
  adrv9001_reg_field_write(0x1202,  0, 0x01, 0x01);
  adrv9001_reg_field_write(0x1203,  1, 0x01, 0x00);
  adrv9001_reg_field_write(0x1203,  4, 0x0f, 0x00);
  adrv9001_reg_field_write(0x1203,  0, 0x01, 0x01);
  adrv9001_reg_field_write(0x1203,  0, 0x01, 0x00);
  adrv9001_reg_field_write(0x1202,  1, 0x01, 0x01);

  return;
}

// **********************************************************************************
// **********************************************************************************

