// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       ADRV9001 Platform
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#ifndef ADRV9001_H
#define ADRV9001_H

#include "common.h"

void adrv9001_reg_write(uint32_t addr, uint32_t data);
uint32_t adrv9001_reg_read(uint32_t addr);

void adrv9001_reg_field_write(uint32_t addr, uint32_t pos,
  uint32_t mask, uint32_t data);
uint32_t adrv9001_reg_field_read(uint32_t addr, uint32_t pos,
  uint32_t mask);

void adrv9001_delay_ms(uint32_t delay);
uint32_t adrv9001_tx_data_capture(uint32_t tx1_tx0);
void adrv9001_tx2rx_loopback(uint32_t rx1_rx0);
void adrv9001_setup(uint32_t cmos1_lvds0);

#endif

// **********************************************************************************
// **********************************************************************************
