// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       Platform Common
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#include "adrv9001.h"
#include "axi_common.h"
#include "axi_mspi.h"

void adrv9001_reg_write(uint32_t addr, uint32_t data) {

  uint32_t dwords[3];

  dwords[0] = (addr >> 8) & 0xff;
  dwords[1] = (addr >> 0) & 0xff;
  dwords[2] = (data >> 0) & 0xff;

  axi_mspi_chip_select_set(0, AXI_MSPI_ID, 0, 0x0);
  axi_mspi_xfer(0, AXI_MSPI_ID, &dwords[0], 3, 0, 0);
  axi_mspi_chip_select_set(0, AXI_MSPI_ID, 0, 0x1);
  return;
}

uint32_t adrv9001_reg_read(uint32_t addr) {

  uint32_t dwords[3];

  dwords[0] = ((addr >> 8) & 0xff) | 0x80;
  dwords[1] = ((addr >> 0) & 0xff) | 0x00;
  dwords[2] = ((0xff >> 0) & 0xff) | 0x00;

  axi_mspi_chip_select_set(0, AXI_MSPI_ID, 0, 0x0);
  axi_mspi_xfer(0, AXI_MSPI_ID, &dwords[0], 2, &dwords[2], 1);
  axi_mspi_chip_select_set(0, AXI_MSPI_ID, 0, 0x1);
  return(dwords[2]);
}

void adrv9001_reg_field_write(uint32_t addr, uint32_t pos,
  uint32_t mask, uint32_t data) {

  uint32_t value;

  value = adrv9001_reg_read(addr);
  value = (value & ~(mask << pos)) | (data << pos);
  adrv9001_reg_write(addr, value);
  return;
}

uint32_t adrv9001_reg_field_read(uint32_t addr, uint32_t pos,
  uint32_t mask) {

  uint32_t value;

  value = adrv9001_reg_read(addr);
  value = (value >> pos) & mask;
  return(value);
}

void adrv9001_delay_ms(uint32_t delay) {

  axi_sysid_delay_us(0, AXI_SYSID_ID, (1000 * delay));
  return;
}

uint32_t adrv9001_tx_data_capture(uint32_t tx1_tx0) {

  uint32_t base;
  uint32_t data;
  int32_t q1_i0;

  base = (tx1_tx0 == 1) ? 0x0a00 : 0x0600;
  data = 0;

  for (q1_i0 = 0; q1_i0 < 2; q1_i0++) {
    adrv9001_reg_field_write((base + 0x20), 4, 0x1, q1_i0);
    adrv9001_reg_field_write((base + 0x20), 3, 0x1, 0x0);
    adrv9001_reg_field_write((base + 0x20), 3, 0x1, 0x1);
    adrv9001_delay_ms(1);
    data = (data << 8) | adrv9001_reg_read(base + 0x27);
    data = (data << 8) | adrv9001_reg_read(base + 0x26);
  }

  return(data);
}

void adrv9001_tx2rx_loopback(uint32_t rx1_rx0) {
 
  uint32_t base;

  base = (rx1_rx0 == 1) ? 0x1200 : 0x0e00;

  adrv9001_reg_field_write((base + 0x02), 1, 0x1, 0x0);
  adrv9001_reg_field_write((base + 0x02), 0, 0x1, 0x0);
  adrv9001_reg_field_write((base + 0x01), 4, 0x1, 0x1);
  adrv9001_reg_field_write((base + 0x13), 1, 0x1, 0x0);
  adrv9001_reg_field_write((base + 0x13), 0, 0x1, 0x0);
  adrv9001_reg_field_write((base + 0x10), 7, 0x1, 0x1);
}

// **********************************************************************************
// **********************************************************************************

