## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       ZC706 IPI block design
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

## PS7

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ processing_system7 && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_cpu
lappend ip_param_list config.preset zc706
lappend ip_param_list config.pcw_ttc0_peripheral_enable 0
lappend ip_param_list config.pcw_en_clk1_port 1
lappend ip_param_list config.pcw_en_clk2_port 1
lappend ip_param_list config.pcw_fpga0_peripheral_freqmhz 100.0
lappend ip_param_list config.pcw_fpga1_peripheral_freqmhz 200.0
lappend ip_param_list config.pcw_fpga2_peripheral_freqmhz 200.0
lappend ip_param_list config.pcw_use_fabric_interrupt 1
lappend ip_param_list config.pcw_irq_f2p_intr 1
lappend ip_param_list config.pcw_use_m_axi_gp1 1
set_property -dict $ip_param_list [get_bd_cells sys_cpu]
create_bd_intf_port -mode master -vlnv xilinx.com:display_processing_system7:fixedio_rtl:1.0 ps7_io
connect_bd_intf_net [get_bd_intf_pins sys_cpu/fixed_io] [get_bd_intf_ports ps7_io]
create_bd_intf_port -mode master -vlnv xilinx.com:interface:ddrx_rtl:1.0 ps7_ddr
connect_bd_intf_net [get_bd_intf_pins sys_cpu/ddr] [get_bd_intf_ports ps7_ddr]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu/fclk_clk0]
connect_bd_net -net sys_200m_clk [get_bd_pins sys_cpu/fclk_clk1]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu/m_axi_gp0_aclk]
connect_bd_net -net aximm_clk [get_bd_pins sys_cpu/m_axi_gp1_aclk]

## AXILite Reset

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ proc_sys_reset && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_cpu_resetgen
connect_bd_net [get_bd_pins sys_cpu/fclk_reset0_n] [get_bd_pins sys_cpu_resetgen/ext_reset_in]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu_resetgen/slowest_sync_clk]  
connect_bd_net -net axilite_resetn [get_bd_pins sys_cpu_resetgen/peripheral_aresetn]

## AXILite Interconnect

variable axilite_index
set axilite_index -1
add_axilite_peripheral 0x0 sys_cpu/m_axi_gp0

## Memory (PL-DDR)

variable aximm_range
set aximm_range 1G

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ mig_7series && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_ddr
file copy -force $m_root/projects/common/hdl/zc706_mig.prj [get_property ip_dir \
  [get_ips [get_property config.component_name [get_bd_cells sys_ddr]]]]
set_property config.xml_input_file zc706_mig.prj [get_bd_cells sys_ddr]
create_bd_port -dir I -type rst pl_ddr_reset
set_property config.polarity active_high [get_bd_ports pl_ddr_reset]
connect_bd_net [get_bd_ports pl_ddr_reset] [get_bd_pins sys_ddr/sys_rst]
create_bd_intf_port -mode slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 pl_ddr_refclk
connect_bd_intf_net [get_bd_intf_ports pl_ddr_refclk] [get_bd_intf_pins sys_ddr/sys_clk]
create_bd_intf_port -mode master -vlnv xilinx.com:interface:ddrx_rtl:1.0 pl_ddr
connect_bd_intf_net [get_bd_intf_pins sys_ddr/ddr3] [get_bd_intf_ports pl_ddr]
connect_bd_net -net aximm_clk [get_bd_pins sys_ddr/ui_clk]

## AXIMM Reset

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ proc_sys_reset && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_ddr_resetgen
connect_bd_net [get_bd_pins sys_ddr/ui_clk_sync_rst] [get_bd_pins sys_ddr_resetgen/ext_reset_in]
connect_bd_net -net axilite_resetn [get_bd_pins sys_ddr_resetgen/aux_reset_in]
connect_bd_net -net aximm_clk [get_bd_pins sys_ddr_resetgen/slowest_sync_clk]
connect_bd_net -net aximm_resetn [get_bd_pins sys_ddr_resetgen/peripheral_aresetn]
connect_bd_net -net aximm_resetn [get_bd_pins sys_ddr/aresetn]

## AXIMM Interconnect

variable aximm_index
set aximm_index -1
add_aximm_peripheral 0x0 sys_ddr/s_axi
add_aximm_peripheral 0x80000000 sys_cpu/m_axi_gp1

## Interrupts

variable intr_index
set intr_index -1
add_interrupt sys_cpu/irq_f2p

## ##################################################################################
## ##################################################################################

save_bd_design

## ##################################################################################
## ##################################################################################

