## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       ADRV9001 Embedded System Peripherals
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## SPI

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_mspi && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_mspi
connect_bd_net -net axilite_clk [get_bd_pins axi_mspi/s_axi_aclk]  
connect_bd_net -net axilite_resetn [get_bd_pins axi_mspi/s_axi_aresetn]
add_axilite_peripheral 0x44a00000 axi_mspi/s_axi
add_interrupt axi_mspi/interrupt
make_bd_pins_external -name spi_csn [get_bd_pins axi_mspi/spi_csn]
make_bd_pins_external -name spi_clk [get_bd_pins axi_mspi/spi_clk]
make_bd_pins_external -name spi_mosi_t [get_bd_pins axi_mspi/spi_mosi_t]
make_bd_pins_external -name spi_mosi_o [get_bd_pins axi_mspi/spi_mosi_o]
make_bd_pins_external -name spi_mosi_i [get_bd_pins axi_mspi/spi_mosi_i]
make_bd_pins_external -name spi_miso [get_bd_pins axi_mspi/spi_miso]

## ##################################################################################
## ##################################################################################
## System Id

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_sysid && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_sysid
lappend ip_param_list config.status_width 3
lappend ip_param_list config.gpio_in_width 6
lappend ip_param_list config.gpio_out_width 6
lappend ip_param_list config.sys_version $PLATFORM_VERSION
lappend ip_param_list config.sys_params $PLATFORM_PARAMS
lappend ip_param_list config.sys_info_0 [gen_system_id $PLATFORM_ID]
lappend ip_param_list config.sys_info_1 [gen_build_id]
lappend ip_param_list config.sys_build [gen_build_version]
set_property -dict $ip_param_list [get_bd_cells axi_sysid]
connect_bd_net -net axilite_clk [get_bd_pins axi_sysid/axilite_clk]  
connect_bd_net -net axilite_resetn [get_bd_pins axi_sysid/axilite_resetn]
add_axilite_peripheral 0x43000000 axi_sysid/axilite
add_interrupt axi_sysid/interrupt
make_bd_pins_external -name gpio_in [get_bd_pins axi_sysid/gpio_in]
make_bd_pins_external -name gpio_out [get_bd_pins axi_sysid/gpio_out]

## ##################################################################################
## ##################################################################################
## System status

set ip_vlnv [get_ipdefs -all -filter {name =~ xlconcat && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_status
set_property config.num_ports 3 [get_bd_cells sys_status]
connect_bd_net [get_bd_pins sys_status/dout] [get_bd_pins axi_sysid/status]
connect_bd_net [get_bd_pins sys_ddr/mmcm_locked] [get_bd_pins sys_status/in0]
connect_bd_net [get_bd_pins sys_ddr/init_calib_complete] [get_bd_pins sys_status/in1]
make_bd_pins_external -name vadj_err [get_bd_pins sys_status/in2]

## ##################################################################################
## ##################################################################################
## AXI-ADRV9001

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_adrv9001 && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_adrv9001
create_bd_intf_port -mode slave -vlnv analog.com:interface:device_io_rtl:1.0 dio
connect_bd_intf_net [get_bd_intf_ports dio] [get_bd_intf_pins axi_adrv9001/dio]
create_bd_intf_port -mode slave -vlnv analog.com:interface:system_io_rtl:1.0 sys
connect_bd_intf_net [get_bd_intf_ports sys] [get_bd_intf_pins axi_adrv9001/sys]
connect_bd_net [get_bd_pins axi_adrv9001/gpio_out_clk] [get_bd_pins axi_adrv9001/gpio_clk]
connect_bd_net [get_bd_pins axi_adrv9001/dev_out_clk] [get_bd_pins axi_adrv9001/dev_clk]
connect_bd_net [get_bd_pins axi_adrv9001/mcs_out_int] [get_bd_pins axi_adrv9001/mcs_int]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_clk] [get_bd_pins axi_adrv9001/tdd_clk]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_resetn] [get_bd_pins axi_adrv9001/tdd_resetn]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_state] [get_bd_pins axi_adrv9001/tdd_state]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_frm_toggle] [get_bd_pins axi_adrv9001/tdd_frm_toggle]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_clk_cnt] [get_bd_pins axi_adrv9001/tdd_clk_cnt]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_frm_cnt] [get_bd_pins axi_adrv9001/tdd_frm_cnt]
connect_bd_net -net sys_200m_clk [get_bd_pins axi_adrv9001/sys_200m_clk]
connect_bd_net -net axilite_clk [get_bd_pins axi_adrv9001/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_adrv9001/axilite_resetn]
add_axilite_peripheral 0x43010000 axi_adrv9001/axilite
add_interrupt axi_adrv9001/interrupt
make_bd_pins_external -name trig [get_bd_pins axi_adrv9001/trig]

## ##################################################################################
## ##################################################################################
## TX0-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_txdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_tx0
set_property config.instance_id 0 [get_bd_cells axi_dma_tx0]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_tx0/trig]
connect_bd_net [get_bd_pins axi_adrv9001/tx0_clk] [get_bd_pins axi_dma_tx0/tx_clk]
connect_bd_net [get_bd_pins axi_adrv9001/tx0_resetn] [get_bd_pins axi_dma_tx0/tx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_dma_tx0/tx] [get_bd_intf_pins axi_adrv9001/tx0]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_tx0/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_tx0/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_tx0/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_tx0/aximm_resetn]
add_axilite_peripheral 0x43020000 axi_dma_tx0/axilite
add_aximm_peripheral 0x80000000 axi_dma_tx0/aximm
add_interrupt axi_dma_tx0/interrupt

## ##################################################################################
## ##################################################################################
## TX1-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_txdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_tx1
set_property config.instance_id 1 [get_bd_cells axi_dma_tx1]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_tx1/trig]
connect_bd_net [get_bd_pins axi_adrv9001/tx1_clk] [get_bd_pins axi_dma_tx1/tx_clk]
connect_bd_net [get_bd_pins axi_adrv9001/tx1_resetn] [get_bd_pins axi_dma_tx1/tx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_dma_tx1/tx] [get_bd_intf_pins axi_adrv9001/tx1]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_tx1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_tx1/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_tx1/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_tx1/aximm_resetn]
add_axilite_peripheral 0x43030000 axi_dma_tx1/axilite
add_aximm_peripheral 0x80000000 axi_dma_tx1/aximm
add_interrupt axi_dma_tx1/interrupt

## ##################################################################################
## ##################################################################################
## RX0-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_rx0
set_property config.instance_id 2 [get_bd_cells axi_dma_rx0]
set_property config.axis_data_width 64 [get_bd_cells axi_dma_rx0]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_rx0/trig]
connect_bd_net [get_bd_pins axi_adrv9001/rx0_clk] [get_bd_pins axi_dma_rx0/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001/rx0_resetn] [get_bd_pins axi_dma_rx0/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001/rx0] [get_bd_intf_pins axi_dma_rx0/rx]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_rx0/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_rx0/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_rx0/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_rx0/aximm_resetn]
add_axilite_peripheral 0x43040000 axi_dma_rx0/axilite
add_aximm_peripheral 0x80000000 axi_dma_rx0/aximm
add_interrupt axi_dma_rx0/interrupt

## ##################################################################################
## ##################################################################################
## RX1-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_rx1
set_property config.instance_id 3 [get_bd_cells axi_dma_rx1]
set_property config.axis_data_width 64 [get_bd_cells axi_dma_rx1]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_rx1/trig]
connect_bd_net [get_bd_pins axi_adrv9001/rx1_clk] [get_bd_pins axi_dma_rx1/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001/rx1_resetn] [get_bd_pins axi_dma_rx1/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001/rx1] [get_bd_intf_pins axi_dma_rx1/rx]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_rx1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_rx1/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_rx1/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_rx1/aximm_resetn]
add_axilite_peripheral 0x43050000 axi_dma_rx1/axilite
add_aximm_peripheral 0x80000000 axi_dma_rx1/aximm
add_interrupt axi_dma_rx1/interrupt

## ##################################################################################
## ##################################################################################
## ORX0-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_orx0
set_property config.instance_id 4 [get_bd_cells axi_dma_orx0]
set_property config.axis_data_width 64 [get_bd_cells axi_dma_orx0]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_orx0/trig]
connect_bd_net [get_bd_pins axi_adrv9001/rx0_clk] [get_bd_pins axi_dma_orx0/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001/rx0_resetn] [get_bd_pins axi_dma_orx0/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001/orx0] [get_bd_intf_pins axi_dma_orx0/rx]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_orx0/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_orx0/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_orx0/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_orx0/aximm_resetn]
add_axilite_peripheral 0x43060000 axi_dma_orx0/axilite
add_aximm_peripheral 0x80000000 axi_dma_orx0/aximm
add_interrupt axi_dma_orx0/interrupt

## ##################################################################################
## ##################################################################################
## ORX1-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_orx1
set_property config.instance_id 5 [get_bd_cells axi_dma_orx1]
set_property config.axis_data_width 64 [get_bd_cells axi_dma_orx1]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_orx1/trig]
connect_bd_net [get_bd_pins axi_adrv9001/rx1_clk] [get_bd_pins axi_dma_orx1/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001/rx1_resetn] [get_bd_pins axi_dma_orx1/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001/orx1] [get_bd_intf_pins axi_dma_orx1/rx]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_orx1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_orx1/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_orx1/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_orx1/aximm_resetn]
add_axilite_peripheral 0x43070000 axi_dma_orx1/axilite
add_aximm_peripheral 0x80000000 axi_dma_orx1/aximm
add_interrupt axi_dma_orx1/interrupt

## ##################################################################################
## ##################################################################################
## GAIN-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_gain
set_property config.instance_id 6 [get_bd_cells axi_dma_gain]
set_property config.axis_data_width 8 [get_bd_cells axi_dma_gain]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_gain/trig]
connect_bd_net [get_bd_pins axi_adrv9001/gpio_out_clk] [get_bd_pins axi_dma_gain/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001/gpio_resetn] [get_bd_pins axi_dma_gain/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001/gpio_gain] [get_bd_intf_pins axi_dma_gain/rx]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_gain/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_gain/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_gain/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_gain/aximm_resetn]
add_axilite_peripheral 0x43080000 axi_dma_gain/axilite
add_aximm_peripheral 0x80000000 axi_dma_gain/aximm
add_interrupt axi_dma_gain/interrupt

## ##################################################################################
## ##################################################################################
## CLOCKS

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ clk_wiz && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_clkgen
lappend ip_param_list config.use_dyn_reconfig true
lappend ip_param_list config.jitter_sel min_o_jitter
lappend ip_param_list config.prim_in_freq.value_src user
lappend ip_param_list config.prim_in_freq 200
lappend ip_param_list config.clkout1_requested_out_freq 38.4
set_property -dict $ip_param_list [get_bd_cells axi_clkgen]
connect_bd_net -net axilite_clk [get_bd_pins axi_clkgen/s_axi_aclk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_clkgen/s_axi_aresetn]
connect_bd_net [get_bd_pins sys_cpu/fclk_clk2] [get_bd_pins axi_clkgen/clk_in1]
make_bd_pins_external -name sys_dev_out_clk [get_bd_pins axi_clkgen/clk_out1]
add_axilite_peripheral 0x43100000 axi_clkgen/s_axi_lite

## ##################################################################################
## ##################################################################################

save_bd_design

## ##################################################################################
## ##################################################################################

