## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       ADRV9001 Rev.A ZC706
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set PLATFORM_VERSION 0x060700

set mode [lindex $argv 0]
if {($mode ne "lvds") && ($mode ne "cmos")} {
  return -code error [format "ERROR: mode $mode NOT supported!"]
}

if {$mode eq "lvds"} {
  set PLATFORM_PARAMS 0x100b
  set PLATFORM_ID {ADRV9001x2 Rev.B ZC706 LVDS}
}

if {$mode eq "cmos"} {
  set PLATFORM_PARAMS 0x110b
  set PLATFORM_ID {ADRV9001x2 Rev.B ZC706 CMOS}
}

source ../../../bin/vivado_include.tcl

create_project adrv9001x2_zc706 $mode -part xc7z045ffg900-2 -force
set_property board_part xilinx.com:zc706:part0:1.4 [current_project]
msg_settings none

set_property ip_repo_paths {../../../library} [current_fileset]
update_ip_catalog

set ip_core_list {}
lappend ip_core_list ../../../library/axi_sysid
lappend ip_core_list ../../../library/axi_mspi
lappend ip_core_list ../../../library/axi_txdma
lappend ip_core_list ../../../library/axi_rxdma
lappend ip_core_list ../../../library/axi_adrv9001

create_bd_design system
source ../../common/hdl/zc706_bd.tcl
source ../../common/hdl/adrv9001_bd.tcl
source adrv9001x2_bd.tcl

set gpio2_cmos1_lvds0 0
if {$mode eq "cmos"} {
  set gpio2_cmos1_lvds0 1
}

set_property config.axi_adrv9001_rx0_gpio2_cmos1_lvds0 $gpio2_cmos1_lvds0 [get_bd_cells axi_adrv9001]
set_property config.axi_adrv9001_tx0_gpio2_cmos1_lvds0 $gpio2_cmos1_lvds0 [get_bd_cells axi_adrv9001]
set_property config.axi_adrv9001_rx1_gpio2_cmos1_lvds0 $gpio2_cmos1_lvds0 [get_bd_cells axi_adrv9001]
set_property config.axi_adrv9001_tx1_gpio2_cmos1_lvds0 $gpio2_cmos1_lvds0 [get_bd_cells axi_adrv9001]
set_property config.axi_adrv9001_rx0_gpio2_cmos1_lvds0 $gpio2_cmos1_lvds0 [get_bd_cells axi_adrv9001_1]
set_property config.axi_adrv9001_tx0_gpio2_cmos1_lvds0 $gpio2_cmos1_lvds0 [get_bd_cells axi_adrv9001_1]
set_property config.axi_adrv9001_rx1_gpio2_cmos1_lvds0 2 [get_bd_cells axi_adrv9001_1]
set_property config.axi_adrv9001_tx1_gpio2_cmos1_lvds0 2 [get_bd_cells axi_adrv9001_1]

save_bd_design

set project_source_list {}
lappend project_source_list adrv9001x2_zc706.v
lappend project_source_list ../../adrv9001_zc706/hdl/adrv9001_zc706_constr.xdc
lappend project_source_list ../../adrv9001_zc706/hdl/adrv9001_zc706_lvds_constr.xdc
lappend project_source_list ../../adrv9001_zc706/hdl/adrv9001_zc706_cmos_constr.xdc
lappend project_source_list adrv9001x2_zc706_constr.xdc
lappend project_source_list adrv9001x2_zc706_lvds_constr.xdc
lappend project_source_list adrv9001x2_zc706_cmos_constr.xdc
set ip_file_list $project_source_list
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
set_property synth_checkpoint_mode none [get_files system.bd]
set_property top adrv9001x2_zc706 [current_fileset]

generate_target {synthesis implementation} [get_files system.bd]

if {$mode eq "lvds"} {
  set_property is_enabled false [get_files  *adrv9001_zc706_cmos_constr.xdc]
  set_property is_enabled false [get_files  *adrv9001x2_zc706_cmos_constr.xdc]
}

if {$mode eq "cmos"} {
  set_property is_enabled false [get_files  *adrv9001_zc706_lvds_constr.xdc]
  set_property is_enabled false [get_files  *adrv9001x2_zc706_lvds_constr.xdc]
}

set_property strategy flow_perfoptimized_high [get_runs synth_1]
set_property strategy {vivado implementation defaults} [get_runs impl_1]
set_property steps.phys_opt_design.is_enabled true [get_runs impl_1]
set_property steps.write_bitstream.args.bin_file true [get_runs impl_1]

launch_runs synth_1 -jobs 8
wait_on_run synth_1
launch_runs impl_1 -to_step write_bitstream -jobs 8
wait_on_run impl_1

if {[get_property stats.wns [get_runs impl_1]] < 0.0} {
  return -code error [format "ERROR: Timing Constraints (setup) NOT met!"]
}

if {[get_property stats.whs [get_runs impl_1]] < 0.0} {
  return -code error [format "ERROR: Timing Constraints (hold) NOT met!"]
}

file copy -force $mode/adrv9001x2_zc706.runs/impl_1/adrv9001x2_zc706.sysdef $mode/adrv9001x2_zc706_$mode.hdf
file copy -force $mode/adrv9001x2_zc706.runs/impl_1/adrv9001x2_zc706.bit $mode/adrv9001x2_zc706_$mode.bit

## ##################################################################################
## ##################################################################################
