## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Author:            Rejeesh Kutty
## Description:       ADRV9001 Rev.A ZC706
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## ADRV9001 Common

set_property -dict {PACKAGE_PIN AG24  IOSTANDARD  LVCMOS25} [get_ports d1_rx0_enable]   ; ##  C14  FMC_HPC_LA10_P     IO_L8P_T1_11        rx1_enable
set_property -dict {PACKAGE_PIN T28   IOSTANDARD  LVCMOS25} [get_ports d1_rx1_enable]   ; ##  D27  FMC_HPC_LA26_N     IO_L6N_T0_VREF_13   rx2_enable
set_property -dict {PACKAGE_PIN AD21  IOSTANDARD  LVCMOS25} [get_ports d1_tx0_enable]   ; ##  D14  FMC_HPC_LA09_P     IO_L10P_T1_11       tx1_enable
set_property -dict {PACKAGE_PIN R25   IOSTANDARD  LVCMOS25} [get_ports d1_tx1_enable]   ; ##  G30  FMC_HPC_LA29_P     IO_L13P_T2_MRCC_13  tx2_enable
set_property -dict {PACKAGE_PIN AA24  IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[0]}]   ; ##  G18  FMC_HPC_LA16_P     IO_L22P_T3_11       dgpio_0
set_property -dict {PACKAGE_PIN AB24  IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[1]}]   ; ##  G19  FMC_HPC_LA16_N     IO_L22N_T3_11       dgpio_1
set_property -dict {PACKAGE_PIN Y23   IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[2]}]   ; ##  H20  FMC_HPC_LA15_N     IO_L21N_T3_DQS_11   dgpio_2
set_property -dict {PACKAGE_PIN AE23  IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[3]}]   ; ##  H17  FMC_HPC_LA11_N     IO_L11N_T1_SRCC_11  dgpio_3
set_property -dict {PACKAGE_PIN AE21  IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[4]}]   ; ##  D15  FMC_HPC_LA09_N     IO_L10N_T1_11       dgpio_4
set_property -dict {PACKAGE_PIN AG25  IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[5]}]   ; ##  C15  FMC_HPC_LA10_N     IO_L8N_T1_11        dgpio_5
set_property -dict {PACKAGE_PIN V28   IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[6]}]   ; ##  C26  FMC_HPC_LA27_P     IO_L7P_T1_13        dgpio_6
set_property -dict {PACKAGE_PIN R28   IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[7]}]   ; ##  D26  FMC_HPC_LA26_P     IO_L6P_T0_13        dgpio_7
set_property -dict {PACKAGE_PIN P30   IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[8]}]   ; ##  H31  FMC_HPC_LA28_P     IO_L1P_T0_13        dgpio_8
set_property -dict {PACKAGE_PIN R30   IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[9]}]   ; ##  H32  FMC_HPC_LA28_N     IO_L1N_T0_13        dgpio_9
set_property -dict {PACKAGE_PIN AD23  IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[10]}]  ; ##  H16  FMC_HPC_LA11_P     IO_L11P_T1_SRCC_11  dgpio_10
set_property -dict {PACKAGE_PIN V29   IOSTANDARD  LVCMOS25} [get_ports {d1_dgpio[11]}]  ; ##  C27  FMC_HPC_LA27_N     IO_L7N_T1_13        dgpio_11
set_property -dict {PACKAGE_PIN AA22  IOSTANDARD  LVCMOS25} [get_ports d1_mode]         ; ##  D17  FMC_HPC_LA13_P     IO_L23P_T3_11       mode
set_property -dict {PACKAGE_PIN AA23  IOSTANDARD  LVCMOS25} [get_ports d1_resetb]       ; ##  D18  FMC_HPC_LA13_N     IO_L23N_T3_11       reset_trx
set_property -dict {PACKAGE_PIN P23   IOSTANDARD  LVCMOS25} [get_ports d1_gp_int]       ; ##  H34  FMC_HPC_LA30_P     IO_L18P_T2_13       gp_int
set_property -dict {PACKAGE_PIN AE22  IOSTANDARD  LVCMOS25} [get_ports d1_dev_clk]      ; ##  H04  FMC_HPC_CLK0_M2C_P IO_L12P_T1_MRCC_11  dev_clk_out
set_property -dict {PACKAGE_PIN P21   IOSTANDARD  LVDS_25}  [get_ports d1_mcs_in_p]     ; ##  H37  FMC_HPC_LA32_P     IO_L19P_T3_13       fpga_mcs_in+
set_property -dict {PACKAGE_PIN R21   IOSTANDARD  LVDS_25}  [get_ports d1_mcs_in_n]     ; ##  H38  FMC_HPC_LA32_N     IO_L19N_T3_VREF_13  fpga_mcs_in-
set_property -dict {PACKAGE_PIN AC24  IOSTANDARD  LVDS_25}  [get_ports d1_mcs_out_p]    ; ##  C18  FMC_HPC_LA14_P     IO_L7P_T1_11        dev_mcs_fpga_in+
set_property -dict {PACKAGE_PIN AD24  IOSTANDARD  LVDS_25}  [get_ports d1_mcs_out_n]    ; ##  C19  FMC_HPC_LA14_N     IO_L7N_T1_11        dev_mcs_fpga_in-
set_property -dict {PACKAGE_PIN U26   IOSTANDARD  LVDS_25}  [get_ports d1_ref_clk_p]    ; ##  G02  FMC_HPC_CLK1_M2C_P IO_L12P_T1_MRCC_13  fpga_ref_clk+
set_property -dict {PACKAGE_PIN U27   IOSTANDARD  LVDS_25}  [get_ports d1_ref_clk_n]    ; ##  G03  FMC_HPC_CLK1_M2C_N IO_L12N_T1_MRCC_13  fpga_ref_clk-
set_property -dict {PACKAGE_PIN N29   IOSTANDARD  LVCMOS25} [get_ports d1_vadj_err]     ; ##  G33  FMC_HPC_LA31_P     IO_L4P_T0_13        vadj_err
set_property -dict {PACKAGE_PIN P29   IOSTANDARD  LVCMOS25} [get_ports d1_status]       ; ##  G34  FMC_HPC_LA31_N     IO_L4N_T0_13        platform_status
set_property -dict {PACKAGE_PIN AF22  IOSTANDARD  LVCMOS25} [get_ports d1_fan_tach]     ; ##  H05  FMC_HPC_CLK0_M2C_N IO_L12N_T1_MRCC_11  fan_tach

set_property -dict {PACKAGE_PIN Y22   IOSTANDARD  LVCMOS25} [get_ports spi_d1_csn]      ; ##  H19  FMC_HPC_LA15_P     IO_L21P_T3_DQS_11   spi_en
set_property -dict {PACKAGE_PIN AF23  IOSTANDARD  LVCMOS25} [get_ports spi_d1_clk]      ; ##  G15  FMC_HPC_LA12_P     IO_L9P_T1_DQS_11    spi_clk
set_property -dict {PACKAGE_PIN R26   IOSTANDARD  LVCMOS25} [get_ports spi_d1_mosi]     ; ##  G31  FMC_HPC_LA29_N     IO_L13N_T2_MRCC_13  spi_dio
set_property -dict {PACKAGE_PIN AF24  IOSTANDARD  LVCMOS25} [get_ports spi_d1_miso]     ; ##  G16  FMC_HPC_LA12_N     IO_L9N_T1_DQS_11    spi_do

set_property -dict {PACKAGE_PIN Y20   IOSTANDARD  LVCMOS25} [get_ports d1_dev_out_clk]  ; ##  J58 Pin.2 PMOD1_4_LS

set_property diff_term true [get_ports d1_ref_clk_p]
set_property diff_term true [get_ports d1_ref_clk_n]
set_property diff_term true [get_ports d1_mcs_in_p]
set_property diff_term true [get_ports d1_mcs_in_n]

## ##################################################################################
## ##################################################################################
## ADRV9001 Placer

set_property loc IDELAY_X0Y123 [get_cells -hierarchical -filter {name =~ *axi_adrv9001_1/inst/i_tx0*i_delay_ext_clk}]
set_property loc IDELAY_X0Y125 [get_cells -hierarchical -filter {name =~ *axi_adrv9001_1/inst/i_tx0*i_delay_int_clk}]

## ##################################################################################
## ##################################################################################
## ADRV9001 Clocks

create_clock -name d1_rx0_clk_in -period 2.00 [get_ports d1_rx0_cssi_clk_lssi_clk_p]
create_clock -name d1_tx0_ref_clk_in -period 2.00 [get_ports d1_tx0_cssi_refclk_lssi_refclk_p]
create_clock -name d1_dev_clk_in -period 52.083 [get_ports d1_dev_clk]
create_clock -name d1_ref_clk_in -period 26.041 [get_ports d1_ref_clk_p]
create_clock -name d1_rx0_clk -period 8.00 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *axi_adrv9001_1/rx0_clk}]]
create_clock -name d1_tx0_clk -period 8.00 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *axi_adrv9001_1/tx0_clk}]]

## ##################################################################################
## ##################################################################################

