// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Author:            Rejeesh Kutty
// Description:       ADRV9001 Rev.A ZC706
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module adrv9001x2_zc706 (

  // ps fixed io and ddr

  inout   wire          ps7_io_ddr_vrp,
  inout   wire          ps7_io_ddr_vrn,
  inout   wire  [53:0]  ps7_io_mio,
  inout   wire          ps7_io_ps_clk,
  inout   wire          ps7_io_ps_porb,
  inout   wire          ps7_io_ps_srstb,
  inout   wire  [14:0]  ps7_ddr_addr,
  inout   wire  [ 2:0]  ps7_ddr_ba,
  inout   wire          ps7_ddr_cas_n,
  inout   wire          ps7_ddr_ck_p,
  inout   wire          ps7_ddr_ck_n,
  inout   wire          ps7_ddr_cke,
  inout   wire          ps7_ddr_cs_n,
  inout   wire  [ 3:0]  ps7_ddr_dm,
  inout   wire  [31:0]  ps7_ddr_dq,
  inout   wire  [ 3:0]  ps7_ddr_dqs_p,
  inout   wire  [ 3:0]  ps7_ddr_dqs_n,
  inout   wire          ps7_ddr_odt,
  inout   wire          ps7_ddr_ras_n,
  inout   wire          ps7_ddr_reset_n,
  inout   wire          ps7_ddr_we_n,

  // pl ddr

  output  wire  [13:0]  pl_ddr_addr,
  output  wire  [ 2:0]  pl_ddr_ba,
  output  wire          pl_ddr_cas_n,
  output  wire          pl_ddr_ck_p,
  output  wire          pl_ddr_ck_n,
  output  wire          pl_ddr_cke,
  output  wire          pl_ddr_cs_n,
  output  wire  [ 7:0]  pl_ddr_dm,
  inout   wire  [63:0]  pl_ddr_dq,
  inout   wire  [ 7:0]  pl_ddr_dqs_p,
  inout   wire  [ 7:0]  pl_ddr_dqs_n,
  output  wire          pl_ddr_odt,
  output  wire          pl_ddr_ras_n,
  input   wire          pl_ddr_refclk_p,
  input   wire          pl_ddr_refclk_n,
  input   wire          pl_ddr_reset,
  output  wire          pl_ddr_reset_n,
  output  wire          pl_ddr_we_n,

  // platform gpio

  input   wire  [ 3:0]  gpio_sw,
  input   wire  [ 2:0]  gpio_pb,
  output  wire  [ 3:0]  gpio_led,

  // spi

  output  wire          spi_csn,
  output  wire          spi_clk,
  inout   wire          spi_mosi,
  input   wire          spi_miso,

  output  wire          spi_d1_csn,
  output  wire          spi_d1_clk,
  inout   wire          spi_d1_mosi,
  input   wire          spi_d1_miso,

  // reference & monitor clocks

  output  wire          dev_out_clk,
  output  wire          d1_dev_out_clk,
  inout   wire  [ 1:0]  trig,

  // adrv9001 io
 
  input   wire          rx0_cssi_clk_lssi_clk_p,
  input   wire          rx0_cssi_nc_lssi_clk_n,
  input   wire          rx0_cssi_strobe_lssi_strobe_p,
  input   wire          rx0_cssi_nc_lssi_strobe_n,
  input   wire          rx0_cssi_data1_lssi_data0_p,
  input   wire          rx0_cssi_data0_lssi_data0_n,
  input   wire          rx0_cssi_data3_lssi_data1_p,
  input   wire          rx0_cssi_data2_lssi_data1_n,
  input   wire          rx1_cssi_clk_lssi_clk_p,
  input   wire          rx1_cssi_nc_lssi_clk_n,
  input   wire          rx1_cssi_strobe_lssi_strobe_p,
  input   wire          rx1_cssi_nc_lssi_strobe_n,
  input   wire          rx1_cssi_data1_lssi_data0_p,
  input   wire          rx1_cssi_data0_lssi_data0_n,
  input   wire          rx1_cssi_data3_lssi_data1_p,
  input   wire          rx1_cssi_data2_lssi_data1_n,
  input   wire          tx0_cssi_refclk_lssi_refclk_p,
  input   wire          tx0_cssi_nc_lssi_refclk_n,
  output  wire          tx0_cssi_clk_lssi_clk_p,
  output  wire          tx0_cssi_nc_lssi_clk_n,
  output  wire          tx0_cssi_strobe_lssi_strobe_p,
  output  wire          tx0_cssi_nc_lssi_strobe_n,
  output  wire          tx0_cssi_data1_lssi_data0_p,
  output  wire          tx0_cssi_data0_lssi_data0_n,
  output  wire          tx0_cssi_data3_lssi_data1_p,
  output  wire          tx0_cssi_data2_lssi_data1_n,
  input   wire          tx1_cssi_refclk_lssi_refclk_p,
  input   wire          tx1_cssi_nc_lssi_refclk_n,
  output  wire          tx1_cssi_clk_lssi_clk_p,
  output  wire          tx1_cssi_nc_lssi_clk_n,
  output  wire          tx1_cssi_strobe_lssi_strobe_p,
  output  wire          tx1_cssi_nc_lssi_strobe_n,
  output  wire          tx1_cssi_data1_lssi_data0_p,
  output  wire          tx1_cssi_data0_lssi_data0_n,
  output  wire          tx1_cssi_data3_lssi_data1_p,
  output  wire          tx1_cssi_data2_lssi_data1_n,
  output  wire          rx0_enable,
  output  wire          rx1_enable,
  output  wire          tx0_enable,
  output  wire          tx1_enable,
  inout   wire  [11:0]  dgpio,
  output  wire          mode,
  output  wire          resetb,
  input   wire          gp_int,
  input   wire          dev_clk,

  // adrv9001-1 io
 
  input   wire          d1_rx0_cssi_clk_lssi_clk_p,
  input   wire          d1_rx0_cssi_nc_lssi_clk_n,
  input   wire          d1_rx0_cssi_strobe_lssi_strobe_p,
  input   wire          d1_rx0_cssi_nc_lssi_strobe_n,
  input   wire          d1_rx0_cssi_data1_lssi_data0_p,
  input   wire          d1_rx0_cssi_data0_lssi_data0_n,
  input   wire          d1_rx0_cssi_data3_lssi_data1_p,
  input   wire          d1_rx0_cssi_data2_lssi_data1_n,
  inout   wire  [ 7:0]  d1_rx1_cssi_gpio,
  input   wire          d1_tx0_cssi_refclk_lssi_refclk_p,
  input   wire          d1_tx0_cssi_nc_lssi_refclk_n,
  output  wire          d1_tx0_cssi_clk_lssi_clk_p,
  output  wire          d1_tx0_cssi_nc_lssi_clk_n,
  output  wire          d1_tx0_cssi_strobe_lssi_strobe_p,
  output  wire          d1_tx0_cssi_nc_lssi_strobe_n,
  output  wire          d1_tx0_cssi_data1_lssi_data0_p,
  output  wire          d1_tx0_cssi_data0_lssi_data0_n,
  output  wire          d1_tx0_cssi_data3_lssi_data1_p,
  output  wire          d1_tx0_cssi_data2_lssi_data1_n,
  inout   wire  [ 9:0]  d1_tx1_cssi_gpio,
  output  wire          d1_rx0_enable,
  output  wire          d1_rx1_enable,
  output  wire          d1_tx0_enable,
  output  wire          d1_tx1_enable,
  inout   wire  [11:0]  d1_dgpio,
  output  wire          d1_mode,
  output  wire          d1_resetb,
  input   wire          d1_gp_int,
  input   wire          d1_dev_clk,

  // system io
 
  input   wire          vadj_err,
  output  wire          status,
  output  wire          fan_tach,
  input   wire          ref_clk_p,
  input   wire          ref_clk_n,
  input   wire          mcs_in_p,
  input   wire          mcs_in_n,
  output  wire          mcs_out_p,
  output  wire          mcs_out_n,

  input   wire          d1_vadj_err,
  output  wire          d1_status,
  output  wire          d1_fan_tach,
  input   wire          d1_ref_clk_p,
  input   wire          d1_ref_clk_n,
  input   wire          d1_mcs_in_p,
  input   wire          d1_mcs_in_n,
  output  wire          d1_mcs_out_p,
  output  wire          d1_mcs_out_n);

  // internal signals

  wire          [ 3:0]  gpio_ctl;
  wire          [ 7:0]  d1_rx1_cssi_gpio_enb;
  wire          [ 7:0]  d1_rx1_cssi_gpio_out;
  wire          [ 9:0]  d1_tx1_cssi_gpio_enb;
  wire          [ 9:0]  d1_tx1_cssi_gpio_out;
  wire          [ 1:0]  spi_int_csn;
  wire                  spi_int_clk;
  wire                  spi_int_mosi_i;
  wire                  spi_int_mosi_o;
  wire                  spi_int_mosi_t;
  wire                  spi_int_miso;
  wire                  sys_dev_out_clk;

  // defaults

  assign gpio_ctl[3:2] = {d1_fan_tach, d1_status};
  assign gpio_ctl[1:0] = {fan_tach, status};

  assign d1_rx1_cssi_gpio[0] = (d1_rx1_cssi_gpio_enb[0] == 1'd1) ? d1_rx1_cssi_gpio_out[0] : 1'bz;
  assign d1_rx1_cssi_gpio[1] = (d1_rx1_cssi_gpio_enb[1] == 1'd1) ? d1_rx1_cssi_gpio_out[1] : 1'bz;
  assign d1_rx1_cssi_gpio[2] = (d1_rx1_cssi_gpio_enb[2] == 1'd1) ? d1_rx1_cssi_gpio_out[2] : 1'bz;
  assign d1_rx1_cssi_gpio[3] = (d1_rx1_cssi_gpio_enb[3] == 1'd1) ? d1_rx1_cssi_gpio_out[3] : 1'bz;
  assign d1_rx1_cssi_gpio[4] = (d1_rx1_cssi_gpio_enb[4] == 1'd1) ? d1_rx1_cssi_gpio_out[4] : 1'bz;
  assign d1_rx1_cssi_gpio[5] = (d1_rx1_cssi_gpio_enb[5] == 1'd1) ? d1_rx1_cssi_gpio_out[5] : 1'bz;
  assign d1_rx1_cssi_gpio[6] = (d1_rx1_cssi_gpio_enb[6] == 1'd1) ? d1_rx1_cssi_gpio_out[6] : 1'bz;
  assign d1_rx1_cssi_gpio[7] = (d1_rx1_cssi_gpio_enb[7] == 1'd1) ? d1_rx1_cssi_gpio_out[7] : 1'bz;

  assign d1_tx1_cssi_gpio[0] = (d1_tx1_cssi_gpio_enb[0] == 1'd1) ? d1_tx1_cssi_gpio_out[0] : 1'bz;
  assign d1_tx1_cssi_gpio[1] = (d1_tx1_cssi_gpio_enb[1] == 1'd1) ? d1_tx1_cssi_gpio_out[1] : 1'bz;
  assign d1_tx1_cssi_gpio[2] = (d1_tx1_cssi_gpio_enb[2] == 1'd1) ? d1_tx1_cssi_gpio_out[2] : 1'bz;
  assign d1_tx1_cssi_gpio[3] = (d1_tx1_cssi_gpio_enb[3] == 1'd1) ? d1_tx1_cssi_gpio_out[3] : 1'bz;
  assign d1_tx1_cssi_gpio[4] = (d1_tx1_cssi_gpio_enb[4] == 1'd1) ? d1_tx1_cssi_gpio_out[4] : 1'bz;
  assign d1_tx1_cssi_gpio[5] = (d1_tx1_cssi_gpio_enb[5] == 1'd1) ? d1_tx1_cssi_gpio_out[5] : 1'bz;
  assign d1_tx1_cssi_gpio[6] = (d1_tx1_cssi_gpio_enb[6] == 1'd1) ? d1_tx1_cssi_gpio_out[6] : 1'bz;
  assign d1_tx1_cssi_gpio[7] = (d1_tx1_cssi_gpio_enb[7] == 1'd1) ? d1_tx1_cssi_gpio_out[7] : 1'bz;
  assign d1_tx1_cssi_gpio[8] = (d1_tx1_cssi_gpio_enb[8] == 1'd1) ? d1_tx1_cssi_gpio_out[8] : 1'bz;
  assign d1_tx1_cssi_gpio[9] = (d1_tx1_cssi_gpio_enb[9] == 1'd1) ? d1_tx1_cssi_gpio_out[9] : 1'bz;

  assign spi_csn = spi_int_csn[0];
  assign spi_d1_csn = spi_int_csn[1];
  assign spi_clk = spi_int_clk;
  assign spi_d1_clk = spi_int_clk;
  assign spi_mosi = (spi_int_mosi_t == 1'b1) ? 1'bz : spi_int_mosi_o;
  assign spi_d1_mosi = (spi_int_mosi_t == 1'b1) ? 1'bz : spi_int_mosi_o;
  assign spi_int_mosi_i = (spi_int_csn == 2'b01) ? spi_d1_mosi :
    ((spi_int_csn == 2'b10) ? spi_mosi : 1'd1);
  assign spi_int_miso = (spi_int_csn == 2'b01) ? spi_d1_miso :
    ((spi_int_csn == 2'b10) ? spi_miso : 1'd1);

  // device reference clock

  ODDR #(.DDR_CLK_EDGE("SAME_EDGE")) i_oddr_d1_dev_out_clk (
    .CE                                     (1'b1),
    .R                                      (1'b0),
    .S                                      (1'b0),
    .D1                                     (1'b1),
    .D2                                     (1'b0),
    .C                                      (sys_dev_out_clk),
    .Q                                      (d1_dev_out_clk));

  ODDR #(.DDR_CLK_EDGE("SAME_EDGE")) i_oddr_dev_out_clk (
    .CE                                     (1'b1),
    .R                                      (1'b0),
    .S                                      (1'b0),
    .D1                                     (1'b1),
    .D2                                     (1'b0),
    .C                                      (sys_dev_out_clk),
    .Q                                      (dev_out_clk));

  // ipi-system

  system i_system (
    .d1_vadj_err                            (d1_vadj_err),
    .dio_1_dev_clk                          (d1_dev_clk),
    .dio_1_dgpio                            (d1_dgpio),
    .dio_1_gp_int                           (d1_gp_int),
    .dio_1_mode                             (d1_mode),
    .dio_1_resetb                           (d1_resetb),
    .dio_1_rx0_cssi_clk_lssi_clk_p          (d1_rx0_cssi_clk_lssi_clk_p),
    .dio_1_rx0_cssi_data0_lssi_data0_n      (d1_rx0_cssi_data0_lssi_data0_n),
    .dio_1_rx0_cssi_data1_lssi_data0_p      (d1_rx0_cssi_data1_lssi_data0_p),
    .dio_1_rx0_cssi_data2_lssi_data1_n      (d1_rx0_cssi_data2_lssi_data1_n),
    .dio_1_rx0_cssi_data3_lssi_data1_p      (d1_rx0_cssi_data3_lssi_data1_p),
    .dio_1_rx0_cssi_gpio_enb                (),
    .dio_1_rx0_cssi_gpio_in                 (8'd0),
    .dio_1_rx0_cssi_gpio_out                (),
    .dio_1_rx0_cssi_nc_lssi_clk_n           (d1_rx0_cssi_nc_lssi_clk_n),
    .dio_1_rx0_cssi_nc_lssi_strobe_n        (d1_rx0_cssi_nc_lssi_strobe_n),
    .dio_1_rx0_cssi_strobe_lssi_strobe_p    (d1_rx0_cssi_strobe_lssi_strobe_p),
    .dio_1_rx0_enable                       (d1_rx0_enable),
    .dio_1_rx1_cssi_clk_lssi_clk_p          (1'd0),
    .dio_1_rx1_cssi_data0_lssi_data0_n      (1'd0),
    .dio_1_rx1_cssi_data1_lssi_data0_p      (1'd0),
    .dio_1_rx1_cssi_data2_lssi_data1_n      (1'd0),
    .dio_1_rx1_cssi_data3_lssi_data1_p      (1'd0),
    .dio_1_rx1_cssi_gpio_enb                (d1_rx1_cssi_gpio_enb),
    .dio_1_rx1_cssi_gpio_in                 (d1_rx1_cssi_gpio),
    .dio_1_rx1_cssi_gpio_out                (d1_rx1_cssi_gpio_out),
    .dio_1_rx1_cssi_nc_lssi_clk_n           (1'd0),
    .dio_1_rx1_cssi_nc_lssi_strobe_n        (1'd0),
    .dio_1_rx1_cssi_strobe_lssi_strobe_p    (1'd0),
    .dio_1_rx1_enable                       (d1_rx1_enable),
    .dio_1_tx0_cssi_clk_lssi_clk_p          (d1_tx0_cssi_clk_lssi_clk_p),
    .dio_1_tx0_cssi_data0_lssi_data0_n      (d1_tx0_cssi_data0_lssi_data0_n),
    .dio_1_tx0_cssi_data1_lssi_data0_p      (d1_tx0_cssi_data1_lssi_data0_p),
    .dio_1_tx0_cssi_data2_lssi_data1_n      (d1_tx0_cssi_data2_lssi_data1_n),
    .dio_1_tx0_cssi_data3_lssi_data1_p      (d1_tx0_cssi_data3_lssi_data1_p),
    .dio_1_tx0_cssi_gpio_enb                (),
    .dio_1_tx0_cssi_gpio_in                 (10'd0),
    .dio_1_tx0_cssi_gpio_out                (),
    .dio_1_tx0_cssi_nc_lssi_clk_n           (d1_tx0_cssi_nc_lssi_clk_n),
    .dio_1_tx0_cssi_nc_lssi_refclk_n        (d1_tx0_cssi_nc_lssi_refclk_n),
    .dio_1_tx0_cssi_nc_lssi_strobe_n        (d1_tx0_cssi_nc_lssi_strobe_n),
    .dio_1_tx0_cssi_refclk_lssi_refclk_p    (d1_tx0_cssi_refclk_lssi_refclk_p),
    .dio_1_tx0_cssi_strobe_lssi_strobe_p    (d1_tx0_cssi_strobe_lssi_strobe_p),
    .dio_1_tx0_enable                       (d1_tx0_enable),
    .dio_1_tx1_cssi_clk_lssi_clk_p          (),
    .dio_1_tx1_cssi_data0_lssi_data0_n      (),
    .dio_1_tx1_cssi_data1_lssi_data0_p      (),
    .dio_1_tx1_cssi_data2_lssi_data1_n      (),
    .dio_1_tx1_cssi_data3_lssi_data1_p      (),
    .dio_1_tx1_cssi_gpio_enb                (d1_tx1_cssi_gpio_enb),
    .dio_1_tx1_cssi_gpio_in                 (d1_tx1_cssi_gpio),
    .dio_1_tx1_cssi_gpio_out                (d1_tx1_cssi_gpio_out),
    .dio_1_tx1_cssi_nc_lssi_clk_n           (),
    .dio_1_tx1_cssi_nc_lssi_refclk_n        (1'd0),
    .dio_1_tx1_cssi_nc_lssi_strobe_n        (),
    .dio_1_tx1_cssi_refclk_lssi_refclk_p    (1'd0),
    .dio_1_tx1_cssi_strobe_lssi_strobe_p    (),
    .dio_1_tx1_enable                       (d1_tx1_enable),
    .dio_dev_clk                            (dev_clk),
    .dio_dgpio                              (dgpio),
    .dio_gp_int                             (gp_int),
    .dio_mode                               (mode),
    .dio_resetb                             (resetb),
    .dio_rx0_cssi_clk_lssi_clk_p            (rx0_cssi_clk_lssi_clk_p),
    .dio_rx0_cssi_data0_lssi_data0_n        (rx0_cssi_data0_lssi_data0_n),
    .dio_rx0_cssi_data1_lssi_data0_p        (rx0_cssi_data1_lssi_data0_p),
    .dio_rx0_cssi_data2_lssi_data1_n        (rx0_cssi_data2_lssi_data1_n),
    .dio_rx0_cssi_data3_lssi_data1_p        (rx0_cssi_data3_lssi_data1_p),
    .dio_rx0_cssi_gpio_enb                  (),
    .dio_rx0_cssi_gpio_in                   (8'd0),
    .dio_rx0_cssi_gpio_out                  (),
    .dio_rx0_cssi_nc_lssi_clk_n             (rx0_cssi_nc_lssi_clk_n),
    .dio_rx0_cssi_nc_lssi_strobe_n          (rx0_cssi_nc_lssi_strobe_n),
    .dio_rx0_cssi_strobe_lssi_strobe_p      (rx0_cssi_strobe_lssi_strobe_p),
    .dio_rx0_enable                         (rx0_enable),
    .dio_rx1_cssi_clk_lssi_clk_p            (rx1_cssi_clk_lssi_clk_p),
    .dio_rx1_cssi_data0_lssi_data0_n        (rx1_cssi_data0_lssi_data0_n),
    .dio_rx1_cssi_data1_lssi_data0_p        (rx1_cssi_data1_lssi_data0_p),
    .dio_rx1_cssi_data2_lssi_data1_n        (rx1_cssi_data2_lssi_data1_n),
    .dio_rx1_cssi_data3_lssi_data1_p        (rx1_cssi_data3_lssi_data1_p),
    .dio_rx1_cssi_gpio_enb                  (),
    .dio_rx1_cssi_gpio_in                   (8'd0),
    .dio_rx1_cssi_gpio_out                  (),
    .dio_rx1_cssi_nc_lssi_clk_n             (rx1_cssi_nc_lssi_clk_n),
    .dio_rx1_cssi_nc_lssi_strobe_n          (rx1_cssi_nc_lssi_strobe_n),
    .dio_rx1_cssi_strobe_lssi_strobe_p      (rx1_cssi_strobe_lssi_strobe_p),
    .dio_rx1_enable                         (rx1_enable),
    .dio_tx0_cssi_clk_lssi_clk_p            (tx0_cssi_clk_lssi_clk_p),
    .dio_tx0_cssi_data0_lssi_data0_n        (tx0_cssi_data0_lssi_data0_n),
    .dio_tx0_cssi_data1_lssi_data0_p        (tx0_cssi_data1_lssi_data0_p),
    .dio_tx0_cssi_data2_lssi_data1_n        (tx0_cssi_data2_lssi_data1_n),
    .dio_tx0_cssi_data3_lssi_data1_p        (tx0_cssi_data3_lssi_data1_p),
    .dio_tx0_cssi_gpio_enb                  (),
    .dio_tx0_cssi_gpio_in                   (10'd0),
    .dio_tx0_cssi_gpio_out                  (),
    .dio_tx0_cssi_nc_lssi_clk_n             (tx0_cssi_nc_lssi_clk_n),
    .dio_tx0_cssi_nc_lssi_refclk_n          (tx0_cssi_nc_lssi_refclk_n),
    .dio_tx0_cssi_nc_lssi_strobe_n          (tx0_cssi_nc_lssi_strobe_n),
    .dio_tx0_cssi_refclk_lssi_refclk_p      (tx0_cssi_refclk_lssi_refclk_p),
    .dio_tx0_cssi_strobe_lssi_strobe_p      (tx0_cssi_strobe_lssi_strobe_p),
    .dio_tx0_enable                         (tx0_enable),
    .dio_tx1_cssi_clk_lssi_clk_p            (tx1_cssi_clk_lssi_clk_p),
    .dio_tx1_cssi_data0_lssi_data0_n        (tx1_cssi_data0_lssi_data0_n),
    .dio_tx1_cssi_data1_lssi_data0_p        (tx1_cssi_data1_lssi_data0_p),
    .dio_tx1_cssi_data2_lssi_data1_n        (tx1_cssi_data2_lssi_data1_n),
    .dio_tx1_cssi_data3_lssi_data1_p        (tx1_cssi_data3_lssi_data1_p),
    .dio_tx1_cssi_gpio_enb                  (),
    .dio_tx1_cssi_gpio_in                   (10'd0),
    .dio_tx1_cssi_gpio_out                  (),
    .dio_tx1_cssi_nc_lssi_clk_n             (tx1_cssi_nc_lssi_clk_n),
    .dio_tx1_cssi_nc_lssi_refclk_n          (tx1_cssi_nc_lssi_refclk_n),
    .dio_tx1_cssi_nc_lssi_strobe_n          (tx1_cssi_nc_lssi_strobe_n),
    .dio_tx1_cssi_refclk_lssi_refclk_p      (tx1_cssi_refclk_lssi_refclk_p),
    .dio_tx1_cssi_strobe_lssi_strobe_p      (tx1_cssi_strobe_lssi_strobe_p),
    .dio_tx1_enable                         (tx1_enable),
    .gpio_in                                ({gpio_pb, gpio_sw}),
    .gpio_out                               ({gpio_ctl, gpio_led}),
    .pl_ddr_addr                            (pl_ddr_addr),
    .pl_ddr_ba                              (pl_ddr_ba),
    .pl_ddr_cas_n                           (pl_ddr_cas_n),
    .pl_ddr_ck_n                            (pl_ddr_ck_n),
    .pl_ddr_ck_p                            (pl_ddr_ck_p),
    .pl_ddr_cke                             (pl_ddr_cke),
    .pl_ddr_cs_n                            (pl_ddr_cs_n),
    .pl_ddr_dm                              (pl_ddr_dm),
    .pl_ddr_dq                              (pl_ddr_dq),
    .pl_ddr_dqs_n                           (pl_ddr_dqs_n),
    .pl_ddr_dqs_p                           (pl_ddr_dqs_p),
    .pl_ddr_odt                             (pl_ddr_odt),
    .pl_ddr_ras_n                           (pl_ddr_ras_n),
    .pl_ddr_refclk_clk_n                    (pl_ddr_refclk_n),
    .pl_ddr_refclk_clk_p                    (pl_ddr_refclk_p),
    .pl_ddr_reset                           (pl_ddr_reset),
    .pl_ddr_reset_n                         (pl_ddr_reset_n),
    .pl_ddr_we_n                            (pl_ddr_we_n),
    .ps7_ddr_addr                           (ps7_ddr_addr),
    .ps7_ddr_ba                             (ps7_ddr_ba),
    .ps7_ddr_cas_n                          (ps7_ddr_cas_n),
    .ps7_ddr_ck_n                           (ps7_ddr_ck_n),
    .ps7_ddr_ck_p                           (ps7_ddr_ck_p),
    .ps7_ddr_cke                            (ps7_ddr_cke),
    .ps7_ddr_cs_n                           (ps7_ddr_cs_n),
    .ps7_ddr_dm                             (ps7_ddr_dm),
    .ps7_ddr_dq                             (ps7_ddr_dq),
    .ps7_ddr_dqs_n                          (ps7_ddr_dqs_n),
    .ps7_ddr_dqs_p                          (ps7_ddr_dqs_p),
    .ps7_ddr_odt                            (ps7_ddr_odt),
    .ps7_ddr_ras_n                          (ps7_ddr_ras_n),
    .ps7_ddr_reset_n                        (ps7_ddr_reset_n),
    .ps7_ddr_we_n                           (ps7_ddr_we_n),
    .ps7_io_ddr_vrn                         (ps7_io_ddr_vrn),
    .ps7_io_ddr_vrp                         (ps7_io_ddr_vrp),
    .ps7_io_mio                             (ps7_io_mio),
    .ps7_io_ps_clk                          (ps7_io_ps_clk),
    .ps7_io_ps_porb                         (ps7_io_ps_porb),
    .ps7_io_ps_srstb                        (ps7_io_ps_srstb),
    .spi_clk                                (spi_int_clk),
    .spi_csn                                (spi_int_csn),
    .spi_miso                               (spi_int_miso),
    .spi_mosi_i                             (spi_int_mosi_i),
    .spi_mosi_o                             (spi_int_mosi_o),
    .spi_mosi_t                             (spi_int_mosi_t),
    .sys_1_mcs_in_n                         (d1_mcs_in_n),
    .sys_1_mcs_in_p                         (d1_mcs_in_p),
    .sys_1_mcs_out_n                        (d1_mcs_out_n),
    .sys_1_mcs_out_p                        (d1_mcs_out_p),
    .sys_1_ref_clk_n                        (d1_ref_clk_n),
    .sys_1_ref_clk_p                        (d1_ref_clk_p),
    .sys_dev_out_clk                        (sys_dev_out_clk),
    .sys_mcs_in_n                           (mcs_in_n),
    .sys_mcs_in_p                           (mcs_in_p),
    .sys_mcs_out_n                          (mcs_out_n),
    .sys_mcs_out_p                          (mcs_out_p),
    .sys_ref_clk_n                          (ref_clk_n),
    .sys_ref_clk_p                          (ref_clk_p),
    .trig                                   (trig),
    .vadj_err                               (vadj_err));

endmodule

// **********************************************************************************
// **********************************************************************************
